/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.convert;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CodeConverter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Analyzer;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Frame;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.Transformer;

public final class TransformAccessArrayField
extends Transformer {
    private final String methodClassname;
    private final CodeConverter.ArrayAccessReplacementMethodNames names;
    private Frame[] frames;
    private int offset;

    /*
     * WARNING - void declaration
     */
    public TransformAccessArrayField(Transformer next, String methodClassname, CodeConverter.ArrayAccessReplacementMethodNames names) throws NotFoundException {
        super((Transformer)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.methodClassname = var2_2;
        this.names = var3_3;
    }

    @Override
    public final void initialize(ConstPool cp, CtClass clazz, MethodInfo minfo) throws CannotCompileException {
        CodeIterator iterator2 = minfo.getCodeAttribute().iterator();
        while (iterator2.hasNext()) {
            try {
                int pos = iterator2.next();
                int c2 = iterator2.byteAt(pos);
                if (c2 == 50) {
                    this.initFrames(clazz, minfo);
                }
                if (c2 == 50 || c2 == 51 || c2 == 52 || c2 == 49 || c2 == 48 || c2 == 46 || c2 == 47 || c2 == 53) {
                    this.replace(cp, iterator2, pos, c2, this.getLoadReplacementSignature(c2));
                    continue;
                }
                if (c2 != 83 && c2 != 84 && c2 != 85 && c2 != 82 && c2 != 81 && c2 != 79 && c2 != 80 && c2 != 86) continue;
                this.replace(cp, iterator2, pos, c2, this.getStoreReplacementSignature(c2));
            }
            catch (Exception e2) {
                throw new CannotCompileException(e2);
            }
        }
    }

    @Override
    public final void clean() {
        this.frames = null;
        this.offset = -1;
    }

    @Override
    public final int transform(CtClass tclazz, int pos, CodeIterator iterator2, ConstPool cp) throws BadBytecode {
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    private Frame getFrame(int pos) throws BadBytecode {
        void var1_1;
        return this.frames[var1_1 - this.offset];
    }

    /*
     * WARNING - void declaration
     */
    private void initFrames(CtClass clazz, MethodInfo minfo) throws BadBytecode {
        if (this.frames == null) {
            void var2_2;
            void var1_1;
            this.frames = new Analyzer().analyze((CtClass)var1_1, (MethodInfo)var2_2);
            this.offset = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int updatePos(int pos, int increment) {
        void var2_2;
        void var1_1;
        if (this.offset >= 0) {
            this.offset += increment;
        }
        return (int)(var1_1 + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String getTopType(int pos) throws BadBytecode {
        Frame frame = this.getFrame(pos);
        if (frame == null) {
            return null;
        }
        CtClass clazz = frame.peek().getCtClass();
        if (clazz != null) {
            void var1_2;
            return Descriptor.toJvmName((CtClass)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int replace(ConstPool cp, CodeIterator iterator2, int pos, int opcode, String signature) throws BadBytecode {
        void var3_4;
        String castType = null;
        String methodName = this.getMethodName(opcode);
        if (methodName != null) {
            if (opcode == 50) {
                castType = this.getTopType(iterator2.lookAhead());
                if (castType == null) {
                    return pos;
                }
                if ("java/lang/Object".equals(castType)) {
                    castType = null;
                }
            }
            iterator2.writeByte(0, pos);
            CodeIterator.Gap gap = iterator2.insertGapAt(pos, castType != null ? 5 : 2, false);
            pos = gap.position;
            int mi = cp.addClassInfo(this.methodClassname);
            int methodref = cp.addMethodrefInfo(mi, methodName, signature);
            iterator2.writeByte(184, pos);
            iterator2.write16bit(methodref, pos + 1);
            if (castType != null) {
                void var1_2;
                void var2_3;
                int index = cp.addClassInfo(castType);
                iterator2.writeByte(192, pos + 3);
                var2_3.write16bit((int)var1_2, pos + 4);
            }
            pos = this.updatePos(pos, gap.length);
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private String getMethodName(int opcode) {
        void var2_2;
        void var1_1;
        String methodName = null;
        switch (var1_1) {
            case 50: {
                methodName = this.names.objectRead();
                break;
            }
            case 51: {
                methodName = this.names.byteOrBooleanRead();
                break;
            }
            case 52: {
                methodName = this.names.charRead();
                break;
            }
            case 49: {
                methodName = this.names.doubleRead();
                break;
            }
            case 48: {
                methodName = this.names.floatRead();
                break;
            }
            case 46: {
                methodName = this.names.intRead();
                break;
            }
            case 53: {
                methodName = this.names.shortRead();
                break;
            }
            case 47: {
                methodName = this.names.longRead();
                break;
            }
            case 83: {
                methodName = this.names.objectWrite();
                break;
            }
            case 84: {
                methodName = this.names.byteOrBooleanWrite();
                break;
            }
            case 85: {
                methodName = this.names.charWrite();
                break;
            }
            case 82: {
                methodName = this.names.doubleWrite();
                break;
            }
            case 81: {
                methodName = this.names.floatWrite();
                break;
            }
            case 79: {
                methodName = this.names.intWrite();
                break;
            }
            case 86: {
                methodName = this.names.shortWrite();
                break;
            }
            case 80: {
                methodName = this.names.longWrite();
            }
        }
        if ("".equals(methodName)) {
            methodName = null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getLoadReplacementSignature(int opcode) throws BadBytecode {
        void var1_1;
        switch (opcode) {
            case 50: {
                return "(Ljava/lang/Object;I)Ljava/lang/Object;";
            }
            case 51: {
                return "(Ljava/lang/Object;I)B";
            }
            case 52: {
                return "(Ljava/lang/Object;I)C";
            }
            case 49: {
                return "(Ljava/lang/Object;I)D";
            }
            case 48: {
                return "(Ljava/lang/Object;I)F";
            }
            case 46: {
                return "(Ljava/lang/Object;I)I";
            }
            case 53: {
                return "(Ljava/lang/Object;I)S";
            }
            case 47: {
                return "(Ljava/lang/Object;I)J";
            }
        }
        throw new BadBytecode((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String getStoreReplacementSignature(int opcode) throws BadBytecode {
        void var1_1;
        switch (opcode) {
            case 83: {
                return "(Ljava/lang/Object;ILjava/lang/Object;)V";
            }
            case 84: {
                return "(Ljava/lang/Object;IB)V";
            }
            case 85: {
                return "(Ljava/lang/Object;IC)V";
            }
            case 82: {
                return "(Ljava/lang/Object;ID)V";
            }
            case 81: {
                return "(Ljava/lang/Object;IF)V";
            }
            case 79: {
                return "(Ljava/lang/Object;II)V";
            }
            case 86: {
                return "(Ljava/lang/Object;IS)V";
            }
            case 80: {
                return "(Ljava/lang/Object;IJ)V";
            }
        }
        throw new BadBytecode((int)var1_1);
    }
}

