/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.compiler;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.NoFieldException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.TokenId;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTree;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Declarator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Keyword;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Symbol;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class MemberResolver
implements TokenId {
    private ClassPool classPool;
    private static final int YES = 0;
    private static final int NO = -1;
    private static final String INVALID = "<invalid>";
    private static Map<ClassPool, Reference<Map<String, String>>> invalidNamesMap = new WeakHashMap<ClassPool, Reference<Map<String, String>>>();
    private Map<String, String> invalidNames = null;

    /*
     * WARNING - void declaration
     */
    public MemberResolver(ClassPool cp) {
        void var1_1;
        this.classPool = var1_1;
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    private static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    /*
     * WARNING - void declaration
     */
    public Method lookupMethod(CtClass clazz, CtClass currentClass, MethodInfo current, String methodName, int[] argTypes, int[] argDims, String[] argClassNames) throws CompileError {
        void var1_1;
        Method m2;
        int res;
        Method maybe = null;
        if (current != null && clazz == currentClass && current.getName().equals(methodName) && (res = this.compareSignature(current.getDescriptor(), argTypes, argDims, argClassNames)) != -1) {
            void var3_4;
            Method r2 = new Method(clazz, current, res);
            if (res == 0) {
                return r2;
            }
            maybe = var3_4;
        }
        if ((m2 = this.lookupMethod((CtClass)var1_1, methodName, argTypes, argDims, argClassNames, maybe != null)) != null) {
            void var2_2;
            return var2_2;
        }
        return maybe;
    }

    /*
     * WARNING - void declaration
     */
    private Method lookupMethod(CtClass clazz, String methodName, int[] argTypes, int[] argDims, String[] argClassNames, boolean onlyExact) throws CompileError {
        CtClass[] pclazz22;
        Method maybe = null;
        Object cf22 = clazz.getClassFile2();
        if (cf22 != null) {
            cf22 = ((ClassFile)cf22).getMethods();
            cf22 = cf22.iterator();
            while (cf22.hasNext()) {
                int res;
                MethodInfo minfo = cf22.next();
                if (!minfo.getName().equals(methodName) || (minfo.getAccessFlags() & 0x40) != 0 || (res = this.compareSignature(minfo.getDescriptor(), argTypes, argDims, argClassNames)) == -1) continue;
                Method r2 = new Method(clazz, minfo, res);
                if (res == 0) {
                    return r2;
                }
                if (maybe != null && maybe.notmatch <= res) continue;
                maybe = r2;
            }
        }
        if (onlyExact) {
            maybe = null;
        } else if (maybe != null) {
            return maybe;
        }
        int cf22 = clazz.getModifiers();
        boolean isIntf = Modifier.isInterface(cf22);
        try {
            Method r3;
            if (!isIntf && (pclazz22 = clazz.getSuperclass()) != null && (r3 = this.lookupMethod((CtClass)pclazz22, methodName, argTypes, argDims, argClassNames, onlyExact)) != null) {
                return r3;
            }
        }
        catch (NotFoundException notFoundException) {}
        try {
            void var3_3;
            void var2_2;
            Method r4;
            void var1_1;
            CtClass pclazz;
            CtClass[] r3 = pclazz22 = clazz.getInterfaces();
            int pclazz22 = pclazz22.length;
            for (int i2 = 0; i2 < pclazz22; ++i2) {
                CtClass intf = r3[i2];
                Method r5 = this.lookupMethod(intf, methodName, argTypes, argDims, argClassNames, onlyExact);
                if (r5 == null) continue;
                return r5;
            }
            if (isIntf && (pclazz = var1_1.getSuperclass()) != null && (r4 = this.lookupMethod(pclazz, (String)var2_2, (int[])var3_3, argDims, argClassNames, onlyExact)) != null) {
                return r4;
            }
        }
        catch (NotFoundException notFoundException) {}
        return maybe;
    }

    private int compareSignature(String desc, int[] argTypes, int[] argDims, String[] argClassNames) throws CompileError {
        int result = 0;
        int i2 = 1;
        int nArgs = argTypes.length;
        if (nArgs != Descriptor.numOfParameters(desc)) {
            return -1;
        }
        int len = desc.length();
        int n2 = 0;
        while (i2 < len) {
            int j2;
            char c2;
            if ((c2 = desc.charAt(i2++)) == ')') {
                if (n2 == nArgs) {
                    return result;
                }
                return -1;
            }
            if (n2 >= nArgs) {
                return -1;
            }
            int dim = 0;
            while (c2 == '[') {
                ++dim;
                c2 = desc.charAt(i2++);
            }
            if (argTypes[n2] == 412) {
                if (dim == 0 && c2 != 'L') {
                    return -1;
                }
                if (c2 == 'L') {
                    i2 = desc.indexOf(59, i2) + 1;
                }
            } else if (argDims[n2] != dim) {
                if (dim != 0 || c2 != 'L' || !desc.startsWith("java/lang/Object;", i2)) {
                    return -1;
                }
                i2 = desc.indexOf(59, i2) + 1;
                ++result;
                if (i2 <= 0) {
                    return -1;
                }
            } else if (c2 == 'L') {
                block24: {
                    j2 = desc.indexOf(59, i2);
                    if (j2 < 0 || argTypes[n2] != 307) {
                        return -1;
                    }
                    String cname = desc.substring(i2, j2);
                    if (!cname.equals(argClassNames[n2])) {
                        CtClass clazz = this.lookupClassByJvmName(argClassNames[n2]);
                        try {
                            if (clazz.subtypeOf(this.lookupClassByJvmName(cname))) {
                                ++result;
                                break block24;
                            }
                            return -1;
                        }
                        catch (NotFoundException notFoundException) {
                            ++result;
                        }
                    }
                }
                int n3 = j2 + 1;
            } else {
                int at;
                int t2 = MemberResolver.descToType((char)j2);
                if (t2 != (at = argTypes[n2])) {
                    if (t2 == 324 && (at == 334 || at == 303 || at == 306)) {
                        ++result;
                    } else {
                        return -1;
                    }
                }
            }
            ++n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public CtField lookupFieldByJvmName2(String jvmClassName, Symbol fieldSym, ASTree expr) throws NoFieldException {
        CtClass cc;
        String field = fieldSym.get();
        try {
            cc = this.lookupClass(MemberResolver.jvmToJavaName(jvmClassName), true);
        }
        catch (CompileError compileError) {
            throw new NoFieldException(jvmClassName + "/" + field, expr);
        }
        try {
            return cc.getField(field);
        }
        catch (NotFoundException notFoundException) {
            void var3_3;
            void var2_2;
            void var1_1;
            jvmClassName = MemberResolver.javaToJvmName(cc.getName());
            throw new NoFieldException((String)var1_1 + "$" + (String)var2_2, (ASTree)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CtField lookupFieldByJvmName(String jvmClassName, Symbol fieldName) throws CompileError {
        void var2_2;
        void var1_1;
        return this.lookupField(MemberResolver.jvmToJavaName((String)var1_1), (Symbol)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CtField lookupField(String className, Symbol fieldName) throws CompileError {
        CtClass cc = this.lookupClass(className, false);
        try {
            void var1_1;
            return var1_1.getField(fieldName.get());
        }
        catch (NotFoundException notFoundException) {
            void var2_2;
            throw new CompileError("no such field: " + var2_2.get());
        }
    }

    /*
     * WARNING - void declaration
     */
    public CtClass lookupClassByName(ASTList name) throws CompileError {
        void var1_1;
        return this.lookupClass(Declarator.astToClassName((ASTList)var1_1, '.'), false);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass lookupClassByJvmName(String jvmName) throws CompileError {
        void var1_1;
        return this.lookupClass(MemberResolver.jvmToJavaName((String)var1_1), false);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass lookupClass(Declarator decl) throws CompileError {
        void var1_1;
        return this.lookupClass(decl.getType(), decl.getArrayDim(), var1_1.getClassName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CtClass lookupClass(int type, int dim, String classname) throws CompileError {
        void var1_2;
        String cname22;
        if (type == 307) {
            void var3_4;
            CtClass clazz = this.lookupClassByJvmName((String)var3_4);
            if (dim <= 0) return cname22;
            cname22 = clazz.getName();
        } else {
            void cname22;
            cname22 = MemberResolver.getTypeName((int)cname22);
        }
        while (dim-- > 0) {
            cname22 = cname22 + "[]";
        }
        return this.lookupClass((String)var1_2, false);
    }

    /*
     * WARNING - void declaration
     */
    static String getTypeName(int type) throws CompileError {
        void var1_1;
        int n2;
        String cname = "";
        switch (n2) {
            case 301: {
                cname = "boolean";
                break;
            }
            case 306: {
                cname = "char";
                break;
            }
            case 303: {
                cname = "byte";
                break;
            }
            case 334: {
                cname = "short";
                break;
            }
            case 324: {
                cname = "int";
                break;
            }
            case 326: {
                cname = "long";
                break;
            }
            case 317: {
                cname = "float";
                break;
            }
            case 312: {
                cname = "double";
                break;
            }
            case 344: {
                cname = "void";
                break;
            }
            default: {
                MemberResolver.fatal();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass lookupClass(String name, boolean notCheckInner) throws CompileError {
        void var2_3;
        void var1_1;
        void var3_4;
        CtClass cc;
        Map<String, String> cache = this.getInvalidNames();
        String found = cache.get(name);
        if (found == INVALID) {
            throw new CompileError("no such class: " + name);
        }
        if (found != null) {
            try {
                return this.classPool.get(found);
            }
            catch (NotFoundException notFoundException) {}
        }
        try {
            cc = this.lookupClass0(name, notCheckInner);
        }
        catch (NotFoundException notFoundException) {
            cc = this.searchImports(name);
        }
        var3_4.put(var1_1, cc.getName());
        return var2_3;
    }

    public static int getInvalidMapSize() {
        return invalidNamesMap.size();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> getInvalidNames() {
        void var1_1;
        Hashtable<String, String> ht = this.invalidNames;
        if (ht != null) return var1_1;
        Class<MemberResolver> clazz = MemberResolver.class;
        synchronized (MemberResolver.class) {
            Reference<Map<String, String>> ref = invalidNamesMap.get(this.classPool);
            if (ref != null) {
                void var3_4;
                ht = (Hashtable<String, String>)var3_4.get();
            }
            if (ht == null) {
                ht = new Hashtable<String, String>();
                invalidNamesMap.put(this.classPool, new WeakReference<Hashtable<String, String>>(ht));
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.invalidNames = ht;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private CtClass searchImports(String orgName) throws CompileError {
        void var1_1;
        if (orgName.indexOf(46) < 0) {
            Iterator<String> it = this.classPool.getImportedPackages();
            while (it.hasNext()) {
                String pac = it.next();
                String fqName = pac.replaceAll("\\.$", "") + "." + orgName;
                try {
                    return this.classPool.get(fqName);
                }
                catch (NotFoundException notFoundException) {
                    try {
                        void var3_3;
                        if (!pac.endsWith("." + orgName)) continue;
                        return this.classPool.get((String)var3_3);
                    }
                    catch (NotFoundException notFoundException2) {
                    }
                }
            }
        }
        this.getInvalidNames().put(orgName, INVALID);
        throw new CompileError("no such class: " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private CtClass lookupClass0(String classname, boolean notCheckInner) throws NotFoundException {
        void var3_3;
        CtClass cc = null;
        do {
            try {
                cc = this.classPool.get(classname);
            }
            catch (NotFoundException e2) {
                String string;
                int i2 = classname.lastIndexOf(46);
                if (notCheckInner || i2 < 0) {
                    throw e2;
                }
                StringBuilder sbuf = new StringBuilder(classname);
                sbuf.setCharAt(i2, '$');
                string = ((StringBuilder)((Object)string)).toString();
            }
        } while (cc == null);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String resolveClassName(ASTList name) throws CompileError {
        void var1_1;
        if (name == null) {
            return null;
        }
        return MemberResolver.javaToJvmName(this.lookupClassByName((ASTList)var1_1).getName());
    }

    /*
     * WARNING - void declaration
     */
    public String resolveJvmClassName(String jvmName) throws CompileError {
        void var1_1;
        if (jvmName == null) {
            return null;
        }
        return MemberResolver.javaToJvmName(this.lookupClassByJvmName((String)var1_1).getName());
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass getSuperclass(CtClass c2) throws CompileError {
        CtClass ctClass;
        try {
            CtClass sc = c2.getSuperclass();
            if (sc != null) {
                void var1_1;
                return var1_1;
            }
        }
        catch (NotFoundException notFoundException) {}
        throw new CompileError("cannot find the super class of " + ctClass.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass getSuperInterface(CtClass c2, String interfaceName) throws CompileError {
        CtClass ctClass;
        void var1_1;
        try {
            CtClass[] intfs = c2.getInterfaces();
            for (int i2 = 0; i2 < intfs.length; ++i2) {
                if (!intfs[i2].getName().equals(interfaceName)) continue;
                return intfs[i2];
            }
        }
        catch (NotFoundException notFoundException) {}
        throw new CompileError("cannot find the super interface " + (String)var1_1 + " of " + ctClass.getName());
    }

    public static String javaToJvmName(String classname) {
        return classname.replace('.', '/');
    }

    public static String jvmToJavaName(String classname) {
        return classname.replace('/', '.');
    }

    public static int descToType(char c2) throws CompileError {
        switch (c2) {
            case 'Z': {
                return 301;
            }
            case 'C': {
                return 306;
            }
            case 'B': {
                return 303;
            }
            case 'S': {
                return 334;
            }
            case 'I': {
                return 324;
            }
            case 'J': {
                return 326;
            }
            case 'F': {
                return 317;
            }
            case 'D': {
                return 312;
            }
            case 'V': {
                return 344;
            }
            case 'L': 
            case '[': {
                return 307;
            }
        }
        MemberResolver.fatal();
        return 344;
    }

    /*
     * WARNING - void declaration
     */
    public static int getModifiers(ASTList mods) {
        void var1_1;
        int m2 = 0;
        while (mods != null) {
            void var2_2;
            Keyword k2 = (Keyword)mods.head();
            mods = mods.tail();
            switch (var2_2.get()) {
                case 335: {
                    m2 |= 8;
                    break;
                }
                case 315: {
                    m2 |= 0x10;
                    break;
                }
                case 338: {
                    m2 |= 0x20;
                    break;
                }
                case 300: {
                    m2 |= 0x400;
                    break;
                }
                case 332: {
                    m2 |= 1;
                    break;
                }
                case 331: {
                    m2 |= 4;
                    break;
                }
                case 330: {
                    m2 |= 2;
                    break;
                }
                case 345: {
                    m2 |= 0x40;
                    break;
                }
                case 342: {
                    m2 |= 0x80;
                    break;
                }
                case 347: {
                    m2 |= 0x800;
                }
            }
        }
        return (int)var1_1;
    }

    public static class Method {
        public CtClass declaring;
        public MethodInfo info;
        public int notmatch;

        /*
         * WARNING - void declaration
         */
        public Method(CtClass c2, MethodInfo i2, int n2) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaring = var1_1;
            this.info = var2_2;
            this.notmatch = var3_3;
        }

        public boolean isStatic() {
            int n2 = this.info.getAccessFlags();
            return (n2 & 8) != 0;
        }
    }
}

