/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.compiler;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AccessFlag;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Bytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FieldInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.AccessorMaker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.MemberResolver;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.NoFieldException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.TypeChecker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTree;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ArrayInit;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CallExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Declarator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Expr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Keyword;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Member;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.MethodDecl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.NewExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Pair;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Stmnt;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MemberCodeGen
extends CodeGen {
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;
    protected boolean resultStatic;

    /*
     * WARNING - void declaration
     */
    public MemberCodeGen(Bytecode b2, CtClass cc, ClassPool cp) {
        super((Bytecode)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.resolver = new MemberResolver((ClassPool)var3_3);
        this.thisClass = var2_2;
        this.thisMethod = null;
    }

    /*
     * WARNING - void declaration
     */
    public int getMajorVersion() {
        void var1_1;
        ClassFile cf = this.thisClass.getClassFile2();
        if (cf == null) {
            return ClassFile.MAJOR_VERSION;
        }
        return var1_1.getMajorVersion();
    }

    /*
     * WARNING - void declaration
     */
    public void setThisMethod(CtMethod m2) {
        void var1_1;
        this.thisMethod = var1_1.getMethodInfo2();
        if (this.typeChecker != null) {
            this.typeChecker.setThisMethod(this.thisMethod);
        }
    }

    public CtClass getThisClass() {
        return this.thisClass;
    }

    @Override
    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    @Override
    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    @Override
    protected void insertDefaultSuperCall() throws CompileError {
        this.bytecode.addAload(0);
        this.bytecode.addInvokespecial(MemberResolver.getSuperclass(this.thisClass), "<init>", "()V");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atTryStmnt(Stmnt st) throws CompileError {
        void var2_2;
        Bytecode bc = this.bytecode;
        Stmnt body = (Stmnt)((ASTree)st).getLeft();
        if (body == null) {
            return;
        }
        ASTList catchList = (ASTList)((ASTree)st).getRight().getLeft();
        Stmnt finallyBlock = (Stmnt)((ASTree)st).getRight().getRight().getLeft();
        ArrayList<Integer> gotoList = new ArrayList<Integer>();
        JsrHook jsrHook = null;
        if (finallyBlock != null) {
            jsrHook = new JsrHook(this);
        }
        int start = bc.currentPc();
        ((ASTree)body).accept(this);
        int end = bc.currentPc();
        if (start == end) {
            throw new CompileError("empty try block");
        }
        boolean tryNotReturn = !this.hasReturned;
        if (tryNotReturn) {
            bc.addOpcode(167);
            gotoList.add(bc.currentPc());
            bc.addIndex(0);
        }
        int var = this.getMaxLocals();
        this.incMaxLocals(1);
        while (catchList != null) {
            Pair p2 = (Pair)catchList.head();
            catchList = catchList.tail();
            Declarator decl = (Declarator)((ASTree)p2).getLeft();
            Stmnt block = (Stmnt)((ASTree)p2).getRight();
            decl.setLocalVar(var);
            CtClass type = this.resolver.lookupClassByJvmName(decl.getClassName());
            decl.setClassName(MemberResolver.javaToJvmName(type.getName()));
            bc.addExceptionHandler(start, end, bc.currentPc(), type);
            bc.growStack(1);
            bc.addAstore(var);
            this.hasReturned = false;
            if (block != null) {
                ((ASTree)block).accept(this);
            }
            if (this.hasReturned) continue;
            bc.addOpcode(167);
            gotoList.add(bc.currentPc());
            bc.addIndex(0);
            tryNotReturn = true;
        }
        if (finallyBlock != null) {
            int pcAnyCatch;
            jsrHook.remove(this);
            int n2 = pcAnyCatch = bc.currentPc();
            bc.addExceptionHandler(start, n2, n2, 0);
            bc.growStack(1);
            bc.addAstore(var);
            this.hasReturned = false;
            ((ASTree)finallyBlock).accept(this);
            if (!this.hasReturned) {
                bc.addAload(var);
                bc.addOpcode(191);
            }
            this.addFinally(jsrHook.jsrList, finallyBlock);
        }
        int pcEnd = var2_2.currentPc();
        this.patchGoto(gotoList, pcEnd);
        boolean bl = this.hasReturned = !tryNotReturn;
        if (finallyBlock != null && tryNotReturn) {
            void var1_1;
            var1_1.accept(this);
        }
    }

    private void addFinally(List<int[]> returnList, Stmnt finallyBlock) throws CompileError {
        Iterator iterator2;
        Bytecode bc = this.bytecode;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            int[] ret = (int[])iterator2.next();
            int pc = ret[0];
            bc.write16bit(pc, bc.currentPc() - pc + 1);
            JsrHook2 hook = new JsrHook2(this, ret);
            ((ASTree)finallyBlock).accept(this);
            hook.remove(this);
            if (this.hasReturned) continue;
            bc.addOpcode(167);
            bc.addIndex(pc + 3 - bc.currentPc());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atNewExpr(NewExpr expr) throws CompileError {
        void var3_3;
        void var1_1;
        void var2_2;
        if (expr.isArray()) {
            this.atNewArrayExpr(expr);
            return;
        }
        CtClass clazz = this.resolver.lookupClassByName(expr.getClassName());
        String cname = clazz.getName();
        ASTList args2 = expr.getArguments();
        this.bytecode.addNew(cname);
        this.bytecode.addOpcode(89);
        this.atMethodCallCore((CtClass)var2_2, "<init>", (ASTList)var1_1, false, true, -1, null);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = MemberResolver.javaToJvmName((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void atNewArrayExpr(NewExpr expr) throws CompileError {
        void var1_1;
        void var3_3;
        void var2_2;
        int type = expr.getArrayType();
        ASTList size = expr.getArraySize();
        ASTList classname = expr.getClassName();
        ArrayInit init = expr.getInitializer();
        if (size.length() > 1) {
            if (init != null) {
                throw new CompileError("sorry, multi-dimensional array initializer for new is not supported");
            }
            this.atMultiNewArray(type, classname, size);
            return;
        }
        ASTree sizeExpr = size.head();
        this.atNewArrayExpr2((int)var2_2, (ASTree)var3_3, Declarator.astToClassName(classname, '/'), (ArrayInit)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void atNewArrayExpr2(int type, ASTree sizeExpr, String jvmClassname, ArrayInit init) throws CompileError {
        void var2_2;
        void var1_1;
        String elementClass;
        if (init == null) {
            if (sizeExpr == null) {
                throw new CompileError("no array size");
            }
            sizeExpr.accept(this);
        } else if (sizeExpr == null) {
            int s2 = init.size();
            this.bytecode.addIconst(s2);
        } else {
            throw new CompileError("unnecessary array size specified for new");
        }
        if (type == 307) {
            elementClass = this.resolveClassName(jvmClassname);
            this.bytecode.addAnewarray(MemberResolver.jvmToJavaName(elementClass));
        } else {
            elementClass = null;
            int atype = 0;
            switch (type) {
                case 301: {
                    atype = 4;
                    break;
                }
                case 306: {
                    atype = 5;
                    break;
                }
                case 317: {
                    atype = 6;
                    break;
                }
                case 312: {
                    atype = 7;
                    break;
                }
                case 303: {
                    atype = 8;
                    break;
                }
                case 334: {
                    atype = 9;
                    break;
                }
                case 324: {
                    atype = 10;
                    break;
                }
                case 326: {
                    atype = 11;
                    break;
                }
                default: {
                    MemberCodeGen.badNewExpr();
                }
            }
            this.bytecode.addOpcode(188);
            this.bytecode.add(atype);
        }
        if (init != null) {
            int s3 = init.size();
            ASTList list = init;
            for (int i2 = 0; i2 < s3; ++i2) {
                this.bytecode.addOpcode(89);
                this.bytecode.addIconst(i2);
                list.head().accept(this);
                if (!MemberCodeGen.isRefType(type)) {
                    MemberCodeGen memberCodeGen = this;
                    memberCodeGen.atNumCastExpr(memberCodeGen.exprType, type);
                }
                this.bytecode.addOpcode(MemberCodeGen.getArrayWriteOp(type, 0));
                list = list.tail();
            }
        }
        this.exprType = var1_1;
        this.arrayDim = 1;
        this.className = var2_2;
    }

    private static void badNewExpr() throws CompileError {
        throw new CompileError("bad new expression");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atArrayVariableAssign(ArrayInit init, int varType, int varArray, String varClass) throws CompileError {
        void var1_1;
        void var2_2;
        this.atNewArrayExpr2((int)var2_2, null, varClass, (ArrayInit)var1_1);
    }

    @Override
    public void atArrayInit(ArrayInit init) throws CompileError {
        throw new CompileError("array initializer is not supported");
    }

    /*
     * WARNING - void declaration
     */
    protected void atMultiNewArray(int type, ASTList classname, ASTList size) throws CompileError {
        String desc;
        ASTree s2;
        int dim = size.length();
        int count = 0;
        while (size != null && (s2 = size.head()) != null) {
            ++count;
            s2.accept(this);
            if (this.exprType != 324) {
                throw new CompileError("bad type for array size");
            }
            size = size.tail();
        }
        this.exprType = type;
        this.arrayDim = dim;
        if (type == 307) {
            void var2_2;
            this.className = this.resolveClassName((ASTList)var2_2);
            desc = MemberCodeGen.toJvmArrayName(this.className, dim);
        } else {
            void var1_1;
            desc = MemberCodeGen.toJvmTypeName((int)var1_1, dim);
        }
        this.bytecode.addMultiNewarray(desc, count);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        void var1_1;
        void var2_2;
        void var3_3;
        boolean bl;
        String mname = null;
        CtClass targetClass = null;
        ASTree method = expr.oprand1();
        ASTList args2 = (ASTList)expr.oprand2();
        boolean isStatic = false;
        boolean isSpecial = false;
        int aload0pos = -1;
        MemberResolver.Method cached = expr.getMethod();
        if (method instanceof Member) {
            mname = ((Member)method).get();
            targetClass = this.thisClass;
            if (this.inStaticMethod || cached != null && cached.isStatic()) {
                isStatic = true;
            } else {
                aload0pos = this.bytecode.currentPc();
                this.bytecode.addAload(0);
            }
        } else if (method instanceof Keyword) {
            isSpecial = true;
            mname = "<init>";
            targetClass = this.thisClass;
            if (this.inStaticMethod) {
                throw new CompileError("a constructor cannot be static");
            }
            this.bytecode.addAload(0);
            if (((Keyword)method).get() == 336) {
                targetClass = MemberResolver.getSuperclass(targetClass);
            }
        } else if (method instanceof Expr) {
            Expr e2 = (Expr)method;
            mname = ((Symbol)e2.oprand2()).get();
            int op = e2.getOperator();
            if (op == 35) {
                targetClass = this.resolver.lookupClass(((Symbol)e2.oprand1()).get(), false);
                isStatic = true;
            } else if (op == 46) {
                ASTree target = e2.oprand1();
                String classFollowedByDotSuper = TypeChecker.isDotSuper(target);
                if (classFollowedByDotSuper != null) {
                    isSpecial = true;
                    targetClass = MemberResolver.getSuperInterface(this.thisClass, classFollowedByDotSuper);
                    if (this.inStaticMethod || cached != null && cached.isStatic()) {
                        isStatic = true;
                    } else {
                        aload0pos = this.bytecode.currentPc();
                        this.bytecode.addAload(0);
                    }
                } else {
                    if (target instanceof Keyword && ((Keyword)target).get() == 336) {
                        isSpecial = true;
                    }
                    try {
                        target.accept(this);
                    }
                    catch (NoFieldException noFieldException) {
                        NoFieldException nfe = noFieldException;
                        if (noFieldException.getExpr() != target) {
                            throw nfe;
                        }
                        this.exprType = 307;
                        this.arrayDim = 0;
                        this.className = nfe.getField();
                        bl = true;
                    }
                    if (this.arrayDim > 0) {
                        targetClass = this.resolver.lookupClass("java.lang.Object", true);
                    } else if (this.exprType == 307) {
                        targetClass = this.resolver.lookupClassByJvmName(this.className);
                    } else {
                        MemberCodeGen.badMethod();
                    }
                }
            } else {
                MemberCodeGen.badMethod();
            }
        } else {
            MemberCodeGen.fatal();
        }
        this.atMethodCallCore((CtClass)var3_3, (String)var2_2, args2, bl, isSpecial, aload0pos, (MemberResolver.Method)var1_1);
    }

    private static void badMethod() throws CompileError {
        throw new CompileError("bad method");
    }

    /*
     * WARNING - void declaration
     */
    public void atMethodCallCore(CtClass targetClass, String mname, ASTList args2, boolean isStatic, boolean isSpecial, int aload0pos, MemberResolver.Method found) throws CompileError {
        void var2_2;
        void var1_1;
        void var3_3;
        int nargs = this.getMethodArgsLength(args2);
        int[] types = new int[nargs];
        int[] dims = new int[nargs];
        String[] cnames = new String[nargs];
        if (!isStatic && found != null && found.isStatic()) {
            this.bytecode.addOpcode(87);
            isStatic = true;
        }
        this.bytecode.getStackDepth();
        this.atMethodArgs((ASTList)var3_3, types, dims, cnames);
        if (found == null) {
            found = this.resolver.lookupMethod(targetClass, this.thisClass, this.thisMethod, mname, types, dims, cnames);
        }
        if (found == null) {
            String msg;
            msg = mname.equals("<init>") ? "constructor not found" : "Method " + mname + " not found in " + ((CtClass)((Object)msg)).getName();
            throw new CompileError((String)var1_1);
        }
        this.atMethodCallCore2((CtClass)var1_1, (String)var2_2, isStatic, isSpecial, aload0pos, found);
    }

    private boolean isFromSameDeclaringClass(CtClass outer, CtClass inner) {
        try {
            while (outer != null) {
                if (this.isEnclosing(outer, inner)) {
                    return true;
                }
                outer = outer.getDeclaringClass();
            }
        }
        catch (NotFoundException notFoundException) {}
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void atMethodCallCore2(CtClass targetClass, String mname, boolean isStatic, boolean isSpecial, int aload0pos, MemberResolver.Method found) throws CompileError {
        void var3_4;
        CtClass declClass = found.declaring;
        MethodInfo minfo = found.info;
        String desc = minfo.getDescriptor();
        int acc = minfo.getAccessFlags();
        if (mname.equals("<init>")) {
            isSpecial = true;
            if (declClass != targetClass) {
                throw new CompileError("no such constructor: " + targetClass.getName());
            }
            if (declClass != this.thisClass && AccessFlag.isPrivate(acc) && (declClass.getClassFile().getMajorVersion() < 52 || !this.isFromSameDeclaringClass(declClass, this.thisClass))) {
                desc = this.getAccessibleConstructor(desc, declClass, minfo);
                this.bytecode.addOpcode(1);
            }
        } else if (AccessFlag.isPrivate(acc)) {
            if (declClass == this.thisClass) {
                isSpecial = true;
            } else {
                isSpecial = false;
                isStatic = true;
                String origDesc = desc;
                if ((acc & 8) == 0) {
                    desc = Descriptor.insertParameter(declClass.getName(), origDesc);
                }
                acc = AccessFlag.setPackage(acc) | 8;
                mname = this.getAccessiblePrivate(mname, origDesc, desc, minfo, declClass);
            }
        }
        boolean popTarget = false;
        if ((acc & 8) != 0) {
            if (!isStatic) {
                isStatic = true;
                if (aload0pos >= 0) {
                    this.bytecode.write(aload0pos, 0);
                } else {
                    popTarget = true;
                }
            }
            this.bytecode.addInvokestatic(declClass, mname, desc);
        } else if (isSpecial) {
            this.bytecode.addInvokespecial(targetClass, mname, desc);
        } else {
            if (!Modifier.isPublic(declClass.getModifiers()) || declClass.isInterface() != targetClass.isInterface()) {
                declClass = targetClass;
            }
            if (declClass.isInterface()) {
                void var1_2;
                int nargs = Descriptor.paramSize(desc) + 1;
                this.bytecode.addInvokeinterface(declClass, mname, desc, (int)var1_2);
            } else {
                void var2_3;
                if (isStatic) {
                    throw new CompileError(mname + " is not static");
                }
                this.bytecode.addInvokevirtual(declClass, (String)var2_3, desc);
            }
        }
        this.setReturnType(desc, (boolean)var3_4, popTarget);
    }

    /*
     * WARNING - void declaration
     */
    protected String getAccessiblePrivate(String methodName, String desc, String newDesc, MethodInfo minfo, CtClass declClass) throws CompileError {
        void var1_1;
        AccessorMaker maker;
        if (this.isEnclosing(declClass, this.thisClass) && (maker = declClass.getAccessorMaker()) != null) {
            void var3_3;
            void var2_2;
            return maker.getMethodAccessor(methodName, (String)var2_2, (String)var3_3, minfo);
        }
        throw new CompileError("Method " + (String)var1_1 + " is private");
    }

    /*
     * WARNING - void declaration
     */
    protected String getAccessibleConstructor(String desc, CtClass declClass, MethodInfo minfo) throws CompileError {
        void var2_2;
        AccessorMaker maker;
        if (this.isEnclosing(declClass, this.thisClass) && (maker = declClass.getAccessorMaker()) != null) {
            void var3_3;
            void var1_1;
            return maker.getConstructor(declClass, (String)var1_1, (MethodInfo)var3_3);
        }
        throw new CompileError("the called constructor is private in " + var2_2.getName());
    }

    private boolean isEnclosing(CtClass outer, CtClass inner) {
        try {
            while (inner != null) {
                if ((inner = inner.getDeclaringClass()) != outer) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {}
        return false;
    }

    public int getMethodArgsLength(ASTList args2) {
        return ASTList.length(args2);
    }

    public void atMethodArgs(ASTList args2, int[] types, int[] dims, String[] cnames) throws CompileError {
        int i2 = 0;
        while (args2 != null) {
            ASTree aSTree = args2.head();
            aSTree.accept(this);
            types[i2] = this.exprType;
            dims[i2] = this.arrayDim;
            cnames[i2] = this.className;
            ++i2;
            args2 = args2.tail();
        }
    }

    /*
     * WARNING - void declaration
     */
    void setReturnType(String desc, boolean isStatic, boolean popTarget) throws CompileError {
        void var3_3;
        void var2_2;
        int j2;
        int i2 = desc.indexOf(41);
        if (i2 < 0) {
            MemberCodeGen.badMethod();
        }
        char c2 = desc.charAt(++i2);
        int dim = 0;
        while (c2 == '[') {
            ++dim;
            c2 = desc.charAt(++i2);
        }
        this.arrayDim = dim;
        if (c2 == 'L') {
            void var1_1;
            j2 = desc.indexOf(59, i2 + 1);
            if (j2 < 0) {
                MemberCodeGen.badMethod();
            }
            this.exprType = 307;
            this.className = var1_1.substring(i2 + 1, j2);
        } else {
            this.exprType = MemberResolver.descToType((char)j2);
            this.className = null;
        }
        int etype = this.exprType;
        if (var2_2 != false && var3_3 != false) {
            if (MemberCodeGen.is2word(etype, dim)) {
                this.bytecode.addOpcode(93);
                this.bytecode.addOpcode(88);
                this.bytecode.addOpcode(87);
                return;
            }
            if (etype == 344) {
                this.bytecode.addOpcode(87);
                return;
            }
            this.bytecode.addOpcode(95);
            this.bytecode.addOpcode(87);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right, boolean doDup) throws CompileError {
        void var1_2;
        void var3_4;
        int fi;
        CtField f2 = this.fieldAccess(left, false);
        boolean is_static = this.resultStatic;
        if (op != 61 && !is_static) {
            this.bytecode.addOpcode(89);
        }
        if (op == 61) {
            FieldInfo finfo = f2.getFieldInfo2();
            this.setFieldType(finfo);
            AccessorMaker accessorMaker = this.isAccessibleField(f2, finfo);
            fi = accessorMaker == null ? this.addFieldrefInfo(f2, finfo) : 0;
        } else {
            fi = this.atFieldRead(f2, is_static);
        }
        int fType = this.exprType;
        int fDim = this.arrayDim;
        String cname = this.className;
        this.atAssignCore(expr, op, right, fType, fDim, cname);
        boolean is2w = MemberCodeGen.is2word(fType, fDim);
        if (doDup) {
            void var2_3;
            int dup_code = is_static ? (is2w ? 92 : 89) : (is2w ? 93 : 90);
            this.bytecode.addOpcode((int)var2_3);
        }
        this.atFieldAssignCore((CtField)var3_4, is_static, fi, (boolean)var1_2);
        this.exprType = fType;
        this.arrayDim = fDim;
        this.className = cname;
    }

    /*
     * WARNING - void declaration
     */
    private void atFieldAssignCore(CtField f2, boolean is_static, int fi, boolean is2byte) throws CompileError {
        void var1_1;
        void var3_4;
        void var2_2;
        if (fi != 0) {
            if (is_static) {
                this.bytecode.add(179);
                this.bytecode.growStack(is2byte ? -2 : -1);
            } else {
                this.bytecode.add(181);
                this.bytecode.growStack(is2byte ? -3 : -2);
            }
            this.bytecode.addIndex(fi);
            return;
        }
        CtClass declClass = ((CtMember)f2).getDeclaringClass();
        AccessorMaker maker = declClass.getAccessorMaker();
        FieldInfo finfo = f2.getFieldInfo2();
        MethodInfo minfo = maker.getFieldSetter(finfo, (boolean)var2_2);
        this.bytecode.addInvokestatic((CtClass)var3_4, minfo.getName(), var1_1.getDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMember(Member mem) throws CompileError {
        void var1_1;
        this.atFieldRead((ASTree)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atFieldRead(ASTree expr) throws CompileError {
        void var2_3;
        void var3_4;
        CtField f2 = this.fieldAccess(expr, true);
        if (f2 == null) {
            this.atArrayLength(expr);
            return;
        }
        boolean is_static = this.resultStatic;
        ASTree cexpr = TypeChecker.getConstantFieldValue(f2);
        if (cexpr == null) {
            void var1_2;
            this.atFieldRead(f2, (boolean)var1_2);
            return;
        }
        var3_4.accept(this);
        this.setFieldType(var2_3.getFieldInfo2());
    }

    private void atArrayLength(ASTree expr) throws CompileError {
        if (this.arrayDim == 0) {
            throw new CompileError(".length applied to a non array");
        }
        this.bytecode.addOpcode(190);
        this.exprType = 324;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     */
    private int atFieldRead(CtField f2, boolean isStatic) throws CompileError {
        void var3_4;
        void var2_2;
        void var1_1;
        MethodInfo minfo;
        FieldInfo finfo = f2.getFieldInfo2();
        boolean is2byte = this.setFieldType(finfo);
        AccessorMaker maker = this.isAccessibleField(f2, finfo);
        if (maker != null) {
            minfo = maker.getFieldGetter(finfo, isStatic);
            this.bytecode.addInvokestatic(((CtMember)f2).getDeclaringClass(), minfo.getName(), minfo.getDescriptor());
            return 0;
        }
        int fi = this.addFieldrefInfo((CtField)var1_1, (FieldInfo)((Object)minfo));
        if (var2_2 != false) {
            this.bytecode.add(178);
            this.bytecode.growStack(is2byte ? 2 : 1);
        } else {
            this.bytecode.add(180);
            this.bytecode.growStack(is2byte ? 1 : 0);
        }
        this.bytecode.addIndex(fi);
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private AccessorMaker isAccessibleField(CtField f2, FieldInfo finfo) throws CompileError {
        if (AccessFlag.isPrivate(finfo.getAccessFlags()) && ((CtMember)f2).getDeclaringClass() != this.thisClass) {
            void var2_2;
            void var1_1;
            AccessorMaker maker;
            CtClass declClass = ((CtMember)f2).getDeclaringClass();
            if (this.isEnclosing(declClass, this.thisClass) && (maker = declClass.getAccessorMaker()) != null) {
                void var3_3;
                return var3_3;
            }
            throw new CompileError("Field " + var1_1.getName() + " in " + var2_2.getName() + " is private.");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean setFieldType(FieldInfo finfo) throws CompileError {
        void var3_4;
        void var2_3;
        void var1_1;
        String type = finfo.getDescriptor();
        int i2 = 0;
        int dim = 0;
        char c2 = type.charAt(0);
        while (c2 == '[') {
            ++dim;
            c2 = type.charAt(++i2);
        }
        this.arrayDim = dim;
        this.exprType = MemberResolver.descToType(c2);
        this.className = c2 == 'L' ? type.substring(i2 + 1, var1_1.indexOf(59, (int)(var2_3 + true))) : null;
        boolean bl = var3_4 == false && (c2 == 'J' || c2 == 'D');
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private int addFieldrefInfo(CtField f2, FieldInfo finfo) {
        void var2_3;
        void var1_2;
        void var3_4;
        ConstPool cp = this.bytecode.getConstPool();
        String cname = ((CtMember)f2).getDeclaringClass().getName();
        int ci = cp.addClassInfo(cname);
        String name = finfo.getName();
        String type = finfo.getDescriptor();
        return var3_4.addFieldrefInfo((int)var1_2, name, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atClassObject2(String cname) throws CompileError {
        void var1_1;
        if (this.getMajorVersion() < 49) {
            super.atClassObject2(cname);
            return;
        }
        this.bytecode.addLdc(this.bytecode.getConstPool().addClassInfo((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atFieldPlusPlus(int token, boolean isPost, ASTree oprand, Expr expr, boolean doDup) throws CompileError {
        void var3_3;
        void var2_2;
        void var1_1;
        CtField f2 = this.fieldAccess(oprand, false);
        boolean is_static = this.resultStatic;
        if (!is_static) {
            this.bytecode.addOpcode(89);
        }
        int fi = this.atFieldRead(f2, is_static);
        int n2 = this.exprType;
        boolean is2w = MemberCodeGen.is2word(n2, this.arrayDim);
        int dup_code = is_static ? (is2w ? 92 : 89) : (is2w ? 93 : 90);
        this.atPlusPlusCore(dup_code, doDup, (int)var1_1, (boolean)var2_2, expr);
        this.atFieldAssignCore((CtField)var3_3, is_static, fi, is2w);
    }

    /*
     * WARNING - void declaration
     */
    protected CtField fieldAccess(ASTree expr, boolean acceptLength) throws CompileError {
        if (expr instanceof Member) {
            CtField f2;
            String name = ((Member)expr).get();
            try {
                f2 = this.thisClass.getField(name);
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(name, expr);
            }
            boolean is_static = Modifier.isStatic(((CtMember)f2).getModifiers());
            if (!is_static) {
                if (this.inStaticMethod) {
                    throw new CompileError("not available in a static method: " + name);
                }
                this.bytecode.addAload(0);
            }
            this.resultStatic = is_static;
            return f2;
        }
        if (expr instanceof Expr) {
            Expr e2 = (Expr)expr;
            int op = e2.getOperator();
            if (op == 35) {
                CtField f3 = this.resolver.lookupField(((Symbol)e2.oprand1()).get(), (Symbol)e2.oprand2());
                this.resultStatic = true;
                return f3;
            }
            if (op == 46) {
                CtMember f4 = null;
                try {
                    e2.oprand1().accept(this);
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        f4 = this.resolver.lookupFieldByJvmName(this.className, (Symbol)e2.oprand2());
                    } else {
                        if (acceptLength && this.arrayDim > 0 && ((Symbol)e2.oprand2()).get().equals("length")) {
                            return null;
                        }
                        MemberCodeGen.badLvalue();
                    }
                    boolean is_static = Modifier.isStatic(f4.getModifiers());
                    if (is_static) {
                        this.bytecode.addOpcode(87);
                    }
                    this.resultStatic = is_static;
                    return f4;
                }
                catch (NoFieldException noFieldException) {
                    void var1_1;
                    void var3_5;
                    void var2_3;
                    NoFieldException nfe = noFieldException;
                    if (noFieldException.getExpr() != e2.oprand1()) {
                        throw nfe;
                    }
                    Symbol fname = (Symbol)e2.oprand2();
                    String cname = nfe.getField();
                    f4 = this.resolver.lookupFieldByJvmName2((String)var2_3, (Symbol)var3_5, (ASTree)var1_1);
                    this.resultStatic = true;
                    return f4;
                }
            }
            MemberCodeGen.badLvalue();
        } else {
            MemberCodeGen.badLvalue();
        }
        this.resultStatic = false;
        return null;
    }

    private static void badLvalue() throws CompileError {
        throw new CompileError("bad l-value");
    }

    /*
     * WARNING - void declaration
     */
    public CtClass[] makeParamList(MethodDecl md) throws CompileError {
        void var1_1;
        CtClass[] params;
        ASTList plist = md.getParams();
        if (plist == null) {
            params = new CtClass[]{};
        } else {
            int i2 = 0;
            params = new CtClass[plist.length()];
            while (plist != null) {
                params[i2++] = this.resolver.lookupClass((Declarator)plist.head());
                plist = plist.tail();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass[] makeThrowsList(MethodDecl md) throws CompileError {
        void var1_1;
        ASTList list = md.getThrows();
        if (list == null) {
            return null;
        }
        int i2 = 0;
        CtClass[] clist = new CtClass[list.length()];
        while (list != null) {
            clist[i2++] = this.resolver.lookupClassByName((ASTList)list.head());
            list = list.tail();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String resolveClassName(ASTList name) throws CompileError {
        void var1_1;
        return this.resolver.resolveClassName((ASTList)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String resolveClassName(String jvmName) throws CompileError {
        void var1_1;
        return this.resolver.resolveJvmClassName((String)var1_1);
    }

    static class JsrHook
    extends CodeGen.ReturnHook {
        List<int[]> jsrList = new ArrayList<int[]>();
        CodeGen cgen;
        int var;

        /*
         * WARNING - void declaration
         */
        JsrHook(CodeGen gen) {
            super(gen);
            void var1_1;
            this.cgen = var1_1;
            this.var = -1;
        }

        /*
         * WARNING - void declaration
         */
        private int getVar(int size) {
            if (this.var < 0) {
                void var1_1;
                this.var = this.cgen.getMaxLocals();
                this.cgen.incMaxLocals((int)var1_1);
            }
            return this.var;
        }

        /*
         * WARNING - void declaration
         */
        private void jsrJmp(Bytecode b2) {
            void var1_1;
            b2.addOpcode(167);
            this.jsrList.add(new int[]{b2.currentPc(), this.var});
            var1_1.addIndex(0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean doit(Bytecode b2, int opcode) {
            switch (opcode) {
                case 177: {
                    this.jsrJmp(b2);
                    break;
                }
                case 176: {
                    b2.addAstore(this.getVar(1));
                    this.jsrJmp(b2);
                    b2.addAload(this.var);
                    break;
                }
                case 172: {
                    b2.addIstore(this.getVar(1));
                    this.jsrJmp(b2);
                    b2.addIload(this.var);
                    break;
                }
                case 173: {
                    b2.addLstore(this.getVar(2));
                    this.jsrJmp(b2);
                    b2.addLload(this.var);
                    break;
                }
                case 175: {
                    b2.addDstore(this.getVar(2));
                    this.jsrJmp(b2);
                    b2.addDload(this.var);
                    break;
                }
                case 174: {
                    void var1_1;
                    b2.addFstore(this.getVar(1));
                    this.jsrJmp(b2);
                    var1_1.addFload(this.var);
                    break;
                }
                default: {
                    throw new RuntimeException("fatal");
                }
            }
            return false;
        }
    }

    static class JsrHook2
    extends CodeGen.ReturnHook {
        int var;
        int target;

        /*
         * WARNING - void declaration
         */
        JsrHook2(CodeGen gen, int[] retTarget) {
            super((CodeGen)var1_1);
            void var2_2;
            void var1_1;
            this.target = retTarget[0];
            this.var = var2_2[1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean doit(Bytecode b2, int opcode) {
            void var1_1;
            switch (opcode) {
                case 177: {
                    break;
                }
                case 176: {
                    b2.addAstore(this.var);
                    break;
                }
                case 172: {
                    b2.addIstore(this.var);
                    break;
                }
                case 173: {
                    b2.addLstore(this.var);
                    break;
                }
                case 175: {
                    b2.addDstore(this.var);
                    break;
                }
                case 174: {
                    b2.addFstore(this.var);
                    break;
                }
                default: {
                    throw new RuntimeException("fatal");
                }
            }
            b2.addOpcode(167);
            b2.addIndex(this.target - var1_1.currentPc() + 3);
            return true;
        }
    }
}

