/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.compiler;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtPrimitiveType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.JvstCodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.MemberResolver;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.TypeChecker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTree;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CallExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CastExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Expr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Member;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Symbol;

public class JvstTypeChecker
extends TypeChecker {
    private JvstCodeGen codeGen;

    /*
     * WARNING - void declaration
     */
    public JvstTypeChecker(CtClass cc, ClassPool cp, JvstCodeGen gen) {
        super((CtClass)var1_1, (ClassPool)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.codeGen = var3_3;
    }

    public void addNullIfVoid() {
        if (this.exprType == 344) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMember(Member mem) throws CompileError {
        void var1_1;
        void var2_2;
        String name = mem.get();
        if (name.equals(this.codeGen.paramArrayName)) {
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Object";
            return;
        }
        if (name.equals("$sig")) {
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Class";
            return;
        }
        if (name.equals("$type") || var2_2.equals("$class")) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Class";
            return;
        }
        super.atMember((Member)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right) throws CompileError {
        void var3_3;
        void var2_2;
        void var1_1;
        if (left instanceof Member && ((Member)left).get().equals(this.codeGen.paramArrayName)) {
            right.accept(this);
            CtClass[] params = this.codeGen.paramTypeList;
            if (this.codeGen.paramTypeList == null) {
                return;
            }
            int n2 = params.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.compileUnwrapValue(params[i2]);
            }
            return;
        }
        super.atFieldAssign((Expr)var1_1, (int)var2_2, (ASTree)var3_3, right);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        void var1_1;
        ASTree p2;
        ASTList classname = expr.getClassName();
        if (classname != null && expr.getArrayDim() == 0 && (p2 = classname.head()) instanceof Symbol && classname.tail() == null) {
            void var2_2;
            void var3_3;
            String typename = ((Symbol)var3_3).get();
            if (typename.equals(this.codeGen.returnCastName)) {
                this.atCastToRtype(expr);
                return;
            }
            if (var2_2.equals("$w")) {
                this.atCastToWrapper(expr);
                return;
            }
        }
        super.atCastExpr((CastExpr)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void atCastToRtype(CastExpr expr) throws CompileError {
        CtClass returnType = this.codeGen.returnType;
        ((CastExpr)expr).getOprand().accept(this);
        if (this.exprType == 344 || CodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            this.compileUnwrapValue(returnType);
            return;
        }
        if (returnType instanceof CtPrimitiveType) {
            void var1_2;
            void var2_3;
            expr = (CtPrimitiveType)var2_3;
            int destType = MemberResolver.descToType(((CtPrimitiveType)expr).getDescriptor());
            this.exprType = var1_2;
            this.arrayDim = 0;
            this.className = null;
        }
    }

    protected void atCastToWrapper(CastExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        if (CodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            return;
        }
        CtClass ctClass = this.resolver.lookupClass(this.exprType, this.arrayDim, this.className);
        if (ctClass instanceof CtPrimitiveType) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        void var1_1;
        ASTree method = expr.oprand1();
        if (method instanceof Member) {
            void var2_2;
            String name = ((Member)method).get();
            if (this.codeGen.procHandler != null && name.equals(this.codeGen.proceedName)) {
                this.codeGen.procHandler.setReturnType(this, (ASTList)expr.oprand2());
                return;
            }
            if (var2_2.equals("$cflow")) {
                this.atCflow((ASTList)expr.oprand2());
                return;
            }
        }
        super.atCallExpr((CallExpr)var1_1);
    }

    protected void atCflow(ASTList cname) throws CompileError {
        this.exprType = 324;
        this.arrayDim = 0;
        this.className = null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isParamListName(ASTList args2) {
        if (this.codeGen.paramTypeList != null && args2 != null && args2.tail() == null) {
            void var1_1;
            ASTree left = args2.head();
            return left instanceof Member && ((Member)var1_1).get().equals(this.codeGen.paramListName);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMethodArgsLength(ASTList args2) {
        void var3_3;
        String pname = this.codeGen.paramListName;
        int n2 = 0;
        while (args2 != null) {
            ASTree a2 = args2.head();
            if (a2 instanceof Member && ((Member)a2).get().equals(pname)) {
                if (this.codeGen.paramTypeList != null) {
                    n2 += this.codeGen.paramTypeList.length;
                }
            } else {
                ++n2;
            }
            args2 = args2.tail();
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMethodArgs(ASTList args2, int[] types, int[] dims, String[] cnames) throws CompileError {
        CtClass[] params = this.codeGen.paramTypeList;
        String pname = this.codeGen.paramListName;
        int i2 = 0;
        while (args2 != null) {
            ASTree a2 = args2.head();
            if (a2 instanceof Member && ((Member)a2).get().equals(pname)) {
                if (params != null) {
                    int n2 = params.length;
                    for (int k2 = 0; k2 < n2; ++k2) {
                        CtClass p2 = params[k2];
                        this.setType(p2);
                        types[i2] = this.exprType;
                        dims[i2] = this.arrayDim;
                        cnames[i2] = this.className;
                        ++i2;
                    }
                }
            } else {
                void var8_8;
                var8_8.accept(this);
                types[i2] = this.exprType;
                dims[i2] = this.arrayDim;
                cnames[i2] = this.className;
                ++i2;
            }
            args2 = args2.tail();
        }
    }

    /*
     * WARNING - void declaration
     */
    void compileInvokeSpecial(ASTree target, String classname, String methodname, String descriptor, ASTList args2) throws CompileError {
        void var1_2;
        target.accept(this);
        int nargs = ((TypeChecker)this).getMethodArgsLength(args2);
        ((TypeChecker)this).atMethodArgs(args2, new int[nargs], new int[nargs], new String[var1_2]);
        this.setReturnType(descriptor);
        this.addNullIfVoid();
    }

    /*
     * WARNING - void declaration
     */
    protected void compileUnwrapValue(CtClass type) throws CompileError {
        void var1_1;
        if (type == CtClass.voidType) {
            this.addNullIfVoid();
            return;
        }
        this.setType((CtClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setType(CtClass type) throws CompileError {
        void var1_1;
        this.setType((CtClass)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void setType(CtClass type, int dim) throws CompileError {
        void var2_2;
        void var1_1;
        if (type.isPrimitive()) {
            CtPrimitiveType pt = (CtPrimitiveType)type;
            this.exprType = MemberResolver.descToType(var1_1.getDescriptor());
            this.arrayDim = dim;
            this.className = null;
            return;
        }
        if (var1_1.isArray()) {
            try {
                this.setType(var1_1.getComponentType(), dim + 1);
                return;
            }
            catch (NotFoundException notFoundException) {
                throw new CompileError("undefined type: " + var1_1.getName());
            }
        }
        this.exprType = 307;
        this.arrayDim = var2_2;
        this.className = MemberResolver.javaToJvmName(var1_1.getName());
    }
}

