/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.compiler;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtPrimitiveType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Bytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LocalVariableAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.JvstCodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.JvstTypeChecker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.Lex;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.MemberResolver;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.Parser;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ProceedHandler;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.SymbolTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTree;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CallExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Declarator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Expr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.FieldDecl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Member;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.MethodDecl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Stmnt;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Symbol;

public class Javac {
    JvstCodeGen gen;
    SymbolTable stable;
    private Bytecode bytecode;
    public static final String param0Name = "$0";
    public static final String resultVarName = "$_";
    public static final String proceedName = "$proceed";

    /*
     * WARNING - void declaration
     */
    public Javac(CtClass thisClass) {
        this(new Bytecode(thisClass.getClassFile2().getConstPool(), 0, 0), (CtClass)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Javac(Bytecode b2, CtClass thisClass) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this.gen = new JvstCodeGen(b2, (CtClass)v0, v0.getClassPool());
        this.stable = new SymbolTable();
        this.bytecode = var1_1;
    }

    public Bytecode getBytecode() {
        return this.bytecode;
    }

    /*
     * WARNING - void declaration
     */
    public CtMember compile(String src) throws CompileError {
        Parser p2 = new Parser(new Lex(src));
        ASTList mem = p2.parseMember1(this.stable);
        try {
            void var2_4;
            if (mem instanceof FieldDecl) {
                return this.compileField((FieldDecl)mem);
            }
            CtBehavior cb = this.compileMethod(p2, (MethodDecl)mem);
            CtClass decl = cb.getDeclaringClass();
            cb.getMethodInfo2().rebuildStackMapIf6(decl.getClassPool(), var2_4.getClassFile2());
            return cb;
        }
        catch (BadBytecode bb) {
            throw new CompileError(bb.getMessage());
        }
        catch (CannotCompileException e2) {
            void var1_3;
            throw new CompileError(var1_3.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private CtField compileField(FieldDecl fd) throws CompileError, CannotCompileException {
        void var2_2;
        Declarator d2 = fd.getDeclarator();
        CtFieldWithInit f2 = new CtFieldWithInit(this.gen.resolver.lookupClass(d2), d2.getVariable().get(), this.gen.getThisClass());
        ((CtMember)f2).setModifiers(MemberResolver.getModifiers(fd.getModifiers()));
        if (fd.getInit() != null) {
            void var1_1;
            f2.setInit(var1_1.getInit());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CtBehavior compileMethod(Parser p2, MethodDecl md) throws CompileError {
        int mod = MemberResolver.getModifiers(md.getModifiers());
        CtClass[] plist = this.gen.makeParamList(md);
        CtClass[] tlist = this.gen.makeThrowsList(md);
        this.recordParams(plist, Modifier.isStatic(mod));
        md = p2.parseMethod2(this.stable, md);
        try {
            void var2_3;
            if (md.isConstructor()) {
                CtConstructor cons = new CtConstructor(plist, this.gen.getThisClass());
                ((CtMember)cons).setModifiers(mod);
                ((ASTree)md).accept(this.gen);
                cons.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
                cons.setExceptionTypes(tlist);
                return cons;
            }
            Declarator r2 = md.getReturn();
            CtClass rtype = this.gen.resolver.lookupClass(r2);
            this.recordReturnType(rtype, false);
            CtMethod method = new CtMethod(rtype, r2.getVariable().get(), plist, this.gen.getThisClass());
            ((CtMember)method).setModifiers(mod);
            this.gen.setThisMethod(method);
            ((ASTree)md).accept(this.gen);
            if (var2_3.getBody() != null) {
                method.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
            } else {
                void var3_4;
                ((CtMember)method).setModifiers((int)(var3_4 | 0x400));
            }
            method.setExceptionTypes(tlist);
            return method;
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new CompileError(var1_2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Bytecode compileBody(CtBehavior method, String src) throws CompileError {
        try {
            boolean isVoid;
            CtClass rtype;
            int mod = ((CtMember)method).getModifiers();
            this.recordParams(method.getParameterTypes(), Modifier.isStatic(mod));
            if (method instanceof CtMethod) {
                this.gen.setThisMethod((CtMethod)method);
                rtype = ((CtMethod)method).getReturnType();
            } else {
                rtype = CtClass.voidType;
            }
            this.recordReturnType(rtype, false);
            boolean bl = isVoid = rtype == CtClass.voidType;
            if (src == null) {
                Javac.makeDefaultBody(this.bytecode, rtype);
            } else {
                void var2_3;
                Parser p2 = new Parser(new Lex(src));
                SymbolTable stb = new SymbolTable(this.stable);
                Stmnt s2 = p2.parseStatement(stb);
                if (p2.hasMore()) {
                    throw new CompileError("the method/constructor body must be surrounded by {}");
                }
                boolean callSuper = false;
                if (method instanceof CtConstructor) {
                    void var1_1;
                    callSuper = !((CtConstructor)var1_1).isClassInitializer();
                }
                this.gen.atMethodBody(s2, (boolean)var2_3, isVoid);
            }
            return this.bytecode;
        }
        catch (NotFoundException e2) {
            void var3_6;
            throw new CompileError(var3_6.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void makeDefaultBody(Bytecode b2, CtClass type) {
        void var1_2;
        Bytecode bytecode;
        int value;
        int op;
        if (type instanceof CtPrimitiveType) {
            op = ((CtPrimitiveType)(type = (CtPrimitiveType)type)).getReturnOp();
            value = op == 175 ? 14 : (op == 174 ? 11 : (op == 173 ? 9 : (op == 177 ? 0 : 3)));
        } else {
            op = 176;
            value = 1;
        }
        if (value != 0) {
            void var2_3;
            b2.addOpcode((int)var2_3);
        }
        bytecode.addOpcode((int)var1_2);
    }

    public boolean recordLocalVariables(CodeAttribute ca, int pc) throws CompileError {
        LocalVariableAttribute va = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
        if (va == null) {
            return false;
        }
        int n2 = va.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int start = va.startPc(i2);
            int len = va.codeLength(i2);
            if (start > pc || pc >= start + len) continue;
            this.gen.recordVariable(va.descriptor(i2), va.variableName(i2), va.index(i2), this.stable);
        }
        return true;
    }

    public boolean recordParamNames(CodeAttribute ca, int numOfLocalVars) throws CompileError {
        LocalVariableAttribute va = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
        if (va == null) {
            return false;
        }
        int n2 = va.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int index = va.index(i2);
            if (index >= numOfLocalVars) continue;
            this.gen.recordVariable(va.descriptor(i2), va.variableName(i2), index, this.stable);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int recordParams(CtClass[] params, boolean isStatic) throws CompileError {
        void var2_2;
        void var1_1;
        return this.gen.recordParams((CtClass[])var1_1, (boolean)var2_2, "$", "$args", "$$", this.stable);
    }

    /*
     * WARNING - void declaration
     */
    public int recordParams(String target, CtClass[] params, boolean use0, int varNo, boolean isStatic) throws CompileError {
        void var1_1;
        void var3_3;
        void var2_2;
        return this.gen.recordParams((CtClass[])var2_2, isStatic, "$", "$args", "$$", (boolean)var3_3, varNo, (String)var1_1, this.stable);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLocals(int max) {
        void var1_1;
        this.gen.setMaxLocals((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int recordReturnType(CtClass type, boolean useResultVar) throws CompileError {
        void var2_2;
        void var1_1;
        this.gen.recordType(type);
        return this.gen.recordReturnType((CtClass)var1_1, "$r", var2_2 != false ? resultVarName : null, this.stable);
    }

    /*
     * WARNING - void declaration
     */
    public void recordType(CtClass t2) {
        void var1_1;
        this.gen.recordType((CtClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int recordVariable(CtClass type, String name) throws CompileError {
        void var2_2;
        void var1_1;
        return this.gen.recordVariable((CtClass)var1_1, (String)var2_2, this.stable);
    }

    /*
     * WARNING - void declaration
     */
    public void recordProceed(String target, String method) throws CompileError {
        void var1_1;
        void var2_2;
        target = new Parser(new Lex((String)target));
        ASTree texpr = ((Parser)target).parseExpression(this.stable);
        ProceedHandler h2 = new ProceedHandler(){
            final /* synthetic */ String val$m;
            final /* synthetic */ ASTree val$texpr;
            final /* synthetic */ Javac this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$m = string;
                this.val$texpr = aSTree;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void doit(JvstCodeGen gen, Bytecode b2, ASTList args2) throws CompileError {
                void var1_1;
                void var2_2;
                void var3_3;
                ASTree expr = new Member(this.val$m);
                if (this.val$texpr != null) {
                    expr = Expr.make(46, this.val$texpr, expr);
                }
                expr = CallExpr.makeCall(expr, (ASTree)var3_3);
                gen.compileExpr((ASTree)var2_2);
                var1_1.addNullIfVoid();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setReturnType(JvstTypeChecker check2, ASTList args2) throws CompileError {
                void var1_1;
                void var2_2;
                CallExpr callExpr;
                ASTree expr = new Member(this.val$m);
                if (this.val$texpr != null) {
                    expr = Expr.make(46, this.val$texpr, expr);
                }
                callExpr = CallExpr.makeCall(callExpr, (ASTree)var2_2);
                ((ASTree)callExpr).accept(check2);
                var1_1.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler((ProceedHandler)var1_1, proceedName);
    }

    /*
     * WARNING - void declaration
     */
    public void recordStaticProceed(String targetClass, String method) throws CompileError {
        void var1_1;
        void var2_2;
        String c2 = targetClass;
        ProceedHandler h2 = new ProceedHandler(){
            final /* synthetic */ String val$c;
            final /* synthetic */ String val$m;
            final /* synthetic */ Javac this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$c = string;
                this.val$m = string2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void doit(JvstCodeGen gen, Bytecode b2, ASTList args2) throws CompileError {
                void var1_1;
                void var2_2;
                void var3_3;
                b2 = Expr.make(35, (ASTree)new Symbol(this.val$c), (ASTree)new Member(this.val$m));
                CallExpr expr = CallExpr.makeCall((ASTree)b2, (ASTree)var3_3);
                gen.compileExpr((ASTree)var2_2);
                var1_1.addNullIfVoid();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setReturnType(JvstTypeChecker check2, ASTList args2) throws CompileError {
                void var1_1;
                void var2_2;
                Expr expr = Expr.make(35, (ASTree)new Symbol(this.val$c), (ASTree)new Member(this.val$m));
                expr = CallExpr.makeCall(expr, (ASTree)var2_2);
                ((ASTree)expr).accept(check2);
                var1_1.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler((ProceedHandler)var1_1, proceedName);
    }

    /*
     * WARNING - void declaration
     */
    public void recordSpecialProceed(String target, String classname, String methodname, String descriptor, int methodIndex) throws CompileError {
        void var1_1;
        void var3_3;
        void var2_2;
        target = new Parser(new Lex((String)target));
        ASTree texpr = ((Parser)target).parseExpression(this.stable);
        ProceedHandler h2 = new ProceedHandler(){
            final /* synthetic */ ASTree val$texpr;
            final /* synthetic */ int val$methodIndex;
            final /* synthetic */ String val$descriptor;
            final /* synthetic */ String val$classname;
            final /* synthetic */ String val$methodname;
            final /* synthetic */ Javac this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$texpr = aSTree;
                this.val$methodIndex = n2;
                this.val$descriptor = string;
                this.val$classname = string2;
                this.val$methodname = string3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void doit(JvstCodeGen gen, Bytecode b2, ASTList args2) throws CompileError {
                void var3_3;
                gen.compileInvokeSpecial(this.val$texpr, this.val$methodIndex, this.val$descriptor, (ASTList)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setReturnType(JvstTypeChecker c2, ASTList args2) throws CompileError {
                void var2_2;
                c2.compileInvokeSpecial(this.val$texpr, this.val$classname, this.val$methodname, this.val$descriptor, (ASTList)var2_2);
            }
        };
        this.gen.setProceedHandler((ProceedHandler)var1_1, proceedName);
    }

    /*
     * WARNING - void declaration
     */
    public void recordProceed(ProceedHandler h2) {
        void var1_1;
        this.gen.setProceedHandler((ProceedHandler)var1_1, proceedName);
    }

    /*
     * WARNING - void declaration
     */
    public void compileStmnt(String src) throws CompileError {
        Parser p2 = new Parser(new Lex(src));
        SymbolTable stb = new SymbolTable(this.stable);
        while (p2.hasMore()) {
            void var3_3;
            Stmnt s2 = p2.parseStatement(stb);
            if (s2 == null) continue;
            var3_3.accept(this.gen);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void compileExpr(String src) throws CompileError {
        void var1_1;
        ASTree e2 = Javac.parseExpr(src, this.stable);
        this.compileExpr((ASTree)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ASTree parseExpr(String src, SymbolTable st) throws CompileError {
        void var1_1;
        Parser parser;
        parser = new Parser(new Lex((String)((Object)parser)));
        return parser.parseExpression((SymbolTable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void compileExpr(ASTree e2) throws CompileError {
        if (e2 != null) {
            void var1_1;
            this.gen.compileExpr((ASTree)var1_1);
        }
    }

    public static class CtFieldWithInit
    extends CtField {
        private ASTree init = null;

        /*
         * WARNING - void declaration
         */
        CtFieldWithInit(CtClass type, String name, CtClass declaring) throws CannotCompileException {
            super((CtClass)var1_1, (String)var2_2, (CtClass)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected void setInit(ASTree i2) {
            void var1_1;
            this.init = var1_1;
        }

        @Override
        protected ASTree getInitAST() {
            return this.init;
        }
    }
}

