/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.compiler;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Bytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.MemberResolver;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.TokenId;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.TypeChecker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTree;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ArrayInit;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.AssignExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.BinExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CallExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CastExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CondExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Declarator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.DoubleConst;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Expr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.FieldDecl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.InstanceOfExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.IntConst;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Keyword;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Member;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.MethodDecl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.NewExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Pair;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Stmnt;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.StringL;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Symbol;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Variable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CodeGen
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String javaLangString = "java.lang.String";
    static final String jvmJavaLangString = "java/lang/String";
    protected Bytecode bytecode;
    private int tempVar;
    TypeChecker typeChecker;
    protected boolean hasReturned;
    public boolean inStaticMethod;
    protected List<Integer> breakList;
    protected List<Integer> continueList;
    protected ReturnHook returnHooks;
    protected int exprType;
    protected int arrayDim;
    protected String className;
    static final int[] binOp = new int[]{43, 99, 98, 97, 96, 45, 103, 102, 101, 100, 42, 107, 106, 105, 104, 47, 111, 110, 109, 108, 37, 115, 114, 113, 112, 124, 0, 0, 129, 128, 94, 0, 0, 131, 130, 38, 0, 0, 127, 126, 364, 0, 0, 121, 120, 366, 0, 0, 123, 122, 370, 0, 0, 125, 124};
    private static final int[] ifOp = new int[]{358, 159, 160, 350, 160, 159, 357, 164, 163, 359, 162, 161, 60, 161, 162, 62, 163, 164};
    private static final int[] ifOp2 = new int[]{358, 153, 154, 350, 154, 153, 357, 158, 157, 359, 156, 155, 60, 155, 156, 62, 157, 158};
    private static final int P_DOUBLE = 0;
    private static final int P_FLOAT = 1;
    private static final int P_LONG = 2;
    private static final int P_INT = 3;
    private static final int P_OTHER = -1;
    private static final int[] castOp = new int[]{0, 144, 143, 142, 141, 0, 140, 139, 138, 137, 0, 136, 135, 134, 133, 0};

    /*
     * WARNING - void declaration
     */
    public CodeGen(Bytecode b2) {
        void var1_1;
        this.bytecode = var1_1;
        this.tempVar = -1;
        this.typeChecker = null;
        this.hasReturned = false;
        this.inStaticMethod = false;
        this.breakList = null;
        this.continueList = null;
        this.returnHooks = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setTypeChecker(TypeChecker checker) {
        void var1_1;
        this.typeChecker = var1_1;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    public static boolean is2word(int type, int dim) {
        int n2;
        return dim == 0 && (type == 312 || n2 == 326);
    }

    public int getMaxLocals() {
        return this.bytecode.getMaxLocals();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLocals(int n2) {
        void var1_1;
        this.bytecode.setMaxLocals((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void incMaxLocals(int size) {
        void var1_1;
        this.bytecode.incMaxLocals((int)var1_1);
    }

    protected int getTempVar() {
        if (this.tempVar < 0) {
            this.tempVar = this.getMaxLocals();
            this.incMaxLocals(2);
        }
        return this.tempVar;
    }

    /*
     * WARNING - void declaration
     */
    protected int getLocalVar(Declarator d2) {
        void var2_2;
        int v2 = d2.getLocalVar();
        if (v2 < 0) {
            void var1_1;
            v2 = this.getMaxLocals();
            var1_1.setLocalVar(v2);
            this.incMaxLocals(1);
        }
        return (int)var2_2;
    }

    protected abstract String getThisName();

    protected abstract String getSuperName() throws CompileError;

    protected abstract String resolveClassName(ASTList var1) throws CompileError;

    protected abstract String resolveClassName(String var1) throws CompileError;

    /*
     * WARNING - void declaration
     */
    protected static String toJvmArrayName(String name, int dim) {
        void var2_2;
        String string;
        void d2;
        if (name == null) {
            return null;
        }
        if (dim == 0) {
            return name;
        }
        StringBuilder sbuf = new StringBuilder();
        while (d2-- > 0) {
            sbuf.append('[');
        }
        sbuf.append('L');
        sbuf.append(string);
        sbuf.append(';');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static String toJvmTypeName(int type, int dim) {
        void var0_1;
        void var2_3;
        int c2 = 73;
        switch (type) {
            case 301: {
                c2 = 90;
                break;
            }
            case 303: {
                c2 = 66;
                break;
            }
            case 306: {
                c2 = 67;
                break;
            }
            case 334: {
                c2 = 83;
                break;
            }
            case 324: {
                c2 = 73;
                break;
            }
            case 326: {
                c2 = 74;
                break;
            }
            case 317: {
                c2 = 70;
                break;
            }
            case 312: {
                c2 = 68;
                break;
            }
            case 344: {
                c2 = 86;
            }
        }
        StringBuilder sbuf = new StringBuilder();
        while (dim-- > 0) {
            sbuf.append('[');
        }
        sbuf.append((char)var2_3);
        return var0_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void compileExpr(ASTree expr) throws CompileError {
        void var1_1;
        this.doTypeCheck(expr);
        var1_1.accept(this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compileBooleanExpr(boolean branchIf, ASTree expr) throws CompileError {
        void var2_2;
        void var1_1;
        this.doTypeCheck(expr);
        return this.booleanExpr((boolean)var1_1, (ASTree)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void doTypeCheck(ASTree expr) throws CompileError {
        if (this.typeChecker != null) {
            void var1_1;
            var1_1.accept(this.typeChecker);
        }
    }

    @Override
    public void atASTList(ASTList n2) throws CompileError {
        CodeGen.fatal();
    }

    @Override
    public void atPair(Pair n2) throws CompileError {
        CodeGen.fatal();
    }

    @Override
    public void atSymbol(Symbol n2) throws CompileError {
        CodeGen.fatal();
    }

    @Override
    public void atFieldDecl(FieldDecl field) throws CompileError {
        field.getInit().accept(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMethodDecl(MethodDecl method) throws CompileError {
        void var1_1;
        void var2_2;
        this.setMaxLocals(1);
        for (ASTList mods = method.getModifiers(); mods != null; mods = mods.tail()) {
            Keyword k2 = (Keyword)mods.head();
            if (k2.get() != 335) continue;
            this.setMaxLocals(0);
            this.inStaticMethod = true;
        }
        for (ASTList params = method.getParams(); params != null; params = params.tail()) {
            ((Visitor)this).atDeclarator((Declarator)params.head());
        }
        Stmnt s2 = method.getBody();
        this.atMethodBody((Stmnt)var2_2, method.isConstructor(), var1_1.getReturn().getType() == 344);
    }

    /*
     * WARNING - void declaration
     */
    public void atMethodBody(Stmnt s2, boolean isCons, boolean isVoid) throws CompileError {
        void var1_1;
        void var2_2;
        if (s2 == null) {
            return;
        }
        if (var2_2 != false && this.needsSuperCall(s2)) {
            this.insertDefaultSuperCall();
        }
        this.hasReturned = false;
        var1_1.accept(this);
        if (!this.hasReturned) {
            void var3_3;
            if (var3_3 != false) {
                this.bytecode.addOpcode(177);
                this.hasReturned = true;
                return;
            }
            throw new CompileError("no return statement");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean needsSuperCall(Stmnt body) throws CompileError {
        ASTree target;
        ASTree expr;
        if (body.getOperator() == 66) {
            body = (Stmnt)body.head();
        }
        if (body != null && body.getOperator() == 69 && (expr = body.head()) != null && expr instanceof Expr && ((Expr)expr).getOperator() == 67 && (target = ((Expr)expr).head()) instanceof Keyword) {
            void var1_2;
            int token = ((Keyword)target).get();
            return token != 339 && var1_2 != 336;
        }
        return true;
    }

    protected abstract void insertDefaultSuperCall() throws CompileError;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void atStmnt(Stmnt st) throws CompileError {
        void var1_1;
        void var2_2;
        void e22;
        if (st == null) {
            return;
        }
        int op = st.getOperator();
        if (op == 69) {
            ASTree expr = ((ASTree)st).getLeft();
            this.doTypeCheck(expr);
            if (expr instanceof AssignExpr) {
                this.atAssignExpr((AssignExpr)expr, false);
                return;
            }
            if (CodeGen.isPlusPlusExpr(expr)) {
                Expr e22 = (Expr)expr;
                this.atPlusPlus(e22.getOperator(), e22.oprand1(), e22, false);
                return;
            }
            expr.accept(this);
            if (CodeGen.is2word(this.exprType, this.arrayDim)) {
                this.bytecode.addOpcode(88);
                return;
            }
            if (this.exprType == 344) return;
            this.bytecode.addOpcode(87);
            return;
        }
        if (e22 == 68 || e22 == 66) {
            ASTList list;
            while (list != null) {
                void var2_4;
                ASTree h2 = list.head();
                list = list.tail();
                if (h2 == null) continue;
                var2_4.accept(this);
            }
            return;
        }
        if (var2_2 == 320) {
            this.atIfStmnt((Stmnt)var1_1);
            return;
        }
        if (var2_2 == 346 || var2_2 == 311) {
            this.atWhileStmnt((Stmnt)var1_1, var2_2 == 346);
            return;
        }
        if (var2_2 == 318) {
            this.atForStmnt((Stmnt)var1_1);
            return;
        }
        if (var2_2 == 302 || var2_2 == 309) {
            this.atBreakStmnt((Stmnt)var1_1, var2_2 == 302);
            return;
        }
        if (var2_2 == 333) {
            this.atReturnStmnt((Stmnt)var1_1);
            return;
        }
        if (var2_2 == 340) {
            this.atThrowStmnt((Stmnt)var1_1);
            return;
        }
        if (var2_2 == 343) {
            this.atTryStmnt((Stmnt)var1_1);
            return;
        }
        if (var2_2 == 337) {
            this.atSwitchStmnt((Stmnt)var1_1);
            return;
        }
        if (var2_2 == 338) {
            this.atSyncStmnt((Stmnt)var1_1);
            return;
        }
        this.hasReturned = false;
        throw new CompileError("sorry, not supported statement: TokenId " + (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void atIfStmnt(Stmnt st) throws CompileError {
        void var2_3;
        ASTree expr = st.head();
        Stmnt thenp = (Stmnt)st.tail().head();
        Stmnt elsep = (Stmnt)st.tail().tail().head();
        if (this.compileBooleanExpr(false, expr)) {
            this.hasReturned = false;
            if (elsep != null) {
                ((ASTree)elsep).accept(this);
            }
            return;
        }
        int pc = this.bytecode.currentPc();
        int pc2 = 0;
        this.bytecode.addIndex(0);
        this.hasReturned = false;
        if (thenp != null) {
            ((ASTree)thenp).accept(this);
        }
        boolean thenHasReturned = this.hasReturned;
        this.hasReturned = false;
        if (elsep != null && !thenHasReturned) {
            this.bytecode.addOpcode(167);
            pc2 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        Bytecode bytecode = this.bytecode;
        bytecode.write16bit(pc, bytecode.currentPc() - var2_3 + 1);
        if (elsep != null) {
            void var3_5;
            void var1_1;
            var1_1.accept(this);
            if (!thenHasReturned) {
                Bytecode bytecode2 = this.bytecode;
                bytecode2.write16bit(pc2, bytecode2.currentPc() - pc2 + 1);
            }
            this.hasReturned = var3_5 != false && this.hasReturned;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void atWhileStmnt(Stmnt st, boolean notDo) throws CompileError {
        void var2_3;
        void var3_4;
        void var1_2;
        boolean alwaysBranch;
        List<Integer> prevBreakList = this.breakList;
        List<Integer> prevContList = this.continueList;
        this.breakList = new ArrayList<Integer>();
        this.continueList = new ArrayList<Integer>();
        ASTree expr = st.head();
        Stmnt body = (Stmnt)st.tail();
        int pc = 0;
        if (notDo) {
            this.bytecode.addOpcode(167);
            pc = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        int pc2 = this.bytecode.currentPc();
        if (body != null) {
            ((ASTree)body).accept(this);
        }
        int pc3 = this.bytecode.currentPc();
        if (notDo) {
            this.bytecode.write16bit(pc, pc3 - pc + 1);
        }
        if (alwaysBranch = this.compileBooleanExpr(true, expr)) {
            this.bytecode.addOpcode(167);
            alwaysBranch = this.breakList.isEmpty();
        }
        Bytecode bytecode = this.bytecode;
        bytecode.addIndex(pc2 - bytecode.currentPc() + 1);
        CodeGen codeGen = this;
        codeGen.patchGoto(codeGen.breakList, this.bytecode.currentPc());
        CodeGen codeGen2 = this;
        codeGen2.patchGoto(codeGen2.continueList, (int)var1_2);
        this.continueList = prevContList;
        this.breakList = var3_4;
        this.hasReturned = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void patchGoto(List<Integer> list, int targetPc) {
        for (int pc : list) {
            void var3_3;
            this.bytecode.write16bit(pc, targetPc - var3_3 + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void atForStmnt(Stmnt st) throws CompileError {
        void var2_3;
        void var3_4;
        void var1_2;
        List<Integer> prevBreakList = this.breakList;
        List<Integer> prevContList = this.continueList;
        this.breakList = new ArrayList<Integer>();
        this.continueList = new ArrayList<Integer>();
        Stmnt init = (Stmnt)st.head();
        ASTList p2 = st.tail();
        ASTree expr = p2.head();
        p2 = p2.tail();
        Stmnt update = (Stmnt)p2.head();
        Stmnt body = (Stmnt)p2.tail();
        if (init != null) {
            ((ASTree)init).accept(this);
        }
        int pc = this.bytecode.currentPc();
        int pc2 = 0;
        if (expr != null) {
            if (this.compileBooleanExpr(false, expr)) {
                this.continueList = prevContList;
                this.breakList = prevBreakList;
                this.hasReturned = false;
                return;
            }
            pc2 = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
        }
        if (body != null) {
            ((ASTree)body).accept(this);
        }
        int pc3 = this.bytecode.currentPc();
        if (update != null) {
            ((ASTree)update).accept(this);
        }
        this.bytecode.addOpcode(167);
        Bytecode bytecode = this.bytecode;
        bytecode.addIndex(pc - bytecode.currentPc() + 1);
        int pc4 = this.bytecode.currentPc();
        if (expr != null) {
            this.bytecode.write16bit(pc2, pc4 - pc2 + 1);
        }
        CodeGen codeGen = this;
        codeGen.patchGoto(codeGen.breakList, pc4);
        CodeGen codeGen2 = this;
        codeGen2.patchGoto(codeGen2.continueList, (int)var1_2);
        this.continueList = var3_4;
        this.breakList = var2_3;
        this.hasReturned = false;
    }

    private void atSwitchStmnt(Stmnt st) throws CompileError {
        ASTList list;
        boolean isString = false;
        if (this.typeChecker != null) {
            this.doTypeCheck(st.head());
            isString = this.typeChecker.exprType == 307 && this.typeChecker.arrayDim == 0 && jvmJavaLangString.equals(this.typeChecker.className);
        }
        this.compileExpr(st.head());
        int tmpVar = -1;
        if (isString) {
            tmpVar = this.getMaxLocals();
            this.incMaxLocals(1);
            this.bytecode.addAstore(tmpVar);
            this.bytecode.addAload(tmpVar);
            this.bytecode.addInvokevirtual(jvmJavaLangString, "hashCode", "()I");
        }
        List<Integer> prevBreakList = this.breakList;
        this.breakList = new ArrayList<Integer>();
        int opcodePc = this.bytecode.currentPc();
        this.bytecode.addOpcode(171);
        int npads = 3 - (opcodePc & 3);
        while (npads-- > 0) {
            this.bytecode.add(0);
        }
        Stmnt body = (Stmnt)st.tail();
        int npairs = 0;
        for (ASTList list2 = body; list2 != null; list2 = list2.tail()) {
            if (((Stmnt)list2.head()).getOperator() != 304) continue;
            ++npairs;
        }
        int opcodePc2 = this.bytecode.currentPc();
        this.bytecode.addGap(4);
        this.bytecode.add32bit(npairs);
        this.bytecode.addGap(npairs << 3);
        long[] pairs = new long[npairs];
        ArrayList<Integer> gotoDefaults = new ArrayList<Integer>();
        int ipairs = 0;
        int defaultPc = -1;
        while (list != null) {
            Stmnt label = (Stmnt)list.head();
            int op = label.getOperator();
            if (op == 310) {
                defaultPc = this.bytecode.currentPc();
            } else if (op != 304) {
                CodeGen.fatal();
            } else {
                int curPos = this.bytecode.currentPc();
                long caseLabel = isString ? (long)this.computeStringLabel(label.head(), tmpVar, gotoDefaults) : (long)this.computeLabel(label.head());
                pairs[ipairs++] = (caseLabel << 32) + (long)(curPos - opcodePc);
            }
            this.hasReturned = false;
            ((ASTree)((Stmnt)label.tail())).accept(this);
            list = list.tail();
        }
        Arrays.sort(pairs);
        int pc = opcodePc2 + 8;
        for (int i2 = 0; i2 < npairs; ++i2) {
            this.bytecode.write32bit(pc, (int)(pairs[i2] >>> 32));
            this.bytecode.write32bit(pc + 4, (int)pairs[i2]);
            pc += 8;
        }
        if (defaultPc < 0 || this.breakList.size() > 0) {
            this.hasReturned = false;
        }
        int endPc = this.bytecode.currentPc();
        if (defaultPc < 0) {
            defaultPc = endPc;
        }
        this.bytecode.write32bit(opcodePc2, defaultPc - opcodePc);
        for (int addr : gotoDefaults) {
            this.bytecode.write16bit(addr, defaultPc - addr + 1);
        }
        CodeGen codeGen = this;
        codeGen.patchGoto(codeGen.breakList, endPc);
        this.breakList = prevBreakList;
    }

    /*
     * WARNING - void declaration
     */
    private int computeLabel(ASTree expr) throws CompileError {
        this.doTypeCheck(expr);
        expr = TypeChecker.stripPlusExpr(expr);
        if (expr instanceof IntConst) {
            void var1_1;
            return (int)((IntConst)var1_1).get();
        }
        throw new CompileError("bad case label");
    }

    /*
     * WARNING - void declaration
     */
    private int computeStringLabel(ASTree expr, int tmpVar, List<Integer> gotoDefaults) throws CompileError {
        this.doTypeCheck(expr);
        expr = TypeChecker.stripPlusExpr(expr);
        if (expr instanceof StringL) {
            void var1_1;
            void var2_3;
            void var3_4;
            String label = ((StringL)expr).get();
            this.bytecode.addAload(tmpVar);
            this.bytecode.addLdc(label);
            this.bytecode.addInvokevirtual(jvmJavaLangString, "equals", "(Ljava/lang/Object;)Z");
            this.bytecode.addOpcode(153);
            Integer pc = this.bytecode.currentPc();
            this.bytecode.addIndex(0);
            var3_4.add(var2_3);
            return var1_1.hashCode();
        }
        throw new CompileError("bad case label");
    }

    /*
     * WARNING - void declaration
     */
    private void atBreakStmnt(Stmnt st, boolean notCont) throws CompileError {
        void var1_1;
        void var2_2;
        if (st.head() != null) {
            throw new CompileError("sorry, not support labeled break or continue");
        }
        this.bytecode.addOpcode(167);
        Integer pc = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        if (var2_2 != false) {
            this.breakList.add(pc);
            return;
        }
        this.continueList.add((Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void atReturnStmnt(Stmnt st) throws CompileError {
        void var1_1;
        this.atReturnStmnt2(var1_1.getLeft());
    }

    /*
     * WARNING - void declaration
     */
    protected final void atReturnStmnt2(ASTree result) throws CompileError {
        void var1_2;
        int op22;
        if (result == null) {
            op22 = 177;
        } else {
            int type;
            void op22;
            this.compileExpr((ASTree)op22);
            op22 = this.arrayDim > 0 ? 176 : ((type = this.exprType) == 312 ? 175 : (type == 317 ? 174 : (type == 326 ? 173 : (CodeGen.isRefType(type) ? 176 : 172))));
        }
        ReturnHook har = this.returnHooks;
        while (har != null) {
            if (har.doit(this.bytecode, op22)) {
                this.hasReturned = true;
                return;
            }
            har = har.next;
        }
        this.bytecode.addOpcode((int)var1_2);
        this.hasReturned = true;
    }

    /*
     * WARNING - void declaration
     */
    private void atThrowStmnt(Stmnt st) throws CompileError {
        void var1_1;
        ASTree e2 = ((ASTree)st).getLeft();
        this.compileExpr((ASTree)var1_1);
        if (this.exprType != 307 || this.arrayDim > 0) {
            throw new CompileError("bad throw statement");
        }
        this.bytecode.addOpcode(191);
        this.hasReturned = true;
    }

    protected void atTryStmnt(Stmnt st) throws CompileError {
        this.hasReturned = false;
    }

    /*
     * WARNING - void declaration
     */
    private void atSyncStmnt(Stmnt st) throws CompileError {
        void var3_4;
        void var2_3;
        int nbreaks = CodeGen.getListSize(this.breakList);
        int ncontinues = CodeGen.getListSize(this.continueList);
        this.compileExpr(st.head());
        if (this.exprType != 307 && this.arrayDim == 0) {
            throw new CompileError("bad type expr for synchronized block");
        }
        Bytecode bc = this.bytecode;
        int var = bc.getMaxLocals();
        bc.incMaxLocals(1);
        bc.addOpcode(89);
        bc.addAstore(var);
        bc.addOpcode(194);
        CodeGen codeGen = this;
        ReturnHook rh = new ReturnHook(codeGen, codeGen, var){
            final /* synthetic */ int val$var;
            final /* synthetic */ CodeGen this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$var = n2;
                super((CodeGen)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected boolean doit(Bytecode b2, int opcode) {
                void var1_1;
                b2.addAload(this.val$var);
                var1_1.addOpcode(195);
                return false;
            }
        };
        int pc = bc.currentPc();
        Stmnt body = (Stmnt)st.tail();
        if (body != null) {
            ((ASTree)body).accept(this);
        }
        int pc2 = bc.currentPc();
        int pc3 = 0;
        if (!this.hasReturned) {
            rh.doit(bc, 0);
            bc.addOpcode(167);
            pc3 = bc.currentPc();
            bc.addIndex(0);
        }
        if (pc < pc2) {
            void var1_2;
            int pc4 = bc.currentPc();
            rh.doit(bc, 0);
            bc.addOpcode(191);
            bc.addExceptionHandler(pc, (int)var1_2, pc4, 0);
        }
        if (!this.hasReturned) {
            bc.write16bit(pc3, bc.currentPc() - pc3 + 1);
        }
        rh.remove(this);
        if (CodeGen.getListSize(this.breakList) != var2_3 || CodeGen.getListSize(this.continueList) != var3_4) {
            throw new CompileError("sorry, cannot break/continue in synchronized block");
        }
    }

    private static int getListSize(List<Integer> list) {
        List<Integer> list2;
        if (list == null) {
            return 0;
        }
        return list2.size();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPlusPlusExpr(ASTree expr) {
        if (expr instanceof Expr) {
            void var0_1;
            int op = ((Expr)expr).getOperator();
            return op == 362 || var0_1 == 363;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atDeclarator(Declarator d2) throws CompileError {
        d2.setLocalVar(this.getMaxLocals());
        d2.setClassName(this.resolveClassName(d2.getClassName()));
        int size = CodeGen.is2word(d2.getType(), d2.getArrayDim()) ? 2 : 1;
        this.incMaxLocals(size);
        ASTree init = d2.getInitializer();
        if (init != null) {
            void var2_3;
            void var1_1;
            this.doTypeCheck(init);
            this.atVariableAssign(null, 61, null, (Declarator)var1_1, (ASTree)var2_3, false);
        }
    }

    @Override
    public abstract void atNewExpr(NewExpr var1) throws CompileError;

    @Override
    public abstract void atArrayInit(ArrayInit var1) throws CompileError;

    /*
     * WARNING - void declaration
     */
    @Override
    public void atAssignExpr(AssignExpr expr) throws CompileError {
        void var1_1;
        this.atAssignExpr((AssignExpr)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    protected void atAssignExpr(AssignExpr expr, boolean doDup) throws CompileError {
        void var2_2;
        void var3_3;
        void var1_1;
        Expr expr2;
        int op = expr.getOperator();
        ASTree left = expr.oprand1();
        ASTree right = expr.oprand2();
        if (left instanceof Variable) {
            this.atVariableAssign(expr, op, (Variable)left, ((Variable)left).getDeclarator(), right, doDup);
            return;
        }
        if (left instanceof Expr && (expr2 = (Expr)left).getOperator() == 65) {
            this.atArrayAssign(expr, op, (Expr)left, right, doDup);
            return;
        }
        this.atFieldAssign((Expr)var1_1, (int)var3_3, left, right, (boolean)var2_2);
    }

    protected static void badAssign(Expr expr) throws CompileError {
        String string;
        String msg;
        msg = expr == null ? "incompatible type for assignment" : "incompatible type for " + ((Expr)((Object)msg)).getName();
        throw new CompileError(string);
    }

    /*
     * WARNING - void declaration
     */
    private void atVariableAssign(Expr expr, int op, Variable var, Declarator d2, ASTree right, boolean doDup) throws CompileError {
        int varType = d2.getType();
        int varArray = d2.getArrayDim();
        String varClass = d2.getClassName();
        int varNo = this.getLocalVar(d2);
        if (op != 61) {
            void var3_3;
            ((Visitor)this).atVariable((Variable)var3_3);
        }
        if (expr == null && right instanceof ArrayInit) {
            this.atArrayVariableAssign((ArrayInit)right, varType, varArray, varClass);
        } else {
            void var2_2;
            void var1_1;
            this.atAssignCore((Expr)var1_1, (int)var2_2, right, varType, varArray, varClass);
        }
        if (doDup) {
            if (CodeGen.is2word(varType, varArray)) {
                this.bytecode.addOpcode(92);
            } else {
                this.bytecode.addOpcode(89);
            }
        }
        if (varArray > 0) {
            this.bytecode.addAstore(varNo);
        } else if (varType == 312) {
            this.bytecode.addDstore(varNo);
        } else if (varType == 317) {
            this.bytecode.addFstore(varNo);
        } else if (varType == 326) {
            this.bytecode.addLstore(varNo);
        } else if (CodeGen.isRefType(varType)) {
            this.bytecode.addAstore(varNo);
        } else {
            this.bytecode.addIstore(varNo);
        }
        this.exprType = varType;
        this.arrayDim = varArray;
        this.className = varClass;
    }

    protected abstract void atArrayVariableAssign(ArrayInit var1, int var2, int var3, String var4) throws CompileError;

    /*
     * WARNING - void declaration
     */
    private void atArrayAssign(Expr expr, int op, Expr array, ASTree right, boolean doDup) throws CompileError {
        void var3_4;
        void var2_2;
        void var1_1;
        this.arrayAccess(array.oprand1(), array.oprand2());
        if (op != 61) {
            this.bytecode.addOpcode(92);
            this.bytecode.addOpcode(CodeGen.getArrayReadOp(this.exprType, this.arrayDim));
        }
        int aType = this.exprType;
        int aDim = this.arrayDim;
        String cname = this.className;
        this.atAssignCore((Expr)var1_1, (int)var2_2, right, aType, aDim, cname);
        if (doDup) {
            if (CodeGen.is2word(aType, aDim)) {
                this.bytecode.addOpcode(94);
            } else {
                this.bytecode.addOpcode(91);
            }
        }
        this.bytecode.addOpcode(CodeGen.getArrayWriteOp(aType, aDim));
        this.exprType = var3_4;
        this.arrayDim = aDim;
        this.className = cname;
    }

    protected abstract void atFieldAssign(Expr var1, int var2, ASTree var3, ASTree var4, boolean var5) throws CompileError;

    /*
     * WARNING - void declaration
     */
    protected void atAssignCore(Expr expr, int op, ASTree right, int type, int dim, String cname) throws CompileError {
        void var2_2;
        if (op == 354 && dim == 0 && type == 307) {
            this.atStringPlusEq(expr, type, dim, cname, right);
        } else {
            right.accept(this);
            CodeGen codeGen = this;
            if (codeGen.invalidDim(codeGen.exprType, this.arrayDim, this.className, type, dim, cname, false) || op != 61 && dim > 0) {
                CodeGen.badAssign(expr);
            }
            if (op != 61) {
                void var3_4;
                void var1_1;
                int token = assignOps[op - 351];
                int k2 = CodeGen.lookupBinOp(token);
                if (k2 < 0) {
                    CodeGen.fatal();
                }
                this.atArithBinExpr((Expr)var1_1, (int)var3_4, k2, type);
            }
        }
        if (var2_2 != 61 || dim == 0 && !CodeGen.isRefType(type)) {
            CodeGen codeGen = this;
            codeGen.atNumCastExpr(codeGen.exprType, type);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void atStringPlusEq(Expr expr, int type, int dim, String cname, ASTree right) throws CompileError {
        void var3_3;
        void var2_2;
        if (!jvmJavaLangString.equals(cname)) {
            void var1_1;
            CodeGen.badAssign((Expr)var1_1);
        }
        this.convToString((int)var2_2, (int)var3_3);
        right.accept(this);
        CodeGen codeGen = this;
        codeGen.convToString(codeGen.exprType, this.arrayDim);
        this.bytecode.addInvokevirtual(javaLangString, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    /*
     * WARNING - void declaration
     */
    private boolean invalidDim(int srcType, int srcDim, String srcClass, int destType, int destDim, String destClass, boolean isCast) {
        if (srcDim != destDim) {
            void var3_3;
            void var1_1;
            void var2_2;
            if (srcType == 412) {
                return false;
            }
            if (destDim == 0 && destType == 307 && jvmJavaLangObject.equals(destClass)) {
                return false;
            }
            return !isCast || var2_2 != false || var1_1 != 307 || !jvmJavaLangObject.equals(var3_3);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCondExpr(CondExpr expr) throws CompileError {
        void var3_3;
        void var1_1;
        void var2_2;
        if (this.booleanExpr(false, expr.condExpr())) {
            expr.elseExpr().accept(this);
            return;
        }
        int pc = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        expr.thenExpr().accept(this);
        int dim1 = this.arrayDim;
        this.bytecode.addOpcode(167);
        int pc2 = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        Bytecode bytecode = this.bytecode;
        bytecode.write16bit(pc, bytecode.currentPc() - var2_2 + 1);
        var1_1.elseExpr().accept(this);
        if (var3_3 != this.arrayDim) {
            throw new CompileError("type mismatch in ?:");
        }
        Bytecode bytecode2 = this.bytecode;
        bytecode2.write16bit(pc2, bytecode2.currentPc() - pc2 + 1);
    }

    static int lookupBinOp(int token) {
        int[] code = binOp;
        int s2 = binOp.length;
        for (int k2 = 0; k2 < s2; k2 += 5) {
            if (code[k2] != token) continue;
            return k2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void atBinExpr(BinExpr expr) throws CompileError {
        void var1_1;
        int token = expr.getOperator();
        int k2 = CodeGen.lookupBinOp(token);
        if (k2 >= 0) {
            void var3_3;
            void var2_2;
            expr.oprand1().accept(this);
            ASTree right = expr.oprand2();
            if (right == null) {
                return;
            }
            int type1 = this.exprType;
            int dim1 = this.arrayDim;
            String cname1 = this.className;
            right.accept(this);
            if (dim1 != this.arrayDim) {
                throw new CompileError("incompatible array types");
            }
            if (token == 43 && dim1 == 0 && (type1 == 307 || this.exprType == 307)) {
                this.atStringConcatExpr(expr, type1, dim1, cname1);
                return;
            }
            this.atArithBinExpr(expr, (int)var2_2, (int)var3_3, type1);
            return;
        }
        if (!this.booleanExpr(true, (ASTree)var1_1)) {
            this.bytecode.addIndex(7);
            this.bytecode.addIconst(0);
            this.bytecode.addOpcode(167);
            this.bytecode.addIndex(4);
        }
        this.bytecode.addIconst(1);
    }

    /*
     * WARNING - void declaration
     */
    private void atArithBinExpr(Expr expr, int token, int index, int type1) throws CompileError {
        void var1_1;
        int op;
        if (this.arrayDim != 0) {
            CodeGen.badTypes(expr);
        }
        int type2 = this.exprType;
        if (token == 364 || token == 366 || token == 370) {
            if (type2 == 324 || type2 == 334 || type2 == 306 || type2 == 303) {
                this.exprType = type1;
            } else {
                CodeGen.badTypes(expr);
            }
        } else {
            this.convertOprandTypes(type1, type2, expr);
        }
        int p2 = CodeGen.typePrecedence(this.exprType);
        if (p2 >= 0 && (op = binOp[index + p2 + 1]) != 0) {
            void var3_3;
            void var2_2;
            if (var2_2 == 3 && this.exprType != 301) {
                this.exprType = 324;
            }
            this.bytecode.addOpcode((int)var3_3);
            return;
        }
        CodeGen.badTypes((Expr)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void atStringConcatExpr(Expr expr, int type1, int dim1, String cname1) throws CompileError {
        void var3_4;
        void var2_3;
        boolean type2IsString;
        int type2 = this.exprType;
        int dim2 = this.arrayDim;
        boolean type2Is2 = CodeGen.is2word(type2, dim2);
        boolean bl = type2IsString = type2 == 307 && jvmJavaLangString.equals(this.className);
        if (type2Is2) {
            this.convToString(type2, dim2);
        }
        if (CodeGen.is2word(type1, dim1)) {
            this.bytecode.addOpcode(91);
            this.bytecode.addOpcode(87);
        } else {
            this.bytecode.addOpcode(95);
        }
        this.convToString((int)var2_3, (int)var3_4);
        this.bytecode.addOpcode(95);
        if (!type2Is2 && !type2IsString) {
            void var1_2;
            this.convToString((int)var1_2, dim2);
        }
        this.bytecode.addInvokevirtual(javaLangString, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    /*
     * WARNING - void declaration
     */
    private void convToString(int type, int dim) throws CompileError {
        void var1_1;
        void var2_2;
        if (CodeGen.isRefType(type) || var2_2 > 0) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
            return;
        }
        if (type == 312) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(D)Ljava/lang/String;");
            return;
        }
        if (type == 317) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(F)Ljava/lang/String;");
            return;
        }
        if (type == 326) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(J)Ljava/lang/String;");
            return;
        }
        if (type == 301) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(Z)Ljava/lang/String;");
            return;
        }
        if (type == 306) {
            this.bytecode.addInvokestatic(javaLangString, "valueOf", "(C)Ljava/lang/String;");
            return;
        }
        if (var1_1 == 344) {
            throw new CompileError("void type expression");
        }
        this.bytecode.addInvokestatic(javaLangString, "valueOf", "(I)Ljava/lang/String;");
    }

    /*
     * WARNING - void declaration
     */
    private boolean booleanExpr(boolean branchIf, ASTree expr) throws CompileError {
        block9: {
            void var2_2;
            int type1;
            ASTree bexpr;
            while (true) {
                int op;
                if ((op = CodeGen.getCompOperator(expr)) == 358) {
                    bexpr = (BinExpr)expr;
                    type1 = this.compileOprands((BinExpr)bexpr);
                    this.compareExpr(branchIf, ((Expr)bexpr).getOperator(), type1, (BinExpr)bexpr);
                    break block9;
                }
                if (type1 != 33) break;
                bexpr = ((Expr)bexpr).oprand1();
                branchIf = !branchIf;
            }
            boolean isAndAnd = type1 == 369;
            if (isAndAnd || type1 == 368) {
                void var3_4;
                if (this.booleanExpr(!isAndAnd, ((Expr)bexpr).oprand1())) {
                    this.exprType = 301;
                    this.arrayDim = 0;
                    return true;
                }
                int pc = this.bytecode.currentPc();
                this.bytecode.addIndex(0);
                if (this.booleanExpr(isAndAnd, var2_2.oprand2())) {
                    this.bytecode.addOpcode(167);
                }
                Bytecode bytecode = this.bytecode;
                bytecode.write16bit(pc, bytecode.currentPc() - pc + 3);
                if (branchIf != var3_4) {
                    this.bytecode.addIndex(6);
                    this.bytecode.addOpcode(167);
                }
            } else {
                void var1_1;
                if (CodeGen.isAlwaysBranch((ASTree)var2_2, branchIf)) {
                    this.exprType = 301;
                    this.arrayDim = 0;
                    return true;
                }
                var2_2.accept(this);
                if (this.exprType != 301 || this.arrayDim != 0) {
                    throw new CompileError("boolean expr is required");
                }
                this.bytecode.addOpcode(var1_1 != false ? 154 : 153);
            }
        }
        this.exprType = 301;
        this.arrayDim = 0;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAlwaysBranch(ASTree expr, boolean branchIf) {
        if (expr instanceof Keyword) {
            void var0_1;
            void var1_2;
            int t2 = ((Keyword)expr).get();
            if (var1_2 != false) {
                return t2 == 410;
            }
            return var0_1 == 411;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static int getCompOperator(ASTree expr) throws CompileError {
        if (expr instanceof Expr) {
            void var1_1;
            ASTree aSTree;
            ASTree bexpr = (Expr)expr;
            int token = ((Expr)bexpr).getOperator();
            if (token == 33) {
                return 33;
            }
            if (aSTree instanceof BinExpr && token != 368 && token != 369 && token != 38 && token != 124) {
                return 358;
            }
            return (int)var1_1;
        }
        return 32;
    }

    /*
     * WARNING - void declaration
     */
    private int compileOprands(BinExpr expr) throws CompileError {
        void var2_2;
        void var1_1;
        expr.oprand1().accept(this);
        int type1 = this.exprType;
        int dim1 = this.arrayDim;
        var1_1.oprand2().accept(this);
        if (dim1 != this.arrayDim) {
            if (type1 != 412 && this.exprType != 412) {
                throw new CompileError("incompatible array types");
            }
            if (this.exprType == 412) {
                void var3_3;
                this.arrayDim = var3_3;
            }
        }
        if (type1 == 412) {
            return this.exprType;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void compareExpr(boolean branchIf, int token, int type1, BinExpr expr) throws CompileError {
        void op2;
        int p2;
        if (this.arrayDim == 0) {
            this.convertOprandTypes(type1, this.exprType, expr);
        }
        if ((p2 = CodeGen.typePrecedence(this.exprType)) == -1 || this.arrayDim > 0) {
            if (token == 358) {
                this.bytecode.addOpcode(branchIf ? 165 : 166);
                return;
            }
            if (token == 350) {
                this.bytecode.addOpcode(branchIf ? 166 : 165);
                return;
            }
            CodeGen.badTypes(expr);
            return;
        }
        if (p2 == 3) {
            int[] op2 = ifOp;
            for (int i2 = 0; i2 < op2.length; i2 += 3) {
                if (op2[i2] != token) continue;
                this.bytecode.addOpcode(op2[i2 + (branchIf ? 1 : 2)]);
                return;
            }
            CodeGen.badTypes(expr);
            return;
        }
        if (op2 == false) {
            if (token == 60 || token == 357) {
                this.bytecode.addOpcode(152);
            } else {
                this.bytecode.addOpcode(151);
            }
        } else if (op2 == true) {
            if (token == 60 || token == 357) {
                this.bytecode.addOpcode(150);
            } else {
                this.bytecode.addOpcode(149);
            }
        } else if (op2 == 2) {
            this.bytecode.addOpcode(148);
        } else {
            CodeGen.fatal();
        }
        int[] op2 = ifOp2;
        for (int i3 = 0; i3 < op2.length; i3 += 3) {
            if (op2[i3] != token) continue;
            this.bytecode.addOpcode(op2[i3 + (branchIf ? 1 : 2)]);
            return;
        }
        CodeGen.badTypes(expr);
    }

    protected static void badTypes(Expr expr) throws CompileError {
        Expr expr2;
        throw new CompileError("invalid types for " + expr2.getName());
    }

    protected static boolean isRefType(int type) {
        int n2;
        return type == 307 || n2 == 412;
    }

    private static int typePrecedence(int type) {
        int n2;
        if (type == 312) {
            return 0;
        }
        if (type == 317) {
            return 1;
        }
        if (type == 326) {
            return 2;
        }
        if (CodeGen.isRefType(type)) {
            return -1;
        }
        if (n2 == 344) {
            return -1;
        }
        return 3;
    }

    static boolean isP_INT(int type) {
        return CodeGen.typePrecedence(type) == 3;
    }

    /*
     * WARNING - void declaration
     */
    static boolean rightIsStrong(int type1, int type2) {
        void var1_1;
        int n2;
        int type1_p = CodeGen.typePrecedence(type1);
        int type2_p = CodeGen.typePrecedence(type2);
        return type1_p >= 0 && type2_p >= 0 && n2 > var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void convertOprandTypes(int type1, int type2, Expr expr) throws CompileError {
        void var2_2;
        int result_type;
        int op;
        boolean rightStrong;
        int type1_p = CodeGen.typePrecedence(type1);
        int type2_p = CodeGen.typePrecedence(type2);
        if (type2_p < 0 && type1_p < 0) {
            return;
        }
        if (type2_p < 0 || type1_p < 0) {
            CodeGen.badTypes(expr);
        }
        if (type1_p <= type2_p) {
            rightStrong = false;
            this.exprType = type1;
            op = castOp[(type2_p << 2) + type1_p];
            result_type = 0;
        } else {
            rightStrong = true;
            op = castOp[(type1_p << 2) + type2_p];
            result_type = type2_p;
        }
        if (var2_2 != false) {
            void var3_4;
            if (result_type == 0 || result_type == 2) {
                if (type1_p == 0 || type1_p == 2) {
                    this.bytecode.addOpcode(94);
                } else {
                    this.bytecode.addOpcode(93);
                }
                this.bytecode.addOpcode(88);
                this.bytecode.addOpcode(op);
                this.bytecode.addOpcode(94);
                this.bytecode.addOpcode(88);
                return;
            }
            if (var3_4 == true) {
                if (type1_p == 2) {
                    this.bytecode.addOpcode(91);
                    this.bytecode.addOpcode(87);
                } else {
                    this.bytecode.addOpcode(95);
                }
                this.bytecode.addOpcode(op);
                this.bytecode.addOpcode(95);
                return;
            }
            CodeGen.fatal();
            return;
        }
        if (op != 0) {
            void var1_1;
            this.bytecode.addOpcode((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        void var3_3;
        void var2_2;
        void var1_1;
        String cname = this.resolveClassName(expr.getClassName());
        String toClass = this.checkCastExpr(expr, cname);
        int srcType = this.exprType;
        this.exprType = expr.getType();
        this.arrayDim = var1_1.getArrayDim();
        this.className = var2_2;
        if (toClass == null) {
            this.atNumCastExpr(srcType, this.exprType);
            return;
        }
        this.bytecode.addCheckcast((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atInstanceOfExpr(InstanceOfExpr expr) throws CompileError {
        void var1_1;
        void var2_2;
        String cname = this.resolveClassName(expr.getClassName());
        String toClass = this.checkCastExpr(expr, (String)var2_2);
        this.bytecode.addInstanceof((String)var1_1);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     */
    private String checkCastExpr(CastExpr expr, String name) throws CompileError {
        ASTree oprand = expr.getOprand();
        int dim = expr.getArrayDim();
        int type = expr.getType();
        oprand.accept(this);
        int srcType = this.exprType;
        int srcDim = this.arrayDim;
        if (this.invalidDim(srcType, this.arrayDim, this.className, type, dim, name, true) || srcType == 344 || type == 344) {
            throw new CompileError("invalid cast");
        }
        if (type == 307) {
            void var2_3;
            void var3_5;
            if (!CodeGen.isRefType((int)var3_5) && srcDim == 0) {
                throw new CompileError("invalid cast");
            }
            return CodeGen.toJvmArrayName((String)var2_3, dim);
        }
        if (dim > 0) {
            void var1_2;
            return CodeGen.toJvmTypeName((int)var1_2, dim);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void atNumCastExpr(int srcType, int destType) throws CompileError {
        void var1_1;
        int op2;
        void var3_3;
        if (srcType == destType) {
            return;
        }
        int stype = CodeGen.typePrecedence(srcType);
        int dtype = CodeGen.typePrecedence(destType);
        int op = stype >= 0 && stype < 3 ? castOp[(stype << 2) + var3_3] : 0;
        op2 = destType == 312 ? 135 : (op2 == 317 ? 134 : (op2 == 326 ? 133 : (op2 == 334 ? 147 : (op2 == 306 ? 146 : (op2 == 303 ? 145 : 0)))));
        if (op != 0) {
            this.bytecode.addOpcode(op);
        }
        if ((op == 0 || op == 136 || op == 139 || var1_1 == 142) && op2 != 0) {
            void var2_2;
            this.bytecode.addOpcode((int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void atExpr(Expr expr) throws CompileError {
        int token = expr.getOperator();
        Object oprand = expr.oprand1();
        if (token == 46) {
            oprand = ((Symbol)expr.oprand2()).get();
            if (((String)oprand).equals("class")) {
                this.atClassObject(expr);
                return;
            }
            this.atFieldRead(expr);
            return;
        }
        if (token == 35) {
            this.atFieldRead(expr);
            return;
        }
        if (token == 65) {
            this.atArrayRead((ASTree)oprand, expr.oprand2());
            return;
        }
        if (token == 362 || token == 363) {
            this.atPlusPlus(token, (ASTree)oprand, expr, true);
            return;
        }
        if (token == 33) {
            if (!this.booleanExpr(false, expr)) {
                this.bytecode.addIndex(7);
                this.bytecode.addIconst(1);
                this.bytecode.addOpcode(167);
                this.bytecode.addIndex(4);
            }
            this.bytecode.addIconst(0);
            return;
        }
        if (token != 67) {
            void var2_2;
            expr.oprand1().accept(this);
            int type = CodeGen.typePrecedence(this.exprType);
            if (this.arrayDim > 0) {
                CodeGen.badType(expr);
            }
            if (token == 45) {
                if (type == 0) {
                    this.bytecode.addOpcode(119);
                    return;
                }
                if (type == 1) {
                    this.bytecode.addOpcode(118);
                    return;
                }
                if (type == 2) {
                    this.bytecode.addOpcode(117);
                    return;
                }
                if (type == 3) {
                    this.bytecode.addOpcode(116);
                    this.exprType = 324;
                    return;
                }
                CodeGen.badType(expr);
                return;
            }
            if (token == 126) {
                if (type == 3) {
                    this.bytecode.addIconst(-1);
                    this.bytecode.addOpcode(130);
                    this.exprType = 324;
                    return;
                }
                if (type == 2) {
                    this.bytecode.addLconst(-1L);
                    this.bytecode.addOpcode(131);
                    return;
                }
                CodeGen.badType(expr);
                return;
            }
            if (var2_2 == 43) {
                void var1_1;
                void var3_4;
                if (var3_4 != -1) return;
                CodeGen.badType((Expr)var1_1);
                return;
            }
        }
        CodeGen.fatal();
    }

    protected static void badType(Expr expr) throws CompileError {
        Expr expr2;
        throw new CompileError("invalid type for " + expr2.getName());
    }

    @Override
    public abstract void atCallExpr(CallExpr var1) throws CompileError;

    protected abstract void atFieldRead(ASTree var1) throws CompileError;

    /*
     * WARNING - void declaration
     */
    public void atClassObject(Expr expr) throws CompileError {
        String string;
        ASTree op1 = expr.oprand1();
        if (!(op1 instanceof Symbol)) {
            throw new CompileError("fatal error: badly parsed .class expr");
        }
        String cname = ((Symbol)op1).get();
        if (cname.startsWith("[")) {
            String name;
            String name2;
            void var3_3;
            int i2 = cname.indexOf("[L");
            if (i2 >= 0 && !var3_3.equals(name2 = this.resolveClassName(name = cname.substring(i2 + 2, cname.length() - 1)))) {
                name2 = MemberResolver.jvmToJavaName(name2);
                StringBuilder sbuf = new StringBuilder();
                while (i2-- >= 0) {
                    sbuf.append('[');
                }
                sbuf.append('L').append(name2).append(';');
                string = ((StringBuilder)((Object)string)).toString();
            }
        } else {
            string = this.resolveClassName(MemberResolver.javaToJvmName(string));
            string = MemberResolver.jvmToJavaName(string);
        }
        this.atClassObject2(string);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = "java/lang/Class";
    }

    /*
     * WARNING - void declaration
     */
    protected void atClassObject2(String cname) throws CompileError {
        void var3_4;
        void var1_2;
        void var2_3;
        int start = this.bytecode.currentPc();
        this.bytecode.addLdc(cname);
        this.bytecode.addInvokestatic("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        int end = this.bytecode.currentPc();
        this.bytecode.addOpcode(167);
        int pc = this.bytecode.currentPc();
        this.bytecode.addIndex(0);
        this.bytecode.addExceptionHandler((int)var2_3, (int)var1_2, this.bytecode.currentPc(), "java.lang.ClassNotFoundException");
        this.bytecode.growStack(1);
        this.bytecode.addInvokestatic("com.alibaba.ttl.threadpool.agent.internal.javassist.runtime.DotClass", "fail", "(Ljava/lang/ClassNotFoundException;)Ljava/lang/NoClassDefFoundError;");
        this.bytecode.addOpcode(191);
        Bytecode bytecode = this.bytecode;
        bytecode.write16bit(pc, bytecode.currentPc() - var3_4 + 1);
    }

    /*
     * WARNING - void declaration
     */
    public void atArrayRead(ASTree array, ASTree index) throws CompileError {
        void var2_2;
        void var1_1;
        this.arrayAccess((ASTree)var1_1, (ASTree)var2_2);
        this.bytecode.addOpcode(CodeGen.getArrayReadOp(this.exprType, this.arrayDim));
    }

    /*
     * WARNING - void declaration
     */
    protected void arrayAccess(ASTree array, ASTree index) throws CompileError {
        void var3_4;
        void var1_2;
        void var2_3;
        array.accept(this);
        int type = this.exprType;
        int dim = this.arrayDim;
        if (dim == 0) {
            throw new CompileError("bad array access");
        }
        String cname = this.className;
        var2_3.accept(this);
        if (CodeGen.typePrecedence(this.exprType) != 3 || this.arrayDim > 0) {
            throw new CompileError("bad array index");
        }
        this.exprType = var1_2;
        this.arrayDim = var3_4 - true;
        this.className = cname;
    }

    protected static int getArrayReadOp(int type, int dim) {
        int n2;
        if (dim > 0) {
            return 50;
        }
        switch (n2) {
            case 312: {
                return 49;
            }
            case 317: {
                return 48;
            }
            case 326: {
                return 47;
            }
            case 324: {
                return 46;
            }
            case 334: {
                return 53;
            }
            case 306: {
                return 52;
            }
            case 301: 
            case 303: {
                return 51;
            }
        }
        return 50;
    }

    protected static int getArrayWriteOp(int type, int dim) {
        int n2;
        if (dim > 0) {
            return 83;
        }
        switch (n2) {
            case 312: {
                return 82;
            }
            case 317: {
                return 81;
            }
            case 326: {
                return 80;
            }
            case 324: {
                return 79;
            }
            case 334: {
                return 86;
            }
            case 306: {
                return 85;
            }
            case 301: 
            case 303: {
                return 84;
            }
        }
        return 83;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void atPlusPlus(int token, ASTree oprand, Expr expr, boolean doDup) throws CompileError {
        void var3_4;
        Expr e2;
        void var2_2;
        void var1_1;
        boolean isPost = oprand == null;
        if (isPost) {
            oprand = expr.oprand2();
        }
        if (oprand instanceof Variable) {
            int delta;
            void var2_3;
            Declarator d2 = ((Variable)oprand).getDeclarator();
            int t2 = this.exprType = d2.getType();
            this.arrayDim = d2.getArrayDim();
            int var = this.getLocalVar(d2);
            if (this.arrayDim > 0) {
                CodeGen.badType(expr);
            }
            if (t2 == 312) {
                this.bytecode.addDload(var);
                if (doDup && isPost) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addDconst(1.0);
                this.bytecode.addOpcode(token == 362 ? 99 : 103);
                if (doDup && !isPost) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addDstore(var);
                return;
            }
            if (t2 == 326) {
                this.bytecode.addLload(var);
                if (doDup && isPost) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addLconst(1L);
                this.bytecode.addOpcode(token == 362 ? 97 : 101);
                if (doDup && !isPost) {
                    this.bytecode.addOpcode(92);
                }
                this.bytecode.addLstore(var);
                return;
            }
            if (t2 == 317) {
                this.bytecode.addFload(var);
                if (doDup && isPost) {
                    this.bytecode.addOpcode(89);
                }
                this.bytecode.addFconst(1.0f);
                this.bytecode.addOpcode(token == 362 ? 98 : 102);
                if (doDup && !isPost) {
                    this.bytecode.addOpcode(89);
                }
                this.bytecode.addFstore(var);
                return;
            }
            if (t2 != 303 && t2 != 306 && t2 != 334 && var2_3 != 324) {
                CodeGen.badType(expr);
                return;
            }
            if (doDup && isPost) {
                this.bytecode.addIload(var);
            }
            int n2 = delta = token == 362 ? 1 : -1;
            if (var > 255) {
                this.bytecode.addOpcode(196);
                this.bytecode.addOpcode(132);
                this.bytecode.addIndex(var);
                this.bytecode.addIndex(delta);
            } else {
                this.bytecode.addOpcode(132);
                this.bytecode.add(var);
                this.bytecode.add((int)var1_1);
            }
            if (!doDup) return;
            if (isPost) return;
            this.bytecode.addIload(var);
            return;
        }
        if (var2_2 instanceof Expr && (e2 = (Expr)var2_2).getOperator() == 65) {
            this.atArrayPlusPlus((int)var1_1, isPost, e2, doDup);
            return;
        }
        this.atFieldPlusPlus((int)var1_1, isPost, (ASTree)var2_2, (Expr)var3_4, doDup);
    }

    /*
     * WARNING - void declaration
     */
    public void atArrayPlusPlus(int token, boolean isPost, Expr expr, boolean doDup) throws CompileError {
        void var3_3;
        void var2_2;
        void var1_1;
        this.arrayAccess(expr.oprand1(), expr.oprand2());
        int t2 = this.exprType;
        int dim = this.arrayDim;
        if (dim > 0) {
            CodeGen.badType(expr);
        }
        this.bytecode.addOpcode(92);
        this.bytecode.addOpcode(CodeGen.getArrayReadOp(t2, this.arrayDim));
        int dup_code = CodeGen.is2word(t2, dim) ? 94 : 91;
        this.atPlusPlusCore(dup_code, doDup, (int)var1_1, (boolean)var2_2, (Expr)var3_3);
        this.bytecode.addOpcode(CodeGen.getArrayWriteOp(t2, dim));
    }

    /*
     * WARNING - void declaration
     */
    protected void atPlusPlusCore(int dup_code, boolean doDup, int token, boolean isPost, Expr expr) throws CompileError {
        void var2_2;
        int t2 = this.exprType;
        if (doDup && isPost) {
            this.bytecode.addOpcode(dup_code);
        }
        if (t2 == 324 || t2 == 303 || t2 == 306 || t2 == 334) {
            this.bytecode.addIconst(1);
            this.bytecode.addOpcode(token == 362 ? 96 : 100);
            this.exprType = 324;
        } else if (t2 == 326) {
            this.bytecode.addLconst(1L);
            this.bytecode.addOpcode(token == 362 ? 97 : 101);
        } else if (t2 == 317) {
            this.bytecode.addFconst(1.0f);
            this.bytecode.addOpcode(token == 362 ? 98 : 102);
        } else if (t2 == 312) {
            void var3_3;
            this.bytecode.addDconst(1.0);
            this.bytecode.addOpcode(var3_3 == 362 ? 99 : 103);
        } else {
            CodeGen.badType(expr);
        }
        if (var2_2 != false && !isPost) {
            void var1_1;
            this.bytecode.addOpcode((int)var1_1);
        }
    }

    protected abstract void atFieldPlusPlus(int var1, boolean var2, ASTree var3, Expr var4, boolean var5) throws CompileError;

    @Override
    public abstract void atMember(Member var1) throws CompileError;

    /*
     * WARNING - void declaration
     */
    @Override
    public void atVariable(Variable v2) throws CompileError {
        void var1_2;
        Declarator d2 = v2.getDeclarator();
        this.exprType = d2.getType();
        this.arrayDim = d2.getArrayDim();
        this.className = d2.getClassName();
        int var = this.getLocalVar(d2);
        if (this.arrayDim > 0) {
            this.bytecode.addAload(var);
            return;
        }
        switch (this.exprType) {
            case 307: {
                this.bytecode.addAload(var);
                return;
            }
            case 326: {
                this.bytecode.addLload(var);
                return;
            }
            case 317: {
                this.bytecode.addFload(var);
                return;
            }
            case 312: {
                this.bytecode.addDload(var);
                return;
            }
        }
        this.bytecode.addIload((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atKeyword(Keyword k2) throws CompileError {
        this.arrayDim = 0;
        int token = k2.get();
        switch (token) {
            case 410: {
                this.bytecode.addIconst(1);
                this.exprType = 301;
                return;
            }
            case 411: {
                this.bytecode.addIconst(0);
                this.exprType = 301;
                return;
            }
            case 412: {
                this.bytecode.addOpcode(1);
                this.exprType = 412;
                return;
            }
            case 336: 
            case 339: {
                void var1_2;
                if (this.inStaticMethod) {
                    throw new CompileError("not-available: " + (token == 339 ? "this" : "super"));
                }
                this.bytecode.addAload(0);
                this.exprType = 307;
                if (var1_2 == 339) {
                    this.className = this.getThisName();
                    return;
                }
                this.className = this.getSuperName();
                return;
            }
        }
        CodeGen.fatal();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atStringL(StringL s2) throws CompileError {
        void var1_1;
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
        this.bytecode.addLdc(var1_1.get());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atIntConst(IntConst i2) throws CompileError {
        void var2_3;
        this.arrayDim = 0;
        long value = i2.get();
        int type = i2.getType();
        if (type == 402 || type == 401) {
            void var1_2;
            this.exprType = var1_2 == 402 ? 324 : 306;
            this.bytecode.addIconst((int)value);
            return;
        }
        this.exprType = 326;
        this.bytecode.addLconst((long)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atDoubleConst(DoubleConst d2) throws CompileError {
        void var1_1;
        this.arrayDim = 0;
        if (d2.getType() == 405) {
            this.exprType = 312;
            this.bytecode.addDconst(d2.get());
            return;
        }
        this.exprType = 317;
        this.bytecode.addFconst((float)var1_1.get());
    }

    protected static abstract class ReturnHook {
        ReturnHook next;

        protected abstract boolean doit(Bytecode var1, int var2);

        protected ReturnHook(CodeGen gen) {
            this.next = gen.returnHooks;
            var1_1.returnHooks = this;
        }

        protected void remove(CodeGen gen) {
            gen.returnHooks = this.next;
        }
    }
}

