/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypeTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class TypeData {
    /*
     * WARNING - void declaration
     */
    public static TypeData[] make(int size) {
        void var1_1;
        TypeData[] array = new TypeData[size];
        for (int i2 = 0; i2 < size; ++i2) {
            array[i2] = TypeTag.TOP;
        }
        return var1_1;
    }

    protected TypeData() {
    }

    /*
     * WARNING - void declaration
     */
    private static void setType(TypeData td, String className, ClassPool cp) throws BadBytecode {
        void var2_2;
        void var1_1;
        td.setType((String)var1_1, (ClassPool)var2_2);
    }

    public abstract int getTypeTag();

    public abstract int getTypeData(ConstPool var1);

    public TypeData join() {
        return new TypeVar(this);
    }

    public abstract BasicType isBasicType();

    public abstract boolean is2WordType();

    public boolean isNullType() {
        return false;
    }

    public boolean isUninit() {
        return false;
    }

    public abstract boolean eq(TypeData var1);

    public abstract String getName();

    public abstract void setType(String var1, ClassPool var2) throws BadBytecode;

    public abstract TypeData getArrayType(int var1) throws NotFoundException;

    public int dfs(List<TypeData> order, int index, ClassPool cp) throws NotFoundException {
        return index;
    }

    protected TypeVar toTypeVar(int dim) {
        return null;
    }

    public void constructorCalled(int offset) {
    }

    public String toString() {
        return super.toString() + "(" + this.toString2(new HashSet<TypeData>()) + ")";
    }

    abstract String toString2(Set<TypeData> var1);

    /*
     * WARNING - void declaration
     */
    public static CtClass commonSuperClassEx(CtClass one, CtClass two) throws NotFoundException {
        void var1_1;
        CtClass ctClass;
        if (one == two) {
            return one;
        }
        if (one.isArray() && two.isArray()) {
            void var3_3;
            void var2_2;
            CtClass ele2;
            CtClass ele1 = one.getComponentType();
            CtClass element = TypeData.commonSuperClassEx(ele1, ele2 = two.getComponentType());
            if (element == var2_2) {
                return one;
            }
            if (element == var3_3) {
                return two;
            }
            return one.getClassPool().get(element == null ? "java.lang.Object" : element.getName() + "[]");
        }
        if (one.isPrimitive() || two.isPrimitive()) {
            return null;
        }
        if (one.isArray() || two.isArray()) {
            return one.getClassPool().get("java.lang.Object");
        }
        return TypeData.commonSuperClass(ctClass, (CtClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass commonSuperClass(CtClass one, CtClass two) throws NotFoundException {
        CtClass ctClass;
        void var3_3;
        CtClass shallow;
        CtClass deep = one;
        CtClass backupShallow = shallow = two;
        CtClass backupDeep = deep;
        while (true) {
            if (TypeData.eq(deep, shallow) && deep.getSuperclass() != null) {
                return deep;
            }
            CtClass deepSuper = deep.getSuperclass();
            CtClass shallowSuper = shallow.getSuperclass();
            if (shallowSuper == null) {
                shallow = backupShallow;
                break;
            }
            if (deepSuper == null) {
                deep = backupDeep;
                backupDeep = backupShallow;
                backupShallow = deep;
                deep = shallow;
                shallow = backupShallow;
                break;
            }
            deep = deepSuper;
            shallow = shallowSuper;
        }
        while ((deep = deep.getSuperclass()) != null) {
            backupDeep = backupDeep.getSuperclass();
        }
        deep = var3_3;
        while (!TypeData.eq(deep, shallow)) {
            deep = deep.getSuperclass();
            shallow = shallow.getSuperclass();
        }
        return ctClass;
    }

    /*
     * WARNING - void declaration
     */
    static boolean eq(CtClass one, CtClass two) {
        void var1_1;
        CtClass ctClass;
        return one == two || one != null && two != null && ctClass.getName().equals(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static void aastore(TypeData array, TypeData value, ClassPool cp) throws BadBytecode {
        if (array instanceof AbsTypeVar && !value.isNullType()) {
            ((AbsTypeVar)array).merge(ArrayType.make(value));
        }
        if (value instanceof AbsTypeVar) {
            String string;
            if (array instanceof AbsTypeVar) {
                ArrayElement.make(array);
                return;
            }
            if (array instanceof ClassName) {
                if (!array.isNullType()) {
                    void var2_2;
                    void var1_1;
                    String type = ArrayElement.typeName(array.getName());
                    var1_1.setType(string, (ClassPool)var2_2);
                    return;
                }
            } else {
                throw new BadBytecode("bad AASTORE: " + string);
            }
        }
    }

    protected static class BasicType
    extends TypeData {
        private String name;
        private int typeTag;
        private char decodedName;

        /*
         * WARNING - void declaration
         */
        public BasicType(String type, int tag, char decoded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.typeTag = var2_2;
            this.decodedName = var3_3;
        }

        @Override
        public int getTypeTag() {
            return this.typeTag;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        public TypeData join() {
            if (this == TypeTag.TOP) {
                return this;
            }
            return super.join();
        }

        @Override
        public BasicType isBasicType() {
            return this;
        }

        @Override
        public boolean is2WordType() {
            return this.typeTag == 4 || this.typeTag == 3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            return this == var1_1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public char getDecodedName() {
            return this.decodedName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var1_1;
            throw new BadBytecode("conflict: " + this.name + " and " + (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            void var2_2;
            if (this == TypeTag.TOP) {
                return this;
            }
            if (dim < 0) {
                throw new NotFoundException("no element type: " + this.name);
            }
            if (dim == 0) {
                return this;
            }
            char[] name = new char[dim + 1];
            for (int i2 = 0; i2 < dim; ++i2) {
                name[i2] = 91;
            }
            name[var1_1] = this.decodedName;
            return new ClassName(new String((char[])var2_2));
        }

        @Override
        String toString2(Set<TypeData> set) {
            return this.name;
        }
    }

    public static class TypeVar
    extends AbsTypeVar {
        protected List<TypeData> lowers = new ArrayList<TypeData>(2);
        protected List<TypeData> usedBy = new ArrayList<TypeData>(2);
        protected List<String> uppers = null;
        protected String fixedType;
        private boolean is2WordType;
        private int visited = 0;
        private int smallest = 0;
        private boolean inList = false;
        private int dimension = 0;

        /*
         * WARNING - void declaration
         */
        public TypeVar(TypeData t2) {
            void var1_1;
            ((AbsTypeVar)this).merge(t2);
            this.fixedType = null;
            this.is2WordType = var1_1.is2WordType();
        }

        @Override
        public String getName() {
            if (this.fixedType == null) {
                return this.lowers.get(0).getName();
            }
            return this.fixedType;
        }

        @Override
        public BasicType isBasicType() {
            if (this.fixedType == null) {
                return this.lowers.get(0).isBasicType();
            }
            return null;
        }

        @Override
        public boolean is2WordType() {
            if (this.fixedType == null) {
                return this.is2WordType;
            }
            return false;
        }

        @Override
        public boolean isNullType() {
            if (this.fixedType == null) {
                return this.lowers.get(0).isNullType();
            }
            return false;
        }

        @Override
        public boolean isUninit() {
            if (this.fixedType == null) {
                return this.lowers.get(0).isUninit();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(TypeData t2) {
            this.lowers.add(t2);
            if (t2 instanceof TypeVar) {
                void var1_1;
                ((TypeVar)var1_1).usedBy.add(this);
            }
        }

        @Override
        public int getTypeTag() {
            if (this.fixedType == null) {
                return this.lowers.get(0).getTypeTag();
            }
            return super.getTypeTag();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getTypeData(ConstPool cp) {
            void var1_1;
            if (this.fixedType == null) {
                return this.lowers.get(0).getTypeData(cp);
            }
            return super.getTypeData((ConstPool)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String typeName, ClassPool cp) throws BadBytecode {
            void var1_1;
            if (this.uppers == null) {
                this.uppers = new ArrayList<String>();
            }
            this.uppers.add((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected TypeVar toTypeVar(int dim) {
            void var1_1;
            this.dimension = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            void var1_1;
            void var2_2;
            if (dim == 0) {
                return this;
            }
            BasicType bt = ((TypeData)this).isBasicType();
            if (bt == null) {
                if (((TypeData)this).isNullType()) {
                    return new NullType();
                }
                return ((TypeData)new ClassName(((TypeData)this).getName())).getArrayType(dim);
            }
            return var2_2.getArrayType((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int dfs(List<TypeData> preOrder, int index, ClassPool cp) throws NotFoundException {
            void var2_2;
            if (this.visited > 0) {
                return index;
            }
            TypeVar typeVar = this;
            typeVar.visited = typeVar.smallest = ++index;
            preOrder.add(this);
            this.inList = true;
            int n2 = this.lowers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeVar child = this.lowers.get(i2).toTypeVar(this.dimension);
                if (child == null) continue;
                if (child.visited == 0) {
                    index = ((TypeData)child).dfs(preOrder, index, cp);
                    if (child.smallest >= this.smallest) continue;
                    this.smallest = child.smallest;
                    continue;
                }
                if (!child.inList || child.visited >= this.smallest) continue;
                this.smallest = child.visited;
            }
            if (this.visited == this.smallest) {
                void var3_3;
                TypeVar cv;
                ArrayList<TypeData> scc = new ArrayList<TypeData>();
                do {
                    List<TypeData> list = preOrder;
                    cv = (TypeVar)list.remove(list.size() - 1);
                    ((TypeVar)list.remove(list.size() - 1)).inList = false;
                    scc.add(cv);
                } while (cv != this);
                this.fixTypes(scc, (ClassPool)var3_3);
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void fixTypes(List<TypeData> scc, ClassPool cp) throws NotFoundException {
            void var1_1;
            void var2_2;
            void var3_3;
            HashSet<String> lowersSet = new HashSet<String>();
            boolean isBasicType = false;
            TypeData kind = null;
            int size = scc.size();
            block0: for (int i2 = 0; i2 < size; ++i2) {
                TypeVar tvar = (TypeVar)scc.get(i2);
                List<TypeData> tds = tvar.lowers;
                int size2 = tds.size();
                for (int j2 = 0; j2 < size2; ++j2) {
                    TypeData typeData = tds.get(j2);
                    TypeData d2 = typeData.getArrayType(tvar.dimension);
                    BasicType bt = d2.isBasicType();
                    if (kind == null) {
                        if (bt == null) {
                            isBasicType = false;
                            kind = d2;
                            if (d2.isUninit()) {
                                continue block0;
                            }
                        } else {
                            isBasicType = true;
                            kind = bt;
                        }
                    } else if (bt == null && isBasicType || bt != null && kind != bt) {
                        isBasicType = true;
                        kind = TypeTag.TOP;
                        continue block0;
                    }
                    if (bt != null || d2.isNullType()) continue;
                    lowersSet.add(d2.getName());
                }
            }
            if (isBasicType) {
                this.is2WordType = kind.is2WordType();
                this.fixTypes1(scc, kind);
                return;
            }
            String typeName = this.fixTypes2(scc, (Set<String>)var3_3, (ClassPool)var2_2);
            this.fixTypes1((List<TypeData>)var1_1, new ClassName(typeName));
        }

        private void fixTypes1(List<TypeData> scc, TypeData kind) throws NotFoundException {
            int size = scc.size();
            for (int i2 = 0; i2 < size; ++i2) {
                TypeVar cv = (TypeVar)scc.get(i2);
                TypeData kind2 = kind.getArrayType(-cv.dimension);
                if (kind2.isBasicType() == null) {
                    cv.fixedType = kind2.getName();
                    continue;
                }
                cv.lowers.clear();
                cv.lowers.add(kind2);
                cv.is2WordType = kind2.is2WordType();
            }
        }

        /*
         * WARNING - void declaration
         */
        private String fixTypes2(List<TypeData> scc, Set<String> lowersSet, ClassPool cp) throws NotFoundException {
            void var2_2;
            Iterator<String> it = lowersSet.iterator();
            if (lowersSet.isEmpty()) {
                return null;
            }
            if (lowersSet.size() == 1) {
                return it.next();
            }
            CtClass cc = cp.get(it.next());
            while (it.hasNext()) {
                cc = TypeVar.commonSuperClassEx(cc, cp.get(it.next()));
            }
            if (cc.getSuperclass() == null || TypeVar.isObjectArray(cc)) {
                void var3_3;
                void var1_1;
                cc = this.fixByUppers((List<TypeData>)var1_1, (ClassPool)var3_3, new HashSet<TypeData>(), cc);
            }
            if (cc.isArray()) {
                return Descriptor.toJvmName(cc);
            }
            return var2_2.getName();
        }

        private static boolean isObjectArray(CtClass cc) throws NotFoundException {
            CtClass ctClass;
            return cc.isArray() && ctClass.getComponentType().getSuperclass() == null;
        }

        private CtClass fixByUppers(List<TypeData> users, ClassPool cp, Set<TypeData> visited, CtClass type) throws NotFoundException {
            if (users == null) {
                return type;
            }
            int size = users.size();
            for (int i2 = 0; i2 < size; ++i2) {
                TypeVar t2 = (TypeVar)users.get(i2);
                if (!visited.add(t2)) {
                    return type;
                }
                if (t2.uppers != null) {
                    int s2 = t2.uppers.size();
                    for (int k2 = 0; k2 < s2; ++k2) {
                        CtClass cc = cp.get(t2.uppers.get(k2));
                        if (!cc.subtypeOf(type)) continue;
                        type = cc;
                    }
                }
                type = this.fixByUppers(t2.usedBy, cp, visited, type);
            }
            return type;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        String toString2(Set<TypeData> hash) {
            TypeData e2;
            hash.add(this);
            if (this.lowers.size() > 0 && (e2 = this.lowers.get(0)) != null && !hash.contains(e2)) {
                void var1_1;
                void var2_2;
                return var2_2.toString2((Set<TypeData>)var1_1);
            }
            return "?";
        }
    }

    public static abstract class AbsTypeVar
    extends TypeData {
        public abstract void merge(TypeData var1);

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return cp.addClassInfo(this.getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            if (d2.isUninit()) {
                return d2.eq(this);
            }
            return this.getName().equals(var1_1.getName());
        }
    }

    public static class ArrayType
    extends AbsTypeVar {
        private AbsTypeVar element;

        /*
         * WARNING - void declaration
         */
        private ArrayType(AbsTypeVar elementType) {
            void var1_1;
            this.element = var1_1;
        }

        static TypeData make(TypeData element) throws BadBytecode {
            TypeData typeData;
            if (element instanceof ArrayElement) {
                return ((ArrayElement)element).arrayType();
            }
            if (element instanceof AbsTypeVar) {
                return new ArrayType((AbsTypeVar)element);
            }
            if (element instanceof ClassName && !element.isNullType()) {
                return new ClassName(ArrayType.typeName(element.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + typeData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(TypeData t2) {
            try {
                if (!t2.isNullType()) {
                    this.element.merge(ArrayElement.make(t2));
                }
                return;
            }
            catch (BadBytecode e2) {
                void var1_2;
                throw new RuntimeException("fatal: " + var1_2);
            }
        }

        @Override
        public String getName() {
            return ArrayType.typeName(this.element.getName());
        }

        public AbsTypeVar elementType() {
            return this.element;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        public static String typeName(String elementType) {
            String string;
            if (elementType.charAt(0) == '[') {
                return "[" + elementType;
            }
            return "[L" + string.replace('.', '/') + ";";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var2_2;
            void var1_1;
            this.element.setType(ArrayElement.typeName((String)var1_1), (ClassPool)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected TypeVar toTypeVar(int dim) {
            void var1_1;
            return this.element.toTypeVar((int)(var1_1 + true));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            void var1_1;
            return this.element.getArrayType((int)(var1_1 + true));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int dfs(List<TypeData> order, int index, ClassPool cp) throws NotFoundException {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.element.dfs((List<TypeData>)var1_1, (int)var2_2, (ClassPool)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        String toString2(Set<TypeData> set) {
            void var1_1;
            return "[" + this.element.toString2((Set<TypeData>)var1_1);
        }
    }

    public static class ArrayElement
    extends AbsTypeVar {
        private AbsTypeVar array;

        /*
         * WARNING - void declaration
         */
        private ArrayElement(AbsTypeVar a2) {
            void var1_1;
            this.array = var1_1;
        }

        public static TypeData make(TypeData array) throws BadBytecode {
            TypeData typeData;
            if (array instanceof ArrayType) {
                return ((ArrayType)array).elementType();
            }
            if (array instanceof AbsTypeVar) {
                return new ArrayElement((AbsTypeVar)array);
            }
            if (array instanceof ClassName && !array.isNullType()) {
                return new ClassName(ArrayElement.typeName(array.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + typeData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(TypeData t2) {
            try {
                if (!t2.isNullType()) {
                    this.array.merge(ArrayType.make(t2));
                }
                return;
            }
            catch (BadBytecode e2) {
                void var1_2;
                throw new RuntimeException("fatal: " + var1_2);
            }
        }

        @Override
        public String getName() {
            return ArrayElement.typeName(this.array.getName());
        }

        public AbsTypeVar arrayType() {
            return this.array;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static String typeName(String arrayType) {
            if (arrayType.length() > 1 && arrayType.charAt(0) == '[') {
                void var1_1;
                char c2 = arrayType.charAt(1);
                if (c2 == 'L') {
                    return arrayType.substring(2, arrayType.length() - 1).replace('/', '.');
                }
                if (var1_1 == 91) {
                    String string;
                    return string.substring(1);
                }
            }
            return "java.lang.Object";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var2_2;
            void var1_1;
            this.array.setType(ArrayType.typeName((String)var1_1), (ClassPool)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected TypeVar toTypeVar(int dim) {
            void var1_1;
            return this.array.toTypeVar((int)(var1_1 - true));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            void var1_1;
            return this.array.getArrayType((int)(var1_1 - true));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int dfs(List<TypeData> order, int index, ClassPool cp) throws NotFoundException {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.array.dfs((List<TypeData>)var1_1, (int)var2_2, (ClassPool)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        String toString2(Set<TypeData> set) {
            void var1_1;
            return "*" + this.array.toString2((Set<TypeData>)var1_1);
        }
    }

    public static class ClassName
    extends TypeData {
        private String name;

        /*
         * WARNING - void declaration
         */
        public ClassName(String n2) {
            void var1_1;
            this.name = var1_1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return cp.addClassInfo(((TypeData)this).getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            if (d2.isUninit()) {
                return d2.eq(this);
            }
            return this.name.equals(var1_1.getName());
        }

        @Override
        public void setType(String typeName, ClassPool cp) throws BadBytecode {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            void var2_3;
            if (dim == 0) {
                return this;
            }
            if (dim > 0) {
                void var3_5;
                char[] dimType = new char[dim];
                for (int i2 = 0; i2 < dim; ++i2) {
                    dimType[i2] = 91;
                }
                String elementType = ((TypeData)this).getName();
                if (elementType.charAt(0) != '[') {
                    elementType = "L" + elementType.replace('.', '/') + ";";
                }
                return new ClassName(new String(dimType) + (String)var3_5);
            }
            for (int i3 = 0; i3 < -dim; ++i3) {
                if (this.name.charAt(i3) == '[') continue;
                throw new NotFoundException("no " + dim + " dimensional array type: " + ((TypeData)this).getName());
            }
            char type = this.name.charAt(-dim);
            if (type == '[') {
                return new ClassName(this.name.substring(-dim));
            }
            if (type == 'L') {
                void var1_1;
                return new ClassName(this.name.substring((int)(-var1_1 + true), this.name.length() - 1).replace('/', '.'));
            }
            if (type == TypeTag.DOUBLE.decodedName) {
                return TypeTag.DOUBLE;
            }
            if (type == TypeTag.FLOAT.decodedName) {
                return TypeTag.FLOAT;
            }
            if (var2_3 == TypeTag.LONG.decodedName) {
                return TypeTag.LONG;
            }
            return TypeTag.INTEGER;
        }

        @Override
        String toString2(Set<TypeData> set) {
            return this.name;
        }
    }

    public static class UninitThis
    extends UninitData {
        /*
         * WARNING - void declaration
         */
        UninitThis(String className) {
            super(-1, (String)var1_1);
            void var1_1;
        }

        @Override
        public UninitData copy() {
            return new UninitThis(((TypeData)this).getName());
        }

        @Override
        public int getTypeTag() {
            return 6;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        String toString2(Set<TypeData> set) {
            return "uninit:this";
        }
    }

    public static class UninitData
    extends ClassName {
        int offset;
        boolean initialized;

        /*
         * WARNING - void declaration
         */
        UninitData(int offset, String className) {
            super((String)var2_2);
            void var1_1;
            void var2_2;
            this.offset = var1_1;
            this.initialized = false;
        }

        public UninitData copy() {
            return new UninitData(this.offset, ((TypeData)this).getName());
        }

        @Override
        public int getTypeTag() {
            return 8;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return this.offset;
        }

        @Override
        public TypeData join() {
            if (this.initialized) {
                return new TypeVar(new ClassName(((TypeData)this).getName()));
            }
            return new UninitTypeVar(this.copy());
        }

        @Override
        public boolean isUninit() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            if (d2 instanceof UninitData) {
                void var1_1;
                UninitData ud = (UninitData)d2;
                return this.offset == ud.offset && ((TypeData)this).getName().equals(var1_1.getName());
            }
            return false;
        }

        public int offset() {
            return this.offset;
        }

        @Override
        public void constructorCalled(int offset) {
            if (offset == this.offset) {
                this.initialized = true;
            }
        }

        @Override
        String toString2(Set<TypeData> set) {
            return ((TypeData)this).getName() + "," + this.offset;
        }
    }

    public static class NullType
    extends ClassName {
        public NullType() {
            super("null-type");
        }

        @Override
        public int getTypeTag() {
            return 5;
        }

        @Override
        public boolean isNullType() {
            return true;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        public TypeData getArrayType(int dim) {
            return this;
        }
    }

    public static class UninitTypeVar
    extends AbsTypeVar {
        protected TypeData type;

        /*
         * WARNING - void declaration
         */
        public UninitTypeVar(UninitData t2) {
            void var1_1;
            this.type = var1_1;
        }

        @Override
        public int getTypeTag() {
            return this.type.getTypeTag();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getTypeData(ConstPool cp) {
            void var1_1;
            return this.type.getTypeData((ConstPool)var1_1);
        }

        @Override
        public BasicType isBasicType() {
            return this.type.isBasicType();
        }

        @Override
        public boolean is2WordType() {
            return this.type.is2WordType();
        }

        @Override
        public boolean isUninit() {
            return this.type.isUninit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            return this.type.eq((TypeData)var1_1);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        protected TypeVar toTypeVar(int dim) {
            return null;
        }

        @Override
        public TypeData join() {
            return this.type.join();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var2_2;
            void var1_1;
            this.type.setType((String)var1_1, (ClassPool)var2_2);
        }

        @Override
        public void merge(TypeData t2) {
            if (!t2.eq(this.type)) {
                this.type = TypeTag.TOP;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void constructorCalled(int offset) {
            void var1_1;
            this.type.constructorCalled((int)var1_1);
        }

        public int offset() {
            if (this.type instanceof UninitData) {
                return ((UninitData)this.type).offset;
            }
            throw new RuntimeException("not available");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeData getArrayType(int dim) throws NotFoundException {
            void var1_1;
            return this.type.getArrayType((int)var1_1);
        }

        @Override
        String toString2(Set<TypeData> set) {
            return "";
        }
    }
}

