/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.BasicBlock;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.Tracer;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypeData;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypedBlock;
import java.util.ArrayList;

public class MapMaker
extends Tracer {
    /*
     * WARNING - void declaration
     */
    public static StackMapTable make(ClassPool classes, MethodInfo minfo) throws BadBytecode {
        void var3_4;
        MapMaker mapMaker;
        TypedBlock[] blocks;
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        try {
            blocks = TypedBlock.makeBlocks(minfo, ca, true);
        }
        catch (BasicBlock.JsrBytecode jsrBytecode) {
            return null;
        }
        if (blocks == null) {
            return null;
        }
        MapMaker mm = new MapMaker(classes, minfo, ca);
        try {
            void var2_3;
            mm.make(blocks, var2_3.getCode());
        }
        catch (BadBytecode bb) {
            void var0_1;
            void var1_2;
            throw new BadBytecode((MethodInfo)var1_2, (Throwable)var0_1);
        }
        return mapMaker.toStackMap((TypedBlock[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static StackMap make2(ClassPool classes, MethodInfo minfo) throws BadBytecode {
        void var3_4;
        void var1_2;
        MapMaker mapMaker;
        TypedBlock[] blocks;
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        try {
            blocks = TypedBlock.makeBlocks(minfo, ca, true);
        }
        catch (BasicBlock.JsrBytecode jsrBytecode) {
            return null;
        }
        if (blocks == null) {
            return null;
        }
        MapMaker mm = new MapMaker(classes, minfo, ca);
        try {
            void var2_3;
            mm.make(blocks, var2_3.getCode());
        }
        catch (BadBytecode bb) {
            void var0_1;
            throw new BadBytecode(minfo, (Throwable)var0_1);
        }
        return mapMaker.toStackMap2(var1_2.getConstPool(), (TypedBlock[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public MapMaker(ClassPool classes, MethodInfo minfo, CodeAttribute ca) {
        super((ClassPool)var1_1, minfo.getConstPool(), ca.getMaxStack(), var3_3.getMaxLocals(), TypedBlock.getRetType(var2_2.getDescriptor()));
        void var2_2;
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MapMaker(MapMaker old) {
        super((Tracer)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void make(TypedBlock[] blocks, byte[] code) throws BadBytecode {
        this.make(code, blocks[0]);
        this.findDeadCatchers(code, blocks);
        try {
            void var2_3;
            this.fixTypes((byte[])var2_3, blocks);
            return;
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new BadBytecode("failed to resolve types", (Throwable)var1_2);
        }
    }

    private void make(byte[] code, TypedBlock tb) throws BadBytecode {
        int pos;
        MapMaker.copyTypeData(tb.stackTop, tb.stackTypes, this.stackTypes);
        this.stackTop = tb.stackTop;
        MapMaker.copyTypeData(tb.localsTypes.length, tb.localsTypes, this.localsTypes);
        this.traceException(code, tb.toCatch);
        int end = pos + tb.length;
        for (pos = tb.position; pos < end; pos += this.doOpcode(pos, code)) {
            this.traceException(code, tb.toCatch);
        }
        if (tb.exit != null) {
            for (int i2 = 0; i2 < tb.exit.length; ++i2) {
                TypedBlock e2 = (TypedBlock)tb.exit[i2];
                if (e2.alreadySet()) {
                    this.mergeMap(e2, true);
                    continue;
                }
                this.recordStackMap(e2);
                MapMaker mapMaker = new MapMaker(this);
                mapMaker.make(code, e2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void traceException(byte[] code, BasicBlock.Catch handler) throws BadBytecode {
        while (handler != null) {
            TypedBlock tb = (TypedBlock)handler.body;
            if (tb.alreadySet()) {
                this.mergeMap(tb, false);
                if (tb.stackTop <= 0) {
                    throw new BadBytecode("bad catch clause: " + handler.typeIndex);
                }
                MapMaker mapMaker = this;
                tb.stackTypes[0] = mapMaker.merge(mapMaker.toExceptionType(handler.typeIndex), tb.stackTypes[0]);
            } else {
                void var3_3;
                this.recordStackMap(tb, handler.typeIndex);
                MapMaker mapMaker = new MapMaker(this);
                mapMaker.make(code, (TypedBlock)var3_3);
            }
            handler = handler.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeMap(TypedBlock dest, boolean mergeStack) throws BadBytecode {
        void var2_2;
        int i2;
        int n2 = this.localsTypes.length;
        for (i2 = 0; i2 < n2; ++i2) {
            MapMaker mapMaker = this;
            dest.localsTypes[i2] = mapMaker.merge(MapMaker.validateTypeData(mapMaker.localsTypes, n2, i2), dest.localsTypes[i2]);
        }
        if (var2_2 != false) {
            n2 = this.stackTop;
            for (i2 = 0; i2 < n2; ++i2) {
                MapMaker mapMaker = this;
                dest.stackTypes[i2] = mapMaker.merge(mapMaker.stackTypes[i2], dest.stackTypes[i2]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private TypeData merge(TypeData src, TypeData target) throws BadBytecode {
        if (src == target) {
            return target;
        }
        if (target instanceof TypeData.ClassName || target instanceof TypeData.BasicType) {
            return target;
        }
        if (target instanceof TypeData.AbsTypeVar) {
            void var2_2;
            void var1_1;
            ((TypeData.AbsTypeVar)target).merge((TypeData)var1_1);
            return var2_2;
        }
        throw new RuntimeException("fatal: this should never happen");
    }

    /*
     * WARNING - void declaration
     */
    private void recordStackMap(TypedBlock target) throws BadBytecode {
        void var2_2;
        void var3_3;
        void var1_1;
        TypeData[] tStackTypes = TypeData.make(this.stackTypes.length);
        int st = this.stackTop;
        MapMaker.recordTypeData(st, this.stackTypes, tStackTypes);
        this.recordStackMap0((TypedBlock)var1_1, (int)var3_3, (TypeData[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void recordStackMap(TypedBlock target, int exceptionType) throws BadBytecode {
        void var3_3;
        void var1_1;
        void var2_2;
        TypeData[] typeDataArray = TypeData.make(this.stackTypes.length);
        TypeData[] tStackTypes = typeDataArray;
        typeDataArray[0] = this.toExceptionType((int)var2_2).join();
        this.recordStackMap0((TypedBlock)var1_1, 1, (TypeData[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private TypeData.ClassName toExceptionType(int exceptionType) {
        void var1_2;
        void type22;
        String type22 = exceptionType == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo((int)type22);
        return new TypeData.ClassName((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void recordStackMap0(TypedBlock target, int st, TypeData[] tStackTypes) throws BadBytecode {
        void var3_3;
        void var2_2;
        void var1_1;
        int n2 = this.localsTypes.length;
        TypeData[] tLocalsTypes = TypeData.make(n2);
        int k2 = MapMaker.recordTypeData(n2, this.localsTypes, tLocalsTypes);
        var1_1.setStackMap((int)var2_2, (TypeData[])var3_3, k2, tLocalsTypes);
    }

    /*
     * WARNING - void declaration
     */
    protected static int recordTypeData(int n2, TypeData[] srcTypes, TypeData[] destTypes) {
        void var3_3;
        int k2 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData t2 = MapMaker.validateTypeData(srcTypes, n2, i2);
            destTypes[i2] = t2.join();
            if (t2 == TOP) continue;
            k2 = i2 + 1;
        }
        return (int)(var3_3 + true);
    }

    /*
     * WARNING - void declaration
     */
    protected static void copyTypeData(int n2, TypeData[] srcTypes, TypeData[] destTypes) {
        int n3;
        void var2_2;
        System.arraycopy(srcTypes, 0, var2_2, 0, n3);
    }

    /*
     * WARNING - void declaration
     */
    private static TypeData validateTypeData(TypeData[] data, int length, int index) {
        void var3_3;
        void var2_2;
        TypeData[] typeDataArray;
        void var1_1;
        TypeData td = data[index];
        if (td.is2WordType() && index + 1 < var1_1 && typeDataArray[var2_2 + true] != TOP) {
            return TOP;
        }
        return var3_3;
    }

    private void findDeadCatchers(byte[] code, TypedBlock[] blocks) throws BadBytecode {
        for (TypedBlock block : blocks) {
            TypedBlock tb;
            if (block.alreadySet()) continue;
            this.fixDeadcode(code, block);
            BasicBlock.Catch handler = block.toCatch;
            if (handler == null || (tb = (TypedBlock)handler.body).alreadySet()) continue;
            this.recordStackMap(tb, handler.typeIndex);
            this.fixDeadcode(code, tb);
            tb.incoming = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fixDeadcode(byte[] code, TypedBlock block) throws BadBytecode {
        void var3_4;
        void var1_1;
        int pos = block.position;
        int len = block.length - 3;
        if (len < 0) {
            if (len == -1) {
                code[pos] = 0;
            }
            code[pos + block.length - 1] = -65;
            block.incoming = 1;
            this.recordStackMap(block, 0);
            return;
        }
        block.incoming = 0;
        for (int k2 = 0; k2 < len; ++k2) {
            code[pos + k2] = 0;
        }
        code[pos + len] = -89;
        ByteArray.write16bit(-len, (byte[])var1_1, (int)(var3_4 + len + true));
    }

    private void fixTypes(byte[] code, TypedBlock[] blocks) throws NotFoundException, BadBytecode {
        ArrayList<TypeData> preOrder = new ArrayList<TypeData>();
        int len = blocks.length;
        int index = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int j2;
            TypedBlock block = blocks[i2];
            if (!block.alreadySet()) continue;
            int n2 = block.localsTypes.length;
            for (j2 = 0; j2 < n2; ++j2) {
                index = block.localsTypes[j2].dfs(preOrder, index, this.classPool);
            }
            n2 = block.stackTop;
            for (j2 = 0; j2 < n2; ++j2) {
                index = block.stackTypes[j2].dfs(preOrder, index, this.classPool);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public StackMapTable toStackMap(TypedBlock[] blocks) {
        void var2_2;
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        int n2 = blocks.length;
        TypedBlock prev = blocks[0];
        int offsetDelta = prev.length;
        if (prev.incoming > 0) {
            writer.sameFrame(0);
            --offsetDelta;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            TypedBlock bb = blocks[i2];
            if (this.isTarget(bb, blocks[i2 - 1])) {
                bb.resetNumLocals();
                int diffL = MapMaker.stackMapDiff(prev.numLocals, prev.localsTypes, bb.numLocals, bb.localsTypes);
                this.toStackMapBody(writer, bb, diffL, offsetDelta, prev);
                offsetDelta = bb.length - 1;
                prev = bb;
                continue;
            }
            if (bb.incoming == 0) {
                writer.sameFrame(offsetDelta);
                offsetDelta = bb.length - 1;
                continue;
            }
            offsetDelta += bb.length;
        }
        return var2_2.toStackMapTable(this.cpool);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTarget(TypedBlock cur, TypedBlock prev) {
        void var2_3;
        void var1_2;
        int in = cur.incoming;
        if (in > 1) {
            return true;
        }
        if (var1_2 <= 0) {
            return false;
        }
        return var2_3.stop;
    }

    /*
     * WARNING - void declaration
     */
    private void toStackMapBody(StackMapTable.Writer writer, TypedBlock bb, int diffL, int offsetDelta, TypedBlock prev) {
        void var3_7;
        void var2_2;
        void var1_1;
        int stackTop = bb.stackTop;
        if (stackTop == 0) {
            if (diffL == 0) {
                writer.sameFrame(offsetDelta);
                return;
            }
            if (diffL < 0 && diffL >= -3) {
                writer.chopFrame(offsetDelta, -diffL);
                return;
            }
            if (diffL > 0 && diffL <= 3) {
                int[] data = new int[diffL];
                int[] tags = this.fillStackMap(bb.numLocals - prev.numLocals, prev.numLocals, data, bb.localsTypes);
                writer.appendFrame(offsetDelta, tags, data);
                return;
            }
        } else {
            void td2;
            void data;
            if (stackTop == 1 && data == false) {
                TypeData td2 = bb.stackTypes[0];
                writer.sameLocals(offsetDelta, td2.getTypeTag(), td2.getTypeData(this.cpool));
                return;
            }
            if (stackTop == 2 && td2 == false && (td = bb.stackTypes[0]).is2WordType()) {
                writer.sameLocals(offsetDelta, td.getTypeTag(), td.getTypeData(this.cpool));
                return;
            }
        }
        int[] sdata = new int[stackTop];
        int[] stags = this.fillStackMap(stackTop, 0, sdata, bb.stackTypes);
        int[] ldata = new int[bb.numLocals];
        int[] ltags = this.fillStackMap(bb.numLocals, 0, ldata, bb.localsTypes);
        var1_1.fullFrame(offsetDelta, (int[])var2_2, ldata, stags, (int[])var3_7);
    }

    private int[] fillStackMap(int num, int offset, int[] data, TypeData[] types) {
        int n2 = offset;
        int realNum = MapMaker.diffSize(types, n2, n2 + num);
        ConstPool cp = this.cpool;
        int[] tags = new int[realNum];
        int j2 = 0;
        for (int i2 = 0; i2 < num; ++i2) {
            TypeData td = types[offset + i2];
            tags[j2] = td.getTypeTag();
            data[j2] = td.getTypeData(cp);
            if (td.is2WordType()) {
                ++i2;
            }
            ++j2;
        }
        return tags;
    }

    /*
     * WARNING - void declaration
     */
    private static int stackMapDiff(int oldTdLen, TypeData[] oldTd, int newTdLen, TypeData[] newTd) {
        int diff = newTdLen - oldTdLen;
        int len = diff > 0 ? oldTdLen : newTdLen;
        if (MapMaker.stackMapEq(oldTd, newTd, len)) {
            int n2;
            void var1_1;
            if (diff > 0) {
                void var2_2;
                void var3_3;
                return MapMaker.diffSize((TypeData[])var3_3, len, (int)var2_2);
            }
            return -MapMaker.diffSize((TypeData[])var1_1, len, n2);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] oldTd, TypeData[] newTd, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (oldTd[i2].eq(newTd[i2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static int diffSize(TypeData[] types, int offset, int len) {
        void var3_3;
        int num = 0;
        while (offset < len) {
            TypeData td = types[offset++];
            ++num;
            if (!td.is2WordType()) continue;
            ++offset;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public StackMap toStackMap2(ConstPool cp, TypedBlock[] blocks) {
        void var1_1;
        void var3_3;
        int i2;
        StackMap.Writer writer = new StackMap.Writer();
        int n2 = blocks.length;
        boolean[] effective = new boolean[n2];
        TypedBlock prev = blocks[0];
        effective[0] = prev.incoming > 0;
        int num = effective[0] ? 1 : 0;
        for (i2 = 1; i2 < n2; ++i2) {
            TypedBlock bb = blocks[i2];
            effective[i2] = this.isTarget(bb, blocks[i2 - 1]);
            if (!effective[i2]) continue;
            bb.resetNumLocals();
            ++num;
        }
        if (num == 0) {
            return null;
        }
        writer.write16bit(num);
        for (i2 = 0; i2 < n2; ++i2) {
            if (!effective[i2]) continue;
            this.writeStackFrame(writer, cp, blocks[i2].position, blocks[i2]);
        }
        return var3_3.toStackMap((ConstPool)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void writeStackFrame(StackMap.Writer writer, ConstPool cp, int offset, TypedBlock tb) {
        void var2_2;
        void var1_1;
        void var3_3;
        writer.write16bit((int)var3_3);
        this.writeVerifyTypeInfo(writer, cp, tb.localsTypes, tb.numLocals);
        this.writeVerifyTypeInfo((StackMap.Writer)var1_1, (ConstPool)var2_2, tb.stackTypes, tb.stackTop);
    }

    private void writeVerifyTypeInfo(StackMap.Writer writer, ConstPool cp, TypeData[] types, int num) {
        TypeData td;
        int i2;
        int numDWord = 0;
        for (i2 = 0; i2 < num; ++i2) {
            td = types[i2];
            if (td == null || !td.is2WordType()) continue;
            ++numDWord;
            ++i2;
        }
        writer.write16bit(num - numDWord);
        for (i2 = 0; i2 < num; ++i2) {
            td = types[i2];
            writer.writeVerifyTypeInfo(td.getTypeTag(), td.getTypeData(cp));
            if (!td.is2WordType()) continue;
            ++i2;
        }
    }
}

