/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BasicBlock {
    protected int position;
    protected int length;
    protected int incoming;
    protected BasicBlock[] exit;
    protected boolean stop;
    protected Catch toCatch;

    /*
     * WARNING - void declaration
     */
    protected BasicBlock(int pos) {
        void var1_1;
        this.position = var1_1;
        this.length = 0;
        this.incoming = 0;
    }

    /*
     * WARNING - void declaration
     */
    public static BasicBlock find(BasicBlock[] blocks, int pos) throws BadBytecode {
        void var1_1;
        BasicBlock[] basicBlockArray = blocks;
        int n2 = blocks.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BasicBlock b2 = basicBlockArray[i2];
            if (b2.position > pos || pos >= b2.position + b2.length) continue;
            return b2;
        }
        throw new BadBytecode("no basic block at " + (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        void var3_3;
        void var2_2;
        StringBuilder sbuf = new StringBuilder();
        String cname = this.getClass().getName();
        int i2 = cname.lastIndexOf(46);
        sbuf.append(i2 < 0 ? cname : var2_2.substring((int)(var3_3 + true)));
        sbuf.append('[');
        this.toString2(sbuf);
        sbuf.append(']');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void toString2(StringBuilder sbuf) {
        void var1_1;
        sbuf.append("pos=").append(this.position).append(", len=").append(this.length).append(", in=").append(this.incoming).append(", exit{");
        if (this.exit != null) {
            BasicBlock[] basicBlockArray = this.exit;
            int n2 = this.exit.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                BasicBlock b2 = basicBlockArray[i2];
                sbuf.append(b2.position).append(',');
            }
        }
        sbuf.append("}, {");
        Catch th = this.toCatch;
        while (th != null) {
            sbuf.append('(').append(th.body.position).append(", ").append(th.typeIndex).append("), ");
            th = th.next;
        }
        var1_1.append('}');
    }

    public static class Catch {
        public Catch next;
        public BasicBlock body;
        public int typeIndex;

        /*
         * WARNING - void declaration
         */
        Catch(BasicBlock b2, int i2, Catch c2) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.body = var1_1;
            this.typeIndex = var2_2;
            this.next = var3_3;
        }
    }

    public static class Maker {
        /*
         * WARNING - void declaration
         */
        protected BasicBlock makeBlock(int pos) {
            void var1_1;
            return new BasicBlock((int)var1_1);
        }

        protected BasicBlock[] makeArray(int size) {
            return new BasicBlock[size];
        }

        /*
         * WARNING - void declaration
         */
        private BasicBlock[] makeArray(BasicBlock b2) {
            void var2_2;
            void var1_1;
            BasicBlock[] basicBlockArray = this.makeArray(1);
            BasicBlock[] array = basicBlockArray;
            basicBlockArray[0] = var1_1;
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private BasicBlock[] makeArray(BasicBlock b1, BasicBlock b2) {
            void var3_3;
            void var2_2;
            void var1_1;
            BasicBlock[] basicBlockArray = this.makeArray(2);
            BasicBlock[] array = basicBlockArray;
            basicBlockArray[0] = var1_1;
            array[1] = var2_2;
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public BasicBlock[] make(MethodInfo minfo) throws BadBytecode {
            void var1_1;
            void var2_2;
            CodeAttribute ca = minfo.getCodeAttribute();
            if (ca == null) {
                return null;
            }
            CodeIterator ci = ca.iterator();
            return this.make(ci, 0, var2_2.getCodeLength(), var1_1.getExceptionTable());
        }

        /*
         * WARNING - void declaration
         */
        public BasicBlock[] make(CodeIterator ci, int begin, int end, ExceptionTable et) throws BadBytecode {
            void var1_1;
            void var3_3;
            void var2_2;
            Map<Integer, Mark> marks = this.makeMarks(ci, (int)var2_2, (int)var3_3, et);
            BasicBlock[] bb = this.makeBlocks(marks);
            this.addCatchers(bb, et);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Mark makeMark(Map<Integer, Mark> table, int pos) {
            void var2_2;
            void var1_1;
            return this.makeMark0((Map<Integer, Mark>)var1_1, (int)var2_2, true, true);
        }

        /*
         * WARNING - void declaration
         */
        private Mark makeMark(Map<Integer, Mark> table, int pos, BasicBlock[] jump, int size, boolean always) {
            void var1_1;
            void var3_3;
            void var2_2;
            Mark m2 = this.makeMark0(table, (int)var2_2, false, false);
            m2.setJump((BasicBlock[])var3_3, size, always);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Mark makeMark0(Map<Integer, Mark> table, int pos, boolean isBlockBegin, boolean isTarget) {
            void var3_3;
            Integer p2 = pos;
            Mark m2 = table.get(p2);
            if (m2 == null) {
                void var1_1;
                m2 = new Mark(pos);
                var1_1.put(p2, m2);
            }
            if (var3_3 != false) {
                if (m2.block == null) {
                    void var2_2;
                    m2.block = this.makeBlock((int)var2_2);
                }
                if (isTarget) {
                    ++m2.block.incoming;
                }
            }
            return m2;
        }

        /*
         * WARNING - void declaration
         */
        private Map<Integer, Mark> makeMarks(CodeIterator ci, int begin, int end, ExceptionTable et) throws BadBytecode {
            void var2_3;
            int index;
            ci.begin();
            ci.move(begin);
            HashMap<Integer, Mark> marks = new HashMap<Integer, Mark>();
            block7: while (ci.hasNext() && (index = ci.next()) < end) {
                void var6_7;
                void to2;
                int op = ci.byteAt(index);
                if (153 <= op && op <= 166 || op == 198 || op == 199) {
                    Mark to2 = this.makeMark(marks, index + ci.s16bitAt(index + 1));
                    Mark next = this.makeMark(marks, index + 3);
                    this.makeMark(marks, index, this.makeArray(to2.block, next.block), 3, false);
                    continue;
                }
                if (167 <= to2 && to2 <= 171) {
                    switch (to2) {
                        case 167: {
                            int n2 = index;
                            this.makeGoto(marks, n2, n2 + ci.s16bitAt(index + 1), 3);
                            continue block7;
                        }
                        case 168: {
                            int n3 = index;
                            this.makeJsr(marks, n3, n3 + ci.s16bitAt(index + 1), 3);
                            continue block7;
                        }
                        case 169: {
                            this.makeMark(marks, index, null, 2, true);
                            continue block7;
                        }
                        case 170: {
                            int p2;
                            int pos = (index & 0xFFFFFFFC) + 4;
                            int low = ci.s32bitAt(pos + 4);
                            int n4 = ci.s32bitAt(pos + 8);
                            int ncases = n4 - low + 1;
                            BasicBlock[] basicBlockArray = this.makeArray(ncases + 1);
                            BasicBlock[] to3 = basicBlockArray;
                            basicBlockArray[0] = this.makeMark(marks, (int)(index + ci.s32bitAt((int)pos))).block;
                            int n5 = p2 + (ncases << 2);
                            int k2 = 1;
                            for (p2 = pos + 12; p2 < n5; p2 += 4) {
                                to3[k2++] = this.makeMark(marks, (int)(index + ci.s32bitAt((int)p2))).block;
                            }
                            this.makeMark(marks, index, to3, n5 - index, true);
                            continue block7;
                        }
                        case 171: {
                            int p3;
                            int pos = (index & 0xFFFFFFFC) + 4;
                            int ncases = ci.s32bitAt(pos + 4);
                            BasicBlock[] basicBlockArray = this.makeArray(ncases + 1);
                            BasicBlock[] to4 = basicBlockArray;
                            basicBlockArray[0] = this.makeMark(marks, (int)(index + ci.s32bitAt((int)pos))).block;
                            int n6 = p3 + (ncases << 3) - 4;
                            int k3 = 1;
                            for (p3 = pos + 8 + 4; p3 < n6; p3 += 8) {
                                to4[k3++] = this.makeMark(marks, (int)(index + ci.s32bitAt((int)p3))).block;
                            }
                            this.makeMark(marks, index, to4, n6 - index, true);
                        }
                    }
                    continue;
                }
                if (172 <= var6_7 && var6_7 <= 177 || var6_7 == 191) {
                    this.makeMark(marks, index, null, 1, true);
                    continue;
                }
                if (var6_7 == 200) {
                    int n7 = index;
                    this.makeGoto(marks, n7, n7 + ci.s32bitAt(index + 1), 5);
                    continue;
                }
                if (var6_7 == 201) {
                    int n8 = index;
                    this.makeJsr(marks, n8, n8 + ci.s32bitAt(index + 1), 5);
                    continue;
                }
                if (var6_7 != 196 || ci.byteAt(index + 1) != 169) continue;
                this.makeMark(marks, index, null, 4, true);
            }
            if (et != null) {
                int i2 = et.size();
                while (--i2 >= 0) {
                    this.makeMark0(marks, et.startPc(i2), true, false);
                    this.makeMark(marks, et.handlerPc(i2));
                }
            }
            return var2_3;
        }

        /*
         * WARNING - void declaration
         */
        private void makeGoto(Map<Integer, Mark> marks, int pos, int target, int size) {
            void var3_4;
            void var2_2;
            void var1_1;
            Mark to = this.makeMark(marks, target);
            BasicBlock[] jumps = this.makeArray(to.block);
            this.makeMark((Map<Integer, Mark>)var1_1, (int)var2_2, (BasicBlock[])var3_4, size, true);
        }

        protected void makeJsr(Map<Integer, Mark> marks, int pos, int target, int size) throws BadBytecode {
            throw new JsrBytecode();
        }

        /*
         * WARNING - void declaration
         */
        private BasicBlock[] makeBlocks(Map<Integer, Mark> markTable) {
            void var2_2;
            BasicBlock prev;
            Object[] marks = markTable.values().toArray(new Mark[markTable.size()]);
            Arrays.sort(marks);
            ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>();
            int i2 = 0;
            if (marks.length > 0 && ((Mark)marks[0]).position == 0 && ((Mark)marks[0]).block != null) {
                ++i2;
                prev = Maker.getBBlock((Mark)marks[0]);
            } else {
                prev = this.makeBlock(0);
            }
            blocks.add(prev);
            while (i2 < marks.length) {
                Object m2;
                BasicBlock bb;
                if ((bb = Maker.getBBlock((Mark)(m2 = marks[i2++]))) == null) {
                    if (prev.length > 0) {
                        prev = this.makeBlock(prev.position + prev.length);
                        blocks.add(prev);
                    }
                    prev.length = ((Mark)m2).position + ((Mark)m2).size - prev.position;
                    prev.exit = ((Mark)m2).jump;
                    prev.stop = ((Mark)m2).alwaysJmp;
                    continue;
                }
                if (prev.length == 0) {
                    prev.length = ((Mark)m2).position - prev.position;
                    ++bb.incoming;
                    prev.exit = this.makeArray(bb);
                } else if (prev.position + prev.length < ((Mark)m2).position) {
                    prev = this.makeBlock(prev.position + prev.length);
                    blocks.add(prev);
                    prev.length = ((Mark)m2).position - prev.position;
                    prev.stop = true;
                    prev.exit = this.makeArray(bb);
                }
                blocks.add(bb);
                prev = bb;
            }
            return blocks.toArray(this.makeArray(var2_2.size()));
        }

        /*
         * WARNING - void declaration
         */
        private static BasicBlock getBBlock(Mark m2) {
            void var1_1;
            BasicBlock b2 = m2.block;
            if (b2 != null && m2.size > 0) {
                Mark mark;
                b2.exit = m2.jump;
                b2.length = m2.size;
                b2.stop = mark.alwaysJmp;
            }
            return var1_1;
        }

        private void addCatchers(BasicBlock[] blocks, ExceptionTable et) throws BadBytecode {
            if (et == null) {
                return;
            }
            int i2 = et.size();
            while (--i2 >= 0) {
                BasicBlock handler = BasicBlock.find(blocks, et.handlerPc(i2));
                int start = et.startPc(i2);
                int end = et.endPc(i2);
                int type = et.catchType(i2);
                --handler.incoming;
                for (int k2 = 0; k2 < blocks.length; ++k2) {
                    BasicBlock bb = blocks[k2];
                    int iPos = bb.position;
                    if (start > iPos || iPos >= end) continue;
                    bb.toCatch = new Catch(handler, type, bb.toCatch);
                    ++handler.incoming;
                }
            }
        }
    }

    static class Mark
    implements Comparable<Mark> {
        int position;
        BasicBlock block;
        BasicBlock[] jump;
        boolean alwaysJmp;
        int size;
        Catch catcher;

        /*
         * WARNING - void declaration
         */
        Mark(int p2) {
            void var1_1;
            this.position = var1_1;
            this.block = null;
            this.jump = null;
            this.alwaysJmp = false;
            this.size = 0;
            this.catcher = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Mark obj) {
            void var1_1;
            if (obj == null) {
                return -1;
            }
            return this.position - var1_1.position;
        }

        /*
         * WARNING - void declaration
         */
        void setJump(BasicBlock[] bb, int s2, boolean always) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.jump = var1_1;
            this.size = var2_2;
            this.alwaysJmp = var3_3;
        }
    }

    static class JsrBytecode
    extends BadBytecode {
        private static final long serialVersionUID = 1L;

        JsrBytecode() {
            super("JSR");
        }
    }
}

