/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AnnotationDefaultAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.Annotation;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AnnotationImpl
implements InvocationHandler {
    private static final String JDK_ANNOTATION_CLASS_NAME = "java.lang.annotation.Annotation";
    private static Method JDK_ANNOTATION_TYPE_METHOD = null;
    private Annotation annotation;
    private ClassPool pool;
    private ClassLoader classLoader;
    private transient Class<?> annotationType;
    private transient int cachedHashCode = Integer.MIN_VALUE;

    /*
     * WARNING - void declaration
     */
    public static Object make(ClassLoader cl, Class<?> clazz, ClassPool cp, Annotation anon) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        ClassLoader classLoader;
        void var3_3;
        AnnotationImpl handler = new AnnotationImpl((Annotation)var3_3, cp, cl);
        return Proxy.newProxyInstance(classLoader, new Class[]{var1_1}, (InvocationHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AnnotationImpl(Annotation a2, ClassPool cp, ClassLoader loader) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.annotation = var1_1;
        this.pool = var2_2;
        this.classLoader = var3_3;
    }

    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> getAnnotationType() {
        if (this.annotationType == null) {
            String typeName = this.annotation.getTypeName();
            try {
                this.annotationType = this.classLoader.loadClass(typeName);
            }
            catch (ClassNotFoundException e2) {
                void var1_1;
                void var2_2;
                NoClassDefFoundError error = new NoClassDefFoundError("Error loading annotation class: " + typeName);
                error.setStackTrace(var2_2.getStackTrace());
                throw var1_1;
            }
        }
        return this.annotationType;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        void var2_2;
        void var3_3;
        MemberValue mv;
        String name = method.getName();
        if (Object.class == method.getDeclaringClass()) {
            if ("equals".equals(name)) {
                Object obj = args2[0];
                return this.checkEquals(obj);
            }
            if ("toString".equals(name)) {
                return this.annotation.toString();
            }
            if ("hashCode".equals(name)) {
                return this.hashCode();
            }
        } else if ("annotationType".equals(name) && method.getParameterTypes().length == 0) {
            return this.getAnnotationType();
        }
        if ((mv = this.annotation.getMemberValue(name)) == null) {
            void var1_1;
            return this.getDefault((String)var1_1, method);
        }
        return var3_3.getValue(this.classLoader, this.pool, (Method)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Object getDefault(String name, Method method) throws ClassNotFoundException, RuntimeException {
        void var1_1;
        void var3_3;
        String classname = this.annotation.getTypeName();
        if (this.pool != null) {
            try {
                AnnotationDefaultAttribute ainfo;
                Object object = this.pool.get(classname);
                object = ((CtClass)object).getClassFile2();
                MethodInfo minfo = ((ClassFile)object).getMethod((String)name);
                if (minfo != null && (ainfo = (AnnotationDefaultAttribute)minfo.getAttribute("AnnotationDefault")) != null) {
                    void var2_2;
                    name = ainfo.getDefaultValue();
                    return ((MemberValue)name).getValue(this.classLoader, this.pool, (Method)var2_2);
                }
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException("cannot find a class file: " + classname);
            }
        }
        throw new RuntimeException("no default value: " + (String)var3_3 + "." + (String)var1_1 + "()");
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            void var1_1;
            boolean hashCode2 = false;
            this.getAnnotationType();
            Method[] methods = this.annotationType.getDeclaredMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                String name = methods[i2].getName();
                int valueHashCode = 0;
                MemberValue mv = this.annotation.getMemberValue(name);
                Object value = null;
                try {
                    if (mv != null) {
                        value = mv.getValue(this.classLoader, this.pool, methods[i2]);
                    }
                    if (value == null) {
                        value = this.getDefault(name, methods[i2]);
                    }
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException hashCode2 = runtimeException;
                    throw runtimeException;
                }
                catch (Exception e2) {
                    void var1_3;
                    throw new RuntimeException("Error retrieving value " + name + " for annotation " + this.annotation.getTypeName(), (Throwable)var1_3);
                }
                if (value != null) {
                    valueHashCode = value.getClass().isArray() ? AnnotationImpl.arrayHashCode(value) : value.hashCode();
                }
                var1_1 += 127 * name.hashCode() ^ valueHashCode;
            }
            this.cachedHashCode = var1_1;
        }
        return this.cachedHashCode;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkEquals(Object obj) throws Exception {
        InvocationHandler ih;
        if (obj == null) {
            return false;
        }
        if (obj instanceof Proxy && (ih = Proxy.getInvocationHandler(obj)) instanceof AnnotationImpl) {
            AnnotationImpl other = (AnnotationImpl)ih;
            return this.annotation.equals(other.annotation);
        }
        Class otherAnnotationType = (Class)JDK_ANNOTATION_TYPE_METHOD.invoke(obj, new Object[0]);
        if (!this.getAnnotationType().equals(otherAnnotationType)) {
            return false;
        }
        Method[] methods = this.annotationType.getDeclaredMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Object otherValue;
            String name = methods[i2].getName();
            MemberValue mv = this.annotation.getMemberValue(name);
            Object value = null;
            try {
                if (mv != null) {
                    value = mv.getValue(this.classLoader, this.pool, methods[i2]);
                }
                if (value == null) {
                    value = this.getDefault(name, methods[i2]);
                }
                otherValue = methods[i2].invoke(obj, new Object[0]);
            }
            catch (RuntimeException runtimeException) {
                obj = runtimeException;
                throw runtimeException;
            }
            catch (Exception e2) {
                void var1_2;
                throw new RuntimeException("Error retrieving value " + name + " for annotation " + this.annotation.getTypeName(), (Throwable)var1_2);
            }
            if (value == null && otherValue != null) {
                return false;
            }
            if (value == null || value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static int arrayHashCode(Object object) {
        void var1_1;
        if (object == null) {
            return 0;
        }
        int result = 1;
        Object[] array = (Object[])object;
        for (int i2 = 0; i2 < array.length; ++i2) {
            void var3_3;
            int elementHashCode = 0;
            if (array[i2] != null) {
                elementHashCode = array[i2].hashCode();
            }
            result = result * 31 + var3_3;
        }
        return (int)var1_1;
    }

    static {
        try {
            Class<?> clazz = Class.forName(JDK_ANNOTATION_CLASS_NAME);
            JDK_ANNOTATION_TYPE_METHOD = clazz.getMethod("annotationType", null);
        }
        catch (Exception exception) {}
    }
}

