/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.MultiArrayType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.MultiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class Type {
    private final CtClass clazz;
    private final boolean special;
    private static final Map<CtClass, Type> prims = new IdentityHashMap<CtClass, Type>();
    public static final Type DOUBLE = new Type(CtClass.doubleType);
    public static final Type BOOLEAN = new Type(CtClass.booleanType);
    public static final Type LONG = new Type(CtClass.longType);
    public static final Type CHAR = new Type(CtClass.charType);
    public static final Type BYTE = new Type(CtClass.byteType);
    public static final Type SHORT = new Type(CtClass.shortType);
    public static final Type INTEGER = new Type(CtClass.intType);
    public static final Type FLOAT = new Type(CtClass.floatType);
    public static final Type VOID = new Type(CtClass.voidType);
    public static final Type UNINIT = new Type(null);
    public static final Type RETURN_ADDRESS = new Type(null, true);
    public static final Type TOP = new Type(null, true);
    public static final Type BOGUS = new Type(null, true);
    public static final Type OBJECT = Type.lookupType("java.lang.Object");
    public static final Type SERIALIZABLE = Type.lookupType("java.io.Serializable");
    public static final Type CLONEABLE = Type.lookupType("java.lang.Cloneable");
    public static final Type THROWABLE = Type.lookupType("java.lang.Throwable");

    /*
     * WARNING - void declaration
     */
    public static Type get(CtClass clazz) {
        CtClass ctClass;
        Type type = prims.get(clazz);
        if (type != null) {
            void var1_1;
            return var1_1;
        }
        return new Type(ctClass);
    }

    /*
     * WARNING - void declaration
     */
    private static Type lookupType(String name) {
        try {
            return new Type(ClassPool.getDefault().get(name));
        }
        catch (NotFoundException e2) {
            void var0_1;
            throw new RuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    Type(CtClass clazz) {
        this((CtClass)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Type(CtClass clazz, boolean special) {
        void var2_2;
        void var1_1;
        this.clazz = var1_1;
        this.special = var2_2;
    }

    boolean popChanged() {
        return false;
    }

    public int getSize() {
        if (this.clazz == CtClass.doubleType || this.clazz == CtClass.longType || this == TOP) {
            return 2;
        }
        return 1;
    }

    public CtClass getCtClass() {
        return this.clazz;
    }

    public boolean isReference() {
        return !this.special && (this.clazz == null || !this.clazz.isPrimitive());
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isArray() {
        return this.clazz != null && this.clazz.isArray();
    }

    /*
     * WARNING - void declaration
     */
    public int getDimensions() {
        void var3_3;
        if (!this.isArray()) {
            return 0;
        }
        String name = this.clazz.getName();
        int pos = name.length() - 1;
        int count = 0;
        while (name.charAt(pos) == ']') {
            pos -= 2;
            ++count;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Type getComponent() {
        void var1_1;
        CtClass component;
        if (this.clazz == null || !this.clazz.isArray()) {
            return null;
        }
        try {
            component = this.clazz.getComponentType();
        }
        catch (NotFoundException e2) {
            throw new RuntimeException(e2);
        }
        Type type = prims.get(component);
        if (type != null) {
            void var2_3;
            return var2_3;
        }
        return new Type((CtClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAssignableFrom(Type type) {
        if (this == type) {
            return true;
        }
        if (type == UNINIT && this.isReference() || this == UNINIT && type.isReference()) {
            return true;
        }
        if (type instanceof MultiType) {
            return ((MultiType)type).isAssignableTo(this);
        }
        if (type instanceof MultiArrayType) {
            return ((MultiArrayType)type).isAssignableTo(this);
        }
        if (this.clazz == null || this.clazz.isPrimitive()) {
            return false;
        }
        try {
            return type.clazz.subtypeOf(this.clazz);
        }
        catch (Exception e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Type merge(Type type) {
        if (type == this) {
            return this;
        }
        if (type == null) {
            return this;
        }
        if (type == UNINIT) {
            return this;
        }
        if (this == UNINIT) {
            return type;
        }
        if (!type.isReference() || !this.isReference()) {
            return BOGUS;
        }
        if (type instanceof MultiType) {
            return type.merge(this);
        }
        if (type.isArray() && this.isArray()) {
            return this.mergeArray(type);
        }
        try {
            return this.mergeClasses(type);
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    Type getRootComponent(Type type) {
        void var1_1;
        while (type.isArray()) {
            type = type.getComponent();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Type createArray(Type rootComponent, int dims) {
        void var1_1;
        if (rootComponent instanceof MultiType) {
            return new MultiArrayType((MultiType)rootComponent, dims);
        }
        String name = this.arrayName(rootComponent.clazz.getName(), dims);
        try {
            void var2_4;
            Type type = Type.get(this.getClassPool(rootComponent).get((String)var2_4));
        }
        catch (NotFoundException e2) {
            throw new RuntimeException(e2);
        }
        return var1_1;
    }

    String arrayName(String component, int dims) {
        String string;
        int i2 = component.length();
        int size = i2 + (dims << 1);
        char[] string2 = new char[size];
        string.getChars(0, i2, string2, 0);
        while (i2 < size) {
            string2[i2++] = 91;
            string2[i2++] = 93;
        }
        string = new String(string2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private ClassPool getClassPool(Type rootComponent) {
        ClassPool pool = rootComponent.clazz.getClassPool();
        if (pool != null) {
            void var1_1;
            return var1_1;
        }
        return ClassPool.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    private Type mergeArray(Type type) {
        void var1_2;
        int targetDims;
        void targetRoot;
        int thisDims;
        Type typeRoot = this.getRootComponent(type);
        Type type2 = this;
        Type thisRoot = type2.getRootComponent(type2);
        int typeDims = type.getDimensions();
        if (typeDims == (thisDims = this.getDimensions())) {
            Type mergedComponent = thisRoot.merge(typeRoot);
            if (mergedComponent == BOGUS) {
                return OBJECT;
            }
            return this.createArray(mergedComponent, thisDims);
        }
        if (typeDims >= thisDims) {
            void var3_4;
            targetRoot = var3_4;
            targetDims = thisDims;
        }
        if (Type.eq(Type.CLONEABLE.clazz, targetRoot.clazz) || Type.eq(Type.SERIALIZABLE.clazz, targetRoot.clazz)) {
            void var2_3;
            return this.createArray((Type)var2_3, targetDims);
        }
        return this.createArray(OBJECT, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static CtClass findCommonSuperClass(CtClass one, CtClass two) throws NotFoundException {
        CtClass ctClass;
        void var3_3;
        CtClass shallow;
        CtClass deep = one;
        CtClass backupShallow = shallow = two;
        CtClass backupDeep = deep;
        while (true) {
            if (Type.eq(deep, shallow) && deep.getSuperclass() != null) {
                return deep;
            }
            CtClass deepSuper = deep.getSuperclass();
            CtClass shallowSuper = shallow.getSuperclass();
            if (shallowSuper == null) {
                shallow = backupShallow;
                break;
            }
            if (deepSuper == null) {
                deep = backupDeep;
                backupDeep = backupShallow;
                backupShallow = deep;
                deep = shallow;
                shallow = backupShallow;
                break;
            }
            deep = deepSuper;
            shallow = shallowSuper;
        }
        while ((deep = deep.getSuperclass()) != null) {
            backupDeep = backupDeep.getSuperclass();
        }
        deep = var3_3;
        while (!Type.eq(deep, shallow)) {
            deep = deep.getSuperclass();
            shallow = shallow.getSuperclass();
        }
        return ctClass;
    }

    /*
     * WARNING - void declaration
     */
    private Type mergeClasses(Type type) throws NotFoundException {
        void var2_2;
        Map<String, CtClass> interfaces;
        CtClass superClass = Type.findCommonSuperClass(this.clazz, type.clazz);
        if (superClass.getSuperclass() == null) {
            interfaces = this.findCommonInterfaces(type);
            if (interfaces.size() == 1) {
                return new Type(interfaces.values().iterator().next());
            }
            if (interfaces.size() > 1) {
                return new MultiType(interfaces);
            }
            return new Type(superClass);
        }
        Map<String, CtClass> commonDeclared = this.findExclusiveDeclaredInterfaces((Type)((Object)interfaces), superClass);
        if (commonDeclared.size() > 0) {
            void var1_1;
            return new MultiType((Map<String, CtClass>)var1_1, new Type(superClass));
        }
        return new Type((CtClass)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, CtClass> findCommonInterfaces(Type type) {
        void var2_2;
        void var1_1;
        Map<String, CtClass> typeMap = this.getAllInterfaces(type.clazz, null);
        Type type2 = this;
        Map<String, CtClass> thisMap = type2.getAllInterfaces(type2.clazz, null);
        return this.findCommonInterfaces((Map<String, CtClass>)var1_1, (Map<String, CtClass>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, CtClass> findExclusiveDeclaredInterfaces(Type type, CtClass exclude) {
        void var3_3;
        void var1_1;
        Map<String, CtClass> map;
        Map<String, CtClass> typeMap = this.getDeclaredInterfaces(type.clazz, null);
        Type type2 = this;
        Map<String, CtClass> thisMap = type2.getDeclaredInterfaces(type2.clazz, null);
        map = this.getAllInterfaces((CtClass)((Object)map), null);
        for (String intf : map.keySet()) {
            typeMap.remove(intf);
            thisMap.remove(intf);
        }
        return this.findCommonInterfaces((Map<String, CtClass>)var1_1, (Map<String, CtClass>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    Map<String, CtClass> findCommonInterfaces(Map<String, CtClass> typeMap, Map<String, CtClass> alterMap) {
        void var2_3;
        if (alterMap == null) {
            alterMap = new HashMap<String, CtClass>();
        }
        if (typeMap == null || typeMap.isEmpty()) {
            alterMap.clear();
        }
        Iterator<String> it = alterMap.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (typeMap.containsKey(name)) continue;
            it.remove();
        }
        ArrayList<CtClass> interfaces = new ArrayList<CtClass>();
        for (CtClass intf : alterMap.values()) {
            try {
                interfaces.addAll(Arrays.asList(intf.getInterfaces()));
            }
            catch (NotFoundException e2) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
        for (CtClass c2 : interfaces) {
            void var3_4;
            alterMap.remove(var3_4.getName());
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, CtClass> getAllInterfaces(CtClass clazz, Map<String, CtClass> map) {
        void var2_2;
        if (map == null) {
            map = new HashMap<String, CtClass>();
        }
        if (clazz.isInterface()) {
            map.put(clazz.getName(), clazz);
        }
        do {
            try {
                CtClass[] ctClassArray = clazz.getInterfaces();
                CtClass[] ctClassArray2 = ctClassArray;
                ctClassArray2 = ctClassArray;
                int n2 = ctClassArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    CtClass intf = ctClassArray2[i2];
                    map.put(intf.getName(), intf);
                    this.getAllInterfaces(intf, map);
                }
                clazz = clazz.getSuperclass();
            }
            catch (NotFoundException e2) {
                void var3_4;
                throw new RuntimeException((Throwable)var3_4);
            }
        } while (clazz != null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, CtClass> getDeclaredInterfaces(CtClass clazz, Map<String, CtClass> map) {
        void var2_3;
        void var1_1;
        if (map == null) {
            map = new HashMap<String, CtClass>();
        }
        if (clazz.isInterface()) {
            map.put(clazz.getName(), clazz);
        }
        try {
            CtClass[] interfaces = clazz.getInterfaces();
        }
        catch (NotFoundException e2) {
            throw new RuntimeException(e2);
        }
        for (void intf : var1_1) {
            map.put(intf.getName(), (CtClass)intf);
            this.getDeclaredInterfaces((CtClass)intf, map);
        }
        return var2_3;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.clazz.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        void var1_1;
        if (!(o2 instanceof Type)) {
            return false;
        }
        return o2.getClass() == this.getClass() && Type.eq(this.clazz, ((Type)var1_1).clazz);
    }

    /*
     * WARNING - void declaration
     */
    static boolean eq(CtClass one, CtClass two) {
        void var1_1;
        CtClass ctClass;
        return one == two || one != null && two != null && ctClass.getName().equals(var1_1.getName());
    }

    public String toString() {
        if (this == BOGUS) {
            return "BOGUS";
        }
        if (this == UNINIT) {
            return "UNINIT";
        }
        if (this == RETURN_ADDRESS) {
            return "RETURN ADDRESS";
        }
        if (this == TOP) {
            return "TOP";
        }
        if (this.clazz == null) {
            return "null";
        }
        return this.clazz.getName();
    }

    static {
        prims.put(CtClass.doubleType, DOUBLE);
        prims.put(CtClass.longType, LONG);
        prims.put(CtClass.charType, CHAR);
        prims.put(CtClass.shortType, SHORT);
        prims.put(CtClass.intType, INTEGER);
        prims.put(CtClass.floatType, FLOAT);
        prims.put(CtClass.byteType, BYTE);
        prims.put(CtClass.booleanType, BOOLEAN);
        prims.put(CtClass.voidType, VOID);
    }
}

