/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.MultiType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Type;

public class MultiArrayType
extends Type {
    private MultiType component;
    private int dims;

    /*
     * WARNING - void declaration
     */
    public MultiArrayType(MultiType component, int dims) {
        super(null);
        void var2_2;
        void var1_1;
        this.component = var1_1;
        this.dims = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtClass getCtClass() {
        CtClass clazz = ((Type)this.component).getCtClass();
        if (clazz == null) {
            return null;
        }
        ClassPool pool = clazz.getClassPool();
        if (pool == null) {
            pool = ClassPool.getDefault();
        }
        String name = this.arrayName(clazz.getName(), this.dims);
        try {
            void var2_3;
            return var2_3.get(name);
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    @Override
    boolean popChanged() {
        return this.component.popChanged();
    }

    @Override
    public int getDimensions() {
        return this.dims;
    }

    @Override
    public Type getComponent() {
        if (this.dims == 1) {
            return this.component;
        }
        return new MultiArrayType(this.component, this.dims - 1);
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isReference() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAssignableTo(Type type) {
        void var2_3;
        void var1_2;
        if (MultiArrayType.eq(type.getCtClass(), Type.OBJECT.getCtClass())) {
            return true;
        }
        if (MultiArrayType.eq(type.getCtClass(), Type.CLONEABLE.getCtClass())) {
            return true;
        }
        if (MultiArrayType.eq(type.getCtClass(), Type.SERIALIZABLE.getCtClass())) {
            return true;
        }
        if (!type.isArray()) {
            return false;
        }
        Type typeRoot = this.getRootComponent(type);
        int typeDims = type.getDimensions();
        if (typeDims > this.dims) {
            return false;
        }
        if (var1_2 < this.dims) {
            if (MultiArrayType.eq(typeRoot.getCtClass(), Type.OBJECT.getCtClass())) {
                return true;
            }
            if (MultiArrayType.eq(typeRoot.getCtClass(), Type.CLONEABLE.getCtClass())) {
                return true;
            }
            return MultiArrayType.eq(typeRoot.getCtClass(), Type.SERIALIZABLE.getCtClass());
        }
        return this.component.isAssignableTo((Type)var2_3);
    }

    @Override
    public int hashCode() {
        return ((Type)this.component).hashCode() + this.dims;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o2) {
        void var1_1;
        if (!(o2 instanceof MultiArrayType)) {
            return false;
        }
        MultiArrayType multi = (MultiArrayType)o2;
        return ((Type)this.component).equals(multi.component) && this.dims == var1_1.dims;
    }

    @Override
    public String toString() {
        MultiArrayType multiArrayType = this;
        return multiArrayType.arrayName(((Type)multiArrayType.component).toString(), this.dims);
    }
}

