/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Type;

public class Frame {
    private Type[] locals;
    private Type[] stack;
    private int top;
    private boolean jsrMerged;
    private boolean retMerged;

    /*
     * WARNING - void declaration
     */
    public Frame(int locals, int stack) {
        void var2_2;
        void var1_1;
        this.locals = new Type[var1_1];
        this.stack = new Type[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public Type getLocal(int index) {
        void var1_1;
        return this.locals[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public void setLocal(int index, Type type) {
        void var2_2;
        this.locals[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Type getStack(int index) {
        void var1_1;
        return this.stack[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public void setStack(int index, Type type) {
        void var2_2;
        this.stack[var1_1] = var2_2;
    }

    public void clearStack() {
        this.top = 0;
    }

    public int getTopIndex() {
        return this.top - 1;
    }

    public int localsLength() {
        return this.locals.length;
    }

    public Type peek() {
        if (this.top <= 0) {
            throw new IndexOutOfBoundsException("Stack is empty");
        }
        return this.stack[this.top - 1];
    }

    public Type pop() {
        if (this.top <= 0) {
            throw new IndexOutOfBoundsException("Stack is empty");
        }
        return this.stack[--this.top];
    }

    /*
     * WARNING - void declaration
     */
    public void push(Type type) {
        void var1_1;
        this.stack[this.top++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Frame copy() {
        void var1_1;
        Frame frame = new Frame(this.locals.length, this.stack.length);
        System.arraycopy(this.locals, 0, frame.locals, 0, this.locals.length);
        System.arraycopy(this.stack, 0, frame.stack, 0, this.stack.length);
        frame.top = this.top;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Frame copyStack() {
        void var1_1;
        Frame frame = new Frame(this.locals.length, this.stack.length);
        System.arraycopy(this.stack, 0, frame.stack, 0, this.stack.length);
        frame.top = this.top;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean mergeStack(Frame frame) {
        void var2_2;
        boolean changed = false;
        if (this.top != frame.top) {
            throw new RuntimeException("Operand stacks could not be merged, they are different sizes!");
        }
        for (int i2 = 0; i2 < this.top; ++i2) {
            if (this.stack[i2] == null) continue;
            Type prev = this.stack[i2];
            Type merged = prev.merge(frame.stack[i2]);
            if (merged == Type.BOGUS) {
                throw new RuntimeException("Operand stacks could not be merged due to differing primitive types: pos = " + i2);
            }
            this.stack[i2] = merged;
            if (merged.equals(prev) && !merged.popChanged()) continue;
            changed = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean merge(Frame frame) {
        void var1_1;
        boolean changed = false;
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != null) {
                Type merged;
                Type prev = this.locals[i2];
                this.locals[i2] = merged = prev.merge(frame.locals[i2]);
                if (merged.equals(prev) && !merged.popChanged()) continue;
                changed = true;
                continue;
            }
            if (frame.locals[i2] == null) continue;
            this.locals[i2] = frame.locals[i2];
            changed = true;
        }
        return var2_2 |= this.mergeStack((Frame)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        int i2;
        StringBuilder buffer = new StringBuilder();
        buffer.append("locals = [");
        for (i2 = 0; i2 < this.locals.length; ++i2) {
            buffer.append(this.locals[i2] == null ? "empty" : this.locals[i2].toString());
            if (i2 >= this.locals.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("] stack = [");
        for (i2 = 0; i2 < this.top; ++i2) {
            buffer.append(this.stack[i2]);
            if (i2 >= this.top - 1) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return var1_1.toString();
    }

    boolean isJsrMerged() {
        return this.jsrMerged;
    }

    /*
     * WARNING - void declaration
     */
    void setJsrMerged(boolean jsrMerged) {
        void var1_1;
        this.jsrMerged = var1_1;
    }

    boolean isRetMerged() {
        return this.retMerged;
    }

    /*
     * WARNING - void declaration
     */
    void setRetMerged(boolean retMerged) {
        void var1_1;
        this.retMerged = var1_1;
    }
}

