/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Frame;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Subroutine;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Type;

public class Executor
implements Opcode {
    private final ConstPool constPool;
    private final ClassPool classPool;
    private final Type STRING_TYPE;
    private final Type CLASS_TYPE;
    private final Type THROWABLE_TYPE;
    private int lastPos;

    /*
     * WARNING - void declaration
     */
    public Executor(ClassPool classPool, ConstPool constPool) {
        void var2_3;
        this.constPool = var2_3;
        this.classPool = classPool;
        try {
            this.STRING_TYPE = this.getType("java.lang.String");
            this.CLASS_TYPE = this.getType("java.lang.Class");
            this.THROWABLE_TYPE = this.getType("java.lang.Throwable");
            return;
        }
        catch (Exception e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void execute(MethodInfo method, int pos, CodeIterator iter, Frame frame, Subroutine subroutine) throws BadBytecode {
        this.lastPos = pos;
        int opcode = iter.byteAt(pos);
        switch (opcode) {
            case 0: {
                return;
            }
            case 1: {
                frame.push(Type.UNINIT);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                frame.push(Type.INTEGER);
                return;
            }
            case 9: 
            case 10: {
                frame.push(Type.LONG);
                frame.push(Type.TOP);
                return;
            }
            case 11: 
            case 12: 
            case 13: {
                frame.push(Type.FLOAT);
                return;
            }
            case 14: 
            case 15: {
                frame.push(Type.DOUBLE);
                frame.push(Type.TOP);
                return;
            }
            case 16: 
            case 17: {
                frame.push(Type.INTEGER);
                return;
            }
            case 18: {
                this.evalLDC(iter.byteAt(pos + 1), frame);
                return;
            }
            case 19: 
            case 20: {
                this.evalLDC(iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 21: {
                this.evalLoad(Type.INTEGER, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 22: {
                this.evalLoad(Type.LONG, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 23: {
                this.evalLoad(Type.FLOAT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 24: {
                this.evalLoad(Type.DOUBLE, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 25: {
                this.evalLoad(Type.OBJECT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.evalLoad(Type.INTEGER, opcode - 26, frame, subroutine);
                return;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.evalLoad(Type.LONG, opcode - 30, frame, subroutine);
                return;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.evalLoad(Type.FLOAT, opcode - 34, frame, subroutine);
                return;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.evalLoad(Type.DOUBLE, opcode - 38, frame, subroutine);
                return;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.evalLoad(Type.OBJECT, opcode - 42, frame, subroutine);
                return;
            }
            case 46: {
                this.evalArrayLoad(Type.INTEGER, frame);
                return;
            }
            case 47: {
                this.evalArrayLoad(Type.LONG, frame);
                return;
            }
            case 48: {
                this.evalArrayLoad(Type.FLOAT, frame);
                return;
            }
            case 49: {
                this.evalArrayLoad(Type.DOUBLE, frame);
                return;
            }
            case 50: {
                this.evalArrayLoad(Type.OBJECT, frame);
                return;
            }
            case 51: 
            case 52: 
            case 53: {
                this.evalArrayLoad(Type.INTEGER, frame);
                return;
            }
            case 54: {
                this.evalStore(Type.INTEGER, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 55: {
                this.evalStore(Type.LONG, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 56: {
                this.evalStore(Type.FLOAT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 57: {
                this.evalStore(Type.DOUBLE, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 58: {
                this.evalStore(Type.OBJECT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.evalStore(Type.INTEGER, opcode - 59, frame, subroutine);
                return;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.evalStore(Type.LONG, opcode - 63, frame, subroutine);
                return;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.evalStore(Type.FLOAT, opcode - 67, frame, subroutine);
                return;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.evalStore(Type.DOUBLE, opcode - 71, frame, subroutine);
                return;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.evalStore(Type.OBJECT, opcode - 75, frame, subroutine);
                return;
            }
            case 79: {
                this.evalArrayStore(Type.INTEGER, frame);
                return;
            }
            case 80: {
                this.evalArrayStore(Type.LONG, frame);
                return;
            }
            case 81: {
                this.evalArrayStore(Type.FLOAT, frame);
                return;
            }
            case 82: {
                this.evalArrayStore(Type.DOUBLE, frame);
                return;
            }
            case 83: {
                this.evalArrayStore(Type.OBJECT, frame);
                return;
            }
            case 84: 
            case 85: 
            case 86: {
                this.evalArrayStore(Type.INTEGER, frame);
                return;
            }
            case 87: {
                if (frame.pop() != Type.TOP) break;
                throw new BadBytecode("POP can not be used with a category 2 value, pos = " + pos);
            }
            case 88: {
                frame.pop();
                frame.pop();
                return;
            }
            case 89: {
                method = frame.peek();
                if (method == Type.TOP) {
                    throw new BadBytecode("DUP can not be used with a category 2 value, pos = " + pos);
                }
                Frame frame2 = frame;
                frame2.push(frame2.peek());
                return;
            }
            case 90: 
            case 91: {
                int end;
                Type type = frame.peek();
                if (type == Type.TOP) {
                    throw new BadBytecode("DUP can not be used with a category 2 value, pos = " + pos);
                }
                int insert = end - (opcode - 90) - 1;
                frame.push(type);
                for (end = frame.getTopIndex(); end > insert; --end) {
                    frame.setStack(end, frame.getStack(end - 1));
                }
                frame.setStack(insert, type);
                return;
            }
            case 92: {
                Frame frame3 = frame;
                frame3.push(frame3.getStack(frame.getTopIndex() - 1));
                Frame frame4 = frame;
                frame4.push(frame4.getStack(frame.getTopIndex() - 1));
                return;
            }
            case 93: 
            case 94: {
                void var2_6;
                int end;
                int insert = end - (opcode - 93) - 1;
                Frame frame5 = frame;
                Type type1 = frame5.getStack(frame5.getTopIndex() - 1);
                Type type2 = frame.peek();
                frame.push(type1);
                frame.push(type2);
                for (end = frame.getTopIndex(); end > insert; --end) {
                    frame.setStack(end, frame.getStack(end - 2));
                }
                frame.setStack(insert, type2);
                frame.setStack(insert - 1, (Type)var2_6);
                return;
            }
            case 95: {
                void var3_7;
                void var2_5;
                Type type1 = frame.pop();
                Type type2 = frame.pop();
                if (type1.getSize() == 2 || type2.getSize() == 2) {
                    throw new BadBytecode("Swap can not be used with category 2 values, pos = " + (int)var2_5);
                }
                frame.push(type1);
                frame.push((Type)var3_7);
                return;
            }
            case 96: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 97: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 98: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 99: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 100: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 101: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 102: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 103: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 104: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 105: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 106: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 107: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 108: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 109: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 110: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 111: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 112: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 113: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 114: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 115: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 116: {
                this.verifyAssignable(Type.INTEGER, this.simplePeek(frame));
                return;
            }
            case 117: {
                this.verifyAssignable(Type.LONG, this.simplePeek(frame));
                return;
            }
            case 118: {
                this.verifyAssignable(Type.FLOAT, this.simplePeek(frame));
                return;
            }
            case 119: {
                this.verifyAssignable(Type.DOUBLE, this.simplePeek(frame));
                return;
            }
            case 120: {
                this.evalShift(Type.INTEGER, frame);
                return;
            }
            case 121: {
                this.evalShift(Type.LONG, frame);
                return;
            }
            case 122: {
                this.evalShift(Type.INTEGER, frame);
                return;
            }
            case 123: {
                this.evalShift(Type.LONG, frame);
                return;
            }
            case 124: {
                this.evalShift(Type.INTEGER, frame);
                return;
            }
            case 125: {
                this.evalShift(Type.LONG, frame);
                return;
            }
            case 126: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 127: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 128: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 129: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 130: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 131: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 132: {
                void var5_11;
                void var3_7;
                void var2_5;
                int index = var3_7.byteAt((int)(var2_5 + true));
                this.verifyAssignable(Type.INTEGER, frame.getLocal(index));
                this.access(index, Type.INTEGER, (Subroutine)var5_11);
                return;
            }
            case 133: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.simplePush(Type.LONG, frame);
                return;
            }
            case 134: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.simplePush(Type.FLOAT, frame);
                return;
            }
            case 135: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.simplePush(Type.DOUBLE, frame);
                return;
            }
            case 136: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.simplePush(Type.INTEGER, frame);
                return;
            }
            case 137: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.simplePush(Type.FLOAT, frame);
                return;
            }
            case 138: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.simplePush(Type.DOUBLE, frame);
                return;
            }
            case 139: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.simplePush(Type.INTEGER, frame);
                return;
            }
            case 140: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.simplePush(Type.LONG, frame);
                return;
            }
            case 141: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.simplePush(Type.DOUBLE, frame);
                return;
            }
            case 142: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.simplePush(Type.INTEGER, frame);
                return;
            }
            case 143: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.simplePush(Type.LONG, frame);
                return;
            }
            case 144: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.simplePush(Type.FLOAT, frame);
                return;
            }
            case 145: 
            case 146: 
            case 147: {
                this.verifyAssignable(Type.INTEGER, frame.peek());
                return;
            }
            case 148: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 149: 
            case 150: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 151: 
            case 152: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                return;
            }
            case 165: 
            case 166: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                frame.push(Type.RETURN_ADDRESS);
                return;
            }
            case 169: {
                void var3_7;
                void var2_5;
                this.verifyAssignable(Type.RETURN_ADDRESS, frame.getLocal(var3_7.byteAt((int)(var2_5 + true))));
                return;
            }
            case 170: 
            case 171: 
            case 172: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                return;
            }
            case 173: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                return;
            }
            case 174: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                return;
            }
            case 175: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                return;
            }
            case 176: {
                try {
                    void index;
                    CtClass returnType = Descriptor.getReturnType(index.getDescriptor(), this.classPool);
                    this.verifyAssignable(Type.get(returnType), this.simplePop(frame));
                    return;
                }
                catch (NotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
            case 177: {
                return;
            }
            case 178: {
                void var3_7;
                void var2_5;
                this.evalGetField(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 179: {
                void var3_7;
                void var2_5;
                this.evalPutField(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 180: {
                void var3_7;
                void var2_5;
                this.evalGetField(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 181: {
                void var3_7;
                void var2_5;
                this.evalPutField(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 182: 
            case 183: 
            case 184: {
                void var3_7;
                void var2_5;
                this.evalInvokeMethod(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 185: {
                void var3_7;
                void var2_5;
                this.evalInvokeIntfMethod(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 186: {
                void var3_7;
                void var2_5;
                this.evalInvokeDynamic(opcode, var3_7.u16bitAt((int)(var2_5 + true)), frame);
                return;
            }
            case 187: {
                void var3_7;
                void var2_5;
                Executor executor = this;
                frame.push(executor.resolveClassInfo(executor.constPool.getClassInfo(var3_7.u16bitAt((int)(var2_5 + true)))));
                return;
            }
            case 188: {
                void var3_7;
                void var2_5;
                this.evalNewArray((int)var2_5, (CodeIterator)var3_7, frame);
                return;
            }
            case 189: {
                void var3_7;
                void var2_5;
                this.evalNewObjectArray((int)var2_5, (CodeIterator)var3_7, frame);
                return;
            }
            case 190: {
                void var2_5;
                Type array = this.simplePop(frame);
                if (!array.isArray() && array != Type.UNINIT) {
                    void var1_1;
                    throw new BadBytecode("Array length passed a non-array [pos = " + (int)var2_5 + "]: " + var1_1);
                }
                frame.push(Type.INTEGER);
                return;
            }
            case 191: {
                Executor executor = this;
                executor.verifyAssignable(executor.THROWABLE_TYPE, this.simplePop(frame));
                return;
            }
            case 192: {
                void var3_7;
                void var2_5;
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                Executor executor = this;
                frame.push(executor.typeFromDesc(executor.constPool.getClassInfoByDescriptor(var3_7.u16bitAt((int)(var2_5 + true)))));
                return;
            }
            case 193: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 194: 
            case 195: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                return;
            }
            case 196: {
                void var5_11;
                void var3_7;
                void var2_5;
                this.evalWide((int)var2_5, (CodeIterator)var3_7, frame, (Subroutine)var5_11);
                return;
            }
            case 197: {
                void var3_7;
                void var2_5;
                this.evalNewObjectArray((int)var2_5, (CodeIterator)var3_7, frame);
                return;
            }
            case 198: 
            case 199: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                return;
            }
            case 200: {
                return;
            }
            case 201: {
                frame.push(Type.RETURN_ADDRESS);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Type zeroExtend(Type type) {
        void var1_1;
        if (type == Type.SHORT || type == Type.BYTE || type == Type.CHAR || type == Type.BOOLEAN) {
            return Type.INTEGER;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void evalArrayLoad(Type expectedComponent, Frame frame) throws BadBytecode {
        void var2_2;
        void var3_3;
        void var1_1;
        Type index = frame.pop();
        Type array = frame.pop();
        if (array == Type.UNINIT) {
            this.verifyAssignable(Type.INTEGER, index);
            if (expectedComponent == Type.OBJECT) {
                this.simplePush(Type.UNINIT, frame);
                return;
            }
            this.simplePush(expectedComponent, frame);
            return;
        }
        Type component = array.getComponent();
        if (component == null) {
            throw new BadBytecode("Not an array! [pos = " + this.lastPos + "]: " + component);
        }
        component = this.zeroExtend(component);
        this.verifyAssignable((Type)var1_1, component);
        this.verifyAssignable(Type.INTEGER, (Type)var3_3);
        this.simplePush(component, (Frame)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void evalArrayStore(Type expectedComponent, Frame frame) throws BadBytecode {
        void var3_3;
        void var2_2;
        Type value = this.simplePop(frame);
        Type index = frame.pop();
        Type array = frame.pop();
        if (array == Type.UNINIT) {
            this.verifyAssignable(Type.INTEGER, index);
            return;
        }
        Type component = array.getComponent();
        if (component == null) {
            throw new BadBytecode("Not an array! [pos = " + this.lastPos + "]: " + component);
        }
        component = this.zeroExtend(component);
        this.verifyAssignable(expectedComponent, component);
        this.verifyAssignable(Type.INTEGER, index);
        if (expectedComponent == Type.OBJECT) {
            void var1_1;
            this.verifyAssignable((Type)var1_1, value);
            return;
        }
        this.verifyAssignable((Type)var2_2, (Type)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void evalBinaryMath(Type expected, Frame frame) throws BadBytecode {
        void var2_2;
        void var1_1;
        void var3_3;
        Type value2 = this.simplePop(frame);
        Type value1 = this.simplePop(frame);
        this.verifyAssignable(expected, (Type)var3_3);
        this.verifyAssignable((Type)var1_1, value1);
        this.simplePush(value1, (Frame)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void evalGetField(int opcode, int index, Frame frame) throws BadBytecode {
        void var3_4;
        String desc = this.constPool.getFieldrefType(index);
        Executor executor = this;
        Type type = executor.zeroExtend(executor.typeFromDesc(desc));
        if (opcode == 180) {
            void var1_2;
            void var2_3;
            Executor executor2 = this;
            Type objectType = executor2.resolveClassInfo(executor2.constPool.getFieldrefClassName((int)var2_3));
            this.verifyAssignable((Type)var1_2, this.simplePop(frame));
        }
        this.simplePush(type, (Frame)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private void evalInvokeIntfMethod(int opcode, int index, Frame frame) throws BadBytecode {
        void var2_4;
        String desc = this.constPool.getInterfaceMethodrefType(index);
        Type[] types = this.paramTypesFromDesc(desc);
        int i2 = types.length;
        while (i2 > 0) {
            Executor executor = this;
            executor.verifyAssignable(executor.zeroExtend(types[--i2]), this.simplePop(frame));
        }
        String classInfo = this.constPool.getInterfaceMethodrefClassName(index);
        Type objectType = this.resolveClassInfo(classInfo);
        this.verifyAssignable((Type)var2_4, this.simplePop(frame));
        Type returnType = this.returnTypeFromDesc(desc);
        if (returnType != Type.VOID) {
            void var3_5;
            void var1_2;
            Executor executor = this;
            executor.simplePush(executor.zeroExtend((Type)var1_2), (Frame)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evalInvokeMethod(int opcode, int index, Frame frame) throws BadBytecode {
        Type returnType;
        String desc = this.constPool.getMethodrefType(index);
        Type[] types = this.paramTypesFromDesc(desc);
        int i2 = types.length;
        while (i2 > 0) {
            Executor executor = this;
            executor.verifyAssignable(executor.zeroExtend(types[--i2]), this.simplePop(frame));
        }
        if (opcode != 184) {
            void var2_4;
            Executor executor = this;
            Type objectType = executor.resolveClassInfo(executor.constPool.getMethodrefClassName((int)var2_4));
            this.verifyAssignable(objectType, this.simplePop(frame));
        }
        if ((returnType = this.returnTypeFromDesc(desc)) != Type.VOID) {
            void var3_5;
            void var1_3;
            Executor executor = this;
            executor.simplePush(executor.zeroExtend((Type)var1_3), (Frame)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evalInvokeDynamic(int opcode, int index, Frame frame) throws BadBytecode {
        String desc = this.constPool.getInvokeDynamicType(index);
        Type[] types = this.paramTypesFromDesc(desc);
        int i2 = types.length;
        while (i2 > 0) {
            Executor executor = this;
            executor.verifyAssignable(executor.zeroExtend(types[--i2]), this.simplePop(frame));
        }
        Type returnType = this.returnTypeFromDesc(desc);
        if (returnType != Type.VOID) {
            void var3_5;
            void var1_2;
            Executor executor = this;
            executor.simplePush(executor.zeroExtend((Type)var1_2), (Frame)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evalLDC(int index, Frame frame) throws BadBytecode {
        void var2_3;
        void var1_2;
        int tag = this.constPool.getTag(index);
        switch (tag) {
            case 8: {
                Type type = this.STRING_TYPE;
                break;
            }
            case 3: {
                Type type = Type.INTEGER;
                break;
            }
            case 4: {
                Type type = Type.FLOAT;
                break;
            }
            case 5: {
                Type type = Type.LONG;
                break;
            }
            case 6: {
                Type type = Type.DOUBLE;
                break;
            }
            case 7: {
                Type type = this.CLASS_TYPE;
                break;
            }
            default: {
                void type;
                throw new BadBytecode("bad LDC [pos = " + this.lastPos + "]: " + (int)type);
            }
        }
        this.simplePush((Type)var1_2, (Frame)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private void evalLoad(Type expected, int index, Frame frame, Subroutine subroutine) throws BadBytecode {
        void var2_2;
        void var3_3;
        void var1_1;
        Type type = frame.getLocal(index);
        this.verifyAssignable((Type)var1_1, type);
        this.simplePush(type, (Frame)var3_3);
        this.access((int)var2_2, type, subroutine);
    }

    /*
     * WARNING - void declaration
     */
    private void evalNewArray(int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        void var1_2;
        void var3_5;
        this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
        int typeInfo = iter.byteAt(pos + 1);
        switch (typeInfo) {
            case 4: {
                Type type = this.getType("boolean[]");
                break;
            }
            case 5: {
                Type type = this.getType("char[]");
                break;
            }
            case 8: {
                Type type = this.getType("byte[]");
                break;
            }
            case 9: {
                Type type = this.getType("short[]");
                break;
            }
            case 10: {
                Type type = this.getType("int[]");
                break;
            }
            case 11: {
                Type type = this.getType("long[]");
                break;
            }
            case 6: {
                Type type = this.getType("float[]");
                break;
            }
            case 7: {
                Type type = this.getType("double[]");
                break;
            }
            default: {
                void var2_4;
                void type;
                throw new BadBytecode("Invalid array type [pos = " + (int)type + "]: " + (int)var2_4);
            }
        }
        var3_5.push((Type)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void evalNewObjectArray(int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        void var3_3;
        int dimensions;
        Executor executor = this;
        Type type = executor.resolveClassInfo(executor.constPool.getClassInfo(iter.u16bitAt(pos + 1)));
        String name = type.getCtClass().getName();
        int n2 = iter.byteAt(pos);
        if (n2 == 197) {
            void var2_2;
            dimensions = var2_2.byteAt(pos + 3);
        } else {
            name = name + "[]";
            dimensions = 1;
        }
        while (dimensions-- > 0) {
            this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
        }
        Executor executor2 = this;
        executor2.simplePush(executor2.getType(name), (Frame)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void evalPutField(int opcode, int index, Frame frame) throws BadBytecode {
        String desc = this.constPool.getFieldrefType(index);
        Executor executor = this;
        Type type = executor.zeroExtend(executor.typeFromDesc(desc));
        this.verifyAssignable(type, this.simplePop(frame));
        if (opcode == 181) {
            void var3_4;
            void var1_2;
            void var2_3;
            Executor executor2 = this;
            Type objectType = executor2.resolveClassInfo(executor2.constPool.getFieldrefClassName((int)var2_3));
            this.verifyAssignable((Type)var1_2, this.simplePop((Frame)var3_4));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evalShift(Type expected, Frame frame) throws BadBytecode {
        void var2_2;
        void var1_1;
        void var3_3;
        Type value2 = this.simplePop(frame);
        Type value1 = this.simplePop(frame);
        this.verifyAssignable(Type.INTEGER, (Type)var3_3);
        this.verifyAssignable((Type)var1_1, value1);
        this.simplePush(value1, (Frame)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void evalStore(Type expected, int index, Frame frame, Subroutine subroutine) throws BadBytecode {
        void var2_2;
        void var3_3;
        Type type = this.simplePop(frame);
        if (expected != Type.OBJECT || type != Type.RETURN_ADDRESS) {
            void var1_1;
            this.verifyAssignable((Type)var1_1, type);
        }
        this.simpleSetLocal(index, type, (Frame)var3_3);
        this.access((int)var2_2, type, subroutine);
    }

    /*
     * WARNING - void declaration
     */
    private void evalWide(int pos, CodeIterator iter, Frame frame, Subroutine subroutine) throws BadBytecode {
        void var1_1;
        int opcode = iter.byteAt(pos + 1);
        int index = iter.u16bitAt(pos + 2);
        switch (opcode) {
            case 21: {
                this.evalLoad(Type.INTEGER, index, frame, subroutine);
                return;
            }
            case 22: {
                this.evalLoad(Type.LONG, index, frame, subroutine);
                return;
            }
            case 23: {
                this.evalLoad(Type.FLOAT, index, frame, subroutine);
                return;
            }
            case 24: {
                this.evalLoad(Type.DOUBLE, index, frame, subroutine);
                return;
            }
            case 25: {
                this.evalLoad(Type.OBJECT, index, frame, subroutine);
                return;
            }
            case 54: {
                this.evalStore(Type.INTEGER, index, frame, subroutine);
                return;
            }
            case 55: {
                this.evalStore(Type.LONG, index, frame, subroutine);
                return;
            }
            case 56: {
                this.evalStore(Type.FLOAT, index, frame, subroutine);
                return;
            }
            case 57: {
                this.evalStore(Type.DOUBLE, index, frame, subroutine);
                return;
            }
            case 58: {
                this.evalStore(Type.OBJECT, index, frame, subroutine);
                return;
            }
            case 132: {
                this.verifyAssignable(Type.INTEGER, frame.getLocal(index));
                return;
            }
            case 169: {
                void var2_3;
                void var3_4;
                this.verifyAssignable(Type.RETURN_ADDRESS, var3_4.getLocal((int)var2_3));
                return;
            }
        }
        throw new BadBytecode("Invalid WIDE operand [pos = " + (int)var1_1 + "]: " + opcode);
    }

    /*
     * WARNING - void declaration
     */
    private Type getType(String name) throws BadBytecode {
        try {
            return Type.get(this.classPool.get(name));
        }
        catch (NotFoundException notFoundException) {
            void var1_1;
            throw new BadBytecode("Could not find class [pos = " + this.lastPos + "]: " + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Type[] paramTypesFromDesc(String desc) throws BadBytecode {
        void var1_1;
        CtClass[] classes;
        try {
            classes = Descriptor.getParameterTypes(desc, this.classPool);
        }
        catch (NotFoundException e2) {
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + e2.getMessage());
        }
        if (classes == null) {
            throw new BadBytecode("Could not obtain parameters for descriptor [pos = " + this.lastPos + "]: " + (String)e2);
        }
        Type[] types = new Type[classes.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = Type.get(classes[i2]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Type returnTypeFromDesc(String desc) throws BadBytecode {
        void var2_3;
        CtClass clazz;
        try {
            clazz = Descriptor.getReturnType(desc, this.classPool);
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + var1_2.getMessage());
        }
        if (clazz == null) {
            void var1_1;
            throw new BadBytecode("Could not obtain return type for descriptor [pos = " + this.lastPos + "]: " + (String)var1_1);
        }
        return Type.get((CtClass)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private Type simplePeek(Frame frame) {
        void var2_2;
        Type type = frame.peek();
        if (type == Type.TOP) {
            void var1_1;
            void v0 = var1_1;
            return v0.getStack(v0.getTopIndex() - 1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Type simplePop(Frame frame) {
        void var2_2;
        Type type = frame.pop();
        if (type == Type.TOP) {
            void var1_1;
            return var1_1.pop();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void simplePush(Type type, Frame frame) {
        void var1_1;
        frame.push(type);
        if (var1_1.getSize() == 2) {
            void var2_2;
            var2_2.push(Type.TOP);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void access(int index, Type type, Subroutine subroutine) {
        void var2_2;
        if (subroutine == null) {
            return;
        }
        subroutine.access(index);
        if (var2_2.getSize() == 2) {
            void var1_1;
            void var3_3;
            var3_3.access((int)(var1_1 + true));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void simpleSetLocal(int index, Type type, Frame frame) {
        void var2_2;
        frame.setLocal(index, type);
        if (var2_2.getSize() == 2) {
            void var1_1;
            void var3_3;
            var3_3.setLocal((int)(var1_1 + true), Type.TOP);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Type resolveClassInfo(String info) throws BadBytecode {
        void var2_3;
        CtClass clazz;
        try {
            clazz = info.charAt(0) == '[' ? Descriptor.toCtClass(info, this.classPool) : this.classPool.get(info);
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + var1_2.getMessage());
        }
        if (clazz == null) {
            void var1_1;
            throw new BadBytecode("Could not obtain type for descriptor [pos = " + this.lastPos + "]: " + (String)var1_1);
        }
        return Type.get((CtClass)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private Type typeFromDesc(String desc) throws BadBytecode {
        void var2_3;
        CtClass clazz;
        try {
            clazz = Descriptor.toCtClass(desc, this.classPool);
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + var1_2.getMessage());
        }
        if (clazz == null) {
            void var1_1;
            throw new BadBytecode("Could not obtain type for descriptor [pos = " + this.lastPos + "]: " + (String)var1_1);
        }
        return Type.get((CtClass)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyAssignable(Type expected, Type type) throws BadBytecode {
        if (!expected.isAssignableFrom(type)) {
            void var2_2;
            void var1_1;
            throw new BadBytecode("Expected type: " + var1_1 + " Got: " + var2_2 + " [pos = " + this.lastPos + "]");
        }
    }
}

