/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Executor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Frame;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.IntQueue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Subroutine;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.SubroutineScanner;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Type;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Util;

public class Analyzer
implements Opcode {
    private final SubroutineScanner scanner = new SubroutineScanner();
    private CtClass clazz;
    private ExceptionInfo[] exceptions;
    private Frame[] frames;
    private Subroutine[] subroutines;

    public Frame[] analyze(CtClass clazz, MethodInfo method) throws BadBytecode {
        this.clazz = clazz;
        CodeAttribute codeAttribute = method.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        int maxLocals = codeAttribute.getMaxLocals();
        int maxStack = codeAttribute.getMaxStack();
        int codeLength = codeAttribute.getCodeLength();
        CodeIterator iter = codeAttribute.iterator();
        IntQueue queue = new IntQueue();
        this.exceptions = this.buildExceptionInfo(method);
        this.subroutines = this.scanner.scan(method);
        Executor executor = new Executor(clazz.getClassPool(), method.getConstPool());
        this.frames = new Frame[codeLength];
        this.frames[iter.lookAhead()] = this.firstFrame(method, maxLocals, maxStack);
        queue.add(iter.next());
        while (!queue.isEmpty()) {
            this.analyzeNextEntry(method, iter, queue, executor);
        }
        return this.frames;
    }

    /*
     * WARNING - void declaration
     */
    public Frame[] analyze(CtMethod method) throws BadBytecode {
        void var1_1;
        return this.analyze(method.getDeclaringClass(), var1_1.getMethodInfo2());
    }

    /*
     * WARNING - void declaration
     */
    private void analyzeNextEntry(MethodInfo method, CodeIterator iter, IntQueue queue, Executor executor) throws BadBytecode {
        void var1_1;
        void var3_3;
        int pos = queue.take();
        iter.move(pos);
        iter.next();
        Frame frame = this.frames[pos].copy();
        Subroutine subroutine = this.subroutines[pos];
        try {
            executor.execute(method, pos, iter, frame, subroutine);
        }
        catch (RuntimeException e2) {
            throw new BadBytecode(e2.getMessage() + "[pos = " + pos + "]", (Throwable)e2);
        }
        int opcode = iter.byteAt(pos);
        if (opcode == 170) {
            this.mergeTableSwitch(queue, pos, iter, frame);
        } else if (opcode == 171) {
            this.mergeLookupSwitch(queue, pos, iter, frame);
        } else if (opcode == 169) {
            this.mergeRet(queue, iter, pos, frame, subroutine);
        } else if (Util.isJumpInstruction(opcode)) {
            int target = Util.getJumpTarget(pos, iter);
            if (Util.isJsr(opcode)) {
                this.mergeJsr(queue, this.frames[pos], this.subroutines[target], pos, this.lookAhead(iter, pos));
            } else if (!Util.isGoto(opcode)) {
                this.merge(queue, frame, this.lookAhead(iter, pos));
            }
            this.merge(queue, frame, target);
        } else if (opcode != 191 && !Util.isReturn(opcode)) {
            void var2_2;
            this.merge(queue, frame, this.lookAhead((CodeIterator)var2_2, pos));
        }
        this.mergeExceptionHandlers((IntQueue)var3_3, (MethodInfo)var1_1, pos, frame);
    }

    /*
     * WARNING - void declaration
     */
    private ExceptionInfo[] buildExceptionInfo(MethodInfo method) {
        ConstPool constPool = method.getConstPool();
        ClassPool classes = this.clazz.getClassPool();
        ExceptionTable table = method.getCodeAttribute().getExceptionTable();
        ExceptionInfo[] exceptions = new ExceptionInfo[table.size()];
        for (int i2 = 0; i2 < table.size(); ++i2) {
            void var1_1;
            Type type;
            int index = table.catchType(i2);
            try {
                type = index == 0 ? Type.THROWABLE : Type.get(classes.get(constPool.getClassInfo(index)));
            }
            catch (NotFoundException e2) {
                void var1_2;
                throw new IllegalStateException(var1_2.getMessage());
            }
            exceptions[i2] = new ExceptionInfo(var1_1.startPc(i2), var1_1.endPc(i2), var1_1.handlerPc(i2), type);
        }
        return exceptions;
    }

    /*
     * WARNING - void declaration
     */
    private Frame firstFrame(MethodInfo method, int maxLocals, int maxStack) {
        void var2_3;
        CtClass[] parameters;
        int pos = 0;
        Frame first = new Frame(maxLocals, maxStack);
        if ((method.getAccessFlags() & 8) == 0) {
            ++pos;
            first.setLocal(0, Type.get(this.clazz));
        }
        try {
            parameters = Descriptor.getParameterTypes(method.getDescriptor(), this.clazz.getClassPool());
        }
        catch (NotFoundException e2) {
            throw new RuntimeException(e2);
        }
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            Type type = this.zeroExtend(Type.get(parameters[i2]));
            first.setLocal(pos++, type);
            if (type.getSize() != 2) continue;
            first.setLocal(pos++, Type.TOP);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private int getNext(CodeIterator iter, int of, int restore) throws BadBytecode {
        void var2_2;
        void var1_1;
        void var3_3;
        iter.move(of);
        iter.next();
        int next = iter.lookAhead();
        iter.move((int)var3_3);
        var1_1.next();
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int lookAhead(CodeIterator iter, int pos) throws BadBytecode {
        void var1_1;
        if (!iter.hasNext()) {
            void var2_2;
            throw new BadBytecode("Execution falls off end! [pos = " + (int)var2_2 + "]");
        }
        return var1_1.lookAhead();
    }

    /*
     * WARNING - void declaration
     */
    private void merge(IntQueue queue, Frame frame, int target) {
        void var2_3;
        boolean changed2;
        Frame old = this.frames[target];
        if (old == null) {
            this.frames[target] = frame.copy();
            changed2 = true;
        } else {
            void changed;
            changed2 = old.merge((Frame)changed);
        }
        if (var2_3 != false) {
            void var3_4;
            void var1_1;
            var1_1.add((int)var3_4);
        }
    }

    private void mergeExceptionHandlers(IntQueue queue, MethodInfo method, int pos, Frame frame) {
        for (int i2 = 0; i2 < this.exceptions.length; ++i2) {
            ExceptionInfo exception = this.exceptions[i2];
            if (pos < exception.start || pos >= exception.end) continue;
            Frame newFrame = frame.copy();
            newFrame.clearStack();
            newFrame.push(exception.type);
            this.merge(queue, newFrame, exception.handler);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeJsr(IntQueue queue, Frame frame, Subroutine sub, int pos, int next) throws BadBytecode {
        if (sub == null) {
            throw new BadBytecode("No subroutine at jsr target! [pos = " + pos + "]");
        }
        Frame old = this.frames[next];
        boolean changed = false;
        if (old == null) {
            old = this.frames[next] = frame.copy();
            changed = true;
        } else {
            for (int i2 = 0; i2 < frame.localsLength(); ++i2) {
                if (sub.isAccessed(i2)) continue;
                Type oldType = old.getLocal(i2);
                Type newType = frame.getLocal(i2);
                if (oldType == null) {
                    old.setLocal(i2, newType);
                } else {
                    newType = oldType.merge(newType);
                    old.setLocal(i2, newType);
                    if (newType.equals(oldType) && !newType.popChanged()) continue;
                }
                changed = true;
            }
        }
        if (!old.isJsrMerged()) {
            old.setJsrMerged(true);
            changed = true;
        }
        if (changed && old.isRetMerged()) {
            void var1_1;
            var1_1.add(next);
        }
    }

    private void mergeLookupSwitch(IntQueue queue, int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        int index = (pos & 0xFFFFFFFC) + 4;
        this.merge(queue, frame, pos + iter.s32bitAt(index));
        int n2 = iter.s32bitAt(index += 4);
        int end = (n2 << 3) + (index += 4);
        index += 4;
        while (index < end) {
            int target = iter.s32bitAt(index) + pos;
            this.merge(queue, frame, target);
            index += 8;
        }
    }

    private void mergeRet(IntQueue queue, CodeIterator iter, int pos, Frame frame, Subroutine subroutine) throws BadBytecode {
        if (subroutine == null) {
            throw new BadBytecode("Ret on no subroutine! [pos = " + pos + "]");
        }
        for (int caller : subroutine.callers()) {
            boolean changed;
            int returnLoc = this.getNext(iter, caller, pos);
            Frame old = this.frames[returnLoc];
            if (old == null) {
                old = this.frames[returnLoc] = frame.copyStack();
                changed = true;
            } else {
                changed = old.mergeStack(frame);
            }
            for (int index : subroutine.accessed()) {
                Type newType;
                Type oldType = old.getLocal(index);
                if (oldType == (newType = frame.getLocal(index))) continue;
                old.setLocal(index, newType);
                changed = true;
            }
            if (!old.isRetMerged()) {
                old.setRetMerged(true);
                changed = true;
            }
            if (!changed || !old.isJsrMerged()) continue;
            queue.add(returnLoc);
        }
    }

    private void mergeTableSwitch(IntQueue queue, int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        int index = (pos & 0xFFFFFFFC) + 4;
        this.merge(queue, frame, pos + iter.s32bitAt(index));
        int low = iter.s32bitAt(index += 4);
        int n2 = iter.s32bitAt(index += 4);
        int end = (n2 - low + 1 << 2) + (index += 4);
        while (index < end) {
            int target = iter.s32bitAt(index) + pos;
            this.merge(queue, frame, target);
            index += 4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Type zeroExtend(Type type) {
        void var1_1;
        if (type == Type.SHORT || type == Type.BYTE || type == Type.CHAR || type == Type.BOOLEAN) {
            return Type.INTEGER;
        }
        return var1_1;
    }

    private static class ExceptionInfo {
        private int end;
        private int handler;
        private int start;
        private Type type;

        /*
         * WARNING - void declaration
         */
        private ExceptionInfo(int start, int end, int handler, Type type) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.start = var1_1;
            this.end = var2_2;
            this.handler = var3_3;
            this.type = type;
        }
    }
}

