/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;

public class StackMapTable
extends AttributeInfo {
    public static final String tag = "StackMapTable";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    /*
     * WARNING - void declaration
     */
    StackMapTable(ConstPool cp, byte[] newInfo) {
        super((ConstPool)var1_1, tag, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    StackMapTable(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) throws RuntimeCopyException {
        try {
            void var2_2;
            void var1_1;
            return new StackMapTable(newCp, new Copier(this.constPool, this.info, (ConstPool)var1_1, (Map<String, String>)var2_2).doit());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void write(DataOutputStream out) throws IOException {
        void var1_1;
        super.write((DataOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void insertLocal(int index, int tag, int classInfo) throws BadBytecode {
        void var1_2;
        void var3_4;
        void var2_3;
        byte[] data = new InsertLocal(this.get(), index, (int)var2_3, (int)var3_4).doit();
        this.set((byte[])var1_2);
    }

    public static int typeTagOf(char descriptor) {
        switch (descriptor) {
            case 'D': {
                return 3;
            }
            case 'F': {
                return 2;
            }
            case 'J': {
                return 4;
            }
            case 'L': 
            case '[': {
                return 7;
            }
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public void println(PrintWriter w2) {
        void var1_1;
        Printer.print(this, (PrintWriter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void println(PrintStream ps) {
        void var1_1;
        Printer.print(this, new PrintWriter((OutputStream)var1_1, true));
    }

    /*
     * WARNING - void declaration
     */
    void shiftPc(int where, int gapSize, boolean exclusive) throws BadBytecode {
        void var3_3;
        void var2_2;
        void var1_1;
        new OffsetShifter(this, where, gapSize).parse();
        new Shifter(this, (int)var1_1, (int)var2_2, (boolean)var3_3).doit();
    }

    /*
     * WARNING - void declaration
     */
    void shiftForSwitch(int where, int gapSize) throws BadBytecode {
        void var2_2;
        void var1_1;
        new SwitchShifter(this, (int)var1_1, (int)var2_2).doit();
    }

    /*
     * WARNING - void declaration
     */
    public void removeNew(int where) throws CannotCompileException {
        try {
            byte[] data = new NewRemover(this.get(), where).doit();
            this.set(data);
            return;
        }
        catch (BadBytecode e2) {
            void var1_3;
            throw new CannotCompileException("bad stack map table", (Throwable)var1_3);
        }
    }

    static class Copier
    extends SimpleCopy {
        private ConstPool srcPool;
        private ConstPool destPool;
        private Map<String, String> classnames;

        /*
         * WARNING - void declaration
         */
        public Copier(ConstPool src, byte[] data, ConstPool dest, Map<String, String> names) {
            super((byte[])var2_2);
            void var3_3;
            void var1_1;
            void var2_2;
            this.srcPool = var1_1;
            this.destPool = var3_3;
            this.classnames = names;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int copyData(int tag, int data) {
            void var2_2;
            if (tag == 7) {
                return this.srcPool.copy(data, this.destPool, this.classnames);
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int[] copyData(int[] tags, int[] data) {
            void var3_3;
            int[] newData = new int[data.length];
            for (int i2 = 0; i2 < data.length; ++i2) {
                newData[i2] = tags[i2] == 7 ? this.srcPool.copy(data[i2], this.destPool, this.classnames) : data[i2];
            }
            return var3_3;
        }
    }

    public static class RuntimeCopyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        public RuntimeCopyException(String s2) {
            super((String)var1_1);
            void var1_1;
        }
    }

    static class InsertLocal
    extends SimpleCopy {
        private int varIndex;
        private int varTag;
        private int varData;

        /*
         * WARNING - void declaration
         */
        public InsertLocal(byte[] data, int varIndex, int varTag, int varData) {
            super((byte[])var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.varIndex = var2_2;
            this.varTag = var3_3;
            this.varData = varData;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            void var2_2;
            void var1_1;
            int len = localTags.length;
            if (len < this.varIndex) {
                super.fullFrame(pos, offsetDelta, localTags, localData, stackTags, stackData);
                return;
            }
            int typeSize = this.varTag == 4 || this.varTag == 3 ? 2 : 1;
            int[] localTags2 = new int[len + typeSize];
            int[] localData2 = new int[len + typeSize];
            int index = this.varIndex;
            int j2 = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                if (j2 == index) {
                    j2 += typeSize;
                }
                localTags2[j2] = localTags[i2];
                localData2[j2++] = localData[i2];
            }
            localTags2[index] = this.varTag;
            localData2[index] = this.varData;
            if (typeSize > 1) {
                localTags2[index + 1] = 0;
                localData2[index + 1] = 0;
            }
            super.fullFrame((int)var1_1, (int)var2_2, localTags2, localData2, stackTags, stackData);
        }
    }

    static class Printer
    extends Walker {
        private PrintWriter writer;
        private int offset;

        /*
         * WARNING - void declaration
         */
        public static void print(StackMapTable smt, PrintWriter writer) {
            try {
                new Printer(smt.get(), writer).parse();
                return;
            }
            catch (BadBytecode e2) {
                void var0_1;
                void var1_2;
                var1_2.println(var0_1.getMessage());
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        Printer(byte[] data, PrintWriter pw) {
            super((byte[])var1_1);
            void var2_2;
            void var1_1;
            this.writer = var2_2;
            this.offset = -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameFrame(int pos, int offsetDelta) {
            void var2_2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " same frame: " + (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            void var3_3;
            void var2_2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " same locals: " + (int)var2_2);
            this.printTypeInfo((int)var3_3, stackData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void chopFrame(int pos, int offsetDelta, int k2) {
            void var3_3;
            void var2_2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " chop frame: " + (int)var2_2 + ",    " + (int)var3_3 + " last locals");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
            void var2_2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " append frame: " + (int)var2_2);
            for (int i2 = 0; i2 < tags.length; ++i2) {
                this.printTypeInfo(tags[i2], data[i2]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int i2;
            void var2_2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " full frame: " + (int)var2_2);
            this.writer.println("[locals]");
            for (i2 = 0; i2 < localTags.length; ++i2) {
                this.printTypeInfo(localTags[i2], localData[i2]);
            }
            this.writer.println("[stack]");
            for (i2 = 0; i2 < stackTags.length; ++i2) {
                this.printTypeInfo(stackTags[i2], stackData[i2]);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void printTypeInfo(int tag, int data) {
            void var3_3;
            void var1_1;
            String msg = null;
            switch (var1_1) {
                case 0: {
                    msg = "top";
                    break;
                }
                case 1: {
                    msg = "integer";
                    break;
                }
                case 2: {
                    msg = "float";
                    break;
                }
                case 3: {
                    msg = "double";
                    break;
                }
                case 4: {
                    msg = "long";
                    break;
                }
                case 5: {
                    msg = "null";
                    break;
                }
                case 6: {
                    msg = "this";
                    break;
                }
                case 7: {
                    msg = "object (cpool_index " + data + ")";
                    break;
                }
                case 8: {
                    void var2_2;
                    msg = "uninitialized (offset " + (int)var2_2 + ")";
                }
            }
            this.writer.print("    ");
            this.writer.println((String)var3_3);
        }
    }

    static class OffsetShifter
    extends Walker {
        int where;
        int gap;

        /*
         * WARNING - void declaration
         */
        public OffsetShifter(StackMapTable smt, int where, int gap) {
            super((StackMapTable)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.where = var2_2;
            this.gap = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void objectOrUninitialized(int tag, int data, int pos) {
            if (tag == 8 && this.where <= data) {
                void var3_3;
                void var2_2;
                ByteArray.write16bit((int)(var2_2 + this.gap), this.info, (int)var3_3);
            }
        }
    }

    static class Shifter
    extends Walker {
        private StackMapTable stackMap;
        int where;
        int gap;
        int position;
        byte[] updatedInfo;
        boolean exclusive;

        /*
         * WARNING - void declaration
         */
        public Shifter(StackMapTable smt, int where, int gap, boolean exclusive) {
            super(smt);
            void var3_3;
            void var2_2;
            void var1_1;
            this.stackMap = var1_1;
            this.where = var2_2;
            this.gap = var3_3;
            this.position = 0;
            this.updatedInfo = null;
            this.exclusive = exclusive;
        }

        public void doit() throws BadBytecode {
            this.parse();
            if (this.updatedInfo != null) {
                this.stackMap.set(this.updatedInfo);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameFrame(int pos, int offsetDelta) {
            void var2_2;
            void var1_1;
            this.update((int)var1_1, (int)var2_2, 0, 251);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            void var2_2;
            void var1_1;
            this.update((int)var1_1, (int)var2_2, 64, 247);
        }

        /*
         * WARNING - void declaration
         */
        void update(int pos, int offsetDelta, int base, int entry) {
            int match;
            int oldPos;
            this.position = oldPos + offsetDelta + ((oldPos = this.position) == 0 ? 0 : 1);
            if (this.exclusive) {
                match = oldPos == 0 && this.where == 0 || oldPos < this.where && this.where <= this.position ? 1 : 0;
            } else {
                int n2 = match = match <= this.where && this.where < this.position ? 1 : 0;
            }
            if (match != 0) {
                void var1_1;
                int current = this.info[pos] & 0xFF;
                int newDelta = offsetDelta + this.gap;
                this.position += this.gap;
                if (newDelta < 64) {
                    void var3_4;
                    this.info[pos] = (byte)(newDelta + var3_4);
                    return;
                }
                if (offsetDelta < 64 && current != entry) {
                    void var2_3;
                    byte[] byArray = Shifter.insertGap(this.info, pos, 2);
                    byte[] newinfo = byArray;
                    byArray[pos] = (byte)entry;
                    ByteArray.write16bit(newDelta, newinfo, pos + 1);
                    this.updatedInfo = var2_3;
                    return;
                }
                ByteArray.write16bit(newDelta, this.info, (int)(var1_1 + true));
            }
        }

        /*
         * WARNING - void declaration
         */
        static byte[] insertGap(byte[] info, int where, int gap) {
            int len = info.length;
            byte[] newinfo = new byte[len + gap];
            if (where <= 0) {
                System.arraycopy(info, 0, newinfo, gap, len);
            } else if (where >= len) {
                System.arraycopy(info, 0, newinfo, 0, len);
            } else {
                void var1_1;
                void var3_3;
                void var2_2;
                byte[] byArray;
                assert (where > 0 && where < len);
                System.arraycopy(info, 0, newinfo, 0, where);
                System.arraycopy(byArray, where, newinfo, where + var2_2, (int)(var3_3 - var1_1));
            }
            return newinfo;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void chopFrame(int pos, int offsetDelta, int k2) {
            void var2_2;
            void var1_1;
            this.update((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
            void var2_2;
            void var1_1;
            this.update((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            void var2_2;
            void var1_1;
            this.update((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        void update(int pos, int offsetDelta) {
            void var3_3;
            int match;
            int oldPos;
            this.position = oldPos + offsetDelta + ((oldPos = this.position) == 0 ? 0 : 1);
            if (this.exclusive) {
                match = oldPos == 0 && this.where == 0 || oldPos < this.where && this.where <= this.position ? 1 : 0;
            } else {
                int n2 = match = match <= this.where && this.where < this.position ? 1 : 0;
            }
            if (var3_3 != false) {
                void var1_1;
                ByteArray.write16bit((int)(var2_2 += this.gap), this.info, (int)(var1_1 + true));
                this.position += this.gap;
            }
        }
    }

    static class SwitchShifter
    extends Shifter {
        /*
         * WARNING - void declaration
         */
        SwitchShifter(StackMapTable smt, int where, int gap) {
            super((StackMapTable)var1_1, (int)var2_2, (int)var3_3, false);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void update(int pos, int offsetDelta, int base, int entry) {
            void var1_1;
            int newDelta;
            int oldPos;
            this.position = oldPos + offsetDelta + ((oldPos = this.position) == 0 ? 0 : 1);
            if (this.where == this.position) {
                newDelta = offsetDelta - this.gap;
            } else if (this.where == newDelta) {
                newDelta = offsetDelta + this.gap;
            } else {
                return;
            }
            if (offsetDelta < 64) {
                if (newDelta < 64) {
                    this.info[pos] = (byte)(newDelta + base);
                    return;
                }
                byte[] byArray = SwitchShifter.insertGap(this.info, pos, 2);
                byte[] newinfo = byArray;
                byArray[pos] = (byte)entry;
                ByteArray.write16bit(newDelta, newinfo, pos + 1);
                this.updatedInfo = newinfo;
                return;
            }
            if (newDelta < 64) {
                void var2_4;
                void var3_5;
                byte[] byArray = SwitchShifter.deleteGap(this.info, pos, 2);
                byte[] newinfo = byArray;
                byArray[pos] = (byte)(newDelta + var3_5);
                this.updatedInfo = var2_4;
                return;
            }
            ByteArray.write16bit(newDelta, this.info, (int)(var1_1 + true));
        }

        static byte[] deleteGap(byte[] info, int where, int gap) {
            where += gap;
            int len = info.length;
            byte[] newinfo = new byte[len - gap];
            for (int i2 = 0; i2 < len; ++i2) {
                int n2 = i2;
                newinfo[n2 - (n2 < where ? 0 : gap)] = info[i2];
            }
            return newinfo;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void update(int pos, int offsetDelta) {
            void var1_1;
            void var2_2;
            void var3_3;
            int oldPos;
            this.position = oldPos + offsetDelta + ((oldPos = this.position) == 0 ? 0 : 1);
            if (this.where == this.position) {
                int newDelta = offsetDelta - this.gap;
            } else if (this.where == var3_3) {
                newDelta += this.gap;
            } else {
                return;
            }
            ByteArray.write16bit((int)var2_2, this.info, (int)(var1_1 + true));
        }
    }

    static class NewRemover
    extends SimpleCopy {
        int posOfNew;

        /*
         * WARNING - void declaration
         */
        public NewRemover(byte[] data, int pos) {
            super((byte[])var1_1);
            void var2_2;
            void var1_1;
            this.posOfNew = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (stackTag == 8 && stackData == this.posOfNew) {
                super.sameFrame(pos, offsetDelta);
                return;
            }
            super.sameLocals((int)var1_1, (int)var2_2, (int)var3_3, stackData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            void var3_3;
            void var2_2;
            void var1_1;
            int n2 = stackTags.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (stackTags[i2] != 8 || stackData[i2] != this.posOfNew || stackTags[i2 + 1] != 8 || stackData[i2 + 1] != this.posOfNew) continue;
                int[] stackTags2 = new int[++n2 - 2];
                int[] stackData2 = new int[n2 - 2];
                int k2 = 0;
                for (int j2 = 0; j2 < n2; ++j2) {
                    if (j2 == i2) {
                        ++j2;
                        continue;
                    }
                    stackTags2[k2] = stackTags[j2];
                    stackData2[k2++] = stackData[j2];
                }
                stackTags = stackTags2;
                stackData = stackData2;
                break;
            }
            super.fullFrame((int)var1_1, (int)var2_2, (int[])var3_3, localData, stackTags, stackData);
        }
    }

    public static class Writer {
        ByteArrayOutputStream output;
        int numOfEntries;

        /*
         * WARNING - void declaration
         */
        public Writer(int size) {
            void var1_1;
            this.output = new ByteArrayOutputStream((int)var1_1);
            this.numOfEntries = 0;
            this.output.write(0);
            this.output.write(0);
        }

        /*
         * WARNING - void declaration
         */
        public byte[] toByteArray() {
            void var1_1;
            byte[] b2 = this.output.toByteArray();
            ByteArray.write16bit(this.numOfEntries, b2, 0);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public StackMapTable toStackMapTable(ConstPool cp) {
            void var1_1;
            return new StackMapTable((ConstPool)var1_1, this.toByteArray());
        }

        /*
         * WARNING - void declaration
         */
        public void sameFrame(int offsetDelta) {
            void var1_1;
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta);
                return;
            }
            this.output.write(251);
            this.write16((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void sameLocals(int offsetDelta, int tag, int data) {
            void var3_3;
            void var2_2;
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta + 64);
            } else {
                void var1_1;
                this.output.write(247);
                this.write16((int)var1_1);
            }
            this.writeTypeInfo((int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void chopFrame(int offsetDelta, int k2) {
            void var1_1;
            void var2_2;
            ++this.numOfEntries;
            this.output.write(251 - var2_2);
            this.write16((int)var1_1);
        }

        public void appendFrame(int offsetDelta, int[] tags, int[] data) {
            ++this.numOfEntries;
            int k2 = tags.length;
            this.output.write(k2 + 251);
            this.write16(offsetDelta);
            for (int i2 = 0; i2 < k2; ++i2) {
                this.writeTypeInfo(tags[i2], data[i2]);
            }
        }

        public void fullFrame(int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int i2;
            ++this.numOfEntries;
            this.output.write(255);
            this.write16(offsetDelta);
            int n2 = localTags.length;
            this.write16(n2);
            for (i2 = 0; i2 < n2; ++i2) {
                this.writeTypeInfo(localTags[i2], localData[i2]);
            }
            n2 = stackTags.length;
            this.write16(n2);
            for (i2 = 0; i2 < n2; ++i2) {
                this.writeTypeInfo(stackTags[i2], stackData[i2]);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeTypeInfo(int tag, int data) {
            void var1_1;
            this.output.write(tag);
            if (tag == 7 || var1_1 == 8) {
                void var2_2;
                this.write16((int)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void write16(int value) {
            void var1_1;
            this.output.write(value >>> 8 & 0xFF);
            this.output.write((int)(var1_1 & 0xFF));
        }
    }

    static class SimpleCopy
    extends Walker {
        private Writer writer;

        /*
         * WARNING - void declaration
         */
        public SimpleCopy(byte[] data) {
            super(data);
            void var1_1;
            this.writer = new Writer(((void)var1_1).length);
        }

        public byte[] doit() throws BadBytecode {
            this.parse();
            return this.writer.toByteArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameFrame(int pos, int offsetDelta) {
            void var2_2;
            this.writer.sameFrame((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            void var3_3;
            void var2_2;
            this.writer.sameLocals((int)var2_2, stackTag, this.copyData((int)var3_3, stackData));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void chopFrame(int pos, int offsetDelta, int k2) {
            void var3_3;
            void var2_2;
            this.writer.chopFrame((int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
            void var3_3;
            void var2_2;
            this.writer.appendFrame((int)var2_2, tags, this.copyData((int[])var3_3, data));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            void var3_3;
            void var2_2;
            this.writer.fullFrame((int)var2_2, localTags, this.copyData((int[])var3_3, localData), stackTags, this.copyData(stackTags, stackData));
        }

        protected int copyData(int tag, int data) {
            return data;
        }

        protected int[] copyData(int[] tags, int[] data) {
            return data;
        }
    }

    public static class Walker {
        byte[] info;
        int numOfEntries;

        /*
         * WARNING - void declaration
         */
        public Walker(StackMapTable smt) {
            this(var1_1.get());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Walker(byte[] data) {
            void var1_1;
            this.info = data;
            this.numOfEntries = ByteArray.readU16bit((byte[])var1_1, 0);
        }

        public final int size() {
            return this.numOfEntries;
        }

        public void parse() throws BadBytecode {
            int n2 = this.numOfEntries;
            int pos = 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                pos = this.stackMapFrames(pos, i2);
            }
        }

        /*
         * WARNING - void declaration
         */
        int stackMapFrames(int pos, int nth) throws BadBytecode {
            void var1_1;
            int type = this.info[pos] & 0xFF;
            if (type < 64) {
                this.sameFrame(pos, type);
                ++pos;
            } else if (type < 128) {
                pos = this.sameLocals(pos, type);
            } else {
                int offset;
                if (type < 247) {
                    throw new BadBytecode("bad frame_type " + type + " in StackMapTable (pos: " + pos + ", frame no.:" + nth + ")");
                }
                if (type == 247) {
                    pos = this.sameLocals(pos, type);
                } else if (type < 251) {
                    offset = ByteArray.readU16bit(this.info, pos + 1);
                    this.chopFrame(pos, offset, 251 - type);
                    pos += 3;
                } else if (type == 251) {
                    void var2_2;
                    offset = ByteArray.readU16bit(this.info, pos + 1);
                    this.sameFrame(pos, (int)var2_2);
                    pos += 3;
                } else {
                    void var3_3;
                    pos = type < 255 ? this.appendFrame(pos, (int)var3_3) : this.fullFrame(pos);
                }
            }
            return (int)var1_1;
        }

        public void sameFrame(int pos, int offsetDelta) throws BadBytecode {
        }

        /*
         * WARNING - void declaration
         */
        private int sameLocals(int pos, int type) throws BadBytecode {
            void var1_1;
            void var2_2;
            void var3_3;
            int offset;
            int top = pos;
            if (type < 128) {
                offset = type - 64;
            } else {
                offset = ByteArray.readU16bit(this.info, pos + 1);
                pos += 2;
            }
            int tag = this.info[pos + 1] & 0xFF;
            int data = 0;
            if (tag == 7 || tag == 8) {
                data = ByteArray.readU16bit(this.info, pos + 2);
                this.objectOrUninitialized(tag, data, pos + 2);
                pos += 2;
            }
            this.sameLocals((int)var3_3, (int)var2_2, tag, data);
            return (int)(var1_1 + 2);
        }

        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) throws BadBytecode {
        }

        public void chopFrame(int pos, int offsetDelta, int k2) throws BadBytecode {
        }

        /*
         * WARNING - void declaration
         */
        private int appendFrame(int pos, int type) throws BadBytecode {
            void var3_3;
            void var1_1;
            int k2 = type - 251;
            int offset = ByteArray.readU16bit(this.info, pos + 1);
            int[] tags = new int[k2];
            int[] data = new int[k2];
            int p2 = pos + 3;
            for (int i2 = 0; i2 < k2; ++i2) {
                int tag;
                tags[i2] = tag = this.info[p2] & 0xFF;
                if (tag == 7 || tag == 8) {
                    data[i2] = ByteArray.readU16bit(this.info, p2 + 1);
                    this.objectOrUninitialized(tag, data[i2], p2 + 1);
                    p2 += 3;
                    continue;
                }
                data[i2] = 0;
                ++p2;
            }
            this.appendFrame((int)var1_1, (int)var3_3, tags, data);
            return p2;
        }

        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) throws BadBytecode {
        }

        /*
         * WARNING - void declaration
         */
        private int fullFrame(int pos) throws BadBytecode {
            void var3_3;
            void var2_2;
            void var1_1;
            int offset = ByteArray.readU16bit(this.info, pos + 1);
            int numOfLocals = ByteArray.readU16bit(this.info, pos + 3);
            int[] localsTags = new int[numOfLocals];
            int[] localsData = new int[numOfLocals];
            int p2 = this.verifyTypeInfo(pos + 5, numOfLocals, localsTags, localsData);
            int numOfItems = ByteArray.readU16bit(this.info, p2);
            int[] itemsTags = new int[numOfItems];
            int[] itemsData = new int[numOfItems];
            p2 = this.verifyTypeInfo(p2 + 2, numOfItems, itemsTags, itemsData);
            this.fullFrame((int)var1_1, (int)var2_2, localsTags, localsData, itemsTags, itemsData);
            return (int)var3_3;
        }

        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) throws BadBytecode {
        }

        /*
         * WARNING - void declaration
         */
        private int verifyTypeInfo(int pos, int n2, int[] tags, int[] data) {
            void var1_1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int tag;
                tags[i2] = tag = this.info[pos++] & 0xFF;
                if (tag != 7 && tag != 8) continue;
                data[i2] = ByteArray.readU16bit(this.info, pos);
                this.objectOrUninitialized(tag, data[i2], pos);
                pos += 2;
            }
            return (int)var1_1;
        }

        public void objectOrUninitialized(int tag, int data, int pos) {
        }
    }
}

