/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class StackMap
extends AttributeInfo {
    public static final String tag = "StackMap";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    /*
     * WARNING - void declaration
     */
    StackMap(ConstPool cp, byte[] newInfo) {
        super((ConstPool)var1_1, tag, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    StackMap(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public int numOfEntries() {
        return ByteArray.readU16bit(this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        void var1_1;
        void var2_2;
        Copier copier = new Copier(this, newCp, (Map<String, String>)var2_2);
        ((Walker)copier).visit();
        return var1_1.getStackMap();
    }

    /*
     * WARNING - void declaration
     */
    public void insertLocal(int index, int tag, int classInfo) throws BadBytecode {
        void var1_2;
        void var3_4;
        void var2_3;
        byte[] data = new InsertLocal(this, index, (int)var2_3, (int)var3_4).doit();
        this.set((byte[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    void shiftPc(int where, int gapSize, boolean exclusive) throws BadBytecode {
        void var3_3;
        void var2_2;
        void var1_1;
        new Shifter(this, (int)var1_1, (int)var2_2, (boolean)var3_3).visit();
    }

    /*
     * WARNING - void declaration
     */
    void shiftForSwitch(int where, int gapSize) throws BadBytecode {
        void var2_2;
        void var1_1;
        new SwitchShifter(this, (int)var1_1, (int)var2_2).visit();
    }

    /*
     * WARNING - void declaration
     */
    public void removeNew(int where) throws CannotCompileException {
        void var1_2;
        byte[] data = new NewRemover(this, where).doit();
        this.set((byte[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public void print(PrintWriter out) {
        void var1_1;
        new Printer(this, (PrintWriter)var1_1).print();
    }

    static class Copier
    extends Walker {
        byte[] dest;
        ConstPool srcCp;
        ConstPool destCp;
        Map<String, String> classnames;

        /*
         * WARNING - void declaration
         */
        Copier(StackMap map, ConstPool newCp, Map<String, String> classnames) {
            super(map);
            void var3_3;
            void var2_2;
            void var1_1;
            this.srcCp = var1_1.getConstPool();
            this.dest = new byte[this.info.length];
            this.destCp = var2_2;
            this.classnames = var3_3;
        }

        @Override
        public void visit() {
            int n2 = ByteArray.readU16bit(this.info, 0);
            ByteArray.write16bit(n2, this.dest, 0);
            super.visit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int locals(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            ByteArray.write16bit(offset, this.dest, pos - 4);
            return super.locals((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int typeInfoArray(int pos, int offset, int num, boolean isLocals) {
            void var3_3;
            void var2_2;
            void var1_1;
            ByteArray.write16bit(num, this.dest, pos - 2);
            return super.typeInfoArray((int)var1_1, (int)var2_2, (int)var3_3, isLocals);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void typeInfo(int pos, byte tag) {
            void var2_2;
            this.dest[var1_1] = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void objectVariable(int pos, int clazz) {
            void var1_1;
            int n2;
            this.dest[pos] = 7;
            n2 = this.srcCp.copy(n2, this.destCp, this.classnames);
            ByteArray.write16bit(n2, this.dest, (int)(var1_1 + true));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void uninitialized(int pos, int offset) {
            void var1_1;
            void var2_2;
            this.dest[pos] = 8;
            ByteArray.write16bit((int)var2_2, this.dest, (int)(var1_1 + true));
        }

        public StackMap getStackMap() {
            return new StackMap(this.destCp, this.dest);
        }
    }

    static class InsertLocal
    extends SimpleCopy {
        private int varIndex;
        private int varTag;
        private int varData;

        /*
         * WARNING - void declaration
         */
        InsertLocal(StackMap map, int varIndex, int varTag, int varData) {
            super((StackMap)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.varIndex = var2_2;
            this.varTag = var3_3;
            this.varData = varData;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int typeInfoArray(int pos, int offset, int num, boolean isLocals) {
            void var1_1;
            void var3_3;
            if (!isLocals || num < this.varIndex) {
                return super.typeInfoArray(pos, offset, num, isLocals);
            }
            this.writer.write16bit(num + 1);
            for (int k2 = 0; k2 < num; ++k2) {
                if (k2 == this.varIndex) {
                    this.writeVarTypeInfo();
                }
                pos = this.typeInfoArray2(k2, pos);
            }
            if (var3_3 == this.varIndex) {
                this.writeVarTypeInfo();
            }
            return (int)var1_1;
        }

        private void writeVarTypeInfo() {
            if (this.varTag == 7) {
                this.writer.writeVerifyTypeInfo(7, this.varData);
                return;
            }
            if (this.varTag == 8) {
                this.writer.writeVerifyTypeInfo(8, this.varData);
                return;
            }
            this.writer.writeVerifyTypeInfo(this.varTag, 0);
        }
    }

    static class Shifter
    extends Walker {
        private int where;
        private int gap;
        private boolean exclusive;

        /*
         * WARNING - void declaration
         */
        public Shifter(StackMap smt, int where, int gap, boolean exclusive) {
            super((StackMap)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.where = var2_2;
            this.gap = var3_3;
            this.exclusive = exclusive;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int locals(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.exclusive ? this.where <= offset : this.where < offset) {
                ByteArray.write16bit(offset + this.gap, this.info, pos - 4);
            }
            return super.locals((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void uninitialized(int pos, int offset) {
            if (this.where <= offset) {
                void var1_1;
                void var2_2;
                ByteArray.write16bit((int)(var2_2 + this.gap), this.info, (int)(var1_1 + true));
            }
        }
    }

    static class SwitchShifter
    extends Walker {
        private int where;
        private int gap;

        /*
         * WARNING - void declaration
         */
        public SwitchShifter(StackMap smt, int where, int gap) {
            super((StackMap)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.where = var2_2;
            this.gap = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int locals(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.where == pos + offset) {
                ByteArray.write16bit(offset - this.gap, this.info, pos - 4);
            } else if (this.where == pos) {
                ByteArray.write16bit(offset + this.gap, this.info, pos - 4);
            }
            return super.locals((int)var1_1, (int)var2_2, (int)var3_3);
        }
    }

    static class NewRemover
    extends SimpleCopy {
        int posOfNew;

        /*
         * WARNING - void declaration
         */
        NewRemover(StackMap map, int where) {
            super((StackMap)var1_1);
            void var2_2;
            void var1_1;
            this.posOfNew = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int stack(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.stackTypeInfoArray((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private int stackTypeInfoArray(int pos, int offset, int num) {
            void var1_1;
            int tag;
            int k2;
            int p2 = pos;
            int count = 0;
            for (k2 = 0; k2 < num; ++k2) {
                tag = this.info[p2];
                if (tag == 7) {
                    p2 += 3;
                    continue;
                }
                if (tag == 8) {
                    tag = ByteArray.readU16bit(this.info, p2 + 1);
                    if (tag == this.posOfNew) {
                        ++count;
                    }
                    p2 += 3;
                    continue;
                }
                ++p2;
            }
            this.writer.write16bit(num - count);
            for (k2 = 0; k2 < num; ++k2) {
                void var6_6;
                int clazz;
                tag = this.info[pos];
                if (tag == 7) {
                    clazz = ByteArray.readU16bit(this.info, pos + 1);
                    ((Walker)this).objectVariable(pos, clazz);
                    pos += 3;
                    continue;
                }
                if (clazz == 8) {
                    int offsetOfNew = ByteArray.readU16bit(this.info, pos + 1);
                    if (offsetOfNew != this.posOfNew) {
                        ((Walker)this).uninitialized(pos, offsetOfNew);
                    }
                    pos += 3;
                    continue;
                }
                ((Walker)this).typeInfo(pos, (byte)var6_6);
                ++pos;
            }
            return (int)var1_1;
        }
    }

    static class Printer
    extends Walker {
        private PrintWriter writer;

        /*
         * WARNING - void declaration
         */
        public Printer(StackMap map, PrintWriter out) {
            super((StackMap)var1_1);
            void var2_2;
            void var1_1;
            this.writer = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void print() {
            void var1_1;
            int num = ByteArray.readU16bit(this.info, 0);
            this.writer.println((int)var1_1 + " entries");
            this.visit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int locals(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.writer.println("  * offset " + offset);
            return super.locals((int)var1_1, (int)var2_2, (int)var3_3);
        }
    }

    public static class Writer {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public byte[] toByteArray() {
            return this.output.toByteArray();
        }

        /*
         * WARNING - void declaration
         */
        public StackMap toStackMap(ConstPool cp) {
            void var1_1;
            return new StackMap((ConstPool)var1_1, this.output.toByteArray());
        }

        /*
         * WARNING - void declaration
         */
        public void writeVerifyTypeInfo(int tag, int data) {
            void var1_1;
            this.output.write(tag);
            if (tag == 7 || var1_1 == 8) {
                void var2_2;
                this.write16bit((int)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void write16bit(int value) {
            void var1_1;
            this.output.write(value >>> 8 & 0xFF);
            this.output.write((int)(var1_1 & 0xFF));
        }
    }

    static class SimpleCopy
    extends Walker {
        Writer writer = new Writer();

        /*
         * WARNING - void declaration
         */
        SimpleCopy(StackMap map) {
            super((StackMap)var1_1);
            void var1_1;
        }

        byte[] doit() {
            ((Walker)this).visit();
            return this.writer.toByteArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit() {
            void var1_1;
            int num = ByteArray.readU16bit(this.info, 0);
            this.writer.write16bit((int)var1_1);
            super.visit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int locals(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.writer.write16bit(offset);
            return super.locals((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int typeInfoArray(int pos, int offset, int num, boolean isLocals) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.writer.write16bit(num);
            return super.typeInfoArray((int)var1_1, (int)var2_2, (int)var3_3, isLocals);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void typeInfo(int pos, byte tag) {
            void var2_2;
            this.writer.writeVerifyTypeInfo((int)var2_2, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void objectVariable(int pos, int clazz) {
            void var2_2;
            this.writer.writeVerifyTypeInfo(7, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void uninitialized(int pos, int offset) {
            void var2_2;
            this.writer.writeVerifyTypeInfo(8, (int)var2_2);
        }
    }

    public static class Walker {
        byte[] info;

        /*
         * WARNING - void declaration
         */
        public Walker(StackMap sm) {
            void var1_1;
            this.info = var1_1.get();
        }

        public void visit() {
            int num = ByteArray.readU16bit(this.info, 0);
            int pos = 2;
            for (int i2 = 0; i2 < num; ++i2) {
                int offset = ByteArray.readU16bit(this.info, pos);
                int numLoc = ByteArray.readU16bit(this.info, pos + 2);
                pos = this.locals(pos + 4, offset, numLoc);
                int numStack = ByteArray.readU16bit(this.info, pos);
                pos = this.stack(pos + 2, offset, numStack);
            }
        }

        /*
         * WARNING - void declaration
         */
        public int locals(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.typeInfoArray((int)var1_1, (int)var2_2, (int)var3_3, true);
        }

        /*
         * WARNING - void declaration
         */
        public int stack(int pos, int offset, int num) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.typeInfoArray((int)var1_1, (int)var2_2, (int)var3_3, false);
        }

        /*
         * WARNING - void declaration
         */
        public int typeInfoArray(int pos, int offset, int num, boolean isLocals) {
            void var1_1;
            for (int k2 = 0; k2 < num; ++k2) {
                pos = this.typeInfoArray2(k2, pos);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        int typeInfoArray2(int k2, int pos) {
            void var2_2;
            void var1_1;
            int clazz;
            byte tag = this.info[pos];
            if (tag == 7) {
                clazz = ByteArray.readU16bit(this.info, pos + 1);
                this.objectVariable(pos, clazz);
                pos += 3;
            } else if (clazz == 8) {
                int offsetOfNew = ByteArray.readU16bit(this.info, pos + 1);
                this.uninitialized(pos, (int)var1_1);
                pos += 3;
            } else {
                this.typeInfo(pos, (byte)var1_1);
                ++pos;
            }
            return (int)var2_2;
        }

        public void typeInfo(int pos, byte tag) {
        }

        public void objectVariable(int pos, int clazz) {
        }

        public void uninitialized(int pos, int offset) {
        }
    }
}

