/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SignatureAttribute
extends AttributeInfo {
    public static final String tag = "Signature";

    /*
     * WARNING - void declaration
     */
    SignatureAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SignatureAttribute(ConstPool cp, String signature) {
        super(cp, tag);
        void var2_3;
        void var1_2;
        int index = cp.addUtf8Info(signature);
        byte[] byArray = new byte[2];
        byte[] bvalue = byArray;
        byArray[0] = (byte)(index >>> 8);
        bvalue[1] = (byte)var1_2;
        this.set((byte[])var2_3);
    }

    public String getSignature() {
        return this.getConstPool().getUtf8Info(ByteArray.readU16bit(this.get(), 0));
    }

    /*
     * WARNING - void declaration
     */
    public void setSignature(String sig) {
        void var1_1;
        int n2 = this.getConstPool().addUtf8Info((String)var1_1);
        ByteArray.write16bit(n2, this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        void var1_1;
        return new SignatureAttribute((ConstPool)var1_1, this.getSignature());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void renameClass(String oldname, String newname) {
        void var1_1;
        void var2_2;
        String sig = SignatureAttribute.renameClass(this.getSignature(), oldname, (String)var2_2);
        this.setSignature((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void renameClass(Map<String, String> classnames) {
        void var1_1;
        String sig = SignatureAttribute.renameClass(this.getSignature(), classnames);
        this.setSignature((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static String renameClass(String desc, String oldname, String newname) {
        void var3_3;
        String string;
        void var2_2;
        void var1_1;
        HashMap<void, void> map = new HashMap<void, void>();
        map.put(var1_1, var2_2);
        return SignatureAttribute.renameClass(string, (Map<String, String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String renameClass(String desc, Map<String, String> map) {
        void var2_2;
        ArrayList<StringBuilder> genericParamBufs;
        ArrayList<StringBuilder> nameBufs;
        int j2;
        if (map == null || map.isEmpty()) {
            return desc;
        }
        StringBuilder newdesc = new StringBuilder();
        int head = 0;
        int i2 = 0;
        while ((j2 = desc.indexOf(76, i2)) >= 0 && (i2 = SignatureAttribute.parseClassName(nameBufs = new ArrayList<StringBuilder>(), genericParamBufs = new ArrayList<StringBuilder>(), desc, j2) + 1) >= 0) {
            String name = String.join((CharSequence)"$", nameBufs.toArray(new StringBuilder[0]));
            String newname = map.get(name);
            if (newname != null) {
                if (!SignatureAttribute.makeNewClassName(desc, map, name, newname, newdesc, head, j2, nameBufs, genericParamBufs)) continue;
                head = i2;
                continue;
            }
            if (!SignatureAttribute.replaceTypeArguments(desc, map, newdesc, head, j2, nameBufs, genericParamBufs)) continue;
            head = i2;
        }
        if (head == 0) {
            return desc;
        }
        int len = desc.length();
        if (head < len) {
            void var3_3;
            String string;
            newdesc.append(string.substring((int)var3_3, len));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int parseClassName(ArrayList<StringBuilder> nameBufs, ArrayList<StringBuilder> genericParamBufs, String desc, int j2) {
        void var3_3;
        void var1_1;
        ArrayList<StringBuilder> arrayList;
        StringBuilder nameBuf = new StringBuilder();
        StringBuilder genericParamBuf = new StringBuilder();
        try {
            void k2;
            char c2;
            while ((c2 = desc.charAt((int)(++k2))) != ';') {
                int level;
                if (c2 == '<') {
                    genericParamBuf.append(c2);
                    level = 1;
                } else {
                    if (c2 == '.') {
                        nameBufs.add(nameBuf);
                        genericParamBufs.add(genericParamBuf);
                        nameBuf = new StringBuilder();
                        genericParamBuf = new StringBuilder();
                        continue;
                    }
                    nameBuf.append(c2);
                    continue;
                }
                while (level > 0) {
                    c2 = desc.charAt((int)(++k2));
                    genericParamBuf.append(c2);
                    if (c2 == '<') {
                        ++level;
                        continue;
                    }
                    if (c2 != '>') continue;
                    --level;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -2;
        }
        arrayList.add(nameBuf);
        var1_1.add(genericParamBuf);
        return (int)var3_3;
    }

    private static boolean makeNewClassName(String desc, Map<String, String> map, String name, String newname, StringBuilder newdesc, int head, int j2, ArrayList<StringBuilder> nameBufs, ArrayList<StringBuilder> genericParamBufs) {
        String[] newnameSplit;
        String[] nameSplit = name.split("\\$");
        if (nameSplit.length == (newnameSplit = newname.split("\\$")).length) {
            String string;
            String[] newnames = new String[nameBufs.size()];
            int start = 0;
            for (int z = 0; z < nameBufs.size(); ++z) {
                int toAggregate = (int)nameBufs.get(z).chars().filter(ch -> ch == 36).count() + 1;
                int n2 = start;
                String s2 = String.join((CharSequence)"$", Arrays.copyOfRange(newnameSplit, n2, n2 + toAggregate));
                start += toAggregate;
                newnames[z] = s2;
            }
            newdesc.append(string.substring(head, j2));
            newdesc.append('L');
            for (int z = 0; z < newnames.length; ++z) {
                if (z > 0) {
                    newdesc.append('.');
                }
                newdesc.append(newnames[z]);
                StringBuilder genericParamBufCurrent = genericParamBufs.get(z);
                String newgenericParam = genericParamBufCurrent.length() > 0 ? "<" + SignatureAttribute.renameClass(genericParamBufCurrent.substring(1, genericParamBufCurrent.length() - 1), map) + ">" : genericParamBufCurrent.toString();
                newdesc.append(newgenericParam);
            }
            newdesc.append(';');
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean replaceTypeArguments(String desc, Map<String, String> map, StringBuilder newdesc, int head, int j2, ArrayList<StringBuilder> nameBufs, ArrayList<StringBuilder> genericParamBufs) {
        int z;
        ArrayList<String> newGenericParamBufs = new ArrayList<String>();
        boolean changed = false;
        for (z = 0; z < genericParamBufs.size(); ++z) {
            String newGenericParam;
            StringBuilder genericParamBufCurrent = genericParamBufs.get(z);
            if (genericParamBufCurrent.length() > 0) {
                newGenericParam = "<" + SignatureAttribute.renameClass(genericParamBufCurrent.substring(1, genericParamBufCurrent.length() - 1), map) + ">";
                changed = changed || !genericParamBufCurrent.toString().equals(newGenericParam);
            } else {
                newGenericParam = genericParamBufCurrent.toString();
            }
            newGenericParamBufs.add(newGenericParam);
        }
        if (changed) {
            void var2_2;
            void var3_3;
            String string;
            newdesc.append(string.substring((int)var3_3, j2));
            newdesc.append('L');
            for (z = 0; z < genericParamBufs.size(); ++z) {
                if (z > 0) {
                    newdesc.append('.');
                }
                newdesc.append((CharSequence)nameBufs.get(z));
                newdesc.append((String)newGenericParamBufs.get(z));
            }
            var2_2.append(';');
            return true;
        }
        return false;
    }

    private static boolean isNamePart(int c2) {
        int n2;
        return c2 != 59 && n2 != 60;
    }

    public static ClassSignature toClassSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseSig(sig);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string;
            throw SignatureAttribute.error(string);
        }
    }

    public static MethodSignature toMethodSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseMethodSig(sig);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string;
            throw SignatureAttribute.error(string);
        }
    }

    public static ObjectType toFieldSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseObjectType(sig, new Cursor(), false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string;
            throw SignatureAttribute.error(string);
        }
    }

    public static Type toTypeSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseType(sig, new Cursor());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string;
            throw SignatureAttribute.error(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ClassSignature parseSig(String sig) throws BadBytecode, IndexOutOfBoundsException {
        ClassType[] classTypeArray;
        void var3_3;
        void var2_2;
        Cursor cur = new Cursor();
        TypeParameter[] tp = SignatureAttribute.parseTypeParams(sig, cur);
        ClassType superClass = SignatureAttribute.parseClassType(sig, cur);
        int sigLen = sig.length();
        ArrayList<ClassType> ifArray = new ArrayList<ClassType>();
        while (cur.position < sigLen && sig.charAt(cur.position) == 'L') {
            ifArray.add(SignatureAttribute.parseClassType(sig, cur));
        }
        ArrayList<ClassType> arrayList = ifArray;
        ClassType[] ifs = arrayList.toArray(new ClassType[arrayList.size()]);
        return new ClassSignature((TypeParameter[])var2_2, (ClassType)var3_3, classTypeArray);
    }

    /*
     * WARNING - void declaration
     */
    private static MethodSignature parseMethodSig(String sig) throws BadBytecode {
        ObjectType[] objectTypeArray;
        void var2_2;
        void var3_3;
        Cursor cur = new Cursor();
        TypeParameter[] tp = SignatureAttribute.parseTypeParams(sig, cur);
        if (sig.charAt(cur.position++) != '(') {
            throw SignatureAttribute.error(sig);
        }
        ArrayList<Type> params = new ArrayList<Type>();
        while (sig.charAt(cur.position) != ')') {
            Type t2 = SignatureAttribute.parseType(sig, cur);
            params.add(t2);
        }
        ++cur.position;
        Type ret = SignatureAttribute.parseType(sig, cur);
        int sigLen = sig.length();
        ArrayList<ObjectType> exceptions = new ArrayList<ObjectType>();
        while (cur.position < sigLen && sig.charAt(cur.position) == '^') {
            ++cur.position;
            ObjectType t3 = SignatureAttribute.parseObjectType(sig, cur, false);
            if (t3 instanceof ArrayType) {
                throw SignatureAttribute.error(sig);
            }
            exceptions.add(t3);
        }
        void v0 = var3_3;
        Type[] p2 = v0.toArray(new Type[v0.size()]);
        ArrayList<ObjectType> arrayList = exceptions;
        ObjectType[] ex = arrayList.toArray(new ObjectType[arrayList.size()]);
        return new MethodSignature((TypeParameter[])var2_2, p2, ret, objectTypeArray);
    }

    /*
     * WARNING - void declaration
     */
    private static TypeParameter[] parseTypeParams(String sig, Cursor cur) throws BadBytecode {
        void var2_2;
        ArrayList<TypeParameter> typeParam = new ArrayList<TypeParameter>();
        if (sig.charAt(cur.position) == '<') {
            void var1_1;
            ++cur.position;
            while (sig.charAt(cur.position) != '>') {
                void var3_3;
                int nameBegin = cur.position;
                int nameEnd = cur.indexOf(sig, 58);
                ObjectType classBound = SignatureAttribute.parseObjectType(sig, cur, true);
                ArrayList<ObjectType> ifBound = new ArrayList<ObjectType>();
                while (sig.charAt(cur.position) == ':') {
                    ++cur.position;
                    ObjectType t2 = SignatureAttribute.parseObjectType(sig, cur, false);
                    ifBound.add(t2);
                }
                ArrayList<ObjectType> arrayList = ifBound;
                TypeParameter p2 = new TypeParameter(sig, (int)var3_3, nameEnd, classBound, arrayList.toArray(new ObjectType[arrayList.size()]));
                typeParam.add(p2);
            }
            ++var1_1.position;
        }
        void v1 = var2_2;
        return v1.toArray(new TypeParameter[v1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static ObjectType parseObjectType(String sig, Cursor c2, boolean dontThrow) throws BadBytecode {
        String string;
        void var2_3;
        int begin = c2.position;
        switch (sig.charAt(begin)) {
            case 'L': {
                return SignatureAttribute.parseClassType2(sig, c2, null);
            }
            case 'T': {
                void var1_2;
                void var3_4;
                int i2 = c2.indexOf(sig, 59);
                return new TypeVariable(sig, (int)(var3_4 + true), (int)var1_2);
            }
            case '[': {
                void var1_1;
                return SignatureAttribute.parseArray(sig, (Cursor)var1_1);
            }
        }
        if (var2_3 != false) {
            return null;
        }
        throw SignatureAttribute.error(string);
    }

    /*
     * WARNING - void declaration
     */
    private static ClassType parseClassType(String sig, Cursor c2) throws BadBytecode {
        String string;
        if (sig.charAt(c2.position) == 'L') {
            void var1_1;
            return SignatureAttribute.parseClassType2(sig, (Cursor)var1_1, null);
        }
        throw SignatureAttribute.error(string);
    }

    /*
     * WARNING - void declaration
     */
    private static ClassType parseClassType2(String sig, Cursor c2, ClassType parent) throws BadBytecode {
        void var2_2;
        while (true) {
            void var3_3;
            TypeArgument[] targs;
            char t2;
            int start = ++c2.position;
            while ((t2 = sig.charAt(c2.position++)) != '$' && t2 != '<' && t2 != ';') {
            }
            int end = c2.position - 1;
            if (t2 == '<') {
                targs = SignatureAttribute.parseTypeArgs(sig, c2);
                t2 = sig.charAt(c2.position++);
            } else {
                targs = null;
            }
            ClassType thisClass = ClassType.make(sig, (int)var3_3, end, targs, parent);
            if (t2 != '$' && t2 != '.') break;
            --c2.position;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static TypeArgument[] parseTypeArgs(String sig, Cursor c2) throws BadBytecode {
        void var2_2;
        char t2;
        ArrayList<void> args2 = new ArrayList<void>();
        while ((t2 = sig.charAt(c2.position++)) != '>') {
            void var3_3;
            TypeArgument ta22;
            if (t2 == '*') {
                ta22 = new TypeArgument(null, '*');
            } else {
                char ta22;
                if (ta22 != '+' && ta22 != '-') {
                    ta22 = ' ';
                    --c2.position;
                }
                ta22 = new TypeArgument(SignatureAttribute.parseObjectType(sig, c2, false), ta22);
            }
            args2.add(var3_3);
        }
        void v0 = var2_2;
        return v0.toArray(new TypeArgument[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static ObjectType parseArray(String sig, Cursor c2) throws BadBytecode {
        void var1_1;
        String string;
        void var2_2;
        int dim = 1;
        while (sig.charAt(++c2.position) == '[') {
            ++dim;
        }
        return new ArrayType((int)var2_2, SignatureAttribute.parseType(string, (Cursor)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static Type parseType(String sig, Cursor c2) throws BadBytecode {
        void var2_2;
        Type t2 = SignatureAttribute.parseObjectType(sig, c2, true);
        if (t2 == null) {
            void var1_1;
            String string;
            t2 = new BaseType(string.charAt(var1_1.position++));
        }
        return var2_2;
    }

    private static BadBytecode error(String sig) {
        String string;
        return new BadBytecode("bad signature: " + string);
    }

    public static class ClassSignature {
        TypeParameter[] params;
        ClassType superClass;
        ClassType[] interfaces;

        /*
         * WARNING - void declaration
         */
        public ClassSignature(TypeParameter[] params, ClassType superClass, ClassType[] interfaces) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.params = params == null ? new TypeParameter[]{} : var1_1;
            this.superClass = superClass == null ? ClassType.OBJECT : var2_2;
            this.interfaces = interfaces == null ? new ClassType[]{} : var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public ClassSignature(TypeParameter[] p2) {
            this((TypeParameter[])var1_1, null, null);
            void var1_1;
        }

        public TypeParameter[] getParameters() {
            return this.params;
        }

        public ClassType getSuperClass() {
            return this.superClass;
        }

        public ClassType[] getInterfaces() {
            return this.interfaces;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sbuf = new StringBuilder();
            TypeParameter.toString(sbuf, this.params);
            sbuf.append(" extends ").append(this.superClass);
            if (this.interfaces.length > 0) {
                sbuf.append(" implements ");
                Type.toString(sbuf, this.interfaces);
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        public String encode() {
            void var1_1;
            int i2;
            StringBuilder sbuf = new StringBuilder();
            if (this.params.length > 0) {
                sbuf.append('<');
                for (i2 = 0; i2 < this.params.length; ++i2) {
                    this.params[i2].encode(sbuf);
                }
                sbuf.append('>');
            }
            this.superClass.encode(sbuf);
            for (i2 = 0; i2 < this.interfaces.length; ++i2) {
                this.interfaces[i2].encode(sbuf);
            }
            return var1_1.toString();
        }
    }

    public static class MethodSignature {
        TypeParameter[] typeParams;
        Type[] params;
        Type retType;
        ObjectType[] exceptions;

        /*
         * WARNING - void declaration
         */
        public MethodSignature(TypeParameter[] tp, Type[] params, Type ret, ObjectType[] ex) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.typeParams = tp == null ? new TypeParameter[]{} : var1_1;
            this.params = params == null ? new Type[]{} : var2_2;
            this.retType = ret == null ? new BaseType("void") : var3_3;
            this.exceptions = ex == null ? new ObjectType[]{} : ex;
        }

        public TypeParameter[] getTypeParameters() {
            return this.typeParams;
        }

        public Type[] getParameterTypes() {
            return this.params;
        }

        public Type getReturnType() {
            return this.retType;
        }

        public ObjectType[] getExceptionTypes() {
            return this.exceptions;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sbuf = new StringBuilder();
            TypeParameter.toString(sbuf, this.typeParams);
            sbuf.append(" (");
            Type.toString(sbuf, this.params);
            sbuf.append(") ");
            sbuf.append(this.retType);
            if (this.exceptions.length > 0) {
                sbuf.append(" throws ");
                Type.toString(sbuf, this.exceptions);
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        public String encode() {
            void var1_1;
            int i2;
            StringBuilder sbuf = new StringBuilder();
            if (this.typeParams.length > 0) {
                sbuf.append('<');
                for (i2 = 0; i2 < this.typeParams.length; ++i2) {
                    this.typeParams[i2].encode(sbuf);
                }
                sbuf.append('>');
            }
            sbuf.append('(');
            for (i2 = 0; i2 < this.params.length; ++i2) {
                this.params[i2].encode(sbuf);
            }
            sbuf.append(')');
            this.retType.encode(sbuf);
            if (this.exceptions.length > 0) {
                for (i2 = 0; i2 < this.exceptions.length; ++i2) {
                    sbuf.append('^');
                    this.exceptions[i2].encode(sbuf);
                }
            }
            return var1_1.toString();
        }
    }

    private static class Cursor {
        int position = 0;

        private Cursor() {
        }

        /*
         * WARNING - void declaration
         */
        int indexOf(String s2, int ch) throws BadBytecode {
            void var2_2;
            int i2 = s2.indexOf(ch, this.position);
            if (i2 < 0) {
                void var1_1;
                throw SignatureAttribute.error((String)var1_1);
            }
            this.position = i2 + 1;
            return (int)var2_2;
        }
    }

    public static abstract class ObjectType
    extends Type {
        /*
         * WARNING - void declaration
         */
        public String encode() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            this.encode(sb);
            return var1_1.toString();
        }
    }

    public static abstract class Type {
        abstract void encode(StringBuilder var1);

        static void toString(StringBuilder sbuf, Type[] ts) {
            for (int i2 = 0; i2 < ts.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(ts[i2]);
            }
        }

        public String jvmTypeName() {
            return this.toString();
        }
    }

    public static class TypeParameter {
        String name;
        ObjectType superClass;
        ObjectType[] superInterfaces;

        /*
         * WARNING - void declaration
         */
        TypeParameter(String sig, int nb, int ne, ObjectType sc, ObjectType[] si) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1.substring((int)var2_2, (int)var3_3);
            this.superClass = sc;
            this.superInterfaces = si;
        }

        /*
         * WARNING - void declaration
         */
        public TypeParameter(String name, ObjectType superClass, ObjectType[] superInterfaces) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.superClass = var2_2;
            if (superInterfaces == null) {
                this.superInterfaces = new ObjectType[0];
                return;
            }
            this.superInterfaces = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public TypeParameter(String name) {
            this((String)var1_1, null, null);
            void var1_1;
        }

        public String getName() {
            return this.name;
        }

        public ObjectType getClassBound() {
            return this.superClass;
        }

        public ObjectType[] getInterfaceBound() {
            return this.superInterfaces;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            int len;
            StringBuilder sbuf = new StringBuilder(this.getName());
            if (this.superClass != null) {
                sbuf.append(" extends ").append(this.superClass.toString());
            }
            if ((len = this.superInterfaces.length) > 0) {
                for (int i2 = 0; i2 < len; ++i2) {
                    if (i2 > 0 || this.superClass != null) {
                        sbuf.append(" & ");
                    } else {
                        sbuf.append(" extends ");
                    }
                    sbuf.append(this.superInterfaces[i2].toString());
                }
            }
            return var1_1.toString();
        }

        static void toString(StringBuilder sbuf, TypeParameter[] tp) {
            StringBuilder stringBuilder;
            sbuf.append('<');
            for (int i2 = 0; i2 < tp.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(tp[i2]);
            }
            stringBuilder.append('>');
        }

        void encode(StringBuilder sb) {
            sb.append(this.name);
            if (this.superClass == null) {
                sb.append(":Ljava/lang/Object;");
            } else {
                sb.append(':');
                this.superClass.encode(sb);
            }
            for (int i2 = 0; i2 < this.superInterfaces.length; ++i2) {
                sb.append(':');
                this.superInterfaces[i2].encode(sb);
            }
        }
    }

    public static class ClassType
    extends ObjectType {
        String name;
        TypeArgument[] arguments;
        public static ClassType OBJECT = new ClassType("java.lang.Object", null);

        /*
         * WARNING - void declaration
         */
        static ClassType make(String s2, int b2, int e2, TypeArgument[] targs, ClassType parent) {
            void var3_3;
            void var2_2;
            void var1_1;
            String string;
            if (parent == null) {
                return new ClassType(s2, b2, e2, targs);
            }
            return new NestedClassType(string, (int)var1_1, (int)var2_2, (TypeArgument[])var3_3, parent);
        }

        /*
         * WARNING - void declaration
         */
        ClassType(String signature, int begin, int end, TypeArgument[] targs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1.substring((int)var2_2, (int)var3_3).replace('/', '.');
            this.arguments = targs;
        }

        /*
         * WARNING - void declaration
         */
        public ClassType(String className, TypeArgument[] args2) {
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.arguments = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public ClassType(String className) {
            this((String)var1_1, null);
            void var1_1;
        }

        public String getName() {
            return this.name;
        }

        public TypeArgument[] getTypeArguments() {
            return this.arguments;
        }

        public ClassType getDeclaringClass() {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sbuf = new StringBuilder();
            ClassType parent = this.getDeclaringClass();
            if (parent != null) {
                void var2_2;
                sbuf.append(var2_2.toString()).append('.');
            }
            return this.toString2((StringBuilder)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private String toString2(StringBuilder sbuf) {
            void var1_1;
            sbuf.append(this.name);
            if (this.arguments != null) {
                sbuf.append('<');
                int n2 = this.arguments.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(this.arguments[i2].toString());
                }
                sbuf.append('>');
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String jvmTypeName() {
            void var1_1;
            StringBuilder sbuf = new StringBuilder();
            ClassType parent = this.getDeclaringClass();
            if (parent != null) {
                void var2_2;
                sbuf.append(var2_2.jvmTypeName()).append('$');
            }
            return this.toString2((StringBuilder)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void encode(StringBuilder sb) {
            void var1_1;
            sb.append('L');
            this.encode2(sb);
            var1_1.append(';');
        }

        /*
         * WARNING - void declaration
         */
        void encode2(StringBuilder sb) {
            ClassType parent = this.getDeclaringClass();
            if (parent != null) {
                void var2_2;
                var2_2.encode2(sb);
                sb.append('$');
            }
            sb.append(this.name.replace('.', '/'));
            if (this.arguments != null) {
                void var1_1;
                TypeArgument.encode((StringBuilder)var1_1, this.arguments);
            }
        }
    }

    public static class ArrayType
    extends ObjectType {
        int dim;
        Type componentType;

        /*
         * WARNING - void declaration
         */
        public ArrayType(int d2, Type comp) {
            void var2_2;
            void var1_1;
            this.dim = var1_1;
            this.componentType = var2_2;
        }

        public int getDimension() {
            return this.dim;
        }

        public Type getComponentType() {
            return this.componentType;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sbuf = new StringBuilder(this.componentType.toString());
            for (int i2 = 0; i2 < this.dim; ++i2) {
                sbuf.append("[]");
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void encode(StringBuilder sb) {
            void var1_1;
            for (int i2 = 0; i2 < this.dim; ++i2) {
                sb.append('[');
            }
            this.componentType.encode((StringBuilder)var1_1);
        }
    }

    public static class TypeVariable
    extends ObjectType {
        String name;

        /*
         * WARNING - void declaration
         */
        TypeVariable(String sig, int begin, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1.substring((int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public TypeVariable(String name) {
            void var1_1;
            this.name = var1_1;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        void encode(StringBuilder sb) {
            sb.append('T').append(this.name).append(';');
        }
    }

    public static class TypeArgument {
        ObjectType arg;
        char wildcard;

        /*
         * WARNING - void declaration
         */
        TypeArgument(ObjectType a2, char w2) {
            void var2_2;
            void var1_1;
            this.arg = var1_1;
            this.wildcard = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public TypeArgument(ObjectType t2) {
            this((ObjectType)var1_1, ' ');
            void var1_1;
        }

        public TypeArgument() {
            this(null, '*');
        }

        public static TypeArgument subclassOf(ObjectType t2) {
            ObjectType objectType;
            return new TypeArgument(objectType, '+');
        }

        public static TypeArgument superOf(ObjectType t2) {
            ObjectType objectType;
            return new TypeArgument(objectType, '-');
        }

        public char getKind() {
            return this.wildcard;
        }

        public boolean isWildcard() {
            return this.wildcard != ' ';
        }

        public ObjectType getType() {
            return this.arg;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            if (this.wildcard == '*') {
                return "?";
            }
            String type = this.arg.toString();
            if (this.wildcard == ' ') {
                return type;
            }
            if (this.wildcard == '+') {
                return "? extends " + type;
            }
            return "? super " + (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static void encode(StringBuilder sb, TypeArgument[] args2) {
            StringBuilder stringBuilder;
            sb.append('<');
            for (int i2 = 0; i2 < args2.length; ++i2) {
                void var3_3;
                TypeArgument ta = args2[i2];
                if (ta.isWildcard()) {
                    sb.append(ta.wildcard);
                }
                if (ta.getType() == null) continue;
                var3_3.getType().encode(sb);
            }
            stringBuilder.append('>');
        }
    }

    public static class BaseType
    extends Type {
        char descriptor;

        /*
         * WARNING - void declaration
         */
        BaseType(char c2) {
            void var1_1;
            this.descriptor = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public BaseType(String typeName) {
            this(Descriptor.of((String)var1_1).charAt(0));
            void var1_1;
        }

        public char getDescriptor() {
            return this.descriptor;
        }

        public CtClass getCtlass() {
            return Descriptor.toPrimitiveClass(this.descriptor);
        }

        public String toString() {
            return Descriptor.toClassName(Character.toString(this.descriptor));
        }

        @Override
        void encode(StringBuilder sb) {
            sb.append(this.descriptor);
        }
    }

    public static class NestedClassType
    extends ClassType {
        ClassType parent;

        /*
         * WARNING - void declaration
         */
        NestedClassType(String s2, int b2, int e2, TypeArgument[] targs, ClassType p2) {
            super((String)var1_1, (int)var2_2, (int)var3_3, targs);
            void var3_3;
            void var2_2;
            void var1_1;
            this.parent = p2;
        }

        /*
         * WARNING - void declaration
         */
        public NestedClassType(ClassType parent, String className, TypeArgument[] args2) {
            super((String)var2_2, (TypeArgument[])var3_3);
            void var1_1;
            void var3_3;
            void var2_2;
            this.parent = var1_1;
        }

        @Override
        public ClassType getDeclaringClass() {
            return this.parent;
        }
    }
}

