/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AnnotationDefaultAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LineNumberAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.MapMaker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MethodInfo {
    ConstPool constPool;
    int accessFlags;
    int name;
    String cachedName;
    int descriptor;
    List<AttributeInfo> attribute;
    public static boolean doPreverify = false;
    public static final String nameInit = "<init>";
    public static final String nameClinit = "<clinit>";

    /*
     * WARNING - void declaration
     */
    private MethodInfo(ConstPool cp) {
        void var1_1;
        this.constPool = var1_1;
        this.attribute = null;
    }

    /*
     * WARNING - void declaration
     */
    public MethodInfo(ConstPool cp, String methodname, String desc) {
        this(cp);
        void var3_3;
        void var2_2;
        void var1_1;
        this.accessFlags = 0;
        this.name = var1_1.addUtf8Info(methodname);
        this.cachedName = var2_2;
        this.descriptor = this.constPool.addUtf8Info((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    MethodInfo(ConstPool cp, DataInputStream in) throws IOException {
        this((ConstPool)var1_1);
        void var2_2;
        void var1_1;
        this.read((DataInputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MethodInfo(ConstPool cp, String methodname, MethodInfo src, Map<String, String> classnameMap) throws BadBytecode {
        this((ConstPool)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.read((MethodInfo)var3_3, (String)var2_2, classnameMap);
    }

    public String toString() {
        return this.getName() + " " + this.getDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    void compact(ConstPool cp) {
        void var1_1;
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.attribute = AttributeInfo.copyAll(this.attribute, cp);
        this.constPool = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void prune(ConstPool cp) {
        void var1_1;
        void var2_2;
        AttributeInfo signature;
        ExceptionsAttribute ea;
        AnnotationDefaultAttribute defaultAttribute;
        AttributeInfo parameterVisibleAnnotations;
        AttributeInfo parameterInvisibleAnnotations;
        AttributeInfo visibleAnnotations;
        ArrayList<Object> newAttributes = new ArrayList<Object>();
        AttributeInfo invisibleAnnotations = this.getAttribute("RuntimeInvisibleAnnotations");
        if (invisibleAnnotations != null) {
            invisibleAnnotations = invisibleAnnotations.copy(cp, null);
            newAttributes.add(invisibleAnnotations);
        }
        if ((visibleAnnotations = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            visibleAnnotations = visibleAnnotations.copy(cp, null);
            newAttributes.add(visibleAnnotations);
        }
        if ((parameterInvisibleAnnotations = this.getAttribute("RuntimeInvisibleParameterAnnotations")) != null) {
            parameterInvisibleAnnotations = parameterInvisibleAnnotations.copy(cp, null);
            newAttributes.add(parameterInvisibleAnnotations);
        }
        if ((parameterVisibleAnnotations = this.getAttribute("RuntimeVisibleParameterAnnotations")) != null) {
            parameterVisibleAnnotations = parameterVisibleAnnotations.copy(cp, null);
            newAttributes.add(parameterVisibleAnnotations);
        }
        if ((defaultAttribute = (AnnotationDefaultAttribute)this.getAttribute("AnnotationDefault")) != null) {
            newAttributes.add(defaultAttribute);
        }
        if ((ea = this.getExceptionsAttribute()) != null) {
            newAttributes.add(ea);
        }
        if ((signature = this.getAttribute("Signature")) != null) {
            void var3_3;
            signature = signature.copy(cp, null);
            newAttributes.add(var3_3);
        }
        this.attribute = var2_2;
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.constPool = var1_1;
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.constPool.getUtf8Info(this.name);
        }
        return this.cachedName;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String newName) {
        void var1_1;
        this.name = this.constPool.addUtf8Info(newName);
        this.cachedName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMethod() {
        void var1_1;
        String n2 = this.getName();
        return !n2.equals(nameInit) && !var1_1.equals(nameClinit);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isConstructor() {
        return this.getName().equals(nameInit);
    }

    public boolean isStaticInitializer() {
        return this.getName().equals(nameClinit);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessFlags(int acc) {
        void var1_1;
        this.accessFlags = var1_1;
    }

    public String getDescriptor() {
        return this.constPool.getUtf8Info(this.descriptor);
    }

    /*
     * WARNING - void declaration
     */
    public void setDescriptor(String desc) {
        if (!desc.equals(this.getDescriptor())) {
            void var1_1;
            this.descriptor = this.constPool.addUtf8Info((String)var1_1);
        }
    }

    public List<AttributeInfo> getAttributes() {
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        return this.attribute;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeInfo getAttribute(String name) {
        void var1_1;
        return AttributeInfo.lookup(this.attribute, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AttributeInfo removeAttribute(String name) {
        void var1_1;
        return AttributeInfo.remove(this.attribute, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addAttribute(AttributeInfo info) {
        void var1_1;
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        AttributeInfo.remove(this.attribute, info.getName());
        this.attribute.add((AttributeInfo)var1_1);
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        AttributeInfo attributeInfo = AttributeInfo.lookup(this.attribute, "Exceptions");
        return (ExceptionsAttribute)attributeInfo;
    }

    public CodeAttribute getCodeAttribute() {
        AttributeInfo attributeInfo = AttributeInfo.lookup(this.attribute, "Code");
        return (CodeAttribute)attributeInfo;
    }

    public void removeExceptionsAttribute() {
        AttributeInfo.remove(this.attribute, "Exceptions");
    }

    /*
     * WARNING - void declaration
     */
    public void setExceptionsAttribute(ExceptionsAttribute cattr) {
        void var1_1;
        this.removeExceptionsAttribute();
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        this.attribute.add((AttributeInfo)var1_1);
    }

    public void removeCodeAttribute() {
        AttributeInfo.remove(this.attribute, "Code");
    }

    /*
     * WARNING - void declaration
     */
    public void setCodeAttribute(CodeAttribute cattr) {
        void var1_1;
        this.removeCodeAttribute();
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        this.attribute.add((AttributeInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void rebuildStackMapIf6(ClassPool pool, ClassFile cf) throws BadBytecode {
        if (cf.getMajorVersion() >= 50) {
            this.rebuildStackMap(pool);
        }
        if (doPreverify) {
            void var1_1;
            this.rebuildStackMapForME((ClassPool)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rebuildStackMap(ClassPool pool) throws BadBytecode {
        CodeAttribute ca = this.getCodeAttribute();
        if (ca != null) {
            void var1_1;
            void var2_2;
            StackMapTable smt = MapMaker.make(pool, this);
            var2_2.setAttribute((StackMapTable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rebuildStackMapForME(ClassPool pool) throws BadBytecode {
        CodeAttribute ca = this.getCodeAttribute();
        if (ca != null) {
            void var1_1;
            void var2_2;
            StackMap sm = MapMaker.make2(pool, this);
            var2_2.setAttribute((StackMap)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getLineNumber(int pos) {
        void var1_1;
        void var2_2;
        CodeAttribute ca = this.getCodeAttribute();
        if (ca == null) {
            return -1;
        }
        LineNumberAttribute ainfo = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
        if (ainfo == null) {
            return -1;
        }
        return var2_2.toLineNumber((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSuperclass(String superclass) throws BadBytecode {
        if (!this.isConstructor()) {
            return;
        }
        Opcode ca = this.getCodeAttribute();
        byte[] code = ca.getCode();
        int pos = ((CodeIterator)(ca = ca.iterator())).skipSuperConstructor();
        if (pos >= 0) {
            void var2_4;
            void var3_5;
            int n2;
            ConstPool cp = this.constPool;
            int mref = ByteArray.readU16bit(code, pos + 1);
            int nt = cp.getMethodrefNameAndType(mref);
            int sc = cp.addClassInfo(superclass);
            n2 = cp.addMethodrefInfo(n2, nt);
            ByteArray.write16bit(n2, (byte[])var3_5, (int)(var2_4 + true));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void read(MethodInfo src, String methodname, Map<String, String> classnames) {
        CodeAttribute cattr;
        ConstPool destCp = this.constPool;
        this.accessFlags = src.accessFlags;
        this.name = destCp.addUtf8Info((String)methodname);
        this.cachedName = methodname;
        methodname = src.constPool;
        methodname = ((ConstPool)methodname).getUtf8Info(src.descriptor);
        String desc2 = Descriptor.rename((String)methodname, classnames);
        this.descriptor = destCp.addUtf8Info(desc2);
        this.attribute = new ArrayList<AttributeInfo>();
        ExceptionsAttribute eattr = src.getExceptionsAttribute();
        if (eattr != null) {
            void var2_2;
            this.attribute.add(var2_2.copy(destCp, classnames));
        }
        if ((cattr = src.getCodeAttribute()) != null) {
            void var3_3;
            void var1_1;
            this.attribute.add(var1_1.copy(destCp, (Map<String, String>)var3_3));
        }
    }

    private void read(DataInputStream in) throws IOException {
        this.accessFlags = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.descriptor = in.readUnsignedShort();
        int n2 = in.readUnsignedShort();
        this.attribute = new ArrayList<AttributeInfo>();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute.add(AttributeInfo.read(this.constPool, in));
        }
    }

    /*
     * WARNING - void declaration
     */
    void write(DataOutputStream out) throws IOException {
        void var1_1;
        out.writeShort(this.accessFlags);
        out.writeShort(this.name);
        out.writeShort(this.descriptor);
        if (this.attribute == null) {
            out.writeShort(0);
            return;
        }
        out.writeShort(this.attribute.size());
        AttributeInfo.writeAll(this.attribute, (DataOutputStream)var1_1);
    }
}

