/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class LocalVariableAttribute
extends AttributeInfo {
    public static final String tag = "LocalVariableTable";
    public static final String typeTag = "LocalVariableTypeTable";

    /*
     * WARNING - void declaration
     */
    public LocalVariableAttribute(ConstPool cp) {
        super((ConstPool)var1_1, tag, new byte[2]);
        void var1_1;
        ByteArray.write16bit(0, this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public LocalVariableAttribute(ConstPool cp, String name) {
        super((ConstPool)var1_1, (String)var2_2, new byte[2]);
        void var2_2;
        void var1_1;
        ByteArray.write16bit(0, this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    LocalVariableAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    LocalVariableAttribute(ConstPool cp, String name, byte[] i2) {
        super((ConstPool)var1_1, (String)var2_2, (byte[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addEntry(int startPc, int length, int nameIndex, int descriptorIndex, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        int size = this.info.length;
        byte[] newInfo = new byte[size + 10];
        ByteArray.write16bit(this.tableLength() + 1, newInfo, 0);
        for (int i2 = 2; i2 < size; ++i2) {
            newInfo[i2] = this.info[i2];
        }
        ByteArray.write16bit((int)var1_1, newInfo, size);
        ByteArray.write16bit((int)var2_2, newInfo, size + 2);
        ByteArray.write16bit((int)var3_3, newInfo, size + 4);
        ByteArray.write16bit(descriptorIndex, newInfo, size + 6);
        ByteArray.write16bit(index, newInfo, size + 8);
        this.info = newInfo;
    }

    @Override
    void renameClass(String oldname, String newname) {
        ConstPool cp = this.getConstPool();
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int pos = i2 * 10 + 2;
            int index = ByteArray.readU16bit(this.info, pos + 6);
            if (index == 0) continue;
            String desc = cp.getUtf8Info(index);
            desc = this.renameEntry(desc, oldname, newname);
            ByteArray.write16bit(cp.addUtf8Info(desc), this.info, pos + 6);
        }
    }

    /*
     * WARNING - void declaration
     */
    String renameEntry(String desc, String oldname, String newname) {
        void var3_3;
        void var2_2;
        return Descriptor.rename(desc, (String)var2_2, (String)var3_3);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        ConstPool cp = this.getConstPool();
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int pos = i2 * 10 + 2;
            int index = ByteArray.readU16bit(this.info, pos + 6);
            if (index == 0) continue;
            String desc = cp.getUtf8Info(index);
            desc = this.renameEntry(desc, classnames);
            ByteArray.write16bit(cp.addUtf8Info(desc), this.info, pos + 6);
        }
    }

    /*
     * WARNING - void declaration
     */
    String renameEntry(String desc, Map<String, String> classnames) {
        void var2_2;
        return Descriptor.rename(desc, (Map<String, String>)var2_2);
    }

    public void shiftIndex(int lessThan, int delta) {
        int size = this.info.length;
        for (int i2 = 2; i2 < size; i2 += 10) {
            int org = ByteArray.readU16bit(this.info, i2 + 8);
            if (org < lessThan) continue;
            ByteArray.write16bit(org + delta, this.info, i2 + 8);
        }
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int startPc(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)(var1_1 * 10 + 2));
    }

    /*
     * WARNING - void declaration
     */
    public int codeLength(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)(var1_1 * 10 + 4));
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int pos = i2 * 10 + 2;
            int pc = ByteArray.readU16bit(this.info, pos);
            int len = ByteArray.readU16bit(this.info, pos + 2);
            if (pc > where || exclusive && pc == where && pc != 0) {
                ByteArray.write16bit(pc + gapLength, this.info, pos);
                continue;
            }
            if (pc + len <= where && (!exclusive || pc + len != where)) continue;
            ByteArray.write16bit(len + gapLength, this.info, pos + 2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int nameIndex(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)(var1_1 * 10 + 6));
    }

    /*
     * WARNING - void declaration
     */
    public String variableName(int i2) {
        void var1_1;
        return this.getConstPool().getUtf8Info(this.nameIndex((int)var1_1));
    }

    public String variableNameByIndex(int index) {
        for (int i2 = 0; i2 < this.tableLength(); ++i2) {
            if (this.index(i2) != index) continue;
            return this.variableName(i2);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    public int descriptorIndex(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)(var1_1 * 10 + 8));
    }

    /*
     * WARNING - void declaration
     */
    public int signatureIndex(int i2) {
        void var1_1;
        return this.descriptorIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String descriptor(int i2) {
        void var1_1;
        return this.getConstPool().getUtf8Info(this.descriptorIndex((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String signature(int i2) {
        void var1_1;
        return this.descriptor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int index(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)(var1_1 * 10 + 10));
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        byte[] src = this.get();
        byte[] dest = new byte[src.length];
        ConstPool cp = this.getConstPool();
        LocalVariableAttribute attr = this.makeThisAttr(newCp, dest);
        int n2 = ByteArray.readU16bit(src, 0);
        ByteArray.write16bit(n2, dest, 0);
        int j2 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int start2 = ByteArray.readU16bit(src, j2);
            int len = ByteArray.readU16bit(src, j2 + 2);
            int name = ByteArray.readU16bit(src, j2 + 4);
            int type = ByteArray.readU16bit(src, j2 + 6);
            int index = ByteArray.readU16bit(src, j2 + 8);
            ByteArray.write16bit(start2, dest, j2);
            ByteArray.write16bit(len, dest, j2 + 2);
            if (name != 0) {
                name = cp.copy(name, newCp, null);
            }
            ByteArray.write16bit(name, dest, j2 + 4);
            if (type != 0) {
                String start2 = cp.getUtf8Info(type);
                String sig = Descriptor.rename(start2, classnames);
                type = newCp.addUtf8Info(sig);
            }
            ByteArray.write16bit(type, dest, j2 + 6);
            ByteArray.write16bit(index, dest, j2 + 8);
            j2 += 10;
        }
        return attr;
    }

    /*
     * WARNING - void declaration
     */
    LocalVariableAttribute makeThisAttr(ConstPool cp, byte[] dest) {
        void var2_2;
        void var1_1;
        return new LocalVariableAttribute((ConstPool)var1_1, tag, (byte[])var2_2);
    }
}

