/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Mnemonic;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import java.io.PrintStream;

public class InstructionPrinter
implements Opcode {
    private static final String[] opcodes = Mnemonic.OPCODE;
    private final PrintStream stream;

    /*
     * WARNING - void declaration
     */
    public InstructionPrinter(PrintStream stream) {
        void var1_1;
        this.stream = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void print(CtMethod method, PrintStream stream) {
        CtMethod ctMethod;
        void var1_1;
        new InstructionPrinter((PrintStream)var1_1).print(ctMethod);
    }

    /*
     * WARNING - void declaration
     */
    public void print(CtMethod method) {
        MethodInfo info = method.getMethodInfo2();
        ConstPool pool = info.getConstPool();
        CodeAttribute code = info.getCodeAttribute();
        if (code == null) {
            return;
        }
        CodeIterator iterator2 = code.iterator();
        while (iterator2.hasNext()) {
            void var3_4;
            void var1_1;
            int pos;
            try {
                pos = iterator2.next();
            }
            catch (BadBytecode e2) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            this.stream.println(pos + ": " + InstructionPrinter.instructionString((CodeIterator)var1_1, (int)var3_4, pool));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String instructionString(CodeIterator iter, int pos, ConstPool pool) {
        void var3_3;
        int opcode = iter.byteAt(pos);
        if (opcode > opcodes.length || opcode < 0) {
            throw new IllegalArgumentException("Invalid opcode, opcode: " + opcode + " pos: " + pos);
        }
        String opstring = opcodes[opcode];
        switch (var3_3) {
            case 16: {
                return opstring + " " + iter.byteAt(pos + 1);
            }
            case 17: {
                return opstring + " " + iter.s16bitAt(pos + 1);
            }
            case 18: {
                return opstring + " " + InstructionPrinter.ldc(pool, iter.byteAt(pos + 1));
            }
            case 19: 
            case 20: {
                return opstring + " " + InstructionPrinter.ldc(pool, iter.u16bitAt(pos + 1));
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return opstring + " " + iter.byteAt(pos + 1);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return opstring + " " + (iter.s16bitAt(pos + 1) + pos);
            }
            case 132: {
                return opstring + " " + iter.byteAt(pos + 1) + ", " + iter.signedByteAt(pos + 2);
            }
            case 167: 
            case 168: {
                return opstring + " " + (iter.s16bitAt(pos + 1) + pos);
            }
            case 169: {
                return opstring + " " + iter.byteAt(pos + 1);
            }
            case 170: {
                return InstructionPrinter.tableSwitch(iter, pos);
            }
            case 171: {
                return InstructionPrinter.lookupSwitch(iter, pos);
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return opstring + " " + InstructionPrinter.fieldInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 182: 
            case 183: 
            case 184: {
                return opstring + " " + InstructionPrinter.methodInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 185: {
                return opstring + " " + InstructionPrinter.interfaceMethodInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 186: {
                return opstring + " " + iter.u16bitAt(pos + 1);
            }
            case 187: {
                return opstring + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 188: {
                return opstring + " " + InstructionPrinter.arrayInfo(iter.byteAt(pos + 1));
            }
            case 189: 
            case 192: {
                return opstring + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos + 1));
            }
            case 196: {
                return InstructionPrinter.wide(iter, pos);
            }
            case 197: {
                void var2_2;
                return opstring + " " + InstructionPrinter.classInfo((ConstPool)var2_2, iter.u16bitAt(pos + 1));
            }
            case 200: 
            case 201: {
                void var1_1;
                CodeIterator codeIterator;
                return opstring + " " + (codeIterator.s32bitAt(pos + 1) + var1_1);
            }
        }
        return opstring;
    }

    /*
     * WARNING - void declaration
     */
    private static String wide(CodeIterator iter, int pos) {
        void var1_2;
        int opcode = iter.byteAt(pos + 1);
        int index = iter.u16bitAt((int)(var1_2 + 2));
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                void var0_1;
                void var2_3;
                return opcodes[var2_3] + " " + (int)var0_1;
            }
        }
        throw new RuntimeException("Invalid WIDE operand");
    }

    private static String arrayInfo(int type) {
        switch (type) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
        }
        throw new RuntimeException("Invalid array type");
    }

    /*
     * WARNING - void declaration
     */
    private static String classInfo(ConstPool pool, int index) {
        void var1_1;
        ConstPool constPool;
        return "#" + index + " = Class " + constPool.getClassInfo((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String interfaceMethodInfo(ConstPool pool, int index) {
        void var1_1;
        ConstPool constPool;
        return "#" + index + " = Method " + pool.getInterfaceMethodrefClassName(index) + "." + pool.getInterfaceMethodrefName(index) + "(" + constPool.getInterfaceMethodrefType((int)var1_1) + ")";
    }

    /*
     * WARNING - void declaration
     */
    private static String methodInfo(ConstPool pool, int index) {
        void var1_1;
        ConstPool constPool;
        return "#" + index + " = Method " + pool.getMethodrefClassName(index) + "." + pool.getMethodrefName(index) + "(" + constPool.getMethodrefType((int)var1_1) + ")";
    }

    /*
     * WARNING - void declaration
     */
    private static String fieldInfo(ConstPool pool, int index) {
        void var1_1;
        ConstPool constPool;
        return "#" + index + " = Field " + pool.getFieldrefClassName(index) + "." + pool.getFieldrefName(index) + "(" + constPool.getFieldrefType((int)var1_1) + ")";
    }

    /*
     * WARNING - void declaration
     */
    private static String lookupSwitch(CodeIterator iter, int pos) {
        void var2_2;
        StringBuilder buffer = new StringBuilder("lookupswitch {\n");
        int index = (pos & 0xFFFFFFFC) + 4;
        buffer.append("\t\tdefault: ").append(pos + iter.s32bitAt(index)).append('\n');
        int n2 = iter.s32bitAt(index += 4);
        int end = (n2 << 3) + (index += 4);
        while (index < end) {
            int match = iter.s32bitAt(index);
            int target = iter.s32bitAt(index + 4) + pos;
            buffer.append("\t\t").append(match).append(": ").append(target).append('\n');
            index += 8;
        }
        StringBuilder stringBuilder = buffer;
        stringBuilder.setCharAt(stringBuilder.length() - 1, '}');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String tableSwitch(CodeIterator iter, int pos) {
        void var2_2;
        StringBuilder buffer = new StringBuilder("tableswitch {\n");
        int index = (pos & 0xFFFFFFFC) + 4;
        buffer.append("\t\tdefault: ").append(pos + iter.s32bitAt(index)).append('\n');
        int low = iter.s32bitAt(index += 4);
        int n2 = iter.s32bitAt(index += 4);
        int end = (n2 - low + 1 << 2) + (index += 4);
        int key = low;
        while (index < end) {
            int target = iter.s32bitAt(index) + pos;
            buffer.append("\t\t").append(key).append(": ").append(target).append('\n');
            index += 4;
            ++key;
        }
        StringBuilder stringBuilder = buffer;
        stringBuilder.setCharAt(stringBuilder.length() - 1, '}');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String ldc(ConstPool pool, int index) {
        void var2_2;
        int tag = pool.getTag(index);
        switch (tag) {
            case 8: {
                return "#" + index + " = \"" + pool.getStringInfo(index) + "\"";
            }
            case 3: {
                return "#" + index + " = int " + pool.getIntegerInfo(index);
            }
            case 4: {
                return "#" + index + " = float " + pool.getFloatInfo(index);
            }
            case 5: {
                return "#" + index + " = long " + pool.getLongInfo(index);
            }
            case 6: {
                return "#" + index + " = double " + pool.getDoubleInfo(index);
            }
            case 7: {
                void var1_1;
                ConstPool constPool;
                return InstructionPrinter.classInfo(constPool, (int)var1_1);
            }
        }
        throw new RuntimeException("bad LDC: " + (int)var2_2);
    }
}

