/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstantAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FieldInfo {
    ConstPool constPool;
    int accessFlags;
    int name;
    String cachedName;
    String cachedType;
    int descriptor;
    List<AttributeInfo> attribute;

    /*
     * WARNING - void declaration
     */
    private FieldInfo(ConstPool cp) {
        void var1_1;
        this.constPool = var1_1;
        this.accessFlags = 0;
        this.attribute = null;
    }

    /*
     * WARNING - void declaration
     */
    public FieldInfo(ConstPool cp, String fieldName, String desc) {
        this(cp);
        void var3_3;
        void var1_1;
        void var2_2;
        this.name = cp.addUtf8Info(fieldName);
        this.cachedName = var2_2;
        this.descriptor = var1_1.addUtf8Info((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    FieldInfo(ConstPool cp, DataInputStream in) throws IOException {
        this((ConstPool)var1_1);
        void var2_2;
        void var1_1;
        this.read((DataInputStream)var2_2);
    }

    public final String toString() {
        return this.getName() + " " + this.getDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    final void compact(ConstPool cp) {
        void var1_1;
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.attribute = AttributeInfo.copyAll(this.attribute, cp);
        this.constPool = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void prune(ConstPool cp) {
        void var1_1;
        void var2_2;
        int index;
        AttributeInfo signature;
        AttributeInfo visibleAnnotations;
        ArrayList<AttributeInfo> newAttributes = new ArrayList<AttributeInfo>();
        AttributeInfo invisibleAnnotations = this.getAttribute("RuntimeInvisibleAnnotations");
        if (invisibleAnnotations != null) {
            invisibleAnnotations = invisibleAnnotations.copy(cp, null);
            newAttributes.add(invisibleAnnotations);
        }
        if ((visibleAnnotations = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            visibleAnnotations = visibleAnnotations.copy(cp, null);
            newAttributes.add(visibleAnnotations);
        }
        if ((signature = this.getAttribute("Signature")) != null) {
            signature = signature.copy(cp, null);
            newAttributes.add(signature);
        }
        if ((index = this.getConstantValue()) != 0) {
            void var3_4;
            index = this.constPool.copy(index, cp, null);
            newAttributes.add(new ConstantAttribute(cp, (int)var3_4));
        }
        this.attribute = var2_2;
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.constPool = var1_1;
    }

    public final ConstPool getConstPool() {
        return this.constPool;
    }

    public final String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.constPool.getUtf8Info(this.name);
        }
        return this.cachedName;
    }

    /*
     * WARNING - void declaration
     */
    public final void setName(String newName) {
        void var1_1;
        this.name = this.constPool.addUtf8Info(newName);
        this.cachedName = var1_1;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccessFlags(int acc) {
        void var1_1;
        this.accessFlags = var1_1;
    }

    public final String getDescriptor() {
        return this.constPool.getUtf8Info(this.descriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final void setDescriptor(String desc) {
        if (!desc.equals(this.getDescriptor())) {
            void var1_1;
            this.descriptor = this.constPool.addUtf8Info((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getConstantValue() {
        void var1_1;
        if ((this.accessFlags & 8) == 0) {
            return 0;
        }
        ConstantAttribute attr = (ConstantAttribute)this.getAttribute("ConstantValue");
        if (attr == null) {
            return 0;
        }
        return var1_1.getConstantValue();
    }

    public final List<AttributeInfo> getAttributes() {
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        return this.attribute;
    }

    /*
     * WARNING - void declaration
     */
    public final AttributeInfo getAttribute(String name) {
        void var1_1;
        return AttributeInfo.lookup(this.attribute, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final AttributeInfo removeAttribute(String name) {
        void var1_1;
        return AttributeInfo.remove(this.attribute, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addAttribute(AttributeInfo info) {
        void var1_1;
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        AttributeInfo.remove(this.attribute, info.getName());
        this.attribute.add((AttributeInfo)var1_1);
    }

    private void read(DataInputStream in) throws IOException {
        this.accessFlags = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.descriptor = in.readUnsignedShort();
        int n2 = in.readUnsignedShort();
        this.attribute = new ArrayList<AttributeInfo>();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute.add(AttributeInfo.read(this.constPool, in));
        }
    }

    /*
     * WARNING - void declaration
     */
    final void write(DataOutputStream out) throws IOException {
        void var1_1;
        out.writeShort(this.accessFlags);
        out.writeShort(this.name);
        out.writeShort(this.descriptor);
        if (this.attribute == null) {
            out.writeShort(0);
            return;
        }
        out.writeShort(this.attribute.size());
        AttributeInfo.writeAll(this.attribute, (DataOutputStream)var1_1);
    }
}

