/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTableEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExceptionTable
implements Cloneable {
    private ConstPool constPool;
    private List<ExceptionTableEntry> entries;

    /*
     * WARNING - void declaration
     */
    public ExceptionTable(ConstPool cp) {
        void var1_1;
        this.constPool = var1_1;
        this.entries = new ArrayList<ExceptionTableEntry>();
    }

    /*
     * WARNING - void declaration
     */
    ExceptionTable(ConstPool cp, DataInputStream in) throws IOException {
        void var3_4;
        this.constPool = cp;
        int length = in.readUnsignedShort();
        ArrayList<ExceptionTableEntry> list = new ArrayList<ExceptionTableEntry>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            int start = in.readUnsignedShort();
            int end = in.readUnsignedShort();
            int handle = in.readUnsignedShort();
            int type = in.readUnsignedShort();
            list.add(new ExceptionTableEntry(start, end, handle, type));
        }
        this.entries = var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() throws CloneNotSupportedException {
        void var1_1;
        ExceptionTable r2 = (ExceptionTable)super.clone();
        ((ExceptionTable)super.clone()).entries = new ArrayList<ExceptionTableEntry>(this.entries);
        return var1_1;
    }

    public int size() {
        return this.entries.size();
    }

    /*
     * WARNING - void declaration
     */
    public int startPc(int nth) {
        void var1_1;
        return this.entries.get((int)var1_1).startPc;
    }

    /*
     * WARNING - void declaration
     */
    public void setStartPc(int nth, int value) {
        void var2_2;
        this.entries.get((int)var1_1).startPc = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int endPc(int nth) {
        void var1_1;
        return this.entries.get((int)var1_1).endPc;
    }

    /*
     * WARNING - void declaration
     */
    public void setEndPc(int nth, int value) {
        void var2_2;
        this.entries.get((int)var1_1).endPc = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int handlerPc(int nth) {
        void var1_1;
        return this.entries.get((int)var1_1).handlerPc;
    }

    /*
     * WARNING - void declaration
     */
    public void setHandlerPc(int nth, int value) {
        void var2_2;
        this.entries.get((int)var1_1).handlerPc = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int catchType(int nth) {
        void var1_1;
        return this.entries.get((int)var1_1).catchType;
    }

    /*
     * WARNING - void declaration
     */
    public void setCatchType(int nth, int value) {
        void var2_2;
        this.entries.get((int)var1_1).catchType = var2_2;
    }

    public void add(int index, ExceptionTable table, int offset) {
        int len = table.size();
        while (--len >= 0) {
            ExceptionTableEntry e2 = table.entries.get(len);
            this.add(index, e2.startPc + offset, e2.endPc + offset, e2.handlerPc + offset, e2.catchType);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(int index, int start, int end, int handler, int type) {
        if (start < end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.entries.add((int)var1_1, new ExceptionTableEntry((int)var2_2, (int)var3_3, handler, type));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(int start, int end, int handler, int type) {
        if (start < end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.entries.add(new ExceptionTableEntry((int)var1_1, (int)var2_2, (int)var3_3, type));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void remove(int index) {
        void var1_1;
        this.entries.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExceptionTable copy(ConstPool newCp, Map<String, String> classnames) {
        void var3_3;
        ExceptionTable et = new ExceptionTable(newCp);
        ConstPool srcCp = this.constPool;
        for (ExceptionTableEntry e2 : this.entries) {
            int type = srcCp.copy(e2.catchType, newCp, classnames);
            et.add(e2.startPc, e2.endPc, e2.handlerPc, type);
        }
        return var3_3;
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        for (ExceptionTableEntry e2 : this.entries) {
            var4_4.next().startPc = ExceptionTable.shiftPc(e2.startPc, where, gapLength, exclusive);
            e2.endPc = ExceptionTable.shiftPc(e2.endPc, where, gapLength, exclusive);
            e2.handlerPc = ExceptionTable.shiftPc(e2.handlerPc, where, gapLength, exclusive);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int shiftPc(int pc, int where, int gapLength, boolean exclusive) {
        int n2;
        void var1_1;
        void var3_3;
        if (pc > where || var3_3 != false && pc == var1_1) {
            void var2_2;
            pc += var2_2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.size());
        for (ExceptionTableEntry e2 : this.entries) {
            void var3_3;
            out.writeShort(e2.startPc);
            out.writeShort(e2.endPc);
            out.writeShort(e2.handlerPc);
            out.writeShort(var3_3.catchType);
        }
    }
}

