/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtPrimitiveType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import java.util.Map;

public class Descriptor {
    public static String toJvmName(String classname) {
        return classname.replace('.', '/');
    }

    public static String toJavaName(String classname) {
        return classname.replace('/', '.');
    }

    public static String toJvmName(CtClass clazz) {
        CtClass ctClass;
        if (clazz.isArray()) {
            return Descriptor.of(clazz);
        }
        return Descriptor.toJvmName(ctClass.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String toClassName(String descriptor) {
        void var3_4;
        void var2_2;
        void name;
        String name2;
        int arrayDim = 0;
        int i2 = 0;
        char c2 = descriptor.charAt(0);
        while (c2 == '[') {
            ++arrayDim;
            c2 = descriptor.charAt(++i2);
        }
        if (c2 == 'L') {
            int i22 = descriptor.indexOf(59, i2++);
            name2 = descriptor.substring(i2, i22).replace('/', '.');
            i2 = i22;
        } else if (name == 86) {
            name2 = "void";
        } else if (name == 73) {
            name2 = "int";
        } else if (name == 66) {
            name2 = "byte";
        } else if (name == 74) {
            name2 = "long";
        } else if (name == 68) {
            name2 = "double";
        } else if (name == 70) {
            name2 = "float";
        } else if (name == 67) {
            name2 = "char";
        } else if (name == 83) {
            name2 = "short";
        } else if (name == 90) {
            name2 = "boolean";
        } else {
            throw new RuntimeException("bad descriptor: " + descriptor);
        }
        if (var2_2 + true != descriptor.length()) {
            String string;
            throw new RuntimeException("multiple descriptors?: " + string);
        }
        if (arrayDim == 0) {
            return name2;
        }
        StringBuilder sbuf = new StringBuilder((String)var3_4);
        do {
            sbuf.append("[]");
        } while (--arrayDim > 0);
        return sbuf.toString();
    }

    public static String of(String classname) {
        String string;
        if (classname.equals("void")) {
            return "V";
        }
        if (classname.equals("int")) {
            return "I";
        }
        if (classname.equals("byte")) {
            return "B";
        }
        if (classname.equals("long")) {
            return "J";
        }
        if (classname.equals("double")) {
            return "D";
        }
        if (classname.equals("float")) {
            return "F";
        }
        if (classname.equals("char")) {
            return "C";
        }
        if (classname.equals("short")) {
            return "S";
        }
        if (classname.equals("boolean")) {
            return "Z";
        }
        return "L" + Descriptor.toJvmName(string) + ";";
    }

    /*
     * WARNING - void declaration
     */
    public static String rename(String desc, String oldname, String newname) {
        void var3_3;
        int j2;
        if (desc.indexOf(oldname) < 0) {
            return desc;
        }
        StringBuilder newdesc = new StringBuilder();
        int head = 0;
        int i2 = 0;
        while ((j2 = desc.indexOf(76, i2)) >= 0) {
            if (desc.startsWith(oldname, j2 + 1) && desc.charAt(j2 + oldname.length() + 1) == ';') {
                newdesc.append(desc.substring(head, j2));
                newdesc.append('L');
                newdesc.append(newname);
                newdesc.append(';');
                head = j2 = j2 + oldname.length() + 2;
                continue;
            }
            if ((j2 = desc.indexOf(59, j2) + 1) > 0) continue;
            break;
        }
        if (head == 0) {
            return desc;
        }
        int len = desc.length();
        if (head < len) {
            String string;
            newdesc.append(string.substring(head, len));
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String rename(String desc, Map<String, String> map) {
        void var2_2;
        int k2;
        int j2;
        if (map == null) {
            return desc;
        }
        StringBuilder newdesc = new StringBuilder();
        int head = 0;
        int i2 = 0;
        while ((j2 = desc.indexOf(76, i2)) >= 0 && (k2 = desc.indexOf(59, j2)) >= 0) {
            i2 = k2 + 1;
            String name = desc.substring(j2 + 1, k2);
            String name2 = map.get(name);
            if (name2 == null) continue;
            newdesc.append(desc.substring(head, j2));
            newdesc.append('L');
            newdesc.append(name2);
            newdesc.append(';');
            head = i2;
        }
        if (head == 0) {
            return desc;
        }
        int len = desc.length();
        if (head < len) {
            void var3_3;
            String string;
            newdesc.append(string.substring((int)var3_3, len));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String of(CtClass type) {
        void var1_1;
        CtClass ctClass;
        StringBuilder sbuf = new StringBuilder();
        Descriptor.toDescriptor(sbuf, ctClass);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void toDescriptor(StringBuilder desc, CtClass type) {
        StringBuilder stringBuilder;
        void var1_1;
        String name;
        if (type.isArray()) {
            desc.append('[');
            try {
                Descriptor.toDescriptor(desc, type.getComponentType());
                return;
            }
            catch (NotFoundException notFoundException) {
                desc.append('L');
                name = type.getName();
                desc.append(Descriptor.toJvmName(name.substring(0, name.length() - 2)));
                desc.append(';');
                return;
            }
        }
        if (((CtClass)((Object)name)).isPrimitive()) {
            CtPrimitiveType pt = (CtPrimitiveType)((Object)name);
            desc.append(var1_1.getDescriptor());
            return;
        }
        desc.append('L');
        desc.append(var1_1.getName().replace('.', '/'));
        stringBuilder.append(';');
    }

    public static String ofConstructor(CtClass[] paramTypes) {
        CtClass[] ctClassArray;
        return Descriptor.ofMethod(CtClass.voidType, ctClassArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String ofMethod(CtClass returnType, CtClass[] paramTypes) {
        void var2_2;
        StringBuilder desc = new StringBuilder();
        desc.append('(');
        if (paramTypes != null) {
            int n2 = paramTypes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Descriptor.toDescriptor(desc, paramTypes[i2]);
            }
        }
        desc.append(')');
        if (returnType != null) {
            CtClass ctClass;
            Descriptor.toDescriptor(desc, ctClass);
        }
        return var2_2.toString();
    }

    public static String ofParameters(CtClass[] paramTypes) {
        CtClass[] ctClassArray;
        return Descriptor.ofMethod(null, ctClassArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendParameter(String classname, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        int i2 = desc.indexOf(41);
        if (i2 < 0) {
            return desc;
        }
        StringBuilder newdesc = new StringBuilder();
        newdesc.append(desc.substring(0, i2));
        newdesc.append('L');
        newdesc.append(string.replace('.', '/'));
        newdesc.append(';');
        newdesc.append(var1_1.substring((int)var2_2));
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String insertParameter(String classname, String desc) {
        void var1_1;
        String string;
        if (desc.charAt(0) != '(') {
            return desc;
        }
        return "(L" + string.replace('.', '/') + ';' + var1_1.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendParameter(CtClass type, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        CtClass ctClass;
        int i2 = descriptor.indexOf(41);
        if (i2 < 0) {
            return descriptor;
        }
        StringBuilder newdesc = new StringBuilder();
        newdesc.append(descriptor.substring(0, i2));
        Descriptor.toDescriptor(newdesc, ctClass);
        newdesc.append(var1_1.substring((int)var2_2));
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String insertParameter(CtClass type, String descriptor) {
        void var1_1;
        CtClass ctClass;
        if (descriptor.charAt(0) != '(') {
            return descriptor;
        }
        return "(" + Descriptor.of(ctClass) + var1_1.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    public static String changeReturnType(String classname, String desc) {
        void var3_3;
        String string;
        void var2_2;
        void var1_1;
        int i2 = desc.indexOf(41);
        if (i2 < 0) {
            return desc;
        }
        StringBuilder newdesc = new StringBuilder();
        newdesc.append(var1_1.substring(0, (int)(var2_2 + true)));
        newdesc.append('L');
        newdesc.append(string.replace('.', '/'));
        newdesc.append(';');
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass[] getParameterTypes(String desc, ClassPool cp) throws NotFoundException {
        void var2_3;
        if (desc.charAt(0) != '(') {
            return null;
        }
        int n2 = Descriptor.numOfParameters(desc);
        CtClass[] args2 = new CtClass[n2];
        int n3 = 0;
        int i2 = 1;
        while ((i2 = Descriptor.toCtClass(cp, desc, i2, args2, n3++)) > 0) {
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean eqParamTypes(String desc1, String desc2) {
        if (desc1.charAt(0) != '(') {
            return false;
        }
        int i2 = 0;
        char c2;
        while ((c2 = desc1.charAt(i2)) == desc2.charAt(i2)) {
            void var3_3;
            if (var3_3 == 41) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static String getParamDescriptor(String decl) {
        String string;
        return decl.substring(0, string.indexOf(41) + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass getReturnType(String desc, ClassPool cp) throws NotFoundException {
        void var3_3;
        void var2_2;
        String string;
        void var1_1;
        int i2 = desc.indexOf(41);
        if (i2 < 0) {
            return null;
        }
        CtClass[] type = new CtClass[1];
        Descriptor.toCtClass((ClassPool)var1_1, string, (int)(var2_2 + true), type, 0);
        return var3_3[0];
    }

    /*
     * WARNING - void declaration
     */
    public static int numOfParameters(String desc) {
        void var1_1;
        char c2;
        int n2 = 0;
        int i2 = 1;
        while ((c2 = desc.charAt(i2)) != ')') {
            void var3_3;
            while (c2 == '[') {
                c2 = desc.charAt(++i2);
            }
            if (var3_3 == 76) {
                if ((i2 = desc.indexOf(59, i2) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++i2;
            }
            ++n2;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass toCtClass(String desc, ClassPool cp) throws NotFoundException {
        String string;
        void var1_1;
        CtClass[] clazz = new CtClass[1];
        int n2 = Descriptor.toCtClass(cp, desc, 0, clazz, 0);
        if (n2 >= 0) {
            void var2_2;
            return var2_2[0];
        }
        return var1_1.get(string.replace('/', '.'));
    }

    /*
     * WARNING - void declaration
     */
    private static int toCtClass(ClassPool cp, String desc, int i2, CtClass[] args2, int n2) throws NotFoundException {
        ClassPool classPool;
        String string;
        String name;
        int i22;
        int arrayDim = 0;
        char c2 = desc.charAt(i2);
        while (c2 == '[') {
            ++arrayDim;
            c2 = desc.charAt(++i2);
        }
        if (c2 == 'L') {
            i22 = desc.indexOf(59, ++i2);
            name = desc.substring(i2, i22++).replace('/', '.');
        } else {
            void var2_2;
            CtClass type = Descriptor.toPrimitiveClass((char)i22);
            if (type == null) {
                return -1;
            }
            i22 = var2_2 + true;
            if (arrayDim == 0) {
                args2[n2] = type;
                return i22;
            }
            name = type.getName();
        }
        if (arrayDim > 0) {
            StringBuilder sbuf = new StringBuilder(name);
            while (arrayDim-- > 0) {
                sbuf.append("[]");
            }
            string = ((StringBuilder)((Object)string)).toString();
        }
        var3_3[n2] = classPool.get(string);
        return i22;
    }

    /*
     * WARNING - void declaration
     */
    static CtClass toPrimitiveClass(char c2) {
        void var1_1;
        char c3;
        CtClass type = null;
        switch (c3) {
            case 'Z': {
                type = CtClass.booleanType;
                break;
            }
            case 'C': {
                type = CtClass.charType;
                break;
            }
            case 'B': {
                type = CtClass.byteType;
                break;
            }
            case 'S': {
                type = CtClass.shortType;
                break;
            }
            case 'I': {
                type = CtClass.intType;
                break;
            }
            case 'J': {
                type = CtClass.longType;
                break;
            }
            case 'F': {
                type = CtClass.floatType;
                break;
            }
            case 'D': {
                type = CtClass.doubleType;
                break;
            }
            case 'V': {
                type = CtClass.voidType;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int arrayDimension(String desc) {
        void var1_1;
        int dim = 0;
        while (desc.charAt(dim) == '[') {
            ++dim;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String toArrayComponent(String desc, int dim) {
        void var1_1;
        return desc.substring((int)var1_1);
    }

    public static int dataSize(String desc) {
        return Descriptor.dataSize(desc, true);
    }

    public static int paramSize(String desc) {
        return -Descriptor.dataSize(desc, false);
    }

    /*
     * WARNING - void declaration
     */
    private static int dataSize(String desc, boolean withRet) {
        void var2_2;
        void var1_1;
        int n2 = 0;
        char c2 = desc.charAt(0);
        if (c2 == '(') {
            int i2 = 1;
            while (true) {
                if ((c2 = desc.charAt(i2)) == ')') {
                    c2 = desc.charAt(i2 + 1);
                    break;
                }
                boolean array = false;
                while (c2 == '[') {
                    array = true;
                    c2 = desc.charAt(++i2);
                }
                if (c2 == 'L') {
                    if ((i2 = desc.indexOf(59, i2) + 1) <= 0) {
                        throw new IndexOutOfBoundsException("bad descriptor");
                    }
                } else {
                    ++i2;
                }
                if (!(array || c2 != 'J' && c2 != 'D')) {
                    n2 -= 2;
                    continue;
                }
                --n2;
            }
        }
        if (var1_1 != false) {
            void var3_3;
            if (c2 == 'J' || c2 == 'D') {
                n2 += 2;
            } else if (var3_3 != 86) {
                ++n2;
            }
        }
        return (int)var2_2;
    }

    public static String toString(String desc) {
        return PrettyPrinter.toString(desc);
    }

    static class PrettyPrinter {
        PrettyPrinter() {
        }

        /*
         * WARNING - void declaration
         */
        static String toString(String desc) {
            void var1_1;
            StringBuilder sbuf = new StringBuilder();
            if (desc.charAt(0) == '(') {
                int pos = 1;
                sbuf.append('(');
                while (desc.charAt(pos) != ')') {
                    if (pos > 1) {
                        sbuf.append(',');
                    }
                    pos = PrettyPrinter.readType(sbuf, pos, desc);
                }
                sbuf.append(')');
            } else {
                String string;
                PrettyPrinter.readType(sbuf, 0, string);
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        static int readType(StringBuilder sbuf, int pos, String desc) {
            void var1_1;
            char c2 = desc.charAt(pos);
            int arrayDim = 0;
            while (c2 == '[') {
                ++arrayDim;
                c2 = desc.charAt(++pos);
            }
            if (c2 == 'L') {
                while ((c2 = desc.charAt(++pos)) != ';') {
                    if (c2 == '/') {
                        c2 = '.';
                    }
                    sbuf.append(c2);
                }
            } else {
                void var2_2;
                void var3_3;
                CtClass t2 = Descriptor.toPrimitiveClass((char)var3_3);
                sbuf.append(var2_2.getName());
            }
            while (arrayDim-- > 0) {
                sbuf.append("[]");
            }
            return (int)(var1_1 + true);
        }
    }

    public static class Iterator {
        private String desc;
        private int index;
        private int curPos;
        private boolean param;

        /*
         * WARNING - void declaration
         */
        public Iterator(String s2) {
            void var1_1;
            this.desc = var1_1;
            Iterator iterator2 = this;
            iterator2.curPos = 0;
            iterator2.index = 0;
            this.param = false;
        }

        public boolean hasNext() {
            return this.index < this.desc.length();
        }

        public boolean isParameter() {
            return this.param;
        }

        public char currentChar() {
            return this.desc.charAt(this.curPos);
        }

        /*
         * WARNING - void declaration
         */
        public boolean is2byte() {
            void var1_1;
            char c2 = this.currentChar();
            return c2 == 'D' || var1_1 == 74;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            void var1_1;
            void var2_2;
            int nextPos;
            char c2;
            if ((c2 = this.desc.charAt(nextPos = this.index++)) == '(') {
                c2 = this.desc.charAt(++nextPos);
                this.param = true;
            }
            if (c2 == ')') {
                ++this.index;
                c2 = this.desc.charAt(++nextPos);
                this.param = false;
            }
            while (c2 == '[') {
                c2 = this.desc.charAt(++nextPos);
            }
            if (var2_2 == 76) {
                if ((nextPos = this.desc.indexOf(59, nextPos) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++nextPos;
            }
            this.curPos = this.index;
            this.index = var1_1;
            return this.curPos;
        }
    }
}

