/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteStream;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ClassFileWriter {
    private ByteStream output = new ByteStream(512);
    private ConstPoolWriter constPool;
    private FieldWriter fields;
    private MethodWriter methods;
    int thisClass;
    int superClass;

    /*
     * WARNING - void declaration
     */
    public ClassFileWriter(int major, int minor) {
        void var1_1;
        void var2_2;
        this.output.writeInt(-889275714);
        this.output.writeShort((int)var2_2);
        this.output.writeShort((int)var1_1);
        this.constPool = new ConstPoolWriter(this.output);
        this.fields = new FieldWriter(this.constPool);
        this.methods = new MethodWriter(this.constPool);
    }

    public ConstPoolWriter getConstPool() {
        return this.constPool;
    }

    public FieldWriter getFieldWriter() {
        return this.fields;
    }

    public MethodWriter getMethodWriter() {
        return this.methods;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] end(int accessFlags, int thisClass, int superClass, int[] interfaces, AttributeWriter aw) {
        void var3_3;
        this.constPool.end();
        this.output.writeShort(accessFlags);
        this.output.writeShort(thisClass);
        this.output.writeShort((int)var3_3);
        if (interfaces == null) {
            this.output.writeShort(0);
        } else {
            int n2 = interfaces.length;
            this.output.writeShort(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.output.writeShort(interfaces[i2]);
            }
        }
        this.output.enlarge(this.fields.dataSize() + this.methods.dataSize() + 6);
        try {
            this.output.writeShort(this.fields.size());
            this.fields.write(this.output);
            this.output.writeShort(this.methods.numOfMethods());
            this.methods.write(this.output);
        }
        catch (IOException iOException) {}
        ClassFileWriter.writeAttribute(this.output, aw, 0);
        return this.output.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public void end(DataOutputStream out, int accessFlags, int thisClass, int superClass, int[] interfaces, AttributeWriter aw) throws IOException {
        void var1_1;
        this.constPool.end();
        this.output.writeTo(out);
        out.writeShort(accessFlags);
        out.writeShort(thisClass);
        out.writeShort(superClass);
        if (interfaces == null) {
            out.writeShort(0);
        } else {
            int n2 = interfaces.length;
            out.writeShort(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                out.writeShort(interfaces[i2]);
            }
        }
        out.writeShort(this.fields.size());
        this.fields.write(out);
        out.writeShort(this.methods.numOfMethods());
        this.methods.write(out);
        if (aw == null) {
            out.writeShort(0);
            return;
        }
        out.writeShort(aw.size());
        aw.write((DataOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void writeAttribute(ByteStream bs, AttributeWriter aw, int attrCount) {
        void var2_2;
        if (aw == null) {
            bs.writeShort(attrCount);
            return;
        }
        bs.writeShort(aw.size() + var2_2);
        OutputStream dos = new DataOutputStream(bs);
        try {
            OutputStream outputStream2;
            void var1_1;
            var1_1.write((DataOutputStream)dos);
            ((DataOutputStream)outputStream2).flush();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static final class ConstPoolWriter {
        ByteStream output;
        protected int startPos;
        protected int num;

        /*
         * WARNING - void declaration
         */
        ConstPoolWriter(ByteStream out) {
            void var1_1;
            this.output = out;
            this.startPos = var1_1.getPos();
            this.num = 1;
            this.output.writeShort(1);
        }

        /*
         * WARNING - void declaration
         */
        public final int[] addClassInfo(String[] classNames) {
            void var3_3;
            int n2 = classNames.length;
            int[] result = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                result[i2] = this.addClassInfo(classNames[i2]);
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final int addClassInfo(String jvmname) {
            void var1_2;
            int utf8 = this.addUtf8Info(jvmname);
            this.output.write(7);
            this.output.writeShort((int)var1_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addClassInfo(int name) {
            void var1_1;
            this.output.write(7);
            this.output.writeShort((int)var1_1);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addNameAndTypeInfo(String name, String type) {
            void var2_2;
            void var1_1;
            ConstPoolWriter constPoolWriter = this;
            return constPoolWriter.addNameAndTypeInfo(constPoolWriter.addUtf8Info((String)var1_1), this.addUtf8Info((String)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final int addNameAndTypeInfo(int name, int type) {
            void var2_2;
            void var1_1;
            this.output.write(12);
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addFieldrefInfo(int classInfo, int nameAndTypeInfo) {
            void var2_2;
            void var1_1;
            this.output.write(9);
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addMethodrefInfo(int classInfo, int nameAndTypeInfo) {
            void var2_2;
            void var1_1;
            this.output.write(10);
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo) {
            void var2_2;
            void var1_1;
            this.output.write(11);
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addMethodHandleInfo(int kind, int index) {
            void var2_2;
            void var1_1;
            this.output.write(15);
            this.output.write((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addMethodTypeInfo(int desc) {
            void var1_1;
            this.output.write(16);
            this.output.writeShort((int)var1_1);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addInvokeDynamicInfo(int bootstrap, int nameAndTypeInfo) {
            void var2_2;
            void var1_1;
            this.output.write(18);
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addDynamicInfo(int bootstrap, int nameAndTypeInfo) {
            void var2_2;
            void var1_1;
            this.output.write(17);
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addStringInfo(String str) {
            void var1_2;
            int utf8 = this.addUtf8Info(str);
            this.output.write(8);
            this.output.writeShort((int)var1_2);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addIntegerInfo(int i2) {
            void var1_1;
            this.output.write(3);
            this.output.writeInt((int)var1_1);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addFloatInfo(float f2) {
            void var1_1;
            this.output.write(4);
            this.output.writeFloat((float)var1_1);
            return this.num++;
        }

        /*
         * WARNING - void declaration
         */
        public final int addLongInfo(long l2) {
            void var1_2;
            this.output.write(5);
            this.output.writeLong(l2);
            int n2 = this.num;
            this.num += 2;
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        public final int addDoubleInfo(double d2) {
            void var1_2;
            this.output.write(6);
            this.output.writeDouble(d2);
            int n2 = this.num;
            this.num += 2;
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        public final int addUtf8Info(String utf8) {
            void var1_1;
            this.output.write(1);
            this.output.writeUTF((String)var1_1);
            return this.num++;
        }

        final void end() {
            this.output.writeShort(this.startPos, this.num);
        }
    }

    public static final class FieldWriter {
        protected ByteStream output = new ByteStream(128);
        protected ConstPoolWriter constPool;
        private int fieldCount;

        /*
         * WARNING - void declaration
         */
        FieldWriter(ConstPoolWriter cp) {
            void var1_1;
            this.constPool = var1_1;
            this.fieldCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int accessFlags, String name, String descriptor, AttributeWriter aw) {
            void var3_5;
            void var2_3;
            void var1_1;
            int nameIndex = this.constPool.addUtf8Info(name);
            int descIndex = this.constPool.addUtf8Info(descriptor);
            this.add((int)var1_1, (int)var2_3, (int)var3_5, aw);
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int accessFlags, int name, int descriptor, AttributeWriter aw) {
            void var3_3;
            void var2_2;
            void var1_1;
            ++this.fieldCount;
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            this.output.writeShort((int)var3_3);
            ClassFileWriter.writeAttribute(this.output, aw, 0);
        }

        final int size() {
            return this.fieldCount;
        }

        final int dataSize() {
            return this.output.size();
        }

        /*
         * WARNING - void declaration
         */
        final void write(OutputStream out) throws IOException {
            void var1_1;
            this.output.writeTo((OutputStream)var1_1);
        }
    }

    public static final class MethodWriter {
        protected ByteStream output = new ByteStream(256);
        protected ConstPoolWriter constPool;
        private int methodCount;
        protected int codeIndex;
        protected int throwsIndex;
        protected int stackIndex;
        private int startPos;
        private boolean isAbstract;
        private int catchPos;
        private int catchCount;

        /*
         * WARNING - void declaration
         */
        MethodWriter(ConstPoolWriter cp) {
            void var1_1;
            this.constPool = var1_1;
            this.methodCount = 0;
            this.codeIndex = 0;
            this.throwsIndex = 0;
            this.stackIndex = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final void begin(int accessFlags, String name, String descriptor, String[] exceptions, AttributeWriter aw) {
            void var3_5;
            void var2_3;
            void var1_1;
            int[] intfs;
            int nameIndex = this.constPool.addUtf8Info(name);
            int descIndex = this.constPool.addUtf8Info(descriptor);
            intfs = exceptions == null ? null : this.constPool.addClassInfo((String[])intfs);
            this.begin((int)var1_1, (int)var2_3, (int)var3_5, intfs, aw);
        }

        /*
         * WARNING - void declaration
         */
        public final void begin(int accessFlags, int name, int descriptor, int[] exceptions, AttributeWriter aw) {
            void var1_1;
            int attrCount;
            void var3_3;
            void var2_2;
            ++this.methodCount;
            this.output.writeShort(accessFlags);
            this.output.writeShort((int)var2_2);
            this.output.writeShort((int)var3_3);
            this.isAbstract = (accessFlags & 0x400) != 0;
            int n2 = attrCount = this.isAbstract ? 0 : 1;
            if (exceptions != null) {
                ++attrCount;
            }
            ClassFileWriter.writeAttribute(this.output, aw, (int)var1_1);
            if (exceptions != null) {
                this.writeThrows(exceptions);
            }
            if (!this.isAbstract) {
                if (this.codeIndex == 0) {
                    this.codeIndex = this.constPool.addUtf8Info("Code");
                }
                this.startPos = this.output.getPos();
                this.output.writeShort(this.codeIndex);
                this.output.writeBlank(12);
            }
            this.catchPos = -1;
            this.catchCount = 0;
        }

        private void writeThrows(int[] exceptions) {
            if (this.throwsIndex == 0) {
                this.throwsIndex = this.constPool.addUtf8Info("Exceptions");
            }
            this.output.writeShort(this.throwsIndex);
            this.output.writeInt((exceptions.length << 1) + 2);
            this.output.writeShort(exceptions.length);
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                this.output.writeShort(exceptions[i2]);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int b2) {
            void var1_1;
            this.output.write((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void add16(int b2) {
            void var1_1;
            this.output.writeShort((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void add32(int b2) {
            void var1_1;
            this.output.writeInt((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void addInvoke(int opcode, String targetClass, String methodName, String descriptor) {
            void var2_3;
            void var1_1;
            void var3_5;
            int target = this.constPool.addClassInfo(targetClass);
            int nt = this.constPool.addNameAndTypeInfo(methodName, descriptor);
            int method = this.constPool.addMethodrefInfo(target, (int)var3_5);
            this.add((int)var1_1);
            this.add16((int)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        public final void codeEnd(int maxStack, int maxLocals) {
            if (!this.isAbstract) {
                void var2_2;
                void var1_1;
                this.output.writeShort(this.startPos + 6, (int)var1_1);
                this.output.writeShort(this.startPos + 8, (int)var2_2);
                this.output.writeInt(this.startPos + 10, this.output.getPos() - this.startPos - 14);
                this.catchPos = this.output.getPos();
                this.catchCount = 0;
                this.output.writeShort(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addCatch(int startPc, int endPc, int handlerPc, int catchType) {
            void var3_3;
            void var2_2;
            void var1_1;
            ++this.catchCount;
            this.output.writeShort((int)var1_1);
            this.output.writeShort((int)var2_2);
            this.output.writeShort((int)var3_3);
            this.output.writeShort(catchType);
        }

        /*
         * WARNING - void declaration
         */
        public final void end(StackMapTable.Writer smap, AttributeWriter aw) {
            void var3_3;
            void var2_2;
            if (this.isAbstract) {
                return;
            }
            this.output.writeShort(this.catchPos, this.catchCount);
            boolean attrCount = smap != null;
            ClassFileWriter.writeAttribute(this.output, (AttributeWriter)var2_2, (int)var3_3);
            if (smap != null) {
                void var1_1;
                if (this.stackIndex == 0) {
                    this.stackIndex = this.constPool.addUtf8Info("StackMapTable");
                }
                this.output.writeShort(this.stackIndex);
                byte[] data = smap.toByteArray();
                this.output.writeInt(data.length);
                this.output.write((byte[])var1_1);
            }
            this.output.writeInt(this.startPos + 2, this.output.getPos() - this.startPos - 6);
        }

        public final int size() {
            return this.output.getPos() - this.startPos - 14;
        }

        final int numOfMethods() {
            return this.methodCount;
        }

        final int dataSize() {
            return this.output.size();
        }

        /*
         * WARNING - void declaration
         */
        final void write(OutputStream out) throws IOException {
            void var1_1;
            this.output.writeTo((OutputStream)var1_1);
        }
    }

    public static interface AttributeWriter {
        public int size();

        public void write(DataOutputStream var1) throws IOException;
    }
}

