/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AccessFlag;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AnnotationsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FieldInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ParameterAnnotationsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SignatureAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class ClassFilePrinter {
    public static void print(ClassFile cf) {
        ClassFilePrinter.print(cf, new PrintWriter(System.out, true));
    }

    /*
     * WARNING - void declaration
     */
    public static void print(ClassFile cf, PrintWriter out) {
        void var1_1;
        ClassFile classFile;
        Iterator<MethodInfo> iterator2;
        int mod = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out.println("major: " + cf.major + ", minor: " + cf.minor + " modifiers: " + Integer.toHexString(cf.getAccessFlags()));
        out.println(Modifier.toString(mod) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        Object infs = cf.getInterfaces();
        if (infs != null && ((String[])infs).length > 0) {
            out.print("    implements ");
            out.print(infs[0]);
            for (int i2 = 1; i2 < ((Object)infs).length; ++i2) {
                out.print(", " + (String)infs[i2]);
            }
            out.println();
        }
        out.println();
        List<FieldInfo> i2 = cf.getFields();
        for (FieldInfo finfo : i2) {
            int acc = finfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + finfo.getName() + "\t" + finfo.getDescriptor());
            ClassFilePrinter.printAttributes(((FieldInfo)((Object)iterator2)).getAttributes(), out, 'f');
        }
        out.println();
        infs = cf.getMethods();
        iterator2 = infs.iterator();
        while (iterator2.hasNext()) {
            void var2_4;
            MethodInfo minfo = iterator2.next();
            int acc = minfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier((int)var2_4)) + " " + minfo.getName() + "\t" + minfo.getDescriptor());
            ClassFilePrinter.printAttributes(minfo.getAttributes(), out, 'm');
            out.println();
        }
        out.println();
        ClassFilePrinter.printAttributes(classFile.getAttributes(), (PrintWriter)var1_1, 'c');
    }

    /*
     * WARNING - void declaration
     */
    static void printAttributes(List<AttributeInfo> list, PrintWriter out, char kind) {
        Iterator<AttributeInfo> iterator2;
        if (list == null) {
            return;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            if (ai instanceof CodeAttribute) {
                CodeAttribute ca = (CodeAttribute)ai;
                out.println("attribute: " + ai.getName() + ": " + ai.getClass().getName());
                out.println("max stack " + ca.getMaxStack() + ", max locals " + ca.getMaxLocals() + ", " + ca.getExceptionTable().size() + " catch blocks");
                out.println("<code attribute begin>");
                ClassFilePrinter.printAttributes(ca.getAttributes(), out, kind);
                out.println("<code attribute end>");
                continue;
            }
            if (ai instanceof AnnotationsAttribute) {
                out.println("annnotation: " + ai.toString());
                continue;
            }
            if (ai instanceof ParameterAnnotationsAttribute) {
                out.println("parameter annnotations: " + ai.toString());
                continue;
            }
            if (ai instanceof StackMapTable) {
                out.println("<stack map table begin>");
                StackMapTable.Printer.print((StackMapTable)ai, out);
                out.println("<stack map table end>");
                continue;
            }
            if (ai instanceof StackMap) {
                out.println("<stack map begin>");
                ((StackMap)ai).print(out);
                out.println("<stack map end>");
                continue;
            }
            if (ai instanceof SignatureAttribute) {
                SignatureAttribute signatureAttribute = (SignatureAttribute)ai;
                String sig = signatureAttribute.getSignature();
                out.println("signature: " + sig);
                try {
                    String s2;
                    s2 = kind == 'c' ? SignatureAttribute.toClassSignature(sig).toString() : (kind == 'm' ? SignatureAttribute.toMethodSignature(s2).toString() : SignatureAttribute.toFieldSignature(s2).toString());
                    out.println("           " + (String)var3_3);
                }
                catch (BadBytecode badBytecode) {
                    out.println("           syntax error");
                }
                continue;
            }
            out.println("attribute: " + var3_3.getName() + " (" + var3_3.get().length + " byte): " + var3_3.getClass().getName());
        }
    }
}

