/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtPrimitiveType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteVector;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;

public class Bytecode
extends ByteVector
implements Opcode,
Cloneable {
    public static final CtClass THIS = ConstPool.THIS;
    ConstPool constPool;
    int maxStack;
    int maxLocals;
    ExceptionTable tryblocks;
    private int stackDepth;

    /*
     * WARNING - void declaration
     */
    public Bytecode(ConstPool cp, int stacksize, int localvars) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.constPool = cp;
        this.maxStack = var2_2;
        this.maxLocals = var3_3;
        this.tryblocks = new ExceptionTable((ConstPool)var1_1);
        this.stackDepth = 0;
    }

    /*
     * WARNING - void declaration
     */
    public Bytecode(ConstPool cp) {
        this((ConstPool)var1_1, 0, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object clone() {
        try {
            Bytecode bc = (Bytecode)super.clone();
            ((Bytecode)super.clone()).tryblocks = (ExceptionTable)this.tryblocks.clone();
            return bc;
        }
        catch (CloneNotSupportedException cnse) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public ExceptionTable getExceptionTable() {
        return this.tryblocks;
    }

    public CodeAttribute toCodeAttribute() {
        return new CodeAttribute(this.constPool, this.maxStack, this.maxLocals, this.get(), this.tryblocks);
    }

    public int length() {
        return this.getSize();
    }

    public byte[] get() {
        return this.copy();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxStack(int size) {
        void var1_1;
        this.maxStack = var1_1;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLocals(int size) {
        void var1_1;
        this.maxLocals = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLocals(boolean isStatic, CtClass[] params, int locals) {
        void var3_4;
        if (!isStatic) {
            ++locals;
        }
        if (params != null) {
            CtClass doubleType = CtClass.doubleType;
            CtClass longType = CtClass.longType;
            for (CtClass type : params) {
                if (type == doubleType || type == longType) {
                    locals += 2;
                    continue;
                }
                ++locals;
            }
        }
        this.maxLocals = var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public void incMaxLocals(int diff) {
        void var1_1;
        this.maxLocals += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addExceptionHandler(int start, int end, int handler, CtClass type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addExceptionHandler((int)var1_1, (int)var2_2, (int)var3_3, this.constPool.addClassInfo(type));
    }

    /*
     * WARNING - void declaration
     */
    public void addExceptionHandler(int start, int end, int handler, String type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addExceptionHandler((int)var1_1, (int)var2_2, (int)var3_3, this.constPool.addClassInfo(type));
    }

    /*
     * WARNING - void declaration
     */
    public void addExceptionHandler(int start, int end, int handler, int type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.tryblocks.add((int)var1_1, (int)var2_2, (int)var3_3, type);
    }

    public int currentPc() {
        return this.getSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(int offset) {
        void var1_1;
        return super.read((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int read16bit(int offset) {
        void var1_1;
        void var2_2;
        int v1 = this.read(offset);
        int v2 = this.read(offset + 1);
        return (int)((var2_2 << 8) + (var1_1 & 0xFF));
    }

    /*
     * WARNING - void declaration
     */
    public int read32bit(int offset) {
        void var1_1;
        void var2_2;
        int v1 = this.read16bit(offset);
        int v2 = this.read16bit(offset + 2);
        return (int)((var2_2 << 16) + (var1_1 & 0xFFFF));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int offset, int value) {
        void var2_2;
        void var1_1;
        super.write((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write16bit(int offset, int value) {
        void var2_2;
        void var1_1;
        this.write(offset, value >> 8);
        this.write((int)(var1_1 + true), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write32bit(int offset, int value) {
        void var2_2;
        void var1_1;
        this.write16bit(offset, value >> 16);
        this.write16bit((int)(var1_1 + 2), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int code) {
        void var1_1;
        super.add((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void add32bit(int value) {
        void var1_1;
        this.add(value >> 24, value >> 16, value >> 8, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addGap(int length) {
        void var1_1;
        super.addGap((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addOpcode(int code) {
        void var1_1;
        this.add(code);
        this.growStack(STACK_GROW[var1_1]);
    }

    /*
     * WARNING - void declaration
     */
    public void growStack(int diff) {
        void var1_1;
        Bytecode bytecode = this;
        bytecode.setStackDepth(bytecode.stackDepth + var1_1);
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    /*
     * WARNING - void declaration
     */
    public void setStackDepth(int depth) {
        void var1_1;
        this.stackDepth = var1_1;
        if (this.stackDepth > this.maxStack) {
            this.maxStack = this.stackDepth;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addIndex(int index) {
        void var1_1;
        this.add(index >> 8, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addAload(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 42);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(25);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(25);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addAstore(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 75);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(58);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(58);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addIconst(int n2) {
        void var1_1;
        if (n2 < 6 && -2 < n2) {
            this.addOpcode(n2 + 3);
            return;
        }
        if (n2 <= 127 && -128 <= n2) {
            this.addOpcode(16);
            this.add(n2);
            return;
        }
        if (n2 <= Short.MAX_VALUE && Short.MIN_VALUE <= n2) {
            this.addOpcode(17);
            this.add(n2 >> 8);
            this.add(n2);
            return;
        }
        Bytecode bytecode = this;
        bytecode.addLdc(bytecode.constPool.addIntegerInfo((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addConstZero(CtClass type) {
        if (type.isPrimitive()) {
            void var1_1;
            if (type == CtClass.longType) {
                this.addOpcode(9);
                return;
            }
            if (type == CtClass.floatType) {
                this.addOpcode(11);
                return;
            }
            if (type == CtClass.doubleType) {
                this.addOpcode(14);
                return;
            }
            if (var1_1 == CtClass.voidType) {
                throw new RuntimeException("void type?");
            }
            this.addOpcode(3);
            return;
        }
        this.addOpcode(1);
    }

    /*
     * WARNING - void declaration
     */
    public void addIload(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 26);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(21);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(21);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addIstore(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 59);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(54);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(54);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addLconst(long n2) {
        void var1_1;
        if (n2 == 0L || n2 == 1L) {
            this.addOpcode(9 + (int)n2);
            return;
        }
        this.addLdc2w((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addLload(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 30);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(22);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(22);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addLstore(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 63);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(55);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(55);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addDconst(double d2) {
        void var1_1;
        if (d2 == 0.0 || d2 == 1.0) {
            this.addOpcode(14 + (int)d2);
            return;
        }
        this.addLdc2w((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addDload(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 38);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(24);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(24);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addDstore(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 71);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(57);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(57);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addFconst(float f2) {
        void var1_1;
        if (f2 == 0.0f || f2 == 1.0f || f2 == 2.0f) {
            this.addOpcode(11 + (int)f2);
            return;
        }
        Bytecode bytecode = this;
        bytecode.addLdc(bytecode.constPool.addFloatInfo((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addFload(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 34);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(23);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(23);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addFstore(int n2) {
        void var1_1;
        if (n2 < 4) {
            this.addOpcode(n2 + 67);
            return;
        }
        if (n2 < 256) {
            this.addOpcode(56);
            this.add(n2);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(56);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public int addLoad(int n2, CtClass type) {
        void var2_2;
        if (!type.isPrimitive()) {
            void var1_1;
            this.addAload((int)var1_1);
            return 1;
        }
        if (type == CtClass.booleanType || type == CtClass.charType || type == CtClass.byteType || type == CtClass.shortType || type == CtClass.intType) {
            this.addIload(n2);
            return 1;
        }
        if (type == CtClass.longType) {
            this.addLload(n2);
            return 2;
        }
        if (type == CtClass.floatType) {
            this.addFload(n2);
            return 1;
        }
        if (var2_2 != CtClass.doubleType) throw new RuntimeException("void type?");
        this.addDload(n2);
        return 2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public int addStore(int n2, CtClass type) {
        void var2_2;
        if (!type.isPrimitive()) {
            void var1_1;
            this.addAstore((int)var1_1);
            return 1;
        }
        if (type == CtClass.booleanType || type == CtClass.charType || type == CtClass.byteType || type == CtClass.shortType || type == CtClass.intType) {
            this.addIstore(n2);
            return 1;
        }
        if (type == CtClass.longType) {
            this.addLstore(n2);
            return 2;
        }
        if (type == CtClass.floatType) {
            this.addFstore(n2);
            return 1;
        }
        if (var2_2 != CtClass.doubleType) throw new RuntimeException("void type?");
        this.addDstore(n2);
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public int addLoadParameters(CtClass[] params, int offset) {
        void var3_3;
        int stacksize = 0;
        if (params != null) {
            int n2 = params.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stacksize += this.addLoad(stacksize + offset, params[i2]);
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void addCheckcast(CtClass c2) {
        void var1_1;
        this.addOpcode(192);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((CtClass)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addCheckcast(String classname) {
        void var1_1;
        this.addOpcode(192);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addInstanceof(String classname) {
        void var1_1;
        this.addOpcode(193);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addGetfield(CtClass c2, String name, String type) {
        void var3_4;
        void var2_3;
        void var1_2;
        this.add(180);
        int ci = this.constPool.addClassInfo(c2);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addFieldrefInfo((int)var1_2, (String)var2_3, type));
        this.growStack(Descriptor.dataSize((String)var3_4) - 1);
    }

    /*
     * WARNING - void declaration
     */
    public void addGetfield(String c2, String name, String type) {
        void var3_4;
        void var2_3;
        void var1_2;
        this.add(180);
        int ci = this.constPool.addClassInfo(c2);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addFieldrefInfo((int)var1_2, (String)var2_3, type));
        this.growStack(Descriptor.dataSize((String)var3_4) - 1);
    }

    /*
     * WARNING - void declaration
     */
    public void addGetstatic(CtClass c2, String name, String type) {
        void var3_4;
        void var2_3;
        void var1_2;
        this.add(178);
        int ci = this.constPool.addClassInfo(c2);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addFieldrefInfo((int)var1_2, (String)var2_3, type));
        this.growStack(Descriptor.dataSize((String)var3_4));
    }

    /*
     * WARNING - void declaration
     */
    public void addGetstatic(String c2, String name, String type) {
        void var3_4;
        void var2_3;
        void var1_2;
        this.add(178);
        int ci = this.constPool.addClassInfo(c2);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addFieldrefInfo((int)var1_2, (String)var2_3, type));
        this.growStack(Descriptor.dataSize((String)var3_4));
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokespecial(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        String desc = Descriptor.ofMethod(returnType, paramTypes);
        this.addInvokespecial((CtClass)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokespecial(CtClass clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isInterface = clazz == null ? false : clazz.isInterface();
        this.addInvokespecial(isInterface, this.constPool.addClassInfo((CtClass)var1_1), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokespecial(String clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addInvokespecial(false, this.constPool.addClassInfo((String)var1_1), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokespecial(int clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addInvokespecial(false, (int)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokespecial(boolean isInterface, int clazz, String name, String desc) {
        void var1_1;
        void var3_3;
        void var2_2;
        int index = isInterface ? this.constPool.addInterfaceMethodrefInfo(clazz, name, desc) : this.constPool.addMethodrefInfo((int)var2_2, (String)var3_3, desc);
        this.addInvokespecial((int)var1_1, desc);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokespecial(int index, String desc) {
        void var2_2;
        void var1_1;
        this.add(183);
        this.addIndex((int)var1_1);
        this.growStack(Descriptor.dataSize((String)var2_2) - 1);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokestatic(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        String desc = Descriptor.ofMethod(returnType, paramTypes);
        this.addInvokestatic((CtClass)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokestatic(CtClass clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isInterface = clazz == THIS ? false : clazz.isInterface();
        Bytecode bytecode = this;
        bytecode.addInvokestatic(bytecode.constPool.addClassInfo((CtClass)var1_1), (String)var2_2, (String)var3_3, isInterface);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokestatic(String classname, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bytecode bytecode = this;
        bytecode.addInvokestatic(bytecode.constPool.addClassInfo((String)var1_1), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokestatic(int clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addInvokestatic((int)var1_1, (String)var2_2, (String)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    private void addInvokestatic(int clazz, String name, String desc, boolean isInterface) {
        void var3_3;
        void var1_1;
        void var2_2;
        int index;
        this.add(184);
        index = isInterface ? this.constPool.addInterfaceMethodrefInfo(clazz, name, desc) : this.constPool.addMethodrefInfo(index, (String)var2_2, desc);
        this.addIndex((int)var1_1);
        this.growStack(Descriptor.dataSize((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokevirtual(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        String desc = Descriptor.ofMethod(returnType, paramTypes);
        this.addInvokevirtual((CtClass)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokevirtual(CtClass clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bytecode bytecode = this;
        bytecode.addInvokevirtual(bytecode.constPool.addClassInfo((CtClass)var1_1), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokevirtual(String classname, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bytecode bytecode = this;
        bytecode.addInvokevirtual(bytecode.constPool.addClassInfo((String)var1_1), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokevirtual(int clazz, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(182);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addMethodrefInfo((int)var1_1, (String)var2_2, desc));
        this.growStack(Descriptor.dataSize((String)var3_3) - 1);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokeinterface(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes, int count) {
        void var3_3;
        void var2_2;
        void var1_1;
        String desc = Descriptor.ofMethod(returnType, paramTypes);
        this.addInvokeinterface((CtClass)var1_1, (String)var2_2, (String)var3_3, count);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokeinterface(CtClass clazz, String name, String desc, int count) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bytecode bytecode = this;
        bytecode.addInvokeinterface(bytecode.constPool.addClassInfo((CtClass)var1_1), (String)var2_2, (String)var3_3, count);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokeinterface(String classname, String name, String desc, int count) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bytecode bytecode = this;
        bytecode.addInvokeinterface(bytecode.constPool.addClassInfo((String)var1_1), (String)var2_2, (String)var3_3, count);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokeinterface(int clazz, String name, String desc, int count) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(185);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addInterfaceMethodrefInfo((int)var1_1, (String)var2_2, desc));
        this.add(count);
        this.add(0);
        this.growStack(Descriptor.dataSize((String)var3_3) - 1);
    }

    /*
     * WARNING - void declaration
     */
    public void addInvokedynamic(int bootstrap, String name, String desc) {
        void var3_4;
        void var1_1;
        void var2_3;
        int nt = this.constPool.addNameAndTypeInfo(name, desc);
        int dyn = this.constPool.addInvokeDynamicInfo(bootstrap, (int)var2_3);
        this.add(186);
        this.addIndex((int)var1_1);
        this.add(0, 0);
        this.growStack(Descriptor.dataSize((String)var3_4));
    }

    /*
     * WARNING - void declaration
     */
    public void addLdc(String s2) {
        void var1_1;
        Bytecode bytecode = this;
        bytecode.addLdc(bytecode.constPool.addStringInfo((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addLdc(int i2) {
        void var1_1;
        if (i2 > 255) {
            this.addOpcode(19);
            this.addIndex(i2);
            return;
        }
        this.addOpcode(18);
        this.add((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addLdc2w(long l2) {
        void var1_1;
        this.addOpcode(20);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addLongInfo((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addLdc2w(double d2) {
        void var1_1;
        this.addOpcode(20);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addDoubleInfo((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addNew(CtClass clazz) {
        void var1_1;
        this.addOpcode(187);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((CtClass)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addNew(String classname) {
        void var1_1;
        this.addOpcode(187);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addAnewarray(String classname) {
        void var1_1;
        this.addOpcode(189);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addAnewarray(CtClass clazz, int length) {
        void var1_1;
        void var2_2;
        this.addIconst((int)var2_2);
        this.addOpcode(189);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((CtClass)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addNewarray(int atype, int length) {
        void var1_1;
        void var2_2;
        this.addIconst((int)var2_2);
        this.addOpcode(188);
        this.add((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int addMultiNewarray(CtClass clazz, int[] dimensions) {
        void var3_3;
        void var1_1;
        int len = dimensions.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.addIconst(dimensions[i2]);
        }
        this.growStack(len);
        return this.addMultiNewarray((CtClass)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public int addMultiNewarray(CtClass clazz, int dim) {
        void var2_2;
        void var1_1;
        this.add(197);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((CtClass)var1_1));
        this.add(dim);
        this.growStack(1 - dim);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int addMultiNewarray(String desc, int dim) {
        void var2_2;
        void var1_1;
        this.add(197);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addClassInfo((String)var1_1));
        this.add(dim);
        this.growStack(1 - dim);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void addPutfield(CtClass c2, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addPutfield0((CtClass)var1_1, null, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addPutfield(String classname, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addPutfield0(null, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void addPutfield0(CtClass target, String classname, String name, String desc) {
        void var3_4;
        void var1_2;
        void var2_3;
        this.add(181);
        int ci = classname == null ? this.constPool.addClassInfo(target) : this.constPool.addClassInfo((String)var2_3);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addFieldrefInfo((int)var1_2, (String)var3_4, desc));
        this.growStack(-1 - Descriptor.dataSize(desc));
    }

    /*
     * WARNING - void declaration
     */
    public void addPutstatic(CtClass c2, String name, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addPutstatic0((CtClass)var1_1, null, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addPutstatic(String classname, String fieldName, String desc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addPutstatic0(null, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void addPutstatic0(CtClass target, String classname, String fieldName, String desc) {
        void var3_4;
        void var1_2;
        void var2_3;
        this.add(179);
        int ci = classname == null ? this.constPool.addClassInfo(target) : this.constPool.addClassInfo((String)var2_3);
        Bytecode bytecode = this;
        bytecode.addIndex(bytecode.constPool.addFieldrefInfo((int)var1_2, (String)var3_4, desc));
        this.growStack(-Descriptor.dataSize(desc));
    }

    /*
     * WARNING - void declaration
     */
    public void addReturn(CtClass type) {
        if (type == null) {
            this.addOpcode(177);
            return;
        }
        if (type.isPrimitive()) {
            void var1_1;
            CtPrimitiveType ptype = (CtPrimitiveType)type;
            this.addOpcode(var1_1.getReturnOp());
            return;
        }
        this.addOpcode(176);
    }

    /*
     * WARNING - void declaration
     */
    public void addRet(int var) {
        void var1_1;
        if (var < 256) {
            this.addOpcode(169);
            this.add(var);
            return;
        }
        this.addOpcode(196);
        this.addOpcode(169);
        this.addIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addPrintln(String message) {
        void var1_1;
        this.addGetstatic("java.lang.System", "err", "Ljava/io/PrintStream;");
        this.addLdc((String)var1_1);
        this.addInvokevirtual("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
    }
}

