/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.Annotation;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationsWriter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ArrayMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.BooleanMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ByteMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.CharMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ClassMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.DoubleMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.EnumMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.FloatMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.IntegerMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.LongMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ShortMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.StringMemberValue;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AnnotationsAttribute
extends AttributeInfo {
    public static final String visibleTag = "RuntimeVisibleAnnotations";
    public static final String invisibleTag = "RuntimeInvisibleAnnotations";

    /*
     * WARNING - void declaration
     */
    public AnnotationsAttribute(ConstPool cp, String attrname, byte[] info) {
        super((ConstPool)var1_1, (String)var2_2, (byte[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationsAttribute(ConstPool cp, String attrname) {
        this((ConstPool)var1_1, (String)var2_2, new byte[]{0, 0});
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AnnotationsAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public int numAnnotations() {
        return ByteArray.readU16bit(this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        Copier copier = new Copier(this.info, this.constPool, newCp, classnames);
        try {
            void var2_3;
            copier.annotationArray();
            return new AnnotationsAttribute(newCp, this.getName(), var2_3.close());
        }
        catch (Exception e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public Annotation getAnnotation(String type) {
        Annotation[] annotations = this.getAnnotations();
        for (int i2 = 0; i2 < annotations.length; ++i2) {
            if (!annotations[i2].getTypeName().equals(type)) continue;
            return annotations[i2];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addAnnotation(Annotation annotation) {
        void var1_1;
        String type = annotation.getTypeName();
        Annotation[] annotations = this.getAnnotations();
        for (int i2 = 0; i2 < annotations.length; ++i2) {
            if (!annotations[i2].getTypeName().equals(type)) continue;
            annotations[i2] = annotation;
            this.setAnnotations(annotations);
            return;
        }
        Annotation[] newlist = new Annotation[annotations.length + 1];
        System.arraycopy(annotations, 0, newlist, 0, annotations.length);
        newlist[((void)var3_3).length] = var1_1;
        this.setAnnotations(newlist);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAnnotation(String type) {
        Annotation[] annotations = this.getAnnotations();
        for (int i2 = 0; i2 < annotations.length; ++i2) {
            void var1_1;
            if (!annotations[i2].getTypeName().equals(type)) continue;
            Annotation[] newlist = new Annotation[annotations.length - 1];
            System.arraycopy(annotations, 0, newlist, 0, i2);
            if (i2 < annotations.length - 1) {
                System.arraycopy(annotations, i2 + 1, newlist, i2, annotations.length - i2 - 1);
            }
            this.setAnnotations((Annotation[])var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Annotation[] getAnnotations() {
        try {
            return new Parser(this.info, this.constPool).parseAnnotations();
        }
        catch (Exception e2) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAnnotations(Annotation[] annotations) {
        void var2_2;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer = new AnnotationsWriter(output, this.constPool);
        try {
            void var3_3;
            int n2 = annotations.length;
            writer.numAnnotations(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                annotations[i2].write(writer);
            }
            var3_3.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.set(var2_2.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public void setAnnotation(Annotation annotation) {
        void var1_1;
        this.setAnnotations(new Annotation[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void renameClass(String oldname, String newname) {
        void var3_3;
        void var2_2;
        void var1_1;
        HashMap<void, void> map = new HashMap<void, void>();
        map.put(var1_1, var2_2);
        this.renameClass((Map<String, String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void renameClass(Map<String, String> classnames) {
        Renamer renamer = new Renamer(this.info, this.getConstPool(), classnames);
        try {
            renamer.annotationArray();
            return;
        }
        catch (Exception e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void getRefClasses(Map<String, String> classnames) {
        void var1_1;
        this.renameClass((Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_2;
        Annotation[] a2 = this.getAnnotations();
        StringBuilder sbuf = new StringBuilder();
        int i2 = 0;
        while (i2 < a2.length) {
            sbuf.append(a2[i2++].toString());
            if (i2 == a2.length) continue;
            sbuf.append(", ");
        }
        return var2_2.toString();
    }

    static class Copier
    extends Walker {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer;
        ConstPool srcPool;
        ConstPool destPool;
        Map<String, String> classnames;

        /*
         * WARNING - void declaration
         */
        Copier(byte[] info, ConstPool src, ConstPool dest, Map<String, String> map) {
            this((byte[])var1_1, (ConstPool)var2_2, (ConstPool)var3_3, map, true);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Copier(byte[] info, ConstPool src, ConstPool dest, Map<String, String> map, boolean makeWriter) {
            super((byte[])var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            if (makeWriter) {
                this.writer = new AnnotationsWriter(this.output, dest);
            }
            this.srcPool = var2_2;
            this.destPool = var3_3;
            this.classnames = map;
        }

        byte[] close() throws IOException {
            this.writer.close();
            return this.output.toByteArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void parameters(int numParam, int pos) throws Exception {
            void var2_2;
            void var1_1;
            this.writer.numParameters(numParam);
            super.parameters((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotationArray(int pos, int num) throws Exception {
            void var2_2;
            void var1_1;
            this.writer.numAnnotations(num);
            return super.annotationArray((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.writer.annotation(this.copyType(type), numPairs);
            return super.annotation((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int memberValuePair(int pos, int nameIndex) throws Exception {
            void var2_2;
            void var1_1;
            this.writer.memberValuePair(this.copy(nameIndex));
            return super.memberValuePair((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void constValueMember(int tag, int index) throws Exception {
            void var2_2;
            void var1_1;
            this.writer.constValueIndex(tag, this.copy(index));
            super.constValueMember((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.writer.enumConstValue(this.copyType(typeNameIndex), this.copy(constNameIndex));
            super.enumMemberValue((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void classMemberValue(int pos, int index) throws Exception {
            void var2_2;
            void var1_1;
            this.writer.classInfoIndex(this.copyType(index));
            super.classMemberValue((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotationMemberValue(int pos) throws Exception {
            void var1_1;
            this.writer.annotationValue();
            return super.annotationMemberValue((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int arrayMemberValue(int pos, int num) throws Exception {
            void var2_2;
            void var1_1;
            this.writer.arrayValue(num);
            return super.arrayMemberValue((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int copy(int srcIndex) {
            void var1_1;
            return this.srcPool.copy((int)var1_1, this.destPool, this.classnames);
        }

        /*
         * WARNING - void declaration
         */
        int copyType(int srcIndex2) {
            void var1_2;
            String srcIndex2 = this.srcPool.getUtf8Info(srcIndex2);
            String newName = Descriptor.rename(srcIndex2, this.classnames);
            return this.destPool.addUtf8Info((String)var1_2);
        }
    }

    static class Parser
    extends Walker {
        ConstPool pool;
        Annotation[][] allParams;
        Annotation[] allAnno;
        Annotation currentAnno;
        MemberValue currentMember;

        /*
         * WARNING - void declaration
         */
        Parser(byte[] info, ConstPool cp) {
            super((byte[])var1_1);
            void var2_2;
            void var1_1;
            this.pool = var2_2;
        }

        Annotation[][] parseParameters() throws Exception {
            this.parameters();
            return this.allParams;
        }

        Annotation[] parseAnnotations() throws Exception {
            this.annotationArray();
            return this.allAnno;
        }

        MemberValue parseMemberValue() throws Exception {
            this.memberValue(0);
            return this.currentMember;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void parameters(int numParam, int pos) throws Exception {
            void var3_3;
            Annotation[][] params = new Annotation[numParam][];
            for (int i2 = 0; i2 < numParam; ++i2) {
                pos = this.annotationArray(pos);
                params[i2] = this.allAnno;
            }
            this.allParams = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotationArray(int pos, int num) throws Exception {
            void var1_1;
            void var3_3;
            Annotation[] array = new Annotation[num];
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.annotation(pos);
                array[i2] = this.currentAnno;
            }
            this.allAnno = var3_3;
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.currentAnno = new Annotation(type, this.pool);
            return super.annotation((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int memberValuePair(int pos, int nameIndex) throws Exception {
            void var1_1;
            void var2_2;
            pos = super.memberValuePair(pos, nameIndex);
            this.currentAnno.addMemberValue((int)var2_2, this.currentMember);
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void constValueMember(int tag, int index) throws Exception {
            void var2_2;
            void var1_1;
            void var3_3;
            ConstPool cp = this.pool;
            switch (tag) {
                case 66: {
                    MemberValue m2 = new ByteMemberValue(index, cp);
                    break;
                }
                case 67: {
                    MemberValue m2;
                    m2 = new CharMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 68: {
                    MemberValue m2;
                    m2 = new DoubleMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 70: {
                    MemberValue m2;
                    m2 = new FloatMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 73: {
                    MemberValue m2;
                    m2 = new IntegerMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 74: {
                    MemberValue m2;
                    m2 = new LongMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 83: {
                    MemberValue m2;
                    m2 = new ShortMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 90: {
                    MemberValue m2;
                    m2 = new BooleanMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                case 115: {
                    MemberValue m2;
                    m2 = new StringMemberValue(index, (ConstPool)((Object)m2));
                    break;
                }
                default: {
                    throw new RuntimeException("unknown tag:" + tag);
                }
            }
            this.currentMember = var3_3;
            super.constValueMember((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.currentMember = new EnumMemberValue(typeNameIndex, constNameIndex, this.pool);
            super.enumMemberValue((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void classMemberValue(int pos, int index) throws Exception {
            void var2_2;
            void var1_1;
            this.currentMember = new ClassMemberValue(index, this.pool);
            super.classMemberValue((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotationMemberValue(int pos) throws Exception {
            void var1_1;
            void var2_2;
            Annotation anno = this.currentAnno;
            pos = super.annotationMemberValue(pos);
            this.currentMember = new AnnotationMemberValue(this.currentAnno, this.pool);
            this.currentAnno = var2_2;
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int arrayMemberValue(int pos, int num) throws Exception {
            void var1_1;
            void var3_3;
            ArrayMemberValue amv = new ArrayMemberValue(this.pool);
            MemberValue[] elements = new MemberValue[num];
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.memberValue(pos);
                elements[i2] = this.currentMember;
            }
            amv.setValue(elements);
            this.currentMember = var3_3;
            return (int)var1_1;
        }
    }

    static class Renamer
    extends Walker {
        ConstPool cpool;
        Map<String, String> classnames;

        /*
         * WARNING - void declaration
         */
        Renamer(byte[] info, ConstPool cp, Map<String, String> map) {
            super((byte[])var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.cpool = var2_2;
            this.classnames = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.renameType(pos - 4, type);
            return super.annotation((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.renameType(pos + 1, typeNameIndex);
            super.enumMemberValue((int)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void classMemberValue(int pos, int index) throws Exception {
            void var2_2;
            void var1_1;
            this.renameType(pos + 1, index);
            super.classMemberValue((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void renameType(int pos, int index) {
            void var2_3;
            String name = this.cpool.getUtf8Info(index);
            String newName = Descriptor.rename(name, this.classnames);
            if (!var2_3.equals(newName)) {
                void var1_1;
                void var3_5;
                int n2 = this.cpool.addUtf8Info((String)var3_5);
                ByteArray.write16bit(n2, this.info, (int)var1_1);
            }
        }
    }

    static class Walker {
        byte[] info;

        /*
         * WARNING - void declaration
         */
        Walker(byte[] attrInfo) {
            void var1_1;
            this.info = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void parameters() throws Exception {
            void var1_1;
            int numParam = this.info[0] & 0xFF;
            this.parameters((int)var1_1, 1);
        }

        void parameters(int numParam, int pos) throws Exception {
            for (int i2 = 0; i2 < numParam; ++i2) {
                pos = this.annotationArray(pos);
            }
        }

        final void annotationArray() throws Exception {
            this.annotationArray(0);
        }

        /*
         * WARNING - void declaration
         */
        final int annotationArray(int pos) throws Exception {
            void var2_2;
            void var1_1;
            int num = ByteArray.readU16bit(this.info, pos);
            return this.annotationArray((int)(var1_1 + 2), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int annotationArray(int pos, int num) throws Exception {
            void var1_1;
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.annotation(pos);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final int annotation(int pos) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            int type = ByteArray.readU16bit(this.info, pos);
            int numPairs = ByteArray.readU16bit(this.info, pos + 2);
            return this.annotation((int)(var1_1 + 4), (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        int annotation(int pos, int type, int numPairs) throws Exception {
            void var1_1;
            for (int j2 = 0; j2 < numPairs; ++j2) {
                pos = this.memberValuePair(pos);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final int memberValuePair(int pos) throws Exception {
            void var2_2;
            void var1_1;
            int nameIndex = ByteArray.readU16bit(this.info, pos);
            return this.memberValuePair((int)(var1_1 + 2), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int memberValuePair(int pos, int nameIndex) throws Exception {
            void var1_1;
            return this.memberValue((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final int memberValue(int pos) throws Exception {
            void var1_1;
            void var3_6;
            void var2_2;
            int tag = this.info[pos] & 0xFF;
            if (tag == 101) {
                int typeNameIndex = ByteArray.readU16bit(this.info, pos + 1);
                int constNameIndex = ByteArray.readU16bit(this.info, pos + 3);
                this.enumMemberValue(pos, typeNameIndex, (int)var2_2);
                return pos + 5;
            }
            if (var2_2 == 99) {
                int index = ByteArray.readU16bit(this.info, pos + 1);
                this.classMemberValue(pos, index);
                return pos + 3;
            }
            if (var2_2 == 64) {
                return this.annotationMemberValue(pos + 1);
            }
            if (var2_2 == 91) {
                int num = ByteArray.readU16bit(this.info, pos + 1);
                return this.arrayMemberValue(pos + 3, num);
            }
            int index = ByteArray.readU16bit(this.info, pos + 1);
            this.constValueMember((int)var2_2, (int)var3_6);
            return (int)(var1_1 + 3);
        }

        void constValueMember(int tag, int index) throws Exception {
        }

        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
        }

        void classMemberValue(int pos, int index) throws Exception {
        }

        /*
         * WARNING - void declaration
         */
        int annotationMemberValue(int pos) throws Exception {
            void var1_1;
            return this.annotation((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        int arrayMemberValue(int pos, int num) throws Exception {
            void var1_1;
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.memberValue(pos);
            }
            return (int)var1_1;
        }
    }
}

