/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;

public class SerialVersionUID {
    /*
     * WARNING - void declaration
     */
    public static void setSerialVersionUID(CtClass clazz) throws CannotCompileException, NotFoundException {
        try {
            clazz.getDeclaredField("serialVersionUID");
            return;
        }
        catch (NotFoundException notFoundException) {
            CtClass ctClass;
            void var1_1;
            if (!SerialVersionUID.isSerializable(clazz)) {
                return;
            }
            CtField field = new CtField(CtClass.longType, "serialVersionUID", clazz);
            ((CtMember)field).setModifiers(26);
            clazz.addField((CtField)var1_1, SerialVersionUID.calculateDefault(ctClass) + "L");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isSerializable(CtClass clazz) throws NotFoundException {
        void var1_1;
        CtClass ctClass;
        ClassPool pool = clazz.getClassPool();
        return ctClass.subtypeOf(var1_1.get("java.io.Serializable"));
    }

    /*
     * WARNING - void declaration
     */
    public static long calculateDefault(CtClass clazz) throws CannotCompileException {
        try {
            void var2_5;
            int mods;
            int i2;
            void var3_6;
            int i3;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            ClassFile classFile = clazz.getClassFile();
            String javaName = SerialVersionUID.javaName(clazz);
            out.writeUTF(javaName);
            CtMethod[] methods = clazz.getDeclaredMethods();
            int classMods = clazz.getModifiers();
            if ((classMods & 0x200) != 0) {
                classMods = methods.length > 0 ? (classMods |= 0x400) : (classMods &= 0xFFFFFBFF);
            }
            out.writeInt(classMods);
            Object[] interfaces = classFile.getInterfaces();
            for (i3 = 0; i3 < interfaces.length; ++i3) {
                interfaces[i3] = SerialVersionUID.javaName((String)interfaces[i3]);
            }
            Arrays.sort(interfaces);
            for (i3 = 0; i3 < interfaces.length; ++i3) {
                out.writeUTF((String)interfaces[i3]);
            }
            CtField[] fields = clazz.getDeclaredFields();
            Arrays.sort(fields, new Comparator<CtField>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compare(CtField field1, CtField field2) {
                    void var2_2;
                    return ((CtMember)field1).getName().compareTo(var2_2.getName());
                }
            });
            for (int i4 = 0; i4 < fields.length; ++i4) {
                CtField field = fields[i4];
                int mods2 = ((CtMember)field).getModifiers();
                if ((mods2 & 2) != 0 && (mods2 & 0x88) != 0) continue;
                out.writeUTF(((CtMember)field).getName());
                out.writeInt(mods2);
                out.writeUTF(field.getFieldInfo2().getDescriptor());
            }
            if (var3_6.getStaticInitializer() != null) {
                out.writeUTF("<clinit>");
                out.writeInt(8);
                out.writeUTF("()V");
            }
            CtConstructor[] constructors = clazz.getDeclaredConstructors();
            Arrays.sort(constructors, new Comparator<CtConstructor>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compare(CtConstructor c1, CtConstructor c2) {
                    void var2_2;
                    return c1.getMethodInfo2().getDescriptor().compareTo(var2_2.getMethodInfo2().getDescriptor());
                }
            });
            for (i2 = 0; i2 < constructors.length; ++i2) {
                CtConstructor constructor = constructors[i2];
                mods = ((CtMember)constructor).getModifiers();
                if ((mods & 2) != 0) continue;
                out.writeUTF("<init>");
                out.writeInt(mods);
                out.writeUTF(constructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            Arrays.sort(methods, new Comparator<CtMethod>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compare(CtMethod m1, CtMethod m2) {
                    void var3_3;
                    int value = ((CtMember)m1).getName().compareTo(((CtMember)m2).getName());
                    if (value == 0) {
                        void var2_2;
                        void var1_1;
                        value = var1_1.getMethodInfo2().getDescriptor().compareTo(var2_2.getMethodInfo2().getDescriptor());
                    }
                    return (int)var3_3;
                }
            });
            for (i2 = 0; i2 < methods.length; ++i2) {
                CtMethod method = methods[i2];
                mods = ((CtMember)method).getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                out.writeUTF(((CtMember)method).getName());
                out.writeInt(mods);
                out.writeUTF(method.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            var2_5.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] digested = messageDigest.digest(bout.toByteArray());
            long hash = 0L;
            for (int i5 = Math.min(digested.length, 8) - 1; i5 >= 0; --i5) {
                hash = hash << 8 | (long)(digested[i5] & 0xFF);
            }
            return hash;
        }
        catch (IOException e2) {
            throw new CannotCompileException(e2);
        }
        catch (NoSuchAlgorithmException e3) {
            void var1_4;
            throw new CannotCompileException((Throwable)var1_4);
        }
    }

    private static String javaName(CtClass clazz) {
        return Descriptor.toJavaName(Descriptor.toJvmName(clazz));
    }

    private static String javaName(String name) {
        return Descriptor.toJavaName(Descriptor.toJvmName(name));
    }
}

