/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CodeConverter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.FieldInitLink;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AccessFlag;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AnnotationsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Bytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstantAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.EnclosingMethodAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FieldInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.InnerClassesAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ParameterAnnotationsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SignatureAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.Annotation;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationImpl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.AccessorMaker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.Javac;
import com.alibaba.ttl.threadpool.agent.internal.javassist.expr.ExprEditor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CtClassType
extends CtClass {
    ClassPool classPool;
    boolean wasChanged;
    private boolean wasFrozen;
    boolean wasPruned;
    boolean gcConstPool;
    ClassFile classfile;
    byte[] rawClassfile;
    private Reference<CtMember.Cache> memberCache;
    private AccessorMaker accessors;
    private FieldInitLink fieldInitializers;
    private Map<CtMethod, String> hiddenMethods;
    private int uniqueNumberSeed;
    private boolean doPruning = ClassPool.doPruning;
    private int getCount;
    private static final int GET_THRESHOLD = 2;

    /*
     * WARNING - void declaration
     */
    CtClassType(String name, ClassPool cp) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        this.classPool = var2_2;
        CtClassType ctClassType = this;
        CtClassType ctClassType2 = this;
        ctClassType2.gcConstPool = false;
        ctClassType2.wasPruned = false;
        ctClassType.wasFrozen = false;
        ctClassType.wasChanged = false;
        this.classfile = null;
        this.rawClassfile = null;
        this.memberCache = null;
        this.accessors = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.getCount = 0;
    }

    /*
     * WARNING - void declaration
     */
    CtClassType(InputStream ins, ClassPool cp) throws IOException {
        this((String)null, (ClassPool)var2_2);
        void var1_1;
        void var2_2;
        this.classfile = new ClassFile(new DataInputStream((InputStream)var1_1));
        this.qualifiedName = this.classfile.getName();
    }

    /*
     * WARNING - void declaration
     */
    CtClassType(ClassFile cf, ClassPool cp) {
        this((String)null, (ClassPool)var2_2);
        void var1_1;
        void var2_2;
        this.classfile = var1_1;
        this.qualifiedName = this.classfile.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void extendToString(StringBuilder buffer) {
        void var2_2;
        void var1_1;
        if (this.wasChanged) {
            buffer.append("changed ");
        }
        if (this.wasFrozen) {
            buffer.append("frozen ");
        }
        if (this.wasPruned) {
            buffer.append("pruned ");
        }
        buffer.append(Modifier.toString(((CtClass)this).getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        try {
            String string;
            CtClass ext = ((CtClass)this).getSuperclass();
            if (ext != null && !(string = ext.getName()).equals("java.lang.Object")) {
                buffer.append(" extends ").append(ext.getName());
            }
        }
        catch (NotFoundException notFoundException) {
            buffer.append(" extends ??");
        }
        try {
            CtClass[] intf = ((CtClass)this).getInterfaces();
            if (intf.length > 0) {
                buffer.append(" implements ");
            }
            for (int i2 = 0; i2 < intf.length; ++i2) {
                buffer.append(intf[i2].getName());
                buffer.append(", ");
            }
        }
        catch (NotFoundException notFoundException) {
            buffer.append(" extends ??");
        }
        CtMember.Cache memCache = this.getMembers();
        this.exToString(buffer, " fields=", memCache.fieldHead(), memCache.lastField());
        this.exToString(buffer, " constructors=", memCache.consHead(), memCache.lastCons());
        this.exToString((StringBuilder)var1_1, " methods=", memCache.methodHead(), var2_2.lastMethod());
    }

    /*
     * WARNING - void declaration
     */
    private void exToString(StringBuilder buffer, String msg, CtMember head, CtMember tail) {
        void var2_2;
        buffer.append((String)var2_2);
        while (head != tail) {
            head = head.next();
            buffer.append(head);
            buffer.append(", ");
        }
    }

    @Override
    public AccessorMaker getAccessorMaker() {
        if (this.accessors == null) {
            this.accessors = new AccessorMaker(this);
        }
        return this.accessors;
    }

    @Override
    public ClassFile getClassFile2() {
        return this.getClassFile3(true);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ClassFile getClassFile3(boolean doCompress) {
        ClassFile classFile;
        ClassFile cfile = this.classfile;
        if (cfile != null) {
            return cfile;
        }
        if (doCompress) {
            this.classPool.compress();
        }
        CtClassType ctClassType = this;
        // MONITORENTER : ctClassType
        cfile = this.classfile;
        if (cfile != null) {
            // MONITOREXIT : ctClassType
            return classFile;
        }
        byte[] rcfile = this.rawClassfile;
        // MONITOREXIT : ctClassType
        if (rcfile != null) {
            ClassFile cf;
            try {
                cf = new ClassFile(new DataInputStream(new ByteArrayInputStream(rcfile)));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2.toString(), e2);
            }
            this.getCount = 2;
            CtClassType e2 = this;
            // MONITORENTER : e2
            this.rawClassfile = null;
            // MONITOREXIT : e2
            return this.setClassFile(cf);
        }
        InputStream fin = null;
        fin = this.classPool.openClassfile(this.getName());
        if (fin == null) {
            throw new NotFoundException(this.getName());
        }
        ClassFile cf = new ClassFile(new DataInputStream(fin = new BufferedInputStream(fin)));
        if (!cf.getName().equals(this.qualifiedName)) {
            throw new RuntimeException("cannot find " + this.qualifiedName + ": " + cf.getName() + " found in " + this.qualifiedName.replace('.', '/') + ".class");
        }
        classFile = this.setClassFile(cf);
        try {
            fin.close();
            return classFile;
        }
        catch (IOException iOException) {}
        return classFile;
        catch (NotFoundException e3) {
            try {
                throw new RuntimeException(e3.toString(), e3);
                catch (IOException e4) {
                    void var1_5;
                    throw new RuntimeException(e4.toString(), (Throwable)var1_5);
                }
            }
            catch (Throwable throwable) {
                if (fin == null) throw throwable;
                try {
                    ((InputStream)((Object)ctClassType)).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
    }

    @Override
    final void incGetCounter() {
        ++this.getCount;
    }

    @Override
    void compress() {
        if (this.getCount < 2) {
            if (!((CtClass)this).isModified() && ClassPool.releaseUnmodifiedClassFile) {
                this.removeClassFile();
            } else if (((CtClass)this).isFrozen() && !this.wasPruned) {
                this.saveClassFile();
            }
        }
        this.getCount = 0;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void saveClassFile() {
        if (this.classfile == null || this.hasMemberCache() != null) {
            return;
        }
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(barray);
        try {
            void var1_1;
            void var2_2;
            this.classfile.write((DataOutputStream)var2_2);
            barray.close();
            this.rawClassfile = var1_1.toByteArray();
            this.classfile = null;
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private synchronized void removeClassFile() {
        if (this.classfile != null && !((CtClass)this).isModified() && this.hasMemberCache() == null) {
            this.classfile = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized ClassFile setClassFile(ClassFile cf) {
        if (this.classfile == null) {
            void var1_1;
            this.classfile = var1_1;
        }
        return this.classfile;
    }

    @Override
    public ClassPool getClassPool() {
        return this.classPool;
    }

    /*
     * WARNING - void declaration
     */
    void setClassPool(ClassPool cp) {
        void var1_1;
        this.classPool = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URL getURL() throws NotFoundException {
        void var1_1;
        URL url = this.classPool.find(this.getName());
        if (url == null) {
            throw new NotFoundException(this.getName());
        }
        return var1_1;
    }

    @Override
    public boolean isModified() {
        return this.wasChanged;
    }

    @Override
    public boolean isFrozen() {
        return this.wasFrozen;
    }

    @Override
    public void freeze() {
        this.wasFrozen = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void checkModify() throws RuntimeException {
        if (((CtClass)this).isFrozen()) {
            void var1_1;
            String msg = this.getName() + " class is frozen";
            if (this.wasPruned) {
                msg = msg + " and pruned";
            }
            throw new RuntimeException((String)var1_1);
        }
        this.wasChanged = true;
    }

    @Override
    public void defrost() {
        this.checkPruned("defrost");
        this.wasFrozen = false;
    }

    @Override
    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        int i2;
        String cname = clazz.getName();
        if (this == clazz || this.getName().equals(cname)) {
            return true;
        }
        ClassFile file = ((CtClass)this).getClassFile2();
        String supername = file.getSuperclass();
        if (supername != null && supername.equals(cname)) {
            return true;
        }
        String[] ifs = file.getInterfaces();
        int num = ifs.length;
        for (i2 = 0; i2 < num; ++i2) {
            if (!ifs[i2].equals(cname)) continue;
            return true;
        }
        if (supername != null && this.classPool.get(supername).subtypeOf(clazz)) {
            return true;
        }
        for (i2 = 0; i2 < num; ++i2) {
            if (!this.classPool.get(ifs[i2]).subtypeOf(clazz)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setName(String name) throws RuntimeException {
        void var2_2;
        void var1_1;
        void var3_3;
        String oldname = this.getName();
        if (name.equals(oldname)) {
            return;
        }
        this.classPool.checkNotFrozen(name);
        ClassFile cf = ((CtClass)this).getClassFile2();
        super.setName(name);
        var3_3.setName((String)var1_1);
        this.nameReplaced();
        this.classPool.classNameChanged((String)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getGenericSignature() {
        void var1_1;
        SignatureAttribute sa = (SignatureAttribute)((CtClass)this).getClassFile2().getAttribute("Signature");
        if (sa == null) {
            return null;
        }
        return var1_1.getSignature();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setGenericSignature(String sig) {
        void var1_1;
        void var2_2;
        ClassFile cf = this.getClassFile();
        SignatureAttribute sa = new SignatureAttribute(cf.getConstPool(), sig);
        var2_2.addAttribute((AttributeInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceClassName(ClassMap classnames) throws RuntimeException {
        void var1_1;
        String oldClassName = this.getName();
        String newClassName = classnames.get(Descriptor.toJvmName(oldClassName));
        if (newClassName != null) {
            newClassName = Descriptor.toJavaName(newClassName);
            this.classPool.checkNotFrozen(newClassName);
        }
        super.replaceClassName(classnames);
        ClassFile classFile = ((CtClass)this).getClassFile2();
        classFile.renameClass((Map<String, String>)var1_1);
        this.nameReplaced();
        if (newClassName != null) {
            void var2_2;
            void var3_3;
            super.setName((String)var3_3);
            this.classPool.classNameChanged((String)var2_2, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceClassName(String oldname, String newname) throws RuntimeException {
        void var2_2;
        void var1_1;
        String string = this.getName();
        if (string.equals(oldname)) {
            ((CtClass)this).setName(newname);
            return;
        }
        super.replaceClassName(oldname, newname);
        ((CtClass)this).getClassFile2().renameClass((String)var1_1, (String)var2_2);
        this.nameReplaced();
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(((CtClass)this).getModifiers());
    }

    @Override
    public boolean isAnnotation() {
        return Modifier.isAnnotation(((CtClass)this).getModifiers());
    }

    @Override
    public boolean isEnum() {
        return Modifier.isEnum(((CtClass)this).getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getModifiers() {
        ClassFile cf = ((CtClass)this).getClassFile2();
        int n2 = cf.getAccessFlags();
        int acc = AccessFlag.clear(n2, 32);
        int inner = cf.getInnerAccessFlags();
        if (inner != -1) {
            if ((inner & 8) != 0) {
                acc |= 8;
            }
            if ((inner & 1) != 0) {
                acc |= 1;
            } else {
                void var1_2;
                acc &= 0xFFFFFFFE;
                if ((inner & 4) != 0) {
                    acc |= 4;
                } else if ((var1_2 & 2) != 0) {
                    acc |= 2;
                }
            }
        }
        return AccessFlag.toModifier(n2);
    }

    @Override
    public CtClass[] getNestedClasses() throws NotFoundException {
        ClassFile cf = ((CtClass)this).getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return new CtClass[0];
        }
        String thisName = cf.getName() + "$";
        int n2 = ica.tableLength();
        ArrayList<CtClass> list = new ArrayList<CtClass>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String name = ica.innerClass(i2);
            if (name == null || !name.startsWith(thisName) || name.lastIndexOf(36) >= thisName.length()) continue;
            list.add(this.classPool.get(name));
        }
        ArrayList<CtClass> arrayList = list;
        return arrayList.toArray(new CtClass[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setModifiers(int mod) {
        void var1_1;
        this.checkModify();
        CtClassType.updateInnerEntry(mod, this.getName(), this, true);
        ClassFile classFile = ((CtClass)this).getClassFile2();
        classFile.setAccessFlags(AccessFlag.of(var1_1 & 0xFFFFFFF7));
    }

    /*
     * WARNING - void declaration
     */
    private static void updateInnerEntry(int newMod, String name, CtClass clazz, boolean outer) {
        int n2;
        ClassFile classFile = clazz.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (ica != null) {
            int isStatic;
            int mod = newMod & 0xFFFFFFF7;
            int i2 = ica.find(name);
            if (!(i2 < 0 || (isStatic = ica.accessFlags(i2) & 8) == 0 && Modifier.isStatic(newMod))) {
                void var3_4;
                clazz.checkModify();
                ica.setAccessFlags(i2, AccessFlag.of(mod) | isStatic);
                String outName = ica.outerClass(i2);
                if (outName != null && var3_4 != false) {
                    try {
                        void var2_3;
                        CtClass parent = clazz.getClassPool().get(outName);
                        CtClassType.updateInnerEntry(mod, name, (CtClass)var2_3, false);
                        return;
                    }
                    catch (NotFoundException notFoundException) {
                        void var0_1;
                        throw new RuntimeException("cannot find the declaring class: " + (String)var0_1);
                    }
                }
                return;
            }
        }
        if (Modifier.isStatic(n2)) {
            void var1_2;
            throw new RuntimeException("cannot change " + Descriptor.toJavaName((String)var1_2) + " into a static class");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasAnnotation(String annotationName) {
        void var2_2;
        void var3_3;
        void var1_1;
        ClassFile cf = ((CtClass)this).getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType((String)var1_1, ((CtClass)this).getClassPool(), (AnnotationsAttribute)var3_3, (AnnotationsAttribute)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    static boolean hasAnnotationType(Class<?> clz, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CtClassType.hasAnnotationType(clz.getName(), (ClassPool)var1_1, (AnnotationsAttribute)var2_2, (AnnotationsAttribute)var3_3);
    }

    static boolean hasAnnotationType(String annotationTypeName, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) {
        Annotation[] anno1 = a1 == null ? null : a1.getAnnotations();
        Annotation[] anno2 = a2 == null ? null : a2.getAnnotations();
        if (anno1 != null) {
            for (int i2 = 0; i2 < anno1.length; ++i2) {
                if (!anno1[i2].getTypeName().equals(annotationTypeName)) continue;
                return true;
            }
        }
        if (anno2 != null) {
            for (int i3 = 0; i3 < anno2.length; ++i3) {
                if (!anno2[i3].getTypeName().equals(annotationTypeName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
        void var2_2;
        void var3_3;
        void var1_1;
        ClassFile cf = ((CtClass)this).getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(var1_1, ((CtClass)this).getClassPool(), (AnnotationsAttribute)var3_3, (AnnotationsAttribute)var2_2);
    }

    static Object getAnnotationType(Class<?> clz, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        int i2;
        Annotation[] anno2;
        Annotation[] anno1;
        anno1 = a1 == null ? null : anno1.getAnnotations();
        anno2 = a2 == null ? null : anno2.getAnnotations();
        String typeName = clz.getName();
        if (anno1 != null) {
            for (i2 = 0; i2 < anno1.length; ++i2) {
                if (!anno1[i2].getTypeName().equals(typeName)) continue;
                return CtClassType.toAnnoType(anno1[i2], cp);
            }
        }
        if (anno2 != null) {
            for (i2 = 0; i2 < anno2.length; ++i2) {
                if (!anno2[i2].getTypeName().equals(typeName)) continue;
                return CtClassType.toAnnoType(anno2[i2], cp);
            }
        }
        return null;
    }

    @Override
    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException e2) {
            void var1_1;
            throw new RuntimeException("Unexpected exception ", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        void var2_2;
        void var3_3;
        void var1_1;
        ClassFile cf = ((CtClass)this).getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType((boolean)var1_1, ((CtClass)this).getClassPool(), (AnnotationsAttribute)var3_3, (AnnotationsAttribute)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static Object[] toAnnotationType(boolean ignoreNotFound, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        void var0_2;
        int size2;
        Annotation[] anno2;
        int size1;
        Annotation[] anno1;
        if (a1 == null) {
            anno1 = null;
            size1 = 0;
        } else {
            anno1 = anno1.getAnnotations();
            size1 = anno1.length;
        }
        if (a2 == null) {
            anno2 = null;
            size2 = 0;
        } else {
            anno2 = anno2.getAnnotations();
            size2 = anno2.length;
        }
        if (!ignoreNotFound) {
            Object[] result = new Object[size1 + size2];
            for (int i2 = 0; i2 < size1; ++i2) {
                result[i2] = CtClassType.toAnnoType(anno1[i2], cp);
            }
            for (int j2 = 0; j2 < size2; ++j2) {
                result[j2 + size1] = CtClassType.toAnnoType(anno2[j2], cp);
            }
            return result;
        }
        ArrayList<Object> annotations = new ArrayList<Object>();
        for (int i3 = 0; i3 < size1; ++i3) {
            try {
                annotations.add(CtClassType.toAnnoType(anno1[i3], cp));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        for (int j3 = 0; j3 < size2; ++j3) {
            try {
                annotations.add(CtClassType.toAnnoType(anno2[j3], cp));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return var0_2.toArray();
    }

    /*
     * WARNING - void declaration
     */
    static Object[][] toAnnotationType(boolean ignoreNotFound, ClassPool cp, ParameterAnnotationsAttribute a1, ParameterAnnotationsAttribute a2, MethodInfo minfo) throws ClassNotFoundException {
        void numParameters22;
        int numParameters22 = a1 != null ? a1.numParameters() : (a2 != null ? a2.numParameters() : Descriptor.numOfParameters(numParameters22.getDescriptor()));
        Object[][] result = new Object[numParameters22][];
        for (int i2 = 0; i2 < numParameters22; ++i2) {
            int j2;
            int size2;
            Annotation[] anno2;
            int size1;
            Annotation[] anno1;
            if (a1 == null) {
                anno1 = null;
                size1 = 0;
            } else {
                anno1 = a1.getAnnotations()[i2];
                size1 = anno1.length;
            }
            if (a2 == null) {
                anno2 = null;
                size2 = 0;
            } else {
                anno2 = a2.getAnnotations()[i2];
                size2 = anno2.length;
            }
            if (!ignoreNotFound) {
                int j3;
                result[i2] = new Object[size1 + size2];
                for (j3 = 0; j3 < size1; ++j3) {
                    result[i2][j3] = CtClassType.toAnnoType(anno1[j3], cp);
                }
                for (j3 = 0; j3 < size2; ++j3) {
                    result[i2][j3 + size1] = CtClassType.toAnnoType(anno2[j3], cp);
                }
                continue;
            }
            ArrayList<Object> annotations = new ArrayList<Object>();
            for (j2 = 0; j2 < size1; ++j2) {
                try {
                    annotations.add(CtClassType.toAnnoType(anno1[j2], cp));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            for (j2 = 0; j2 < size2; ++j2) {
                try {
                    annotations.add(CtClassType.toAnnoType(anno2[j2], cp));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            result[i2] = annotations.toArray();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static Object toAnnoType(Annotation anno, ClassPool cp) throws ClassNotFoundException {
        try {
            ClassLoader cl = cp.getClassLoader();
            return anno.toAnnotationType(cl, cp);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader cl2 = cp.getClass().getClassLoader();
            try {
                return anno.toAnnotationType(cl2, cp);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    void var1_1;
                    void var2_3;
                    Class<?> clazz = cp.get(anno.getTypeName()).toClass();
                    return AnnotationImpl.make(clazz.getClassLoader(), var2_3, (ClassPool)var1_1, anno);
                }
                catch (Throwable throwable) {
                    Annotation annotation;
                    throw new ClassNotFoundException(annotation.getTypeName());
                }
            }
        }
    }

    @Override
    public boolean subclassOf(CtClass superclass) {
        if (superclass == null) {
            return false;
        }
        String superName = superclass.getName();
        try {
            for (CtClass curr = this; curr != null; curr = ((CtClass)curr).getSuperclass()) {
                if (!curr.getName().equals(superName)) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtClass getSuperclass() throws NotFoundException {
        void var1_1;
        String supername = ((CtClass)this).getClassFile2().getSuperclass();
        if (supername == null) {
            return null;
        }
        return this.classPool.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSuperclass(CtClass clazz) throws CannotCompileException {
        void var1_1;
        this.checkModify();
        if (((CtClass)this).isInterface()) {
            ((CtClass)this).addInterface(clazz);
            return;
        }
        ((CtClass)this).getClassFile2().setSuperclass(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtClass[] getInterfaces() throws NotFoundException {
        void var3_3;
        String[] ifs = ((CtClass)this).getClassFile2().getInterfaces();
        int num = ifs.length;
        CtClass[] ifc = new CtClass[num];
        for (int i2 = 0; i2 < num; ++i2) {
            ifc[i2] = this.classPool.get(ifs[i2]);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInterfaces(CtClass[] list) {
        void var2_2;
        String[] ifs;
        this.checkModify();
        if (list == null) {
            ifs = new String[]{};
        } else {
            int num = list.length;
            ifs = new String[num];
            for (int i2 = 0; i2 < num; ++i2) {
                ifs[i2] = list[i2].getName();
            }
        }
        ((CtClass)this).getClassFile2().setInterfaces((String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addInterface(CtClass anInterface) {
        this.checkModify();
        if (anInterface != null) {
            void var1_1;
            ((CtClass)this).getClassFile2().addInterface(var1_1.getName());
        }
    }

    @Override
    public CtClass getDeclaringClass() throws NotFoundException {
        ClassFile cf = ((CtClass)this).getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return null;
        }
        String name = this.getName();
        int n2 = ica.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!name.equals(ica.innerClass(i2))) continue;
            String outName = ica.outerClass(i2);
            if (outName != null) {
                return this.classPool.get(outName);
            }
            EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cf.getAttribute("EnclosingMethod");
            if (ema == null) continue;
            return this.classPool.get(ema.className());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtBehavior getEnclosingBehavior() throws NotFoundException {
        void var3_3;
        void var2_2;
        ClassFile classFile = ((CtClass)this).getClassFile2();
        EnclosingMethodAttribute ema = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
        if (ema == null) {
            return null;
        }
        CtClass enc = this.classPool.get(ema.className());
        String name = ema.methodName();
        if ("<init>".equals(name)) {
            return enc.getConstructor(ema.methodDescriptor());
        }
        if ("<clinit>".equals(name)) {
            return enc.getClassInitializer();
        }
        return var2_2.getMethod((String)var3_3, ((EnclosingMethodAttribute)((Object)classFile)).methodDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtClass makeNestedClass(String name, boolean isStatic) {
        void var2_3;
        void var1_1;
        if (!isStatic) {
            throw new RuntimeException("sorry, only nested static class is supported");
        }
        this.checkModify();
        CtClass c2 = this.classPool.makeNestedClass(this.getName() + "$" + name);
        ClassFile cf = ((CtClass)this).getClassFile2();
        ClassFile cf2 = c2.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            void var3_4;
            ica = new InnerClassesAttribute(cf.getConstPool());
            var3_4.addAttribute(ica);
        }
        ica.append(c2.getName(), this.getName(), (String)var1_1, cf2.getAccessFlags() & 0xFFFFFFDF | 8);
        cf2.addAttribute(((AttributeInfo)ica).copy(cf2.getConstPool(), null));
        return var2_3;
    }

    private void nameReplaced() {
        CtMember.Cache cache = this.hasMemberCache();
        if (cache != null) {
            CtMember tail = cache.lastMethod();
            for (CtMember mth = cache.methodHead(); mth != tail; mth = mth.next()) {
                mth.nameReplaced();
            }
        }
    }

    protected CtMember.Cache hasMemberCache() {
        if (this.memberCache != null) {
            return this.memberCache.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized CtMember.Cache getMembers() {
        void var1_1;
        CtMember.Cache cache;
        if (this.memberCache == null || (cache = this.memberCache.get()) == null) {
            cache = new CtMember.Cache(this);
            this.makeFieldCache(cache);
            this.makeBehaviorCache(cache);
            this.memberCache = new WeakReference<CtMember.Cache>(cache);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void makeFieldCache(CtMember.Cache cache) {
        Object object = this.getClassFile3(false).getFields();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            FieldInfo finfo = (FieldInfo)object.next();
            cache.addField(new CtField((FieldInfo)var3_3, (CtClass)this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void makeBehaviorCache(CtMember.Cache cache) {
        Object object = this.getClassFile3(false).getMethods();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            MethodInfo minfo = (MethodInfo)object.next();
            if (minfo.isMethod()) {
                cache.addMethod(new CtMethod(minfo, this));
                continue;
            }
            cache.addConstructor(new CtConstructor((MethodInfo)var3_3, (CtClass)this));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtField[] getFields() {
        void var1_1;
        ArrayList<CtMember> alist = new ArrayList<CtMember>();
        CtClassType.getFields(alist, this);
        void v0 = var1_1;
        return v0.toArray(new CtField[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static void getFields(List<CtMember> alist, CtClass cc) {
        void var1_1;
        if (cc == null) {
            return;
        }
        try {
            CtClassType.getFields(alist, cc.getSuperclass());
        }
        catch (NotFoundException notFoundException) {}
        try {
            CtClass[] ctClassArray;
            CtClass[] ctClassArray2 = ctClassArray = cc.getInterfaces();
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctc = ctClassArray2[i2];
                CtClassType.getFields(alist, ctc);
            }
        }
        catch (NotFoundException notFoundException) {}
        CtMember.Cache memCache = ((CtClassType)var1_1).getMembers();
        CtMember field = memCache.fieldHead();
        CtMember tail = memCache.lastField();
        while (field != tail) {
            if (Modifier.isPrivate((field = field.next()).getModifiers())) continue;
            alist.add(field);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtField getField(String name, String desc) throws NotFoundException {
        void var2_2;
        void var1_1;
        void var3_3;
        CtField f2 = this.getField2(name, desc);
        return this.checkGetField((CtField)var3_3, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private CtField checkGetField(CtField f2, String name, String desc) throws NotFoundException {
        void var1_1;
        if (f2 == null) {
            void var2_2;
            String msg = "field: " + (String)var2_2;
            if (desc != null) {
                void var3_3;
                msg = msg + " type " + (String)var3_3;
            }
            throw new NotFoundException((String)var1_1 + " in " + this.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    CtField getField2(String name, String desc) {
        CtClass[] df = this.getDeclaredField2(name, desc);
        if (df != null) {
            return df;
        }
        try {
            CtClass[] ctClassArray = ((CtClass)this).getInterfaces();
            df = ctClassArray;
            df = ctClassArray;
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctClass = df[i2];
                CtField f2 = ctClass.getField2(name, desc);
                if (f2 == null) continue;
                return f2;
            }
            CtClass s2 = ((CtClass)this).getSuperclass();
            if (s2 != null) {
                void var2_2;
                void var1_1;
                void var3_3;
                return var3_3.getField2((String)var1_1, (String)var2_2);
            }
        }
        catch (NotFoundException notFoundException) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtField[] getDeclaredFields() {
        void var3_4;
        CtMember field;
        CtMember.Cache memCache = this.getMembers();
        CtMember tail = memCache.lastField();
        int n2 = CtMember.Cache.count(field, tail);
        CtField[] cfs = new CtField[n2];
        int i2 = 0;
        for (field = memCache.fieldHead(); field != tail; field = field.next()) {
            cfs[i2++] = (CtField)field;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtField getDeclaredField(String name) throws NotFoundException {
        void var1_1;
        return ((CtClass)this).getDeclaredField((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtField getDeclaredField(String name, String desc) throws NotFoundException {
        void var2_2;
        void var1_1;
        void var3_3;
        CtField f2 = this.getDeclaredField2(name, desc);
        return this.checkGetField((CtField)var3_3, (String)var1_1, (String)var2_2);
    }

    private CtField getDeclaredField2(String name, String desc) {
        CtMember.Cache memCache = this.getMembers();
        CtMember field = memCache.fieldHead();
        CtMember tail = memCache.lastField();
        while (field != tail) {
            if (!(field = field.next()).getName().equals(name) || desc != null && !desc.equals(field.getSignature())) continue;
            return (CtField)field;
        }
        return null;
    }

    @Override
    public CtBehavior[] getDeclaredBehaviors() {
        CtMember cons;
        CtMember.Cache memCache = this.getMembers();
        CtMember consTail = memCache.lastCons();
        int cnum = CtMember.Cache.count(cons, consTail);
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        int mnum = CtMember.Cache.count(mth, mthTail);
        CtBehavior[] cb = new CtBehavior[cnum + mnum];
        int i2 = 0;
        for (cons = memCache.consHead(); cons != consTail; cons = cons.next()) {
            cb[i2++] = (CtBehavior)cons;
        }
        while (mth != mthTail) {
            mth = mth.next();
            cb[i2++] = (CtBehavior)mth;
        }
        return cb;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtConstructor[] getConstructors() {
        void var3_4;
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        int n2 = 0;
        CtMember mem = cons;
        while (mem != consTail) {
            if (!CtClassType.isPubCons((CtConstructor)(mem = mem.next()))) continue;
            ++n2;
        }
        CtConstructor[] result = new CtConstructor[n2];
        int i2 = 0;
        mem = cons;
        while (mem != consTail) {
            void var2_2;
            CtConstructor cc = (CtConstructor)(mem = mem.next());
            if (!CtClassType.isPubCons(cc)) continue;
            result[i2++] = var2_2;
        }
        return var3_4;
    }

    private static boolean isPubCons(CtConstructor cons) {
        CtConstructor ctConstructor;
        return !Modifier.isPrivate(((CtMember)cons).getModifiers()) && ctConstructor.isConstructor();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtConstructor getConstructor(String desc) throws NotFoundException {
        void var1_1;
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        while (cons != consTail) {
            CtConstructor cc = (CtConstructor)(cons = cons.next());
            if (!cc.getMethodInfo2().getDescriptor().equals(desc) || !cc.isConstructor()) continue;
            return cc;
        }
        return super.getConstructor((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtConstructor[] getDeclaredConstructors() {
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        int n2 = 0;
        CtMember mem = cons;
        while (mem != consTail) {
            CtConstructor ctConstructor = (CtConstructor)(mem = mem.next());
            if (!ctConstructor.isConstructor()) continue;
            ++n2;
        }
        CtConstructor[] result = new CtConstructor[n2];
        int i2 = 0;
        mem = cons;
        while (mem != consTail) {
            void var2_2;
            CtConstructor cc = (CtConstructor)(mem = mem.next());
            if (!cc.isConstructor()) continue;
            result[i2++] = var2_2;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtConstructor getClassInitializer() {
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        while (cons != consTail) {
            void var3_3;
            CtConstructor cc = (CtConstructor)(cons = cons.next());
            if (!cc.isClassInitializer()) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtMethod[] getMethods() {
        void var1_1;
        HashMap<String, CtMember> h2 = new HashMap<String, CtMember>();
        CtClassType.getMethods0(h2, this);
        return h2.values().toArray(new CtMethod[var1_1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static void getMethods0(Map<String, CtMember> h2, CtClass cc) {
        try {
            CtClass[] ctClassArray;
            CtClass[] ctClassArray2 = ctClassArray = cc.getInterfaces();
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctc = ctClassArray2[i2];
                CtClassType.getMethods0(h2, ctc);
            }
        }
        catch (NotFoundException notFoundException) {}
        try {
            CtClass s2 = cc.getSuperclass();
            if (s2 != null) {
                CtClassType.getMethods0(h2, s2);
            }
        }
        catch (NotFoundException notFoundException) {}
        if (cc instanceof CtClassType) {
            void var1_1;
            CtMember.Cache memCache = ((CtClassType)var1_1).getMembers();
            CtMember mth = memCache.methodHead();
            CtMember mthTail = memCache.lastMethod();
            while (mth != mthTail) {
                if (Modifier.isPrivate((mth = mth.next()).getModifiers())) continue;
                h2.put(((CtMethod)mth).getStringRep(), mth);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        void var1_1;
        CtMethod m2 = CtClassType.getMethod0(this, name, desc);
        if (m2 != null) {
            void var2_2;
            return var2_2;
        }
        throw new NotFoundException((String)var1_1 + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass cc, String name, String desc) {
        CtClass[] ctClassArray;
        if (cc instanceof CtClassType) {
            CtMember.Cache memCache = ((CtClassType)cc).getMembers();
            CtMember mth = memCache.methodHead();
            CtMember mthTail = memCache.lastMethod();
            while (mth != mthTail) {
                if (!(mth = mth.next()).getName().equals(name) || !((CtMethod)mth).getMethodInfo2().getDescriptor().equals(desc)) continue;
                return (CtMethod)mth;
            }
        }
        try {
            CtMethod m2;
            CtClass s2 = cc.getSuperclass();
            if (s2 != null && (m2 = CtClassType.getMethod0((CtClass)ctClassArray, name, desc)) != null) {
                return m2;
            }
        }
        catch (NotFoundException notFoundException) {}
        try {
            CtClass ctClass;
            CtClass[] ctClassArray2 = ctClassArray = ctClass.getInterfaces();
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctClass2 = ctClassArray2[i2];
                CtMethod m3 = CtClassType.getMethod0(ctClass2, name, desc);
                if (m3 == null) continue;
                return m3;
            }
        }
        catch (NotFoundException notFoundException) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtMethod[] getDeclaredMethods() {
        void var3_3;
        CtMember.Cache memCache = this.getMembers();
        CtMember mthTail = memCache.lastMethod();
        ArrayList<CtMember> methods = new ArrayList<CtMember>();
        for (CtMember mth = memCache.methodHead(); mth != mthTail; mth = mth.next()) {
            methods.add(mth);
        }
        void v0 = var3_3;
        return v0.toArray(new CtMethod[v0.size()]);
    }

    @Override
    public CtMethod[] getDeclaredMethods(String name) throws NotFoundException {
        CtMember.Cache memCache = this.getMembers();
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        ArrayList<CtMember> methods = new ArrayList<CtMember>();
        while (mth != mthTail) {
            if (!(mth = mth.next()).getName().equals(name)) continue;
            methods.add(mth);
        }
        ArrayList<CtMember> arrayList = methods;
        return arrayList.toArray(new CtMethod[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        void var1_1;
        CtMember.Cache memCache = this.getMembers();
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        while (mth != mthTail) {
            void var3_3;
            if (!(mth = mth.next()).getName().equals(name)) continue;
            return (CtMethod)var3_3;
        }
        throw new NotFoundException((String)var1_1 + "(..) is not found in " + this.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtMethod getDeclaredMethod(String name, CtClass[] params) throws NotFoundException {
        void var1_1;
        String desc = Descriptor.ofParameters(params);
        CtMember.Cache memCache = this.getMembers();
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        while (mth != mthTail) {
            if (!(mth = mth.next()).getName().equals(name) || !((CtMethod)mth).getMethodInfo2().getDescriptor().startsWith(desc)) continue;
            return (CtMethod)mth;
        }
        throw new NotFoundException((String)var1_1 + "(..) is not found in " + this.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addField(CtField f2, String init) throws CannotCompileException {
        void var2_2;
        void var1_1;
        ((CtClass)this).addField((CtField)var1_1, CtField.Initializer.byExpr((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addField(CtField f2, CtField.Initializer init) throws CannotCompileException {
        this.checkModify();
        if (((CtMember)f2).getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        if (init == null) {
            init = f2.getInit();
        }
        if (init != null) {
            init.check(((CtMember)f2).getSignature());
            int mod = ((CtMember)f2).getModifiers();
            if (Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                try {
                    ConstPool cp = ((CtClass)this).getClassFile2().getConstPool();
                    int index = init.getConstantValue(cp, f2.getType());
                    if (index != 0) {
                        f2.getFieldInfo2().addAttribute(new ConstantAttribute(cp, index));
                        init = null;
                    }
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        this.getMembers().addField(f2);
        ((CtClass)this).getClassFile2().addField(f2.getFieldInfo2());
        if (init != null) {
            void var3_4;
            void var2_2;
            void var1_1;
            FieldInitLink fil = new FieldInitLink((CtField)var1_1, (CtField.Initializer)var2_2);
            FieldInitLink link = this.fieldInitializers;
            if (link == null) {
                this.fieldInitializers = fil;
                return;
            }
            while (link.next != null) {
                link = link.next;
            }
            link.next = var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeField(CtField f2) throws NotFoundException {
        void var1_1;
        void var2_2;
        this.checkModify();
        FieldInfo fi = f2.getFieldInfo2();
        ClassFile classFile = ((CtClass)this).getClassFile2();
        if (classFile.getFields().remove(var2_2)) {
            this.getMembers().remove(f2);
            this.gcConstPool = true;
            return;
        }
        throw new NotFoundException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CtConstructor makeClassInitializer() throws CannotCompileException {
        void var2_2;
        void var1_1;
        CtConstructor clinit = ((CtClass)this).getClassInitializer();
        if (clinit != null) {
            return clinit;
        }
        this.checkModify();
        ClassFile cf = ((CtClass)this).getClassFile2();
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        this.modifyClassConstructor((ClassFile)var1_1, (Bytecode)var2_2, 0, 0);
        return ((CtClass)this).getClassInitializer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConstructor(CtConstructor c2) throws CannotCompileException {
        void var1_1;
        this.checkModify();
        if (c2.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMembers().addConstructor(c2);
        ((CtClass)this).getClassFile2().addMethod(var1_1.getMethodInfo2());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeConstructor(CtConstructor m2) throws NotFoundException {
        void var1_1;
        void var2_2;
        this.checkModify();
        MethodInfo mi = m2.getMethodInfo2();
        ClassFile classFile = ((CtClass)this).getClassFile2();
        if (classFile.getMethods().remove(var2_2)) {
            this.getMembers().remove(m2);
            this.gcConstPool = true;
            return;
        }
        throw new NotFoundException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addMethod(CtMethod m2) throws CannotCompileException {
        void var2_2;
        void var1_1;
        this.checkModify();
        if (m2.getDeclaringClass() != this) {
            throw new CannotCompileException("bad declaring class");
        }
        int mod = ((CtMember)m2).getModifiers();
        if ((((CtClass)this).getModifiers() & 0x200) != 0) {
            if (Modifier.isProtected(mod) || Modifier.isPrivate(mod)) {
                throw new CannotCompileException("an interface method must be public: " + m2.toString());
            }
            ((CtMember)m2).setModifiers(mod | 1);
        }
        this.getMembers().addMethod(m2);
        ((CtClass)this).getClassFile2().addMethod(var1_1.getMethodInfo2());
        if ((var2_2 & 0x400) != 0) {
            CtClassType ctClassType = this;
            ((CtClass)ctClassType).setModifiers(((CtClass)ctClassType).getModifiers() | 0x400);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeMethod(CtMethod m2) throws NotFoundException {
        void var1_1;
        void var2_2;
        this.checkModify();
        MethodInfo mi = m2.getMethodInfo2();
        ClassFile classFile = ((CtClass)this).getClassFile2();
        if (classFile.getMethods().remove(var2_2)) {
            this.getMembers().remove(m2);
            this.gcConstPool = true;
            return;
        }
        throw new NotFoundException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getAttribute(String name) {
        void var1_1;
        AttributeInfo ai = ((CtClass)this).getClassFile2().getAttribute(name);
        if (ai == null) {
            return null;
        }
        return var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttribute(String name, byte[] data) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.checkModify();
        ClassFile cf = ((CtClass)this).getClassFile2();
        cf.addAttribute(new AttributeInfo(var3_3.getConstPool(), (String)var1_1, (byte[])var2_2));
    }

    @Override
    public void instrument(CodeConverter converter) throws CannotCompileException {
        MethodInfo[] methodInfoArray;
        this.checkModify();
        ClassFile cf = ((CtClass)this).getClassFile2();
        ConstPool cp = cf.getConstPool();
        List<MethodInfo> methods = cf.getMethods();
        for (MethodInfo minfo : methods.toArray(new MethodInfo[methodInfoArray.size()])) {
            converter.doit(this, minfo, cp);
        }
    }

    @Override
    public void instrument(ExprEditor editor) throws CannotCompileException {
        this.checkModify();
        MethodInfo[] methodInfoArray = ((CtClass)this).getClassFile2();
        List<MethodInfo> methods = methodInfoArray.getMethods();
        for (MethodInfo minfo : methods.toArray(new MethodInfo[methodInfoArray.size()])) {
            editor.doit(this, minfo);
        }
    }

    @Override
    public void prune() {
        if (this.wasPruned) {
            return;
        }
        CtClassType ctClassType = this;
        ctClassType.wasFrozen = true;
        ctClassType.wasPruned = true;
        ((CtClass)this).getClassFile2().prune();
    }

    @Override
    public void rebuildClassFile() {
        this.gcConstPool = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        try {
            if (((CtClass)this).isModified()) {
                this.checkPruned("toBytecode");
                ClassFile cf = ((CtClass)this).getClassFile2();
                if (this.gcConstPool) {
                    cf.compact();
                    this.gcConstPool = false;
                }
                this.modifyClassConstructor(cf);
                this.modifyConstructors(cf);
                if (debugDump != null) {
                    this.dumpClassFile(cf);
                }
                cf.write(out);
                out.flush();
                this.fieldInitializers = null;
                if (this.doPruning) {
                    cf.prune();
                    this.wasPruned = true;
                }
            } else {
                void var1_1;
                this.classPool.writeClassfile(this.getName(), (OutputStream)var1_1);
            }
            this.getCount = 0;
            this.wasFrozen = true;
            return;
        }
        catch (NotFoundException e2) {
            throw new CannotCompileException(e2);
        }
        catch (IOException e3) {
            void var2_4;
            throw new CannotCompileException((Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dumpClassFile(ClassFile cf) throws IOException {
        DataOutputStream dump = this.makeFileOutput(debugDump);
        try {
            void var1_1;
            var1_1.write(dump);
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.close();
            throw throwable;
        }
        dump.close();
    }

    /*
     * WARNING - void declaration
     */
    private void checkPruned(String method) {
        if (this.wasPruned) {
            void var1_1;
            throw new RuntimeException((String)var1_1 + "(): " + this.getName() + " was pruned.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stopPruning(boolean stop) {
        void var2_2;
        void var1_1;
        boolean prev = !this.doPruning;
        this.doPruning = var1_1 == false;
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void modifyClassConstructor(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        Javac jv = new Javac(code, this);
        int stacksize = 0;
        boolean doInit = false;
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            CtField f2 = fi.field;
            if (Modifier.isStatic(((CtMember)f2).getModifiers())) {
                doInit = true;
                int s2 = fi.init.compileIfStatic(f2.getType(), ((CtMember)f2).getName(), code, jv);
                if (stacksize < s2) {
                    stacksize = s2;
                }
            }
            fi = fi.next;
        }
        if (doInit) {
            void var2_2;
            void var1_1;
            this.modifyClassConstructor((ClassFile)var1_1, (Bytecode)var2_2, stacksize, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void modifyClassConstructor(ClassFile cf, Bytecode code, int stacksize, int localsize) throws CannotCompileException {
        MethodInfo m2 = cf.getStaticInitializer();
        if (m2 == null) {
            code.add(177);
            code.setMaxStack(stacksize);
            code.setMaxLocals(localsize);
            m2 = new MethodInfo(cf.getConstPool(), "<clinit>", "()V");
            m2.setAccessFlags(8);
            m2.setCodeAttribute(code.toCodeAttribute());
            cf.addMethod(m2);
            CtMember.Cache cache = this.hasMemberCache();
            if (cache != null) {
                cache.addConstructor(new CtConstructor(m2, (CtClass)this));
            }
        } else {
            CodeAttribute codeAttr = m2.getCodeAttribute();
            if (codeAttr == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                void var2_2;
                CodeIterator it = codeAttr.iterator();
                int pos = it.insertEx(code.get());
                it.insert(var2_2.getExceptionTable(), pos);
                int n2 = codeAttr.getMaxStack();
                if (n2 < stacksize) {
                    void var3_4;
                    codeAttr.setMaxStack((int)var3_4);
                }
                if ((n2 = codeAttr.getMaxLocals()) < localsize) {
                    codeAttr.setMaxLocals(localsize);
                }
            }
            catch (BadBytecode e2) {
                throw new CannotCompileException(e2);
            }
        }
        try {
            void var1_1;
            m2.rebuildStackMapIf6(this.classPool, (ClassFile)var1_1);
            return;
        }
        catch (BadBytecode e3) {
            throw new CannotCompileException(e3);
        }
    }

    private void modifyConstructors(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool cp = cf.getConstPool();
        Object object = cf.getMethods();
        object = object.iterator();
        while (object.hasNext()) {
            CodeAttribute codeAttr;
            MethodInfo minfo = (MethodInfo)object.next();
            if (!minfo.isConstructor() || (codeAttr = minfo.getCodeAttribute()) == null) continue;
            try {
                Bytecode init = new Bytecode(cp, 0, codeAttr.getMaxLocals());
                CtClass[] params = Descriptor.getParameterTypes(minfo.getDescriptor(), this.classPool);
                int stacksize = this.makeFieldInitializer(init, params);
                CtClassType.insertAuxInitializer(codeAttr, init, stacksize);
                minfo.rebuildStackMapIf6(this.classPool, cf);
            }
            catch (BadBytecode e2) {
                throw new CannotCompileException(e2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void insertAuxInitializer(CodeAttribute codeAttr, Bytecode initializer, int stacksize) throws BadBytecode {
        void var1_1;
        void var3_4;
        CodeIterator it = codeAttr.iterator();
        int n2 = it.skipSuperConstructor();
        if (n2 < 0 && (n2 = it.skipThisConstructor()) >= 0) {
            return;
        }
        int pos = it.insertEx(initializer.get());
        var3_4.insert(var1_1.getExceptionTable(), pos);
        int n3 = codeAttr.getMaxStack();
        if (n3 < stacksize) {
            void var2_3;
            CodeAttribute codeAttribute;
            codeAttribute.setMaxStack((int)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int makeFieldInitializer(Bytecode code, CtClass[] parameters) throws CannotCompileException, NotFoundException {
        void var3_3;
        int stacksize = 0;
        Javac jv = new Javac(code, this);
        try {
            jv.recordParams(parameters, false);
        }
        catch (CompileError e2) {
            throw new CannotCompileException(e2);
        }
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            int s2;
            CtField f2 = fi.field;
            if (!Modifier.isStatic(((CtMember)f2).getModifiers()) && stacksize < (s2 = fi.init.compile(f2.getType(), ((CtMember)f2).getName(), code, parameters, jv))) {
                stacksize = s2;
            }
            fi = fi.next;
        }
        return (int)var3_3;
    }

    Map<CtMethod, String> getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable<CtMethod, String>();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }

    @Override
    public String makeUniqueName(String prefix) {
        String name;
        HashMap<Object, CtClassType> table = new HashMap<Object, CtClassType>();
        this.makeMemberList(table);
        Set keys2 = table.keySet();
        String[] methods = new String[keys2.size()];
        keys2.toArray(methods);
        if (CtClassType.notFindInArray(prefix, methods)) {
            return prefix;
        }
        int i2 = 100;
        do {
            if (i2 <= 999) continue;
            throw new RuntimeException("too many unique name");
        } while (!CtClassType.notFindInArray(name = prefix + i2++, methods));
        return name;
    }

    private static boolean notFindInArray(String prefix, String[] values2) {
        int len = values2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!values2[i2].startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void makeMemberList(Map<Object, CtClassType> table) {
        int mod22 = ((CtClass)this).getModifiers();
        if (Modifier.isAbstract(mod22) || Modifier.isInterface(mod22)) {
            try {
                CtClass[] ctClassArray = ((CtClass)this).getInterfaces();
                CtClass[] mod22 = ctClassArray;
                mod22 = ctClassArray;
                int n2 = ctClassArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    CtClass ic = mod22[i2];
                    if (ic == null || !(ic instanceof CtClassType)) continue;
                    ((CtClassType)ic).makeMemberList(table);
                }
            }
            catch (NotFoundException notFoundException) {}
        }
        try {
            CtClass s2 = ((CtClass)this).getSuperclass();
            if (s2 != null && s2 instanceof CtClassType) {
                void var2_4;
                ((CtClassType)var2_4).makeMemberList(table);
            }
        }
        catch (NotFoundException notFoundException) {}
        List<FieldInfo> list = ((CtClass)this).getClassFile2().getMethods();
        for (MethodInfo methodInfo : list) {
            table.put(methodInfo.getName(), this);
        }
        list = ((CtClass)this).getClassFile2().getFields();
        for (FieldInfo finfo : list) {
            table.put(finfo.getName(), this);
        }
    }
}

