/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPathList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.DirClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.JarClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.JarDirClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.LoaderClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

final class ClassPoolTail {
    protected ClassPathList pathList = null;

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        buf.append("[class path: ");
        ClassPathList list = this.pathList;
        while (list != null) {
            buf.append(list.path.toString());
            buf.append(File.pathSeparatorChar);
            list = list.next;
        }
        buf.append(']');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized ClassPath insertClassPath(ClassPath cp) {
        void var1_1;
        this.pathList = new ClassPathList(cp, this.pathList);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized ClassPath appendClassPath(ClassPath cp) {
        void var1_1;
        ClassPathList tail = new ClassPathList(cp, null);
        ClassPathList list = this.pathList;
        if (list == null) {
            this.pathList = tail;
        } else {
            void var2_2;
            while (list.next != null) {
                list = list.next;
            }
            var3_3.next = var2_2;
        }
        return var1_1;
    }

    public final synchronized void removeClassPath(ClassPath cp) {
        ClassPathList list = this.pathList;
        if (list != null) {
            if (list.path == cp) {
                this.pathList = list.next;
                return;
            }
            while (list.next != null) {
                if (list.next.path == cp) {
                    list.next = list.next.next;
                    continue;
                }
                list = list.next;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ClassPath appendSystemPath() {
        void var1_1;
        if (ClassFile.MAJOR_VERSION < 53) {
            return this.appendClassPath(new ClassClassPath());
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.appendClassPath(new LoaderClassPath((ClassLoader)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final ClassPath insertClassPath(String pathname) throws NotFoundException {
        void var1_1;
        return this.insertClassPath(ClassPoolTail.makePathObject((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final ClassPath appendClassPath(String pathname) throws NotFoundException {
        void var1_1;
        return this.appendClassPath(ClassPoolTail.makePathObject((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static ClassPath makePathObject(String pathname) throws NotFoundException {
        String string;
        String lower = pathname.toLowerCase();
        if (lower.endsWith(".jar") || lower.endsWith(".zip")) {
            return new JarClassPath(pathname);
        }
        int len = pathname.length();
        if (len > 2 && pathname.charAt(len - 1) == '*' && (pathname.charAt(len - 2) == '/' || pathname.charAt(len - 2) == File.separatorChar)) {
            void var1_2;
            String dir = pathname.substring(0, (int)(var1_2 - 2));
            return new JarDirClassPath(string);
        }
        return new DirClassPath(string);
    }

    /*
     * WARNING - void declaration
     */
    final void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        InputStream fin = this.openClassfile(classname);
        if (fin == null) {
            void var1_1;
            throw new NotFoundException((String)var1_1);
        }
        try {
            void var2_3;
            ClassPoolTail.copyStream(fin, (OutputStream)var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.close();
            throw throwable;
        }
        fin.close();
    }

    /*
     * WARNING - void declaration
     */
    final InputStream openClassfile(String classname) throws NotFoundException {
        ClassPathList list = this.pathList;
        InputStream ins = null;
        NotFoundException error = null;
        while (list != null) {
            void var3_3;
            block5: {
                try {
                    ins = list.path.openClassfile(classname);
                }
                catch (NotFoundException e2) {
                    if (error != null) break block5;
                    error = e2;
                }
            }
            if (ins == null) {
                list = list.next;
                continue;
            }
            return var3_3;
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final URL find(String classname) {
        ClassPathList list = this.pathList;
        while (list != null) {
            void var3_3;
            URL url = list.path.find(classname);
            if (url == null) {
                list = list.next;
                continue;
            }
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readStream(InputStream fin) throws IOException {
        byte[][] bufs = new byte[8][];
        int bufsize = 4096;
        for (int i2 = 0; i2 < 8; ++i2) {
            void var2_2;
            int len;
            bufs[i2] = new byte[bufsize];
            int size = 0;
            do {
                Object object;
                if ((len = fin.read(bufs[i2], size, bufsize - size)) >= 0) continue;
                Object result = new byte[bufsize - 4096 + size];
                int s2 = 0;
                for (int j2 = 0; j2 < i2; ++j2) {
                    int n2 = s2;
                    System.arraycopy(bufs[j2], 0, result, n2, n2 + 4096);
                    int n3 = s2;
                    s2 = n3 + n3 + 4096;
                }
                System.arraycopy(bufs[i2], 0, result, (int)var2_2, size);
                return object;
            } while ((size += len) < var2_2);
            var2_2 <<= 1;
        }
        throw new IOException("too much data");
    }

    public static void copyStream(InputStream fin, OutputStream fout) throws IOException {
        int bufsize = 4096;
        byte[] buf = null;
        for (int i2 = 0; i2 < 64; ++i2) {
            int len;
            if (i2 < 8) {
                buf = new byte[bufsize <<= 1];
            }
            int size = 0;
            do {
                if ((len = fin.read(buf, size, bufsize - size)) >= 0) continue;
                fout.write(buf, 0, size);
                return;
            } while ((size += len) < bufsize);
            fout.write(buf);
        }
        throw new IOException("too much data");
    }
}

