/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.TtlTransformer;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlExecutorTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlForkJoinTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlPriorityBlockingQueueTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlTimerTaskTransformlet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public final class TtlAgent {
    private static volatile Map<String, String> kvs;
    private static volatile boolean ttlAgentLoaded;
    private static final String TTL_AGENT_ENABLE_TIMER_TASK_KEY = "ttl.agent.enable.timer.task";
    private static final String TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL = "ttl.agent.disable.inheritable.for.thread.pool";

    /*
     * WARNING - void declaration
     */
    public static void premain(String agentArgs, @NonNull Instrumentation inst) {
        kvs = TtlAgent.splitCommaColonStringToKV(agentArgs);
        Logger.setLoggerImplType(TtlAgent.getLogImplTypeFromAgentArgs(kvs));
        Logger logger = Logger.getLogger(TtlAgent.class);
        try {
            void var1_4;
            logger.info("[TtlAgent.premain] begin, agentArgs: " + agentArgs + ", Instrumentation: " + inst);
            boolean disableInheritableForThreadPool = TtlAgent.isDisableInheritableForThreadPool();
            ArrayList<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();
            transformletList.add(new TtlExecutorTransformlet(disableInheritableForThreadPool));
            transformletList.add(new TtlPriorityBlockingQueueTransformlet());
            transformletList.add(new TtlForkJoinTransformlet(disableInheritableForThreadPool));
            if (TtlAgent.isEnableTimerTask()) {
                transformletList.add(new TtlTimerTaskTransformlet());
            }
            TtlTransformer transformer = new TtlTransformer(transformletList);
            var1_4.addTransformer(transformer, true);
            logger.info("[TtlAgent.premain] addTransformer " + transformer.getClass() + " success");
            logger.info("[TtlAgent.premain] end");
            ttlAgentLoaded = true;
            return;
        }
        catch (Exception e2) {
            void var0_3;
            void var3_7;
            void var2_5;
            String msg = "Fail to load TtlAgent , cause: " + e2;
            var2_5.log(Level.SEVERE, msg, e2);
            throw new IllegalStateException((String)var3_7, (Throwable)var0_3);
        }
    }

    private static String getLogImplTypeFromAgentArgs(@NonNull Map<String, String> kvs) {
        return kvs.get("ttl.agent.logger");
    }

    public static boolean isTtlAgentLoaded() {
        return ttlAgentLoaded;
    }

    public static boolean isDisableInheritableForThreadPool() {
        return TtlAgent.isBooleanOptionSet(kvs, TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL, false);
    }

    public static boolean isEnableTimerTask() {
        return TtlAgent.isBooleanOptionSet(kvs, TTL_AGENT_ENABLE_TIMER_TASK_KEY, true);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isBooleanOptionSet(@Nullable Map<String, String> kvs, @NonNull String key, boolean defaultValue) {
        void var1_1;
        Map<String, String> map;
        if (kvs == null) {
            return defaultValue;
        }
        boolean bl = kvs.containsKey(key);
        if (!bl) {
            void var2_2;
            return (boolean)var2_2;
        }
        return !"false".equalsIgnoreCase(map.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    static Map<String, String> splitCommaColonStringToKV(@Nullable String commaColonString) {
        void var1_1;
        String[] stringArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (commaColonString == null || commaColonString.trim().length() == 0) {
            return ret;
        }
        String[] stringArray2 = stringArray.trim().split("\\s*,\\s*");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            String[] kv = string.trim().split("\\s*:\\s*");
            if (kv.length == 0) continue;
            if (kv.length == 1) {
                ret.put(kv[0], "");
                continue;
            }
            ret.put(kv[0], kv[1]);
        }
        return var1_1;
    }

    private TtlAgent() {
        throw new InstantiationError("Must not instantiate this class");
    }

    static {
        ttlAgentLoaded = false;
    }
}

