/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool;

import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import com.alibaba.ttl.threadpool.ComparableComparator;
import com.alibaba.ttl.threadpool.DisableInheritableThreadFactory;
import com.alibaba.ttl.threadpool.DisableInheritableThreadFactoryWrapper;
import com.alibaba.ttl.threadpool.ExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.ExecutorTtlWrapper;
import com.alibaba.ttl.threadpool.ScheduledExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.TtlUnwrapComparator;
import com.alibaba.ttl.threadpool.agent.TtlAgent;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.Contract;

public final class TtlExecutors {
    private static final Comparator INSTANCE = new TtlUnwrapComparator(ComparableComparator.INSTANCE);

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static Executor getTtlExecutor(@Nullable Executor executor) {
        Executor executor2;
        if (TtlAgent.isTtlAgentLoaded() || executor == null || executor instanceof TtlEnhanced) {
            return executor;
        }
        return new ExecutorTtlWrapper(executor2, true);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ExecutorService getTtlExecutorService(@Nullable ExecutorService executorService) {
        ExecutorService executorService2;
        if (TtlAgent.isTtlAgentLoaded() || executorService == null || executorService instanceof TtlEnhanced) {
            return executorService;
        }
        return new ExecutorServiceTtlWrapper(executorService2, true);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ScheduledExecutorService getTtlScheduledExecutorService(@Nullable ScheduledExecutorService scheduledExecutorService) {
        ScheduledExecutorService scheduledExecutorService2;
        if (TtlAgent.isTtlAgentLoaded() || scheduledExecutorService == null || scheduledExecutorService instanceof TtlEnhanced) {
            return scheduledExecutorService;
        }
        return new ScheduledExecutorServiceTtlWrapper(scheduledExecutorService2, true);
    }

    public static <T extends Executor> boolean isTtlWrapper(@Nullable T executor) {
        return executor instanceof TtlWrapper;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T extends Executor> T unwrap(@Nullable T executor) {
        T t2;
        if (!TtlExecutors.isTtlWrapper(executor)) {
            return executor;
        }
        return (T)((ExecutorTtlWrapper)t2).unwrap();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ThreadFactory getDisableInheritableThreadFactory(@Nullable ThreadFactory threadFactory) {
        ThreadFactory threadFactory2;
        if (threadFactory == null || TtlExecutors.isDisableInheritableThreadFactory(threadFactory)) {
            return threadFactory;
        }
        return new DisableInheritableThreadFactoryWrapper(threadFactory2);
    }

    @NonNull
    public static ThreadFactory getDefaultDisableInheritableThreadFactory() {
        return TtlExecutors.getDisableInheritableThreadFactory(Executors.defaultThreadFactory());
    }

    public static boolean isDisableInheritableThreadFactory(@Nullable ThreadFactory threadFactory) {
        return threadFactory instanceof DisableInheritableThreadFactory;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ThreadFactory unwrap(@Nullable ThreadFactory threadFactory) {
        ThreadFactory threadFactory2;
        if (!TtlExecutors.isDisableInheritableThreadFactory(threadFactory)) {
            return threadFactory;
        }
        return ((DisableInheritableThreadFactory)threadFactory2).unwrap();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static Comparator<Runnable> getTtlRunnableUnwrapComparator(@Nullable Comparator<Runnable> comparator) {
        Comparator<Runnable> comparator2;
        if (comparator == null || TtlExecutors.isTtlRunnableUnwrapComparator(comparator)) {
            return comparator;
        }
        return new TtlUnwrapComparator<Runnable>(comparator2);
    }

    @NonNull
    public static Comparator<Runnable> getTtlRunnableUnwrapComparatorForComparableRunnable() {
        return INSTANCE;
    }

    public static boolean isTtlRunnableUnwrapComparator(@Nullable Comparator<Runnable> comparator) {
        return comparator instanceof TtlUnwrapComparator;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static Comparator<Runnable> unwrap(@Nullable Comparator<Runnable> comparator) {
        Comparator<Runnable> comparator2;
        if (!TtlExecutors.isTtlRunnableUnwrapComparator(comparator)) {
            return comparator;
        }
        return ((TtlUnwrapComparator)comparator2).unwrap();
    }

    private TtlExecutors() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

