/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;

public final class TtlWrappers {
    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> Supplier<T> wrapSupplier(@Nullable Supplier<T> supplier) {
        Supplier<T> supplier2;
        if (supplier == null) {
            return null;
        }
        if (supplier instanceof TtlEnhanced) {
            return supplier;
        }
        return new TtlSupplier<T>(supplier2);
    }

    @Deprecated
    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> Supplier<T> wrap(@Nullable Supplier<T> supplier) {
        return TtlWrappers.wrapSupplier(supplier);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> Consumer<T> wrapConsumer(@Nullable Consumer<T> consumer) {
        Consumer<T> consumer2;
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof TtlEnhanced) {
            return consumer;
        }
        return new TtlConsumer<T>(consumer2);
    }

    @Deprecated
    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> Consumer<T> wrap(@Nullable Consumer<T> consumer) {
        return TtlWrappers.wrapConsumer(consumer);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T, U> BiConsumer<T, U> wrapBiConsumer(@Nullable BiConsumer<T, U> consumer) {
        BiConsumer<T, U> biConsumer;
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof TtlEnhanced) {
            return consumer;
        }
        return new TtlBiConsumer<T, U>(biConsumer);
    }

    @Deprecated
    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T, U> BiConsumer<T, U> wrap(@Nullable BiConsumer<T, U> consumer) {
        return TtlWrappers.wrapBiConsumer(consumer);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T, R> Function<T, R> wrapFunction(@Nullable Function<T, R> fn) {
        Function<T, R> function;
        if (fn == null) {
            return null;
        }
        if (fn instanceof TtlEnhanced) {
            return fn;
        }
        return new TtlFunction<T, R>(function);
    }

    @Deprecated
    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T, R> Function<T, R> wrap(@Nullable Function<T, R> fn) {
        return TtlWrappers.wrapFunction(fn);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T, U, R> BiFunction<T, U, R> wrapBiFunction(@Nullable BiFunction<T, U, R> fn) {
        BiFunction<T, U, R> biFunction;
        if (fn == null) {
            return null;
        }
        if (fn instanceof TtlEnhanced) {
            return fn;
        }
        return new TtlBiFunction<T, U, R>(biFunction);
    }

    @Deprecated
    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T, U, R> BiFunction<T, U, R> wrap(@Nullable BiFunction<T, U, R> fn) {
        return TtlWrappers.wrapBiFunction(fn);
    }

    private TtlWrappers() {
        throw new InstantiationError("Must not instantiate this class");
    }

    private static class TtlBiFunction<T, U, R>
    implements TtlEnhanced,
    TtlWrapper<BiFunction<T, U, R>>,
    BiFunction<T, U, R> {
        final BiFunction<T, U, R> fn;
        final Object captured;

        /*
         * WARNING - void declaration
         */
        TtlBiFunction(@NonNull BiFunction<T, U, R> fn) {
            void var1_1;
            this.fn = var1_1;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public R apply(T t2, U u2) {
            R r2;
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                void var2_3;
                r2 = this.fn.apply((void)r2, var2_3);
            }
            catch (Throwable throwable) {
                void var3_4;
                TransmittableThreadLocal.Transmitter.restore(var3_4);
                throw throwable;
            }
            TransmittableThreadLocal.Transmitter.restore(backup);
            return r2;
        }

        @Override
        @NonNull
        public BiFunction<T, U, R> unwrap() {
            return this.fn;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o2) {
            void var1_1;
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            TtlBiFunction that = (TtlBiFunction)o2;
            return this.fn.equals(var1_1.fn);
        }

        public int hashCode() {
            return this.fn.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.fn.toString();
        }
    }

    private static class TtlFunction<T, R>
    implements TtlEnhanced,
    TtlWrapper<Function<T, R>>,
    Function<T, R> {
        final Function<T, R> fn;
        final Object captured;

        /*
         * WARNING - void declaration
         */
        TtlFunction(@NonNull Function<T, R> fn) {
            void var1_1;
            this.fn = var1_1;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public R apply(T t2) {
            R r2;
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                r2 = this.fn.apply((void)r2);
            }
            catch (Throwable throwable) {
                void var2_3;
                TransmittableThreadLocal.Transmitter.restore(var2_3);
                throw throwable;
            }
            TransmittableThreadLocal.Transmitter.restore(backup);
            return r2;
        }

        @Override
        @NonNull
        public Function<T, R> unwrap() {
            return this.fn;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o2) {
            void var1_1;
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            TtlFunction that = (TtlFunction)o2;
            return this.fn.equals(var1_1.fn);
        }

        public int hashCode() {
            return this.fn.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.fn.toString();
        }
    }

    private static class TtlBiConsumer<T, U>
    implements TtlEnhanced,
    TtlWrapper<BiConsumer<T, U>>,
    BiConsumer<T, U> {
        final BiConsumer<T, U> consumer;
        final Object captured;

        /*
         * WARNING - void declaration
         */
        TtlBiConsumer(@NonNull BiConsumer<T, U> consumer) {
            void var1_1;
            this.consumer = var1_1;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accept(T t2, U u2) {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                void var2_3;
                void var1_1;
                this.consumer.accept(var1_1, var2_3);
            }
            catch (Throwable throwable) {
                void var3_4;
                TransmittableThreadLocal.Transmitter.restore(var3_4);
                throw throwable;
            }
            TransmittableThreadLocal.Transmitter.restore(backup);
        }

        @Override
        @NonNull
        public BiConsumer<T, U> unwrap() {
            return this.consumer;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o2) {
            void var1_1;
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            TtlBiConsumer that = (TtlBiConsumer)o2;
            return this.consumer.equals(var1_1.consumer);
        }

        public int hashCode() {
            return this.consumer.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.consumer.toString();
        }
    }

    private static class TtlConsumer<T>
    implements TtlEnhanced,
    TtlWrapper<Consumer<T>>,
    Consumer<T> {
        final Consumer<T> consumer;
        final Object captured;

        /*
         * WARNING - void declaration
         */
        TtlConsumer(@NonNull Consumer<T> consumer) {
            void var1_1;
            this.consumer = var1_1;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accept(T t2) {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                void var1_1;
                this.consumer.accept(var1_1);
            }
            catch (Throwable throwable) {
                void var2_3;
                TransmittableThreadLocal.Transmitter.restore(var2_3);
                throw throwable;
            }
            TransmittableThreadLocal.Transmitter.restore(backup);
        }

        @Override
        @NonNull
        public Consumer<T> unwrap() {
            return this.consumer;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o2) {
            void var1_1;
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            TtlConsumer that = (TtlConsumer)o2;
            return this.consumer.equals(var1_1.consumer);
        }

        public int hashCode() {
            return this.consumer.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.consumer.toString();
        }
    }

    private static class TtlSupplier<T>
    implements TtlEnhanced,
    TtlWrapper<Supplier<T>>,
    Supplier<T> {
        final Supplier<T> supplier;
        final Object captured;

        /*
         * WARNING - void declaration
         */
        TtlSupplier(@NonNull Supplier<T> supplier) {
            void var1_1;
            this.supplier = var1_1;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T get() {
            T t2;
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                t2 = this.supplier.get();
            }
            catch (Throwable throwable) {
                void var1_1;
                TransmittableThreadLocal.Transmitter.restore(var1_1);
                throw throwable;
            }
            TransmittableThreadLocal.Transmitter.restore(backup);
            return t2;
        }

        @Override
        @NonNull
        public Supplier<T> unwrap() {
            return this.supplier;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o2) {
            void var1_1;
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            TtlSupplier that = (TtlSupplier)o2;
            return this.supplier.equals(var1_1.supplier);
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.supplier.toString();
        }
    }
}

