/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.spi.TtlAttachments;
import com.alibaba.ttl.spi.TtlAttachmentsDelegate;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;

public final class TtlRunnable
implements TtlAttachments,
TtlEnhanced,
TtlWrapper<Runnable>,
Runnable {
    private final AtomicReference<Object> capturedRef;
    private final Runnable runnable;
    private final boolean releaseTtlValueReferenceAfterRun;
    private final TtlAttachmentsDelegate ttlAttachment = new TtlAttachmentsDelegate();

    /*
     * WARNING - void declaration
     */
    private TtlRunnable(@NonNull Runnable runnable2, boolean releaseTtlValueReferenceAfterRun) {
        void var2_2;
        void var1_1;
        this.capturedRef = new AtomicReference<Object>(TransmittableThreadLocal.Transmitter.capture());
        this.runnable = var1_1;
        this.releaseTtlValueReferenceAfterRun = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        Object captured = this.capturedRef.get();
        if (captured == null || this.releaseTtlValueReferenceAfterRun && !this.capturedRef.compareAndSet(captured, null)) {
            throw new IllegalStateException("TTL value reference is released after run!");
        }
        Object backup = TransmittableThreadLocal.Transmitter.replay(captured);
        try {
            this.runnable.run();
        }
        catch (Throwable throwable) {
            void var1_1;
            TransmittableThreadLocal.Transmitter.restore(var1_1);
            throw throwable;
        }
        TransmittableThreadLocal.Transmitter.restore(backup);
    }

    @NonNull
    public final Runnable getRunnable() {
        return this.unwrap();
    }

    @Override
    @NonNull
    public final Runnable unwrap() {
        return this.runnable;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o2) {
        void var1_1;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TtlRunnable that = (TtlRunnable)o2;
        return this.runnable.equals(var1_1.runnable);
    }

    public final int hashCode() {
        return this.runnable.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + " - " + this.runnable.toString();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static TtlRunnable get(@Nullable Runnable runnable2) {
        return TtlRunnable.get(runnable2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null", pure=true)
    public static TtlRunnable get(@Nullable Runnable runnable2, boolean releaseTtlValueReferenceAfterRun) {
        void var1_1;
        return TtlRunnable.get(runnable2, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @Contract(value="null, _, _ -> null; !null, _, _ -> !null", pure=true)
    public static TtlRunnable get(@Nullable Runnable runnable2, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        void var1_1;
        Runnable runnable3;
        if (runnable2 == null) {
            return null;
        }
        if (runnable2 instanceof TtlEnhanced) {
            void var2_2;
            if (var2_2 != false) {
                return (TtlRunnable)runnable2;
            }
            throw new IllegalStateException("Already TtlRunnable!");
        }
        return new TtlRunnable(runnable3, (boolean)var1_1);
    }

    @NonNull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks) {
        return TtlRunnable.gets(tasks, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun) {
        void var1_1;
        return TtlRunnable.gets(tasks, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        void var3_3;
        Iterator<? extends Runnable> iterator2;
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList<TtlRunnable> copy = new ArrayList<TtlRunnable>();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Runnable task = (Runnable)iterator2.next();
            copy.add(TtlRunnable.get(task, releaseTtlValueReferenceAfterRun, idempotent));
        }
        return var3_3;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static Runnable unwrap(@Nullable Runnable runnable2) {
        Runnable runnable3;
        if (!(runnable2 instanceof TtlRunnable)) {
            return runnable2;
        }
        return ((TtlRunnable)runnable3).getRunnable();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static List<Runnable> unwraps(@Nullable Collection<? extends Runnable> tasks) {
        void var1_1;
        Iterator<? extends Runnable> iterator2;
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> copy = new ArrayList<Runnable>();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            Runnable task = (Runnable)iterator2.next();
            if (!(task instanceof TtlRunnable)) {
                copy.add(task);
                continue;
            }
            copy.add(((TtlRunnable)var2_2).getRunnable());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTtlAttachment(@NonNull String key, Object value) {
        void var2_2;
        void var1_1;
        this.ttlAttachment.setTtlAttachment((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getTtlAttachment(@NonNull String key) {
        void var1_1;
        return this.ttlAttachment.getTtlAttachment((String)var1_1);
    }
}

