/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.spi.TtlAttachments;
import com.alibaba.ttl.spi.TtlAttachmentsDelegate;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;

public final class TtlCallable<V>
implements TtlAttachments,
TtlEnhanced,
TtlWrapper<Callable<V>>,
Callable<V> {
    private final AtomicReference<Object> capturedRef;
    private final Callable<V> callable;
    private final boolean releaseTtlValueReferenceAfterCall;
    private final TtlAttachmentsDelegate ttlAttachment = new TtlAttachmentsDelegate();

    /*
     * WARNING - void declaration
     */
    private TtlCallable(@NonNull Callable<V> callable, boolean releaseTtlValueReferenceAfterCall) {
        void var2_2;
        void var1_1;
        this.capturedRef = new AtomicReference<Object>(TransmittableThreadLocal.Transmitter.capture());
        this.callable = var1_1;
        this.releaseTtlValueReferenceAfterCall = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
    public final V call() throws Exception {
        V v2;
        Object captured = this.capturedRef.get();
        if (captured == null || this.releaseTtlValueReferenceAfterCall && !this.capturedRef.compareAndSet(captured, null)) {
            throw new IllegalStateException("TTL value reference is released after call!");
        }
        Object backup = TransmittableThreadLocal.Transmitter.replay(captured);
        try {
            v2 = this.callable.call();
        }
        catch (Throwable throwable) {
            void var1_1;
            TransmittableThreadLocal.Transmitter.restore(var1_1);
            throw throwable;
        }
        TransmittableThreadLocal.Transmitter.restore(backup);
        return v2;
    }

    @NonNull
    public final Callable<V> getCallable() {
        return this.unwrap();
    }

    @Override
    @NonNull
    public final Callable<V> unwrap() {
        return this.callable;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o2) {
        void var1_1;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TtlCallable that = (TtlCallable)o2;
        return this.callable.equals(var1_1.callable);
    }

    public final int hashCode() {
        return this.callable.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + " - " + this.callable.toString();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> TtlCallable<T> get(@Nullable Callable<T> callable) {
        return TtlCallable.get(callable, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null", pure=true)
    public static <T> TtlCallable<T> get(@Nullable Callable<T> callable, boolean releaseTtlValueReferenceAfterCall) {
        void var1_1;
        return TtlCallable.get(callable, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @Contract(value="null, _, _ -> null; !null, _, _ -> !null", pure=true)
    public static <T> TtlCallable<T> get(@Nullable Callable<T> callable, boolean releaseTtlValueReferenceAfterCall, boolean idempotent) {
        void var1_1;
        Callable<T> callable2;
        if (callable == null) {
            return null;
        }
        if (callable instanceof TtlEnhanced) {
            void var2_2;
            if (var2_2 != false) {
                return (TtlCallable)callable;
            }
            throw new IllegalStateException("Already TtlCallable!");
        }
        return new TtlCallable<T>(callable2, (boolean)var1_1);
    }

    @NonNull
    public static <T> List<TtlCallable<T>> gets(@Nullable Collection<? extends Callable<T>> tasks) {
        return TtlCallable.gets(tasks, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T> List<TtlCallable<T>> gets(@Nullable Collection<? extends Callable<T>> tasks, boolean releaseTtlValueReferenceAfterCall) {
        void var1_1;
        return TtlCallable.gets(tasks, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T> List<TtlCallable<T>> gets(@Nullable Collection<? extends Callable<T>> tasks, boolean releaseTtlValueReferenceAfterCall, boolean idempotent) {
        void var3_3;
        Iterator<? extends Callable<T>> iterator2;
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList<TtlCallable<T>> copy = new ArrayList<TtlCallable<T>>();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Callable task = (Callable)iterator2.next();
            copy.add(TtlCallable.get(task, releaseTtlValueReferenceAfterCall, idempotent));
        }
        return var3_3;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> Callable<T> unwrap(@Nullable Callable<T> callable) {
        Callable<T> callable2;
        if (!(callable instanceof TtlCallable)) {
            return callable;
        }
        return ((TtlCallable)callable2).getCallable();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T> List<Callable<T>> unwraps(@Nullable Collection<? extends Callable<T>> tasks) {
        void var1_1;
        Iterator<? extends Callable<T>> iterator2;
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList copy = new ArrayList();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            Callable task = (Callable)iterator2.next();
            if (!(task instanceof TtlCallable)) {
                copy.add(task);
                continue;
            }
            copy.add(((TtlCallable)var2_2).getCallable());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTtlAttachment(@NonNull String key, Object value) {
        void var2_2;
        void var1_1;
        this.ttlAttachment.setTtlAttachment((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getTtlAttachment(@NonNull String key) {
        void var1_1;
        return this.ttlAttachment.getTtlAttachment((String)var1_1);
    }
}

