/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.util;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;
import java.util.stream.IntStream;

public final class FluentBitSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final BitSet bitSet;

    public FluentBitSet() {
        this(new BitSet());
    }

    /*
     * WARNING - void declaration
     */
    public FluentBitSet(BitSet set) {
        void var1_1;
        this.bitSet = (BitSet)Objects.requireNonNull(var1_1, "set");
    }

    /*
     * WARNING - void declaration
     */
    public FluentBitSet(int nbits) {
        this(new BitSet((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet and(BitSet set) {
        void var1_1;
        this.bitSet.and((BitSet)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet and(FluentBitSet set) {
        void var1_1;
        this.bitSet.and(var1_1.bitSet);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet andNot(BitSet set) {
        void var1_1;
        this.bitSet.andNot((BitSet)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet andNot(FluentBitSet set) {
        void var1_1;
        this.bitSet.andNot(var1_1.bitSet);
        return this;
    }

    public final BitSet bitSet() {
        return this.bitSet;
    }

    public final int cardinality() {
        return this.bitSet.cardinality();
    }

    public final FluentBitSet clear() {
        this.bitSet.clear();
        return this;
    }

    public final FluentBitSet clear(int ... bitIndexArray) {
        int[] nArray = bitIndexArray;
        int n2 = bitIndexArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int e2 = nArray[i2];
            this.bitSet.clear(e2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet clear(int bitIndex) {
        void var1_1;
        this.bitSet.clear((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet clear(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        this.bitSet.clear((int)var1_1, (int)var2_2);
        return this;
    }

    public final Object clone() {
        return new FluentBitSet((BitSet)this.bitSet.clone());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FluentBitSet)) {
            return false;
        }
        FluentBitSet other = (FluentBitSet)obj;
        return Objects.equals(this.bitSet, var1_1.bitSet);
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet flip(int bitIndex) {
        void var1_1;
        this.bitSet.flip((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet flip(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        this.bitSet.flip((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean get(int bitIndex) {
        void var1_1;
        return this.bitSet.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet get(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        return new FluentBitSet(this.bitSet.get((int)var1_1, (int)var2_2));
    }

    public final int hashCode() {
        return this.bitSet.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean intersects(BitSet set) {
        void var1_1;
        return this.bitSet.intersects((BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean intersects(FluentBitSet set) {
        void var1_1;
        return this.bitSet.intersects(var1_1.bitSet);
    }

    public final boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    public final int length() {
        return this.bitSet.length();
    }

    /*
     * WARNING - void declaration
     */
    public final int nextClearBit(int fromIndex) {
        void var1_1;
        return this.bitSet.nextClearBit((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int nextSetBit(int fromIndex) {
        void var1_1;
        return this.bitSet.nextSetBit((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet or(BitSet set) {
        void var1_1;
        this.bitSet.or((BitSet)var1_1);
        return this;
    }

    public final FluentBitSet or(FluentBitSet ... set) {
        FluentBitSet[] fluentBitSetArray = set;
        int n2 = set.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FluentBitSet e2 = fluentBitSetArray[i2];
            this.bitSet.or(e2.bitSet);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet or(FluentBitSet set) {
        void var1_1;
        this.bitSet.or(var1_1.bitSet);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final int previousClearBit(int fromIndex) {
        void var1_1;
        return this.bitSet.previousClearBit((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int previousSetBit(int fromIndex) {
        void var1_1;
        return this.bitSet.previousSetBit((int)var1_1);
    }

    public final FluentBitSet set(int ... bitIndexArray) {
        int[] nArray = bitIndexArray;
        int n2 = bitIndexArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int e2 = nArray[i2];
            this.bitSet.set(e2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet set(int bitIndex) {
        void var1_1;
        this.bitSet.set((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet set(int bitIndex, boolean value) {
        void var2_2;
        void var1_1;
        this.bitSet.set((int)var1_1, (boolean)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet set(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        this.bitSet.set((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet set(int fromIndex, int toIndex, boolean value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bitSet.set((int)var1_1, (int)var2_2, (boolean)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet setInclusive(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        this.bitSet.set((int)var1_1, (int)(var2_2 + true));
        return this;
    }

    public final int size() {
        return this.bitSet.size();
    }

    public final IntStream stream() {
        return this.bitSet.stream();
    }

    public final byte[] toByteArray() {
        return this.bitSet.toByteArray();
    }

    public final long[] toLongArray() {
        return this.bitSet.toLongArray();
    }

    public final String toString() {
        return this.bitSet.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet xor(BitSet set) {
        void var1_1;
        this.bitSet.xor((BitSet)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final FluentBitSet xor(FluentBitSet set) {
        void var1_1;
        this.bitSet.xor(var1_1.bitSet);
        return this;
    }
}

