/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class ImmutablePair<L, R>
extends Pair<L, R> {
    public static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair NULL = new ImmutablePair<Object, Object>(null, null);
    private static final long serialVersionUID = 4954918890077093841L;
    public final L left;
    public final R right;

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> Pair<L, R> left(L left) {
        return ImmutablePair.of(left, null);
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    /*
     * WARNING - void declaration
     */
    public static <L, R> ImmutablePair<L, R> of(L left, R right) {
        if (left != null || right != null) {
            void var1_1;
            L l2;
            return new ImmutablePair<L, void>(l2, var1_1);
        }
        return ImmutablePair.nullPair();
    }

    public static <L, R> ImmutablePair<L, R> of(Map.Entry<L, R> pair) {
        if (pair != null) {
            Map.Entry<L, R> entry;
            return new ImmutablePair<L, R>(pair.getKey(), entry.getValue());
        }
        return ImmutablePair.nullPair();
    }

    /*
     * WARNING - void declaration
     */
    public static <L, R> ImmutablePair<L, R> ofNonNull(L left, R right) {
        void var1_1;
        return ImmutablePair.of(Objects.requireNonNull(left, "left"), Objects.requireNonNull(var1_1, "right"));
    }

    public static <L, R> Pair<L, R> right(R right) {
        R r2;
        return ImmutablePair.of(null, r2);
    }

    /*
     * WARNING - void declaration
     */
    public ImmutablePair(L left, R right) {
        void var2_2;
        void var1_1;
        this.left = var1_1;
        this.right = var2_2;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }
}

