/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

final class GmtTimeZone
extends TimeZone {
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    static final long serialVersionUID = 1L;
    private final int offset;
    private final String zoneId;

    /*
     * WARNING - void declaration
     */
    private static StringBuilder twoDigits(StringBuilder sb, int n2) {
        void var1_1;
        return sb.append((char)(48 + n2 / 10)).append((char)(48 + var1_1 % 10));
    }

    /*
     * WARNING - void declaration
     */
    GmtTimeZone(boolean negate, int hours, int minutes) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (hours >= 24) {
            throw new IllegalArgumentException(hours + " hours out of range");
        }
        if (minutes >= 60) {
            throw new IllegalArgumentException(minutes + " minutes out of range");
        }
        int milliseconds = (minutes + hours * 60) * 60000;
        this.offset = negate ? -milliseconds : milliseconds;
        this.zoneId = GmtTimeZone.twoDigits(GmtTimeZone.twoDigits(new StringBuilder(9).append("GMT").append(var1_1 != false ? (char)'-' : '+'), (int)var2_2).append(':'), (int)var3_3).toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GmtTimeZone)) {
            return false;
        }
        GmtTimeZone other = (GmtTimeZone)obj;
        return this.offset == other.offset && Objects.equals(this.zoneId, var1_1.zoneId);
    }

    @Override
    public final String getID() {
        return this.zoneId;
    }

    @Override
    public final int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        return this.offset;
    }

    @Override
    public final int getRawOffset() {
        return this.offset;
    }

    public final int hashCode() {
        return Objects.hash(this.offset, this.zoneId);
    }

    @Override
    public final boolean inDaylightTime(Date date) {
        return false;
    }

    @Override
    public final void setRawOffset(int offsetMillis) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return "[GmtTimeZone id=\"" + this.zoneId + "\",offset=" + this.offset + ']';
    }

    @Override
    public final boolean useDaylightTime() {
        return false;
    }
}

