/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.time.FastDateParser;

public class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;

    /*
     * WARNING - void declaration
     */
    private static Date add(Date date, int calendarField, int amount) {
        void var3_3;
        void var2_2;
        void var1_1;
        Date date2;
        DateUtils.validateDateNotNull(date);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date2);
        c2.add((int)var1_1, (int)var2_2);
        return var3_3.getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static Date addDays(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 5, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addHours(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 11, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addMilliseconds(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 14, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addMinutes(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 12, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addMonths(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addSeconds(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 13, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addWeeks(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 3, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date addYears(Date date, int amount) {
        void var1_1;
        return DateUtils.add(date, 1, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar ceiling(Calendar calendar, int field) {
        void var1_1;
        Calendar calendar2;
        Objects.requireNonNull(calendar, "calendar");
        return DateUtils.modify((Calendar)calendar2.clone(), (int)var1_1, ModifyType.CEILING);
    }

    /*
     * WARNING - void declaration
     */
    public static Date ceiling(Date date, int field) {
        void var1_1;
        return DateUtils.modify(DateUtils.toCalendar(date), (int)var1_1, ModifyType.CEILING).getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static Date ceiling(Object date, int field) {
        Object object;
        Objects.requireNonNull(date, "date");
        if (date instanceof Date) {
            return DateUtils.ceiling((Date)date, field);
        }
        if (date instanceof Calendar) {
            void var1_1;
            return DateUtils.ceiling((Calendar)date, (int)var1_1).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + object.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private static long getFragment(Calendar calendar, int fragment, TimeUnit unit) {
        void var3_3;
        Objects.requireNonNull(calendar, "calendar");
        long result = 0L;
        int offset = unit == TimeUnit.DAYS ? 0 : 1;
        switch (fragment) {
            case 1: {
                result = 0L + unit.convert(calendar.get(6) - offset, TimeUnit.DAYS);
                break;
            }
            case 2: {
                result = 0L + unit.convert(calendar.get(5) - offset, TimeUnit.DAYS);
            }
        }
        switch (fragment) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                result += unit.convert(calendar.get(11), TimeUnit.HOURS);
            }
            case 11: {
                result += unit.convert(calendar.get(12), TimeUnit.MINUTES);
            }
            case 12: {
                result += unit.convert(calendar.get(13), TimeUnit.SECONDS);
            }
            case 13: {
                Calendar calendar2;
                void var2_2;
                result += var2_2.convert(calendar2.get(14), TimeUnit.MILLISECONDS);
                break;
            }
            case 14: {
                break;
            }
            default: {
                void var1_1;
                throw new IllegalArgumentException("The fragment " + (int)var1_1 + " is not supported");
            }
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static long getFragment(Date date, int fragment, TimeUnit unit) {
        void var2_2;
        void var1_1;
        void var3_3;
        Date date2;
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        return DateUtils.getFragment((Calendar)var3_3, (int)var1_1, (TimeUnit)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInDays(Calendar calendar, int fragment) {
        void var1_1;
        return DateUtils.getFragment(calendar, (int)var1_1, TimeUnit.DAYS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInDays(Date date, int fragment) {
        void var1_1;
        return DateUtils.getFragment(date, (int)var1_1, TimeUnit.DAYS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInHours(Calendar calendar, int fragment) {
        void var1_1;
        return DateUtils.getFragment(calendar, (int)var1_1, TimeUnit.HOURS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInHours(Date date, int fragment) {
        void var1_1;
        return DateUtils.getFragment(date, (int)var1_1, TimeUnit.HOURS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInMilliseconds(Calendar calendar, int fragment) {
        void var1_1;
        return DateUtils.getFragment(calendar, (int)var1_1, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInMilliseconds(Date date, int fragment) {
        void var1_1;
        return DateUtils.getFragment(date, (int)var1_1, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInMinutes(Calendar calendar, int fragment) {
        void var1_1;
        return DateUtils.getFragment(calendar, (int)var1_1, TimeUnit.MINUTES);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInMinutes(Date date, int fragment) {
        void var1_1;
        return DateUtils.getFragment(date, (int)var1_1, TimeUnit.MINUTES);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInSeconds(Calendar calendar, int fragment) {
        void var1_1;
        return DateUtils.getFragment(calendar, (int)var1_1, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFragmentInSeconds(Date date, int fragment) {
        void var1_1;
        return DateUtils.getFragment(date, (int)var1_1, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        void var1_1;
        Calendar calendar;
        Objects.requireNonNull(cal1, "cal1");
        Objects.requireNonNull(cal2, "cal2");
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && calendar.get(6) == var1_1.get(6);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameDay(Date date1, Date date2) {
        void var1_1;
        return DateUtils.isSameDay(DateUtils.toCalendar(date1), DateUtils.toCalendar((Date)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameInstant(Calendar cal1, Calendar cal2) {
        void var1_1;
        Calendar calendar;
        Objects.requireNonNull(cal1, "cal1");
        Objects.requireNonNull(cal2, "cal2");
        return calendar.getTime().getTime() == var1_1.getTime().getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameInstant(Date date1, Date date2) {
        void var1_1;
        Date date;
        Objects.requireNonNull(date1, "date1");
        Objects.requireNonNull(date2, "date2");
        return date.getTime() == var1_1.getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLocalTime(Calendar cal1, Calendar cal2) {
        void var1_1;
        Calendar calendar;
        Objects.requireNonNull(cal1, "cal1");
        Objects.requireNonNull(cal2, "cal2");
        return cal1.get(14) == cal2.get(14) && cal1.get(13) == cal2.get(13) && cal1.get(12) == cal2.get(12) && cal1.get(11) == cal2.get(11) && cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0) && calendar.getClass() == var1_1.getClass();
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator<Calendar> iterator(Calendar calendar, int rangeStyle) {
        void var3_5;
        void var2_4;
        Calendar end;
        Calendar start;
        Objects.requireNonNull(calendar, "calendar");
        int startCutoff = 1;
        int endCutoff = 7;
        block0 : switch (rangeStyle) {
            case 5: 
            case 6: {
                start = DateUtils.truncate(calendar, 2);
                end = (Calendar)start.clone();
                end.add(2, 1);
                end.add(5, -1);
                if (rangeStyle != 6) break;
                startCutoff = 2;
                endCutoff = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                start = DateUtils.truncate(calendar, 5);
                end = DateUtils.truncate(calendar, 5);
                switch (rangeStyle) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        startCutoff = 2;
                        endCutoff = 1;
                        break block0;
                    }
                    case 3: {
                        startCutoff = calendar.get(7);
                        endCutoff = startCutoff - 1;
                        break block0;
                    }
                    case 4: {
                        Calendar calendar2;
                        startCutoff = calendar.get(7) - 3;
                        endCutoff = calendar2.get(7) + 3;
                        break block0;
                    }
                }
                break;
            }
            default: {
                void var1_1;
                throw new IllegalArgumentException("The range style " + (int)var1_1 + " is not valid.");
            }
        }
        if (startCutoff <= 0) {
            startCutoff += 7;
        }
        if (startCutoff > 7) {
            startCutoff -= 7;
        }
        if (endCutoff <= 0) {
            endCutoff += 7;
        }
        if (endCutoff > 7) {
            endCutoff -= 7;
        }
        while (start.get(7) != startCutoff) {
            start.add(5, -1);
        }
        while (end.get(7) != endCutoff) {
            end.add(5, 1);
        }
        return new DateIterator((Calendar)var2_4, (Calendar)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator<Calendar> iterator(Date focus, int rangeStyle) {
        void var1_1;
        return DateUtils.iterator(DateUtils.toCalendar(focus), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator<?> iterator(Object calendar, int rangeStyle) {
        Object object;
        Objects.requireNonNull(calendar, "calendar");
        if (calendar instanceof Date) {
            return DateUtils.iterator((Date)calendar, rangeStyle);
        }
        if (calendar instanceof Calendar) {
            void var1_1;
            return DateUtils.iterator((Calendar)calendar, (int)var1_1);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    /*
     * WARNING - void declaration
     */
    private static Calendar modify(Calendar val, int field, ModifyType modType) {
        void var1_1;
        if (val.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (field == 14) {
            return val;
        }
        Date date = val.getTime();
        long time = date.getTime();
        boolean done = false;
        int millisecs = val.get(14);
        if (ModifyType.TRUNCATE == modType || millisecs < 500) {
            time -= (long)millisecs;
        }
        if (field == 13) {
            done = true;
        }
        int seconds = val.get(13);
        if (!(done || ModifyType.TRUNCATE != modType && seconds >= 30)) {
            time -= (long)seconds * 1000L;
        }
        if (field == 12) {
            done = true;
        }
        int minutes = val.get(12);
        if (!(done || ModifyType.TRUNCATE != modType && minutes >= 30)) {
            time -= (long)minutes * 60000L;
        }
        if (date.getTime() != time) {
            date.setTime(time);
            val.setTime(date);
        }
        boolean roundUp = false;
        int[][] nArray = fields;
        int n2 = fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int[] aField;
            int[] nArray2 = aField = nArray[i2];
            int n3 = aField.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = nArray2[i3];
                if (n4 != field) continue;
                if (modType == ModifyType.CEILING || modType == ModifyType.ROUND && roundUp) {
                    if (field == 1001) {
                        if (val.get(5) == 1) {
                            val.add(5, 15);
                        } else {
                            val.add(5, -15);
                            val.add(2, 1);
                        }
                    } else if (field == 9) {
                        if (val.get(11) == 0) {
                            val.add(11, 12);
                        } else {
                            val.add(11, -12);
                            val.add(5, 1);
                        }
                    } else {
                        val.add(aField[0], 1);
                    }
                }
                return val;
            }
            int offset = 0;
            boolean offsetSet = false;
            switch (field) {
                case 1001: {
                    if (aField[0] != 5) break;
                    offset = val.get(5) - 1;
                    if (offset >= 15) {
                        offset -= 15;
                    }
                    roundUp = offset > 7;
                    offsetSet = true;
                    break;
                }
                case 9: {
                    if (aField[0] != 11) break;
                    offset = val.get(11);
                    if (offset >= 12) {
                        offset -= 12;
                    }
                    roundUp = offset >= 6;
                    offsetSet = true;
                }
            }
            if (!offsetSet) {
                int min = val.getActualMinimum(aField[0]);
                int max = val.getActualMaximum(aField[0]);
                offset = val.get(aField[0]) - min;
                boolean bl = roundUp = offset > (max - min) / 2;
            }
            if (offset == 0) continue;
            val.set(aField[0], val.get(aField[0]) - offset);
        }
        throw new IllegalArgumentException("The field " + (int)var1_1 + " is not supported");
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseDate(String str, Locale locale, String ... parsePatterns) throws ParseException {
        void var2_2;
        void var1_1;
        return DateUtils.parseDateWithLeniency(str, (Locale)var1_1, (String[])var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseDate(String str, String ... parsePatterns) throws ParseException {
        void var1_1;
        return DateUtils.parseDate(str, null, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseDateStrictly(String str, Locale locale, String ... parsePatterns) throws ParseException {
        void var2_2;
        void var1_1;
        return DateUtils.parseDateWithLeniency(str, (Locale)var1_1, (String[])var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseDateStrictly(String str, String ... parsePatterns) throws ParseException {
        void var1_1;
        return DateUtils.parseDateStrictly(str, null, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Date parseDateWithLeniency(String dateStr, Locale locale, String[] parsePatterns, boolean lenient) throws ParseException {
        String string;
        void var2_2;
        int n2;
        Objects.requireNonNull(dateStr, "str");
        Objects.requireNonNull(parsePatterns, "parsePatterns");
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = LocaleUtils.toLocale(locale);
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(n2 != 0);
        for (void parsePattern : var2_2) {
            FastDateParser fdp = new FastDateParser((String)parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(dateStr, pos, calendar) && pos.getIndex() == dateStr.length()) {
                    return calendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            pos.setIndex(0);
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar round(Calendar calendar, int field) {
        void var1_1;
        Calendar calendar2;
        Objects.requireNonNull(calendar, "calendar");
        return DateUtils.modify((Calendar)calendar2.clone(), (int)var1_1, ModifyType.ROUND);
    }

    /*
     * WARNING - void declaration
     */
    public static Date round(Date date, int field) {
        void var1_1;
        return DateUtils.modify(DateUtils.toCalendar(date), (int)var1_1, ModifyType.ROUND).getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static Date round(Object date, int field) {
        Object object;
        Objects.requireNonNull(date, "date");
        if (date instanceof Date) {
            return DateUtils.round((Date)date, field);
        }
        if (date instanceof Calendar) {
            void var1_1;
            return DateUtils.round((Calendar)date, (int)var1_1).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    /*
     * WARNING - void declaration
     */
    private static Date set(Date date, int calendarField, int amount) {
        void var3_3;
        void var2_2;
        void var1_1;
        Date date2;
        DateUtils.validateDateNotNull(date);
        Calendar c2 = Calendar.getInstance();
        c2.setLenient(false);
        c2.setTime(date2);
        c2.set((int)var1_1, (int)var2_2);
        return var3_3.getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static Date setDays(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 5, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date setHours(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 11, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date setMilliseconds(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 14, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date setMinutes(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 12, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date setMonths(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date setSeconds(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 13, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Date setYears(Date date, int amount) {
        void var1_1;
        return DateUtils.set(date, 1, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar toCalendar(Date date) {
        void var1_1;
        Date date2;
        Calendar c2 = Calendar.getInstance();
        c2.setTime(Objects.requireNonNull(date2, "date"));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar toCalendar(Date date, TimeZone tz) {
        void var1_1;
        Date date2;
        Calendar c2 = Calendar.getInstance(tz);
        c2.setTime(Objects.requireNonNull(date2, "date"));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar truncate(Calendar date, int field) {
        void var1_1;
        Calendar calendar;
        Objects.requireNonNull(date, "date");
        return DateUtils.modify((Calendar)calendar.clone(), (int)var1_1, ModifyType.TRUNCATE);
    }

    /*
     * WARNING - void declaration
     */
    public static Date truncate(Date date, int field) {
        void var1_1;
        return DateUtils.modify(DateUtils.toCalendar(date), (int)var1_1, ModifyType.TRUNCATE).getTime();
    }

    /*
     * WARNING - void declaration
     */
    public static Date truncate(Object date, int field) {
        Object object;
        Objects.requireNonNull(date, "date");
        if (date instanceof Date) {
            return DateUtils.truncate((Date)date, field);
        }
        if (date instanceof Calendar) {
            void var1_1;
            return DateUtils.truncate((Calendar)date, (int)var1_1).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    /*
     * WARNING - void declaration
     */
    public static int truncatedCompareTo(Calendar cal1, Calendar cal2, int field) {
        void var1_1;
        Calendar calendar;
        void var2_2;
        Calendar truncatedCal1 = DateUtils.truncate(cal1, field);
        Calendar truncatedCal2 = DateUtils.truncate(cal2, (int)var2_2);
        return calendar.compareTo((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int truncatedCompareTo(Date date1, Date date2, int field) {
        void var1_1;
        Date date;
        void var2_2;
        Date truncatedDate1 = DateUtils.truncate(date1, field);
        Date truncatedDate2 = DateUtils.truncate(date2, (int)var2_2);
        return date.compareTo((Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean truncatedEquals(Calendar cal1, Calendar cal2, int field) {
        void var2_2;
        void var1_1;
        return DateUtils.truncatedCompareTo(cal1, (Calendar)var1_1, (int)var2_2) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean truncatedEquals(Date date1, Date date2, int field) {
        void var2_2;
        void var1_1;
        return DateUtils.truncatedCompareTo(date1, (Date)var1_1, (int)var2_2) == 0;
    }

    private static void validateDateNotNull(Date date) {
        Objects.requireNonNull(date, "date");
    }

    @Deprecated
    public DateUtils() {
    }

    private static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }

    static class DateIterator
    implements Iterator<Calendar> {
        private final Calendar endFinal;
        private final Calendar spot;

        /*
         * WARNING - void declaration
         */
        DateIterator(Calendar startFinal, Calendar endFinal) {
            void var1_1;
            void var2_2;
            this.endFinal = var2_2;
            this.spot = var1_1;
            this.spot.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        @Override
        public Calendar next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return (Calendar)this.spot.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

