/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ConstructorUtils {
    /*
     * WARNING - void declaration
     */
    public static <T> Constructor<T> getAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Objects.requireNonNull(cls, "cls");
        try {
            void var1_1;
            Class<T> clazz;
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor((Class<?>)var1_1));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        Objects.requireNonNull(ctor, "ctor");
        if (MemberUtils.isAccessible(ctor) && ConstructorUtils.isAccessible(ctor.getDeclaringClass())) {
            Constructor<T> constructor;
            return constructor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Objects.requireNonNull(cls, "cls");
        try {
            return MemberUtils.setAccessibleWorkaround(cls.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var2_2;
            Constructor<?>[] constructorArray;
            Constructor<?> result = null;
            Constructor<?>[] constructorArray2 = constructorArray.getConstructors();
            constructorArray = constructorArray2;
            constructorArray = constructorArray2;
            int n2 = constructorArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> ctor = constructorArray[i2];
                if (!MemberUtils.isMatchingConstructor(ctor, parameterTypes) || (ctor = ConstructorUtils.getAccessibleConstructor(ctor)) == null) continue;
                MemberUtils.setAccessibleWorkaround(ctor);
                if (result != null && MemberUtils.compareConstructorFit(ctor, result, parameterTypes) >= 0) continue;
                result = ctor;
            }
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeConstructor(Class<T> cls, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<T> clazz;
        void var1_1;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var1_1;
        return ConstructorUtils.invokeConstructor(clazz, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeConstructor(Class<T> cls, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var1_1;
        void var2_2;
        args2 = ArrayUtils.nullToEmpty(args2);
        Constructor<T> ctor = ConstructorUtils.getMatchingAccessibleConstructor(cls, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (ctor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + cls.getName());
        }
        if (ctor.isVarArgs()) {
            Class<?>[] classArray;
            Class<?>[] methodParameterTypes = ctor.getParameterTypes();
            args2 = MethodUtils.getVarArgs(args2, classArray);
        }
        return var2_2.newInstance((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeExactConstructor(Class<T> cls, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<T> clazz;
        void var1_1;
        args2 = ArrayUtils.nullToEmpty(args2);
        void v0 = var1_1;
        return ConstructorUtils.invokeExactConstructor(clazz, (Object[])v0, ClassUtils.toClass((Object[])v0));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeExactConstructor(Class<T> cls, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var1_1;
        void var2_2;
        args2 = ArrayUtils.nullToEmpty(args2);
        Constructor<T> ctor = ConstructorUtils.getAccessibleConstructor(cls, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (ctor == null) {
            Class<T> clazz;
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return var2_2.newInstance((Object[])var1_1);
    }

    private static boolean isAccessible(Class<?> type) {
        for (Class<?> cls = type; cls != null; cls = cls.getEnclosingClass()) {
            if (ClassUtils.isPublic(cls)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public ConstructorUtils() {
    }
}

