/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    public static final Long LONG_INT_MAX_VALUE = Integer.MAX_VALUE;
    public static final Long LONG_INT_MIN_VALUE = Integer.MIN_VALUE;

    /*
     * WARNING - void declaration
     */
    public static int compare(byte x, byte y) {
        void var1_1;
        return x - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int x, int y) {
        void var1_1;
        int n2;
        if (x == y) {
            return 0;
        }
        if (n2 < var1_1) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long x, long y) {
        void var2_1;
        long l2;
        if (x == y) {
            return 0;
        }
        if (l2 < var2_1) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(short x, short y) {
        void var1_1;
        short s2;
        if (x == y) {
            return 0;
        }
        if (s2 < var1_1) {
            return -1;
        }
        return 1;
    }

    public static BigDecimal createBigDecimal(String str) {
        String string;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(string);
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger createBigInteger(String str) {
        BigInteger bigInteger;
        void var3_3;
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            throw new NumberFormatException("An empty string is not a valid number");
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        char char0 = str.charAt(0);
        if (char0 == '-') {
            negate = true;
            pos = 1;
        } else if (char0 == '+') {
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        BigInteger value = new BigInteger(str.substring((int)var1_1), (int)var2_2);
        if (var3_3 != false) {
            return value.negate();
        }
        return bigInteger;
    }

    public static Double createDouble(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Double.valueOf(string);
    }

    public static Float createFloat(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Float.valueOf(string);
    }

    public static Integer createInteger(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Integer.decode(string);
    }

    public static Long createLong(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Long.decode(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Number createNumber(String str) {
        String string;
        void numeric2;
        String mant;
        String dec;
        boolean requestType;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] hexPrefixes = new String[]{"0x", "0X", "#"};
        int length = str.length();
        int offset = str.charAt(0) == '+' || str.charAt(0) == '-' ? 1 : 0;
        int pfxLen = 0;
        int cfr_ignored_0 = hexPrefixes.length;
        for (int i2 = 0; i2 < 3; ++i2) {
            String pfx = hexPrefixes[i2];
            if (!str.startsWith(pfx, offset)) continue;
            pfxLen = 0 + (pfx.length() + offset);
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i3 = pfxLen; i3 < length && (firstSigDigit = str.charAt(i3)) == '0'; ++i3) {
                ++pfxLen;
            }
            int hexDigits = length - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return NumberUtils.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return NumberUtils.createLong(str);
            }
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(length - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        boolean bl = requestType = !Character.isDigit(lastChar) && lastChar != '.';
        if (decPos >= 0) {
            int n2;
            int n3;
            String string2;
            if (expPos >= 0) {
                if (expPos <= decPos || expPos > length) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                string2 = str;
                n3 = decPos + 1;
                n2 = expPos;
            } else {
                string2 = str;
                n3 = decPos + 1;
                n2 = requestType ? length - 1 : length;
            }
            dec = string2.substring(n3, n2);
            mant = NumberUtils.getMantissa(str, decPos);
        } else {
            int n4;
            String string3;
            if (expPos >= 0) {
                if (expPos > length) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                string3 = str;
                n4 = expPos;
            } else {
                string3 = str;
                n4 = requestType ? length - 1 : length;
            }
            mant = NumberUtils.getMantissa(string3, n4);
            dec = null;
        }
        if (requestType) {
            String exp = expPos >= 0 && expPos < length - 1 ? str.substring(expPos + 1, length - 1) : null;
            String numeric2 = str.substring(0, length - 1);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && (!numeric2.isEmpty() && numeric2.charAt(0) == '-' && NumberUtils.isDigits(numeric2.substring(1)) || NumberUtils.isDigits(numeric2))) {
                        try {
                            return NumberUtils.createLong(numeric2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(numeric2);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f2 = NumberUtils.createFloat(str);
                        if (!f2.isInfinite() && (f2.floatValue() != 0.0f || NumberUtils.isZero(mant, dec))) {
                            return f2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d2 = NumberUtils.createDouble(str);
                        if (!d2.isInfinite() && (d2 != 0.0 || NumberUtils.isZero(mant, dec))) {
                            return d2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        return NumberUtils.createBigDecimal(numeric2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        String exp = expPos >= 0 && expPos < numeric2 - true ? str.substring(expPos + 1) : null;
        if (dec == null && exp == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        try {
            void var3_11;
            Float f3 = NumberUtils.createFloat(str);
            Double d3 = NumberUtils.createDouble(str);
            if (!f3.isInfinite() && (f3.floatValue() != 0.0f || NumberUtils.isZero(mant, dec)) && f3.toString().equals(d3.toString())) {
                return f3;
            }
            if (!d3.isInfinite() && (d3 != 0.0 || NumberUtils.isZero((String)var3_11, dec))) {
                void var2_9;
                BigDecimal b2 = NumberUtils.createBigDecimal(str);
                if (b2.compareTo(BigDecimal.valueOf(d3)) == 0) {
                    void var1_6;
                    return var1_6;
                }
                return var2_9;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return NumberUtils.createBigDecimal(string);
    }

    /*
     * WARNING - void declaration
     */
    private static String getMantissa(String str, int stopPos) {
        void var1_1;
        String string;
        void var2_2;
        void var3_3;
        char firstChar = str.charAt(0);
        boolean hasSign = firstChar == '-' || firstChar == '+';
        int length = str.length();
        if (length <= (hasSign ? 1 : 0) || var3_3 < stopPos) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        if (var2_2 != false) {
            return str.substring(1, stopPos);
        }
        return string.substring(0, (int)var1_1);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            if (str.charAt(i2) == '0') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCreatable(String str) {
        int i2;
        int start;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n2 = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && !StringUtils.contains((CharSequence)str, 46)) {
            if (chars[start + 1] == 'x' || chars[start + 1] == 'X') {
                int i3 = start + 2;
                if (i3 == sz) {
                    return false;
                }
                while (i3 < chars.length) {
                    if (!(chars[i3] >= '0' && chars[i3] <= '9' || chars[i3] >= 'a' && chars[i3] <= 'f' || chars[i3] >= 'A' && chars[i3] <= 'F')) {
                        return false;
                    }
                    ++i3;
                }
                return true;
            }
            if (Character.isDigit(chars[start + 1])) {
                for (int i4 = start + 1; i4 < chars.length; ++i4) {
                    if (chars[i4] >= '0' && chars[i4] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i2 = start; i2 < sz || i2 < sz + 1 && allowSigns && !foundDigit; ++i2) {
            if (chars[i2] >= '0' && chars[i2] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i2] == 'e' || chars[i2] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i2] == '+' || chars[i2] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i2 < chars.length) {
            void var0_3;
            void var1_4;
            if (chars[i2] >= '0' && chars[i2] <= '9') {
                return true;
            }
            if (chars[i2] == 'e' || chars[i2] == 'E') {
                return false;
            }
            if (chars[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i2] != 'd' && chars[i2] != 'D' && chars[i2] != 'f' && chars[i2] != 'F')) {
                return foundDigit;
            }
            if (chars[i2] == 'l' || var1_4[var0_3] == 76) {
                void var3_6;
                return foundDigit && var3_6 == false && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isDigits(String str) {
        return StringUtils.isNumeric(str);
    }

    @Deprecated
    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable(str);
    }

    public static boolean isParsable(String str) {
        String string;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        String string2 = str;
        if (string2.charAt(string2.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return NumberUtils.withDecimalsParsing(str, 1);
        }
        return NumberUtils.withDecimalsParsing(string, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isZero(String mant, String dec) {
        void var1_1;
        return NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte max(byte ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        byte max = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= max) continue;
            max = array[i2];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte max(byte a2, byte b2, byte c2) {
        byte by;
        if (b2 > a2) {
            void var1_1;
            a2 = var1_1;
        }
        if (c2 > a2) {
            void var2_2;
            a2 = var2_2;
        }
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public static double max(double ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        double max = array[0];
        for (int j2 = 1; j2 < array.length; ++j2) {
            if (Double.isNaN(array[j2])) {
                return Double.NaN;
            }
            if (!(array[j2] > max)) continue;
            max = array[j2];
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double max(double a2, double b2, double c2) {
        void var2_2;
        return Math.max(Math.max(a2, (double)var2_2), c2);
    }

    /*
     * WARNING - void declaration
     */
    public static float max(float ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        float max = array[0];
        for (int j2 = 1; j2 < array.length; ++j2) {
            if (Float.isNaN(array[j2])) {
                return Float.NaN;
            }
            if (!(array[j2] > max)) continue;
            max = array[j2];
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float max(float a2, float b2, float c2) {
        void var2_2;
        void var1_1;
        return Math.max(Math.max(a2, (float)var1_1), (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int max(int ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        int max = array[0];
        for (int j2 = 1; j2 < array.length; ++j2) {
            if (array[j2] <= max) continue;
            max = array[j2];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int max(int a2, int b2, int c2) {
        int n2;
        if (b2 > a2) {
            void var1_1;
            a2 = var1_1;
        }
        if (c2 > a2) {
            void var2_2;
            a2 = var2_2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        long max = array[0];
        for (int j2 = 1; j2 < array.length; ++j2) {
            if (array[j2] <= max) continue;
            max = array[j2];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long a2, long b2, long c2) {
        long l2;
        if (b2 > a2) {
            void var2_2;
            a2 = var2_2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public static short max(short ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        short max = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= max) continue;
            max = array[i2];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short max(short a2, short b2, short c2) {
        short s2;
        if (b2 > a2) {
            void var1_1;
            a2 = var1_1;
        }
        if (c2 > a2) {
            void var2_2;
            a2 = var2_2;
        }
        return s2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte min(byte ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        byte min = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min) continue;
            min = array[i2];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte min(byte a2, byte b2, byte c2) {
        byte by;
        if (b2 < a2) {
            void var1_1;
            a2 = var1_1;
        }
        if (c2 < a2) {
            void var2_2;
            a2 = var2_2;
        }
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public static double min(double ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        double min = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Double.isNaN(array[i2])) {
                return Double.NaN;
            }
            if (!(array[i2] < min)) continue;
            min = array[i2];
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double min(double a2, double b2, double c2) {
        void var2_2;
        return Math.min(Math.min(a2, (double)var2_2), c2);
    }

    /*
     * WARNING - void declaration
     */
    public static float min(float ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        float min = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Float.isNaN(array[i2])) {
                return Float.NaN;
            }
            if (!(array[i2] < min)) continue;
            min = array[i2];
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float min(float a2, float b2, float c2) {
        void var2_2;
        void var1_1;
        return Math.min(Math.min(a2, (float)var1_1), (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int min(int ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        int min = array[0];
        for (int j2 = 1; j2 < array.length; ++j2) {
            if (array[j2] >= min) continue;
            min = array[j2];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int min(int a2, int b2, int c2) {
        int n2;
        if (b2 < a2) {
            void var1_1;
            a2 = var1_1;
        }
        if (c2 < a2) {
            void var2_2;
            a2 = var2_2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        long min = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min) continue;
            min = array[i2];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long a2, long b2, long c2) {
        long l2;
        if (b2 < a2) {
            void var2_2;
            a2 = var2_2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public static short min(short ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        short min = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min) continue;
            min = array[i2];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short min(short a2, short b2, short c2) {
        short s2;
        if (b2 < a2) {
            void var1_1;
            a2 = var1_1;
        }
        if (c2 < a2) {
            void var2_2;
            a2 = var2_2;
        }
        return s2;
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte toByte(String str, byte defaultValue) {
        try {
            return Byte.parseByte(str);
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            return (byte)var1_1;
        }
    }

    public static double toDouble(BigDecimal value) {
        return NumberUtils.toDouble(value, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public static double toDouble(BigDecimal value, double defaultValue) {
        BigDecimal bigDecimal;
        if (value == null) {
            void var1_1;
            return (double)var1_1;
        }
        return bigDecimal.doubleValue();
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public static double toDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            return (double)var1_1;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static float toFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            return (float)var1_1;
        }
    }

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            return (int)var1_1;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static long toLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            return (long)var1_1;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(BigDecimal value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        BigDecimal bigDecimal;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.setScale((int)var1_1, (RoundingMode)((Object)(roundingMode == null ? RoundingMode.HALF_EVEN : var2_2)));
    }

    public static BigDecimal toScaledBigDecimal(Double value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(Double value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        Double d2;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(d2), (int)var1_1, (RoundingMode)var2_2);
    }

    public static BigDecimal toScaledBigDecimal(Float value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(Float value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        Float f2;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(f2.floatValue()), (int)var1_1, (RoundingMode)var2_2);
    }

    public static BigDecimal toScaledBigDecimal(String value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(String value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        String string;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(NumberUtils.createBigDecimal(string), (int)var1_1, (RoundingMode)var2_2);
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    /*
     * WARNING - void declaration
     */
    public static short toShort(String str, short defaultValue) {
        try {
            return Short.parseShort(str);
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            return (short)var1_1;
        }
    }

    private static void validateArray(Object array) {
        Object object;
        Objects.requireNonNull(array, "array");
        Validate.isTrue(Array.getLength(object) != 0, "Array cannot be empty.", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean withDecimalsParsing(String str, int beginIdx) {
        void i2;
        int decimalPoints = 0;
        while (i2 < str.length()) {
            void var3_3;
            char ch = str.charAt((int)i2);
            boolean isDecimalPoint = ch == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (!isDecimalPoint && !Character.isDigit((char)var3_3)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Deprecated
    public NumberUtils() {
    }
}

