/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigInteger;
import java.util.Objects;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    private static final long serialVersionUID = 65382027393090L;
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    private final int numerator;
    private final int denominator;
    private transient int hashCode;
    private transient String toString;
    private transient String toProperString;

    /*
     * WARNING - void declaration
     */
    private static int addAndCheck(int x, int y) {
        void var2_2;
        void var1_1;
        long s2 = (long)x + (long)var1_1;
        if (s2 < Integer.MIN_VALUE || s2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Fraction getFraction(double value) {
        void var2_1;
        void var3_2;
        int denom2;
        double delta1;
        int sign = value < 0.0 ? -1 : 1;
        if ((value = Math.abs(value)) > 2.147483647E9 || Double.isNaN(value)) {
            throw new ArithmeticException("The value must not be greater than Integer.MAX_VALUE or NaN");
        }
        int wholeNumber = (int)value;
        int numer0 = 0;
        int denom0 = 1;
        int numer1 = 1;
        int denom1 = 0;
        int a1 = (int)(value -= (double)wholeNumber);
        double x1 = 1.0;
        double y1 = value - (double)a1;
        double delta2 = Double.MAX_VALUE;
        int i2 = 1;
        do {
            delta1 = delta2;
            int a2 = (int)(x1 / y1);
            double x2 = y1;
            double y2 = x1 - (double)a2 * y1;
            int numer2 = a1 * numer1 + numer0;
            denom2 = a1 * denom1 + denom0;
            double fraction = (double)numer2 / (double)denom2;
            delta2 = Math.abs(value - fraction);
            a1 = a2;
            x1 = x2;
            y1 = y2;
            numer0 = numer1;
            denom0 = denom1;
            numer1 = numer2;
            denom1 = denom2;
        } while (delta1 > delta2 && denom2 <= 10000 && denom2 > 0 && ++i2 < 25);
        if (i2 == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction((numer0 + var3_2 * denom0) * var2_1, denom0);
    }

    /*
     * WARNING - void declaration
     */
    public static Fraction getFraction(int numerator, int denominator) {
        void var1_1;
        int n2;
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        return new Fraction(n2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Fraction getFraction(int whole, int numerator, int denominator) {
        void var2_2;
        void var3_3;
        void var1_1;
        int n2;
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (numerator < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        long numeratorValue = whole < 0 ? (long)whole * (long)denominator - (long)numerator : (long)n2 * (long)denominator + (long)var1_1;
        if (numeratorValue < Integer.MIN_VALUE || numeratorValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Numerator too large to represent as an Integer.");
        }
        return new Fraction((int)var3_3, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Fraction getFraction(String str) {
        void var3_6;
        void var2_4;
        String string;
        Objects.requireNonNull(str, "str");
        int n2 = str.indexOf(46);
        if (n2 >= 0) {
            return Fraction.getFraction(Double.parseDouble(str));
        }
        int pos = str.indexOf(32);
        if (pos > 0) {
            void var0_1;
            int whole = Integer.parseInt(str.substring(0, pos));
            if ((pos = (str = str.substring(pos + 1)).indexOf(47)) < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            int numer = Integer.parseInt(str.substring(0, pos));
            int denom = Integer.parseInt(str.substring(pos + 1));
            return Fraction.getFraction(whole, numer, (int)var0_1);
        }
        pos = string.indexOf(47);
        if (pos < 0) {
            return Fraction.getFraction(Integer.parseInt(string), 1);
        }
        int numer = Integer.parseInt(string.substring(0, pos));
        int denom = Integer.parseInt(string.substring(n2 + 1));
        return Fraction.getFraction((int)var2_4, (int)var3_6);
    }

    /*
     * WARNING - void declaration
     */
    public static Fraction getReducedFraction(int numerator, int denominator) {
        void var1_1;
        int n2;
        void var2_2;
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (numerator == 0) {
            return ZERO;
        }
        if (denominator == Integer.MIN_VALUE && (numerator & 1) == 0) {
            numerator /= 2;
            denominator /= 2;
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        int gcd = Fraction.greatestCommonDivisor(numerator, denominator);
        numerator /= gcd;
        denominator /= var2_2;
        return new Fraction(n2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int greatestCommonDivisor(int u2, int v2) {
        void var2_2;
        int n2;
        int t2;
        int k2;
        if (u2 == 0 || v2 == 0) {
            if (u2 == Integer.MIN_VALUE || v2 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: gcd is 2^31");
            }
            return Math.abs(u2) + Math.abs(v2);
        }
        if (Math.abs(u2) == 1 || Math.abs(v2) == 1) {
            return 1;
        }
        if (u2 > 0) {
            u2 = -u2;
        }
        if (v2 > 0) {
            v2 = -v2;
        }
        for (k2 = 0; (u2 & 1) == 0 && (v2 & 1) == 0 && k2 < 31; ++k2) {
            u2 /= 2;
            v2 /= 2;
        }
        if (k2 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int n3 = t2 = (u2 & 1) == 1 ? v2 : -(u2 / 2);
        while (true) {
            if ((t2 & 1) == 0) {
                n3 = t2 / 2;
                continue;
            }
            if (t2 > 0) {
                u2 = -t2;
            } else {
                v2 = t2;
            }
            if ((t2 = (v2 - u2) / 2) == 0) break;
        }
        return -n2 * (1 << var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int mulAndCheck(int x, int y) {
        void var2_2;
        void var1_1;
        long m2 = (long)x * (long)var1_1;
        if (m2 < Integer.MIN_VALUE || m2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int mulPosAndCheck(int x, int y) {
        void var2_2;
        void var1_1;
        long m2 = (long)x * (long)var1_1;
        if (m2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mulPos");
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int subAndCheck(int x, int y) {
        void var2_2;
        void var1_1;
        long s2 = (long)x - (long)var1_1;
        if (s2 < Integer.MIN_VALUE || s2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Fraction(int numerator, int denominator) {
        void var2_2;
        void var1_1;
        this.numerator = var1_1;
        this.denominator = var2_2;
    }

    public final Fraction abs() {
        if (this.numerator >= 0) {
            return this;
        }
        return this.negate();
    }

    /*
     * WARNING - void declaration
     */
    public final Fraction add(Fraction fraction) {
        void var1_1;
        return this.addSub((Fraction)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private Fraction addSub(Fraction fraction, boolean isAdd) {
        void var1_1;
        void var3_4;
        void var2_3;
        int tmodd1;
        int d2;
        Objects.requireNonNull(fraction, "fraction");
        if (this.numerator == 0) {
            if (isAdd) {
                return fraction;
            }
            return fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int d1 = Fraction.greatestCommonDivisor(this.denominator, fraction.denominator);
        if (d1 == 1) {
            int uvp = Fraction.mulAndCheck(this.numerator, fraction.denominator);
            int upv = Fraction.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(isAdd ? Fraction.addAndCheck(uvp, upv) : Fraction.subAndCheck(uvp, upv), Fraction.mulPosAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger uvp = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / d1));
        BigInteger upv = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / d1));
        BigInteger t2 = isAdd ? uvp.add(upv) : uvp.subtract(upv);
        BigInteger w2 = t2.divide(BigInteger.valueOf(d2 = (tmodd1 = t2.mod(BigInteger.valueOf(d1)).intValue()) == 0 ? d1 : Fraction.greatestCommonDivisor(tmodd1, d1)));
        if (w2.bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(var2_3.intValue(), Fraction.mulPosAndCheck(this.denominator / var3_4, var1_1.denominator / d2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Fraction other) {
        void var2_2;
        void var1_1;
        if (this == other) {
            return 0;
        }
        if (this.numerator == other.numerator && this.denominator == other.denominator) {
            return 0;
        }
        long first = (long)this.numerator * (long)other.denominator;
        long second = (long)var1_1.numerator * (long)this.denominator;
        return Long.compare((long)var2_2, second);
    }

    /*
     * WARNING - void declaration
     */
    public final Fraction divideBy(Fraction fraction) {
        void var1_1;
        Objects.requireNonNull(fraction, "fraction");
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiplyBy(var1_1.invert());
    }

    @Override
    public final double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction other = (Fraction)obj;
        return this.getNumerator() == other.getNumerator() && this.getDenominator() == var1_1.getDenominator();
    }

    @Override
    public final float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public final int getProperNumerator() {
        return Math.abs(this.numerator % this.denominator);
    }

    public final int getProperWhole() {
        return this.numerator / this.denominator;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * (629 + this.getNumerator()) + this.getDenominator();
        }
        return this.hashCode;
    }

    @Override
    public final int intValue() {
        return this.numerator / this.denominator;
    }

    public final Fraction invert() {
        if (this.numerator == 0) {
            throw new ArithmeticException("Unable to invert zero.");
        }
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: can't negate numerator");
        }
        if (this.numerator < 0) {
            return new Fraction(-this.denominator, -this.numerator);
        }
        return new Fraction(this.denominator, this.numerator);
    }

    @Override
    public final long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    /*
     * WARNING - void declaration
     */
    public final Fraction multiplyBy(Fraction fraction) {
        void var2_2;
        void var1_1;
        void var3_3;
        Objects.requireNonNull(fraction, "fraction");
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int d1 = Fraction.greatestCommonDivisor(this.numerator, fraction.denominator);
        int d2 = Fraction.greatestCommonDivisor(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(Fraction.mulAndCheck(this.numerator / d1, fraction.numerator / d2), Fraction.mulPosAndCheck(this.denominator / var3_3, var1_1.denominator / var2_2));
    }

    public final Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    /*
     * WARNING - void declaration
     */
    public final Fraction pow(int power) {
        void var1_1;
        void var2_2;
        while (true) {
            Fraction this_;
            if (power == 1) {
                return this_;
            }
            if (power == 0) {
                return ONE;
            }
            if (power < 0) {
                if (power == Integer.MIN_VALUE) {
                    power = -(power / 2);
                    this_ = this_.invert().pow(2);
                    continue;
                }
                power = -power;
                this_ = this_.invert();
                continue;
            }
            Fraction fraction = this_;
            Fraction f2 = fraction.multiplyBy(fraction);
            if (power % 2 != 0) break;
            power /= 2;
            this_ = f2;
        }
        return var2_2.pow((int)(var1_1 / 2)).multiplyBy(this_);
    }

    /*
     * WARNING - void declaration
     */
    public final Fraction reduce() {
        void var1_1;
        if (this.numerator == 0) {
            if (this.equals(ZERO)) {
                return this;
            }
            return ZERO;
        }
        int gcd = Fraction.greatestCommonDivisor(Math.abs(this.numerator), this.denominator);
        if (gcd == 1) {
            return this;
        }
        return Fraction.getFraction(this.numerator / gcd, this.denominator / var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Fraction subtract(Fraction fraction) {
        void var1_1;
        return this.addSub((Fraction)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final String toProperString() {
        if (this.toProperString == null) {
            void var1_1;
            int properNumerator;
            this.toProperString = this.numerator == 0 ? "0" : (this.numerator == this.denominator ? "1" : (this.numerator == -1 * this.denominator ? "-1" : ((this.numerator > 0 ? -this.numerator : this.numerator) < -this.denominator ? ((properNumerator = this.getProperNumerator()) == 0 ? Integer.toString(this.getProperWhole()) : this.getProperWhole() + " " + (int)var1_1 + "/" + this.getDenominator()) : this.getNumerator() + "/" + this.getDenominator())));
        }
        return this.toProperString;
    }

    public final String toString() {
        if (this.toString == null) {
            this.toString = this.getNumerator() + "/" + this.getDenominator();
        }
        return this.toString;
    }
}

