/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements Serializable,
ExceptionContext {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultExceptionContext addContextValue(String label, Object value) {
        void var2_2;
        void var1_1;
        this.contextValues.add(new ImmutablePair<void, void>(var1_1, var2_2));
        return this;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public Set<String> getContextLabels() {
        return this.stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Object> getContextValues(String label) {
        void var1_1;
        return this.stream().filter(arg_0 -> DefaultExceptionContext.lambda$getContextValues$0((String)var1_1, arg_0)).map(Pair::getValue).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getFirstContextValue(String label) {
        void var1_1;
        return this.stream().filter(arg_0 -> DefaultExceptionContext.lambda$getFirstContextValue$1((String)var1_1, arg_0)).findFirst().map(Pair::getValue).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        void var2_3;
        StringBuilder buffer = new StringBuilder(256);
        if (baseMessage != null) {
            buffer.append(baseMessage);
        }
        if (!this.contextValues.isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append("Exception Context:\n");
            int i2 = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                buffer.append("\t[");
                buffer.append(++i2);
                buffer.append(':');
                buffer.append(pair.getKey());
                buffer.append("=");
                Object value = pair.getValue();
                try {
                    buffer.append(Objects.toString(value));
                }
                catch (Exception e2) {
                    buffer.append("Exception thrown on toString(): ");
                    buffer.append(ExceptionUtils.getStackTrace(e2));
                }
                buffer.append("]\n");
            }
            buffer.append("---------------------------------");
        }
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultExceptionContext setContextValue(String label, Object value) {
        void var2_2;
        void var1_1;
        this.contextValues.removeIf(p2 -> {
            void var1_1;
            return StringUtils.equals(label, (CharSequence)var1_1.getKey());
        });
        this.addContextValue((String)var1_1, var2_2);
        return this;
    }

    private Stream<Pair<String, Object>> stream() {
        return this.contextValues.stream();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getFirstContextValue$1(String label, Pair pair) {
        void var1_1;
        return StringUtils.equals(label, (CharSequence)var1_1.getKey());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getContextValues$0(String label, Pair pair) {
        void var1_1;
        return StringUtils.equals(label, (CharSequence)var1_1.getKey());
    }
}

