/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;

public class MultiBackgroundInitializer
extends BackgroundInitializer<MultiBackgroundInitializerResults> {
    private final Map<String, BackgroundInitializer<?>> childInitializers = new HashMap();

    public MultiBackgroundInitializer() {
    }

    /*
     * WARNING - void declaration
     */
    public MultiBackgroundInitializer(ExecutorService exec) {
        super((ExecutorService)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addInitializer(String name, BackgroundInitializer<?> backgroundInitializer) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(backgroundInitializer, "backgroundInitializer");
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            void var2_3;
            void var1_1;
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.childInitializers.put((String)var1_1, (BackgroundInitializer<?>)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws ConcurrentException {
        ConcurrentException exception = null;
        for (BackgroundInitializer<?> child : this.childInitializers.values()) {
            try {
                child.close();
            }
            catch (Exception e2) {
                void var3_4;
                if (exception == null) {
                    exception = new ConcurrentException();
                }
                if (e2 instanceof ConcurrentException) {
                    exception.addSuppressed(e2.getCause());
                    continue;
                }
                exception.addSuppressed((Throwable)var3_4);
            }
        }
        if (exception != null) {
            void var1_1;
            throw var1_1;
        }
    }

    @Override
    protected int getTaskCount() {
        return 1 + this.childInitializers.values().stream().mapToInt(BackgroundInitializer::getTaskCount).sum();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected MultiBackgroundInitializerResults initialize() throws Exception {
        void var3_4;
        void var1_2;
        HashMap inits;
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            inits = new HashMap(this.childInitializers);
        }
        ExecutorService exec = this.getActiveExecutor();
        inits.values().forEach(bi -> {
            void var1_1;
            if (bi.getExternalExecutor() == null) {
                ExecutorService executorService;
                bi.setExternalExecutor(executorService);
            }
            var1_1.start();
        });
        HashMap results = new HashMap();
        HashMap excepts = new HashMap();
        inits.forEach((k2, v2) -> {
            try {
                void var3_4;
                results.put(k2, var3_4.get());
                return;
            }
            catch (ConcurrentException cex) {
                void var0_1;
                void var2_3;
                void var1_2;
                var1_2.put(var2_3, var0_1);
                return;
            }
        });
        return new MultiBackgroundInitializerResults((Map)var1_2, (Map)var3_4, (Map)((Object)multiBackgroundInitializer));
    }

    @Override
    public boolean isInitialized() {
        if (this.childInitializers.isEmpty()) {
            return false;
        }
        return this.childInitializers.values().stream().allMatch(BackgroundInitializer::isInitialized);
    }

    public static class MultiBackgroundInitializerResults {
        private final Map<String, BackgroundInitializer<?>> initializers;
        private final Map<String, Object> resultObjects;
        private final Map<String, ConcurrentException> exceptions;

        /*
         * WARNING - void declaration
         */
        private MultiBackgroundInitializerResults(Map<String, BackgroundInitializer<?>> inits, Map<String, Object> results, Map<String, ConcurrentException> excepts) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.initializers = var1_1;
            this.resultObjects = var2_2;
            this.exceptions = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private BackgroundInitializer<?> checkName(String name) {
            void var2_2;
            BackgroundInitializer<?> init = this.initializers.get(name);
            if (init == null) {
                void var1_1;
                throw new NoSuchElementException("No child initializer with name " + (String)var1_1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public ConcurrentException getException(String name) {
            void var1_1;
            this.checkName(name);
            return this.exceptions.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public BackgroundInitializer<?> getInitializer(String name) {
            void var1_1;
            return this.checkName((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Object getResultObject(String name) {
            void var1_1;
            this.checkName(name);
            return this.resultObjects.get(var1_1);
        }

        public Set<String> initializerNames() {
            return Collections.unmodifiableSet(this.initializers.keySet());
        }

        /*
         * WARNING - void declaration
         */
        public boolean isException(String name) {
            void var1_1;
            this.checkName(name);
            return this.exceptions.containsKey(var1_1);
        }

        public boolean isSuccessful() {
            return this.exceptions.isEmpty();
        }
    }
}

