/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong threadCounter;
    private final ThreadFactory wrappedFactory;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String namingPattern;
    private final Integer priority;
    private final Boolean daemon;

    /*
     * WARNING - void declaration
     */
    private BasicThreadFactory(Builder builder) {
        void var1_1;
        this.wrappedFactory = builder.factory != null ? builder.factory : Executors.defaultThreadFactory();
        this.namingPattern = builder.namingPattern;
        this.priority = builder.priority;
        this.daemon = builder.daemon;
        this.uncaughtExceptionHandler = ((Builder)var1_1).exceptionHandler;
        this.threadCounter = new AtomicLong();
    }

    public final Boolean getDaemonFlag() {
        return this.daemon;
    }

    public final String getNamingPattern() {
        return this.namingPattern;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public long getThreadCount() {
        return this.threadCounter.get();
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public final ThreadFactory getWrappedFactory() {
        return this.wrappedFactory;
    }

    /*
     * WARNING - void declaration
     */
    private void initializeThread(Thread thread2) {
        if (this.getNamingPattern() != null) {
            void var2_2;
            Long count = this.threadCounter.incrementAndGet();
            thread2.setName(String.format(this.getNamingPattern(), var2_2));
        }
        if (this.getUncaughtExceptionHandler() != null) {
            thread2.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        }
        if (this.getPriority() != null) {
            thread2.setPriority(this.getPriority());
        }
        if (this.getDaemonFlag() != null) {
            void var1_1;
            var1_1.setDaemon(this.getDaemonFlag());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Thread newThread(Runnable runnable2) {
        void var1_1;
        Thread thread2 = this.getWrappedFactory().newThread(runnable2);
        this.initializeThread(thread2);
        return var1_1;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<BasicThreadFactory> {
        private ThreadFactory factory;
        private Thread.UncaughtExceptionHandler exceptionHandler;
        private String namingPattern;
        private Integer priority;
        private Boolean daemon;

        /*
         * WARNING - void declaration
         */
        @Override
        public BasicThreadFactory build() {
            void var1_1;
            BasicThreadFactory factory2 = new BasicThreadFactory(this);
            this.reset();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder daemon(boolean daemon) {
            void var1_1;
            this.daemon = (boolean)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder namingPattern(String namingPattern) {
            void var1_1;
            this.namingPattern = (String)Objects.requireNonNull(var1_1, "pattern");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder priority(int priority) {
            void var1_1;
            this.priority = (int)var1_1;
            return this;
        }

        public void reset() {
            this.factory = null;
            this.exceptionHandler = null;
            this.namingPattern = null;
            this.priority = null;
            this.daemon = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            void var1_1;
            this.exceptionHandler = (Thread.UncaughtExceptionHandler)Objects.requireNonNull(var1_1, "handler");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder wrappedFactory(ThreadFactory factory2) {
            void var1_1;
            this.factory = (ThreadFactory)Objects.requireNonNull(var1_1, "factory");
            return this;
        }
    }
}

