/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public class BackgroundInitializer<T>
extends AbstractConcurrentInitializer<T, Exception> {
    private ExecutorService externalExecutor;
    private ExecutorService executor;
    private Future<T> future;

    public static <T> Builder<BackgroundInitializer<T>, T> builder() {
        return new Builder();
    }

    protected BackgroundInitializer() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected BackgroundInitializer(ExecutorService exec) {
        void var1_1;
        this.setExternalExecutor((ExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private BackgroundInitializer(FailableSupplier<T, ConcurrentException> initializer, FailableConsumer<T, ConcurrentException> closer, ExecutorService exec) {
        super(var1_1, var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setExternalExecutor((ExecutorService)var3_3);
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.getTaskCount());
    }

    /*
     * WARNING - void declaration
     */
    private Callable<T> createTask(ExecutorService execDestroy) {
        void var1_1;
        return new InitializationTask((ExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get() throws ConcurrentException {
        try {
            return this.getFuture().get();
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            ConcurrentUtils.handleCause(executionException);
            return null;
        }
        catch (InterruptedException iex) {
            void var1_2;
            Thread.currentThread().interrupt();
            throw new ConcurrentException((Throwable)var1_2);
        }
    }

    protected final synchronized ExecutorService getActiveExecutor() {
        return this.executor;
    }

    public final synchronized ExecutorService getExternalExecutor() {
        return this.externalExecutor;
    }

    public synchronized Future<T> getFuture() {
        if (this.future == null) {
            throw new IllegalStateException("start() must be called first!");
        }
        return this.future;
    }

    protected int getTaskCount() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Exception getTypedException(Exception e2) {
        void var1_1;
        return new Exception((Throwable)var1_1);
    }

    @Override
    public synchronized boolean isInitialized() {
        if (this.future == null || !this.future.isDone()) {
            return false;
        }
        try {
            this.future.get();
            return true;
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
            return false;
        }
    }

    public synchronized boolean isStarted() {
        return this.future != null;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setExternalExecutor(ExecutorService externalExecutor) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot set ExecutorService after start()!");
        }
        this.externalExecutor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean start() {
        if (!this.isStarted()) {
            void var1_1;
            ExecutorService tempExec;
            this.executor = this.getExternalExecutor();
            if (this.executor == null) {
                this.executor = tempExec = this.createExecutor();
            } else {
                tempExec = null;
            }
            this.future = this.executor.submit(this.createTask((ExecutorService)var1_1));
            return true;
        }
        return false;
    }

    public static class Builder<I extends BackgroundInitializer<T>, T>
    extends AbstractConcurrentInitializer.AbstractBuilder<I, T, Builder<I, T>, Exception> {
        private ExecutorService externalExecutor;

        @Override
        public I get() {
            return (I)new BackgroundInitializer(this.getInitializer(), this.getCloser(), this.externalExecutor);
        }

        /*
         * WARNING - void declaration
         */
        public Builder<I, T> setExternalExecutor(ExecutorService externalExecutor) {
            void var1_1;
            this.externalExecutor = var1_1;
            return (Builder)this.asThis();
        }
    }

    private final class InitializationTask
    implements Callable<T> {
        private final ExecutorService execFinally;

        /*
         * WARNING - void declaration
         */
        InitializationTask(ExecutorService exec) {
            void var2_2;
            this.execFinally = var2_2;
        }

        @Override
        public final T call() throws Exception {
            try {
                Object t2 = BackgroundInitializer.this.initialize();
                return t2;
            }
            finally {
                if (this.execFinally != null) {
                    this.execFinally.shutdown();
                }
            }
        }
    }
}

