/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public class AtomicInitializer<T>
extends AbstractConcurrentInitializer<T, ConcurrentException> {
    private static final Object NO_INIT = new Object();
    private final AtomicReference<T> reference = new AtomicReference<T>(this.getNoInit());

    public static <T> Builder<AtomicInitializer<T>, T> builder() {
        return new Builder();
    }

    public AtomicInitializer() {
    }

    /*
     * WARNING - void declaration
     */
    private AtomicInitializer(FailableSupplier<T, ConcurrentException> initializer, FailableConsumer<T, ConcurrentException> closer) {
        super(var1_1, var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get() throws ConcurrentException {
        void var1_1;
        T result = this.reference.get();
        if (result == this.getNoInit()) {
            result = this.initialize();
            if (!this.reference.compareAndSet(this.getNoInit(), result)) {
                result = this.reference.get();
            }
        }
        return var1_1;
    }

    private T getNoInit() {
        return (T)NO_INIT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ConcurrentException getTypedException(Exception e2) {
        void var1_1;
        return new ConcurrentException((Throwable)var1_1);
    }

    @Override
    public boolean isInitialized() {
        return this.reference.get() != NO_INIT;
    }

    public static class Builder<I extends AtomicInitializer<T>, T>
    extends AbstractConcurrentInitializer.AbstractBuilder<I, T, Builder<I, T>, ConcurrentException> {
        @Override
        public I get() {
            return (I)new AtomicInitializer(this.getInitializer(), this.getCloser());
        }
    }
}

