/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Objects;
import org.apache.commons.lang3.builder.AbstractSupplier;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public abstract class AbstractConcurrentInitializer<T, E extends Exception>
implements ConcurrentInitializer<T> {
    private final FailableConsumer<? super T, ? extends Exception> closer;
    private final FailableSupplier<? extends T, ? extends Exception> initializer;

    public AbstractConcurrentInitializer() {
        this(FailableSupplier.nul(), FailableConsumer.nop());
    }

    /*
     * WARNING - void declaration
     */
    AbstractConcurrentInitializer(FailableSupplier<? extends T, ? extends Exception> initializer, FailableConsumer<? super T, ? extends Exception> closer) {
        void var1_1;
        void var2_2;
        this.closer = (FailableConsumer)Objects.requireNonNull(var2_2, "closer");
        this.initializer = (FailableSupplier)Objects.requireNonNull(var1_1, "initializer");
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws ConcurrentException {
        if (this.isInitialized()) {
            try {
                this.closer.accept(this.get());
                return;
            }
            catch (Exception e2) {
                void var1_1;
                throw new ConcurrentException((Throwable)ExceptionUtils.throwUnchecked(var1_1));
            }
        }
    }

    protected abstract E getTypedException(Exception var1);

    /*
     * WARNING - void declaration
     */
    protected T initialize() throws E {
        try {
            return this.initializer.get();
        }
        catch (Exception exception) {
            void var2_2;
            Exception e2 = exception;
            ExceptionUtils.throwUnchecked(exception);
            E typedException = this.getTypedException(e2);
            if (typedException.getClass().isAssignableFrom(e2.getClass())) {
                void var1_1;
                throw var1_1;
            }
            throw var2_2;
        }
    }

    protected abstract boolean isInitialized();

    public static abstract class AbstractBuilder<I extends AbstractConcurrentInitializer<T, E>, T, B extends AbstractBuilder<I, T, B, E>, E extends Exception>
    extends AbstractSupplier<I, B, E> {
        private FailableConsumer<T, ? extends Exception> closer = FailableConsumer.nop();
        private FailableSupplier<T, ? extends Exception> initializer = FailableSupplier.nul();

        public FailableConsumer<T, ? extends Exception> getCloser() {
            return this.closer;
        }

        public FailableSupplier<T, ? extends Exception> getInitializer() {
            return this.initializer;
        }

        /*
         * WARNING - void declaration
         */
        public B setCloser(FailableConsumer<T, ? extends Exception> closer) {
            void var1_1;
            this.closer = closer != null ? var1_1 : FailableConsumer.nop();
            return (B)((AbstractBuilder)this.asThis());
        }

        /*
         * WARNING - void declaration
         */
        public B setInitializer(FailableSupplier<T, ? extends Exception> initializer) {
            void var1_1;
            this.initializer = initializer != null ? var1_1 : FailableSupplier.nul();
            return (B)((AbstractBuilder)this.asThis());
        }
    }
}

