/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffExclude;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ReflectionDiffBuilder<T>
implements org.apache.commons.lang3.builder.Builder<DiffResult<T>> {
    private final DiffBuilder<T> diffBuilder;
    private String[] excludeFieldNames;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static String[] toExcludeFieldNames(String[] excludeFieldNames) {
        String[] stringArray;
        if (excludeFieldNames == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ArraySorter.sort(ReflectionToStringBuilder.toNoNullStringArray(stringArray));
    }

    /*
     * WARNING - void declaration
     */
    private ReflectionDiffBuilder(DiffBuilder<T> diffBuilder, String[] excludeFieldNames) {
        void var2_2;
        void var1_1;
        this.diffBuilder = var1_1;
        this.excludeFieldNames = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ReflectionDiffBuilder(T left, T right, ToStringStyle style) {
        this(DiffBuilder.builder().setLeft(var1_1).setRight(var2_2).setStyle((ToStringStyle)var3_3).build(), null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean accept(Field field) {
        void var1_1;
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (this.excludeFieldNames != null && Arrays.binarySearch(this.excludeFieldNames, field.getName()) >= 0) {
            return false;
        }
        return !var1_1.isAnnotationPresent(DiffExclude.class);
    }

    /*
     * WARNING - void declaration
     */
    private void appendFields(Class<?> clazz) {
        for (Field field : FieldUtils.getAllFields(clazz)) {
            if (!this.accept(field)) continue;
            try {
                this.diffBuilder.append(field.getName(), this.readField(field, this.getLeft()), this.readField(field, this.getRight()));
            }
            catch (IllegalAccessException e2) {
                void var1_2;
                throw new IllegalArgumentException("Unexpected IllegalAccessException: " + e2.getMessage(), (Throwable)var1_2);
            }
        }
    }

    @Override
    public DiffResult<T> build() {
        if (this.getLeft().equals(this.getRight())) {
            return this.diffBuilder.build();
        }
        ReflectionDiffBuilder reflectionDiffBuilder = this;
        reflectionDiffBuilder.appendFields(reflectionDiffBuilder.getLeft().getClass());
        return this.diffBuilder.build();
    }

    public String[] getExcludeFieldNames() {
        return (String[])this.excludeFieldNames.clone();
    }

    private T getLeft() {
        return this.diffBuilder.getLeft();
    }

    private T getRight() {
        return this.diffBuilder.getRight();
    }

    /*
     * WARNING - void declaration
     */
    private Object readField(Field field, Object target) throws IllegalAccessException {
        void var2_2;
        return FieldUtils.readField(field, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ReflectionDiffBuilder<T> setExcludeFieldNames(String ... excludeFieldNames) {
        void var1_1;
        this.excludeFieldNames = ReflectionDiffBuilder.toExcludeFieldNames((String[])var1_1);
        return this;
    }

    public static final class Builder<T> {
        private String[] excludeFieldNames = ArrayUtils.EMPTY_STRING_ARRAY;
        private DiffBuilder<T> diffBuilder;

        public final ReflectionDiffBuilder<T> build() {
            return new ReflectionDiffBuilder(this.diffBuilder, this.excludeFieldNames);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setDiffBuilder(DiffBuilder<T> diffBuilder) {
            void var1_1;
            this.diffBuilder = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<T> setExcludeFieldNames(String ... excludeFieldNames) {
            void var1_1;
            this.excludeFieldNames = ReflectionDiffBuilder.toExcludeFieldNames((String[])var1_1);
            return this;
        }
    }
}

